/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.Size;
import java.util.StringTokenizer;

public class RowSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment TOP = FormSpec.f;
    public static final FormSpec.DefaultAlignment CENTER = FormSpec.c;
    public static final FormSpec.DefaultAlignment BOTTOM = FormSpec.a;
    public static final FormSpec.DefaultAlignment FILL = FormSpec.d;
    public static final FormSpec.DefaultAlignment DEFAULT = CENTER;

    public RowSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double d2) {
        super(defaultAlignment, size, d2);
    }

    public RowSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    public RowSpec(String string) {
        super(DEFAULT, string);
    }

    public RowSpec asUnmodifyable() {
        return new UnmodifyableRowSpec(this, null);
    }

    public final boolean isHorizontal() {
        return false;
    }

    public static RowSpec[] decodeSpecs(String string) {
        if (string == null) {
            throw new NullPointerException("The row description must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n2 = stringTokenizer.countTokens();
        RowSpec[] rowSpecArray = new RowSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rowSpecArray[i2] = new RowSpec(stringTokenizer.nextToken());
        }
        return rowSpecArray;
    }

    public static class 1 {
    }

    private static final class UnmodifyableRowSpec
    extends RowSpec {
        private UnmodifyableRowSpec(RowSpec rowSpec) {
            super(rowSpec.getDefaultAlignment(), rowSpec.getSize(), rowSpec.getResizeWeight());
        }

        public void setDefaultAlignment(FormSpec.DefaultAlignment defaultAlignment) {
            throw new UnsupportedOperationException();
        }

        public void setSize(Size size) {
            throw new UnsupportedOperationException();
        }

        public void setResizeWeight(double d2) {
            throw new UnsupportedOperationException();
        }

        public RowSpec asUnmodifyable() {
            return this;
        }

        public UnmodifyableRowSpec(RowSpec rowSpec, 1 var2_2) {
            this(rowSpec);
        }
    }
}

