/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.Size;
import java.util.StringTokenizer;

public class ColumnSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment LEFT = FormSpec.e;
    public static final FormSpec.DefaultAlignment CENTER;
    public static final FormSpec.DefaultAlignment MIDDLE;
    public static final FormSpec.DefaultAlignment RIGHT;
    public static final FormSpec.DefaultAlignment FILL;
    public static final FormSpec.DefaultAlignment DEFAULT;

    public ColumnSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double d2) {
        super(defaultAlignment, size, d2);
    }

    public ColumnSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    public ColumnSpec(String string) {
        super(DEFAULT, string);
    }

    public ColumnSpec asUnmodifyable() {
        return new UnmodifyableColumnSpec(this, null);
    }

    public final boolean isHorizontal() {
        return true;
    }

    public static ColumnSpec[] decodeSpecs(String string) {
        if (string == null) {
            throw new NullPointerException("The column description must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n2 = stringTokenizer.countTokens();
        ColumnSpec[] columnSpecArray = new ColumnSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            columnSpecArray[i2] = new ColumnSpec(stringTokenizer.nextToken());
        }
        return columnSpecArray;
    }

    static {
        MIDDLE = CENTER = FormSpec.c;
        RIGHT = FormSpec.b;
        DEFAULT = FILL = FormSpec.d;
    }

    public static class 1 {
    }

    private static final class UnmodifyableColumnSpec
    extends ColumnSpec {
        private UnmodifyableColumnSpec(ColumnSpec columnSpec) {
            super(columnSpec.getDefaultAlignment(), columnSpec.getSize(), columnSpec.getResizeWeight());
        }

        public void setDefaultAlignment(FormSpec.DefaultAlignment defaultAlignment) {
            throw new UnsupportedOperationException();
        }

        public void setSize(Size size) {
            throw new UnsupportedOperationException();
        }

        public void setResizeWeight(double d2) {
            throw new UnsupportedOperationException();
        }

        public ColumnSpec asUnmodifyable() {
            return this;
        }

        public UnmodifyableColumnSpec(ColumnSpec columnSpec, 1 var2_2) {
            this(columnSpec);
        }
    }
}

