/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CInputMethodDescriptor;
import apple.awt.CToolkit;
import apple.awt.ComponentModel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.JTextComponent;
import sun.awt.im.InputMethodAdapter;

public class CInputMethod
extends InputMethodAdapter {
    private InputMethodContext fIMContext;
    private Component fAwtFocussedComponent;
    private ComponentModel fAwtFocussedComponentPeer;
    private boolean isActive;
    private Locale currentLocale = CInputMethod.a();
    private static Map[] sHighlightStyles;
    private AttributedString fCurrentText = null;
    private int fCurrentTextLength = 0;
    private static final int kCaretPosition = 0;
    private static final int kRawText = 1;
    private static final int kSelectedRawText = 2;
    private static final int kConvertedText = 3;
    private static final int kSelectedConvertedText = 4;

    public CInputMethod() {
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.fIMContext = inputMethodContext;
    }

    public boolean setLocale(Locale locale) {
        return this.setLocale(locale, false);
    }

    private boolean setLocale(Locale locale, boolean bl2) {
        Object[] objectArray = CInputMethodDescriptor.a();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Locale locale2 = (Locale)objectArray[i2];
            if (!locale.equals(locale2) && (!locale2.equals(Locale.JAPAN) || !locale.equals(Locale.JAPANESE)) && (!locale2.equals(Locale.KOREA) || !locale.equals(Locale.KOREAN))) continue;
            CInputMethod.a(locale2.toString(), bl2);
            this.currentLocale = locale2;
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        this.currentLocale = CInputMethod.a();
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
        return this.currentLocale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void setCompositionEnabled(boolean bl2) {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    public boolean isCompositionEnabled() {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    public void activate() {
        if (this.fAwtFocussedComponentPeer != null) {
            boolean bl2 = this.fAwtFocussedComponent.getInputMethodRequests() != null;
            this.nativeActivate(this.fAwtFocussedComponentPeer.c(), bl2);
        }
        this.isActive = true;
    }

    public void deactivate(boolean bl2) {
        this.getLocale();
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeDeactivate(this.fAwtFocussedComponentPeer.c());
        }
        this.isActive = false;
    }

    public void hideWindows() {
    }

    public void removeNotify() {
    }

    public void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        ComponentModel componentModel = this.getNearestNativePeer(component);
        if (this.isActive) {
            if (this.fAwtFocussedComponentPeer != null) {
                this.nativeDeactivate(this.fAwtFocussedComponentPeer.c());
            }
            if (componentModel != null) {
                this.nativeNotifyPeer(componentModel.c(), this);
                boolean bl2 = component.getInputMethodRequests() != null;
                this.nativeActivate(componentModel.c(), bl2);
            }
        } else if (componentModel != null) {
            this.nativeNotifyPeer(componentModel.c(), this);
        }
        this.fAwtFocussedComponent = component;
        this.fAwtFocussedComponentPeer = componentModel;
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n2;
        int n3 = inputMethodHighlight.getState();
        if (n3 == 0) {
            n2 = 0;
        } else if (n3 == 1) {
            n2 = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n2;
        }
        return sHighlightStyles[n2];
    }

    public void endComposition() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.fAwtFocussedComponentPeer.c());
        }
    }

    public void dispose() {
    }

    public Object getControlObject() {
        return null;
    }

    private ComponentModel getNearestNativePeer(Component component) {
        if (component == null) {
            return null;
        }
        ComponentPeer componentPeer = component.getPeer();
        if (componentPeer == null) {
            return null;
        }
        while (componentPeer instanceof LightweightPeer) {
            if ((component = component.getParent()) == null) {
                return null;
            }
            componentPeer = component.getPeer();
            if (componentPeer != null) continue;
            return null;
        }
        if (componentPeer instanceof ComponentModel) {
            return (ComponentModel)componentPeer;
        }
        return null;
    }

    private synchronized void insertText(String string) {
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, this.getLocale(), 0, string.length());
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(string.length() - 1);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, attributedString.getIterator(), string.length(), textHitInfo, textHitInfo);
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        this.fCurrentText = null;
        this.fCurrentTextLength = 0;
    }

    private void startIMUpdate(String string) {
        this.fCurrentText = new AttributedString(string);
        this.fCurrentTextLength = string.length();
    }

    private void addAttribute(boolean bl2, boolean bl3, int n2, int n3) {
        InputMethodHighlight inputMethodHighlight;
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 1;
        if (bl2 && bl3) {
            n6 = 1;
        } else if (!bl2 && bl3) {
            n6 = 1;
        } else if (bl2 && !bl3) {
            n6 = 4;
        } else if (!bl2 && !bl3) {
            n6 = 3;
        }
        switch (n6) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 3: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        this.fCurrentText.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n4, n5);
    }

    private void dispatchText(int n2, int n3) {
        TextHitInfo textHitInfo;
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo textHitInfo2 = textHitInfo = TextHitInfo.afterOffset(this.fCurrentTextLength);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), 0, textHitInfo, textHitInfo2);
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
    }

    private synchronized void unmarkText() {
        TextHitInfo textHitInfo;
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo textHitInfo2 = textHitInfo = TextHitInfo.afterOffset(this.fCurrentTextLength);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), this.fCurrentTextLength, textHitInfo, textHitInfo2);
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        this.fCurrentText = null;
        this.fCurrentTextLength = 0;
    }

    private synchronized boolean hasMarkedText() {
        return this.fCurrentText != null;
    }

    private synchronized String attributedSubstringFromRange(int n2, int n3) {
        int n4;
        if (n2 + n3 > this.fIMContext.getCommittedTextLength() + this.fCurrentTextLength) {
            n3 = this.fIMContext.getCommittedTextLength() - n2;
        }
        AttributedCharacterIterator attributedCharacterIterator = null;
        attributedCharacterIterator = this.fCurrentText == null ? this.fIMContext.getCommittedText(n2, n2 + n3, null) : (n2 < (n4 = this.fIMContext.getInsertPositionOffset()) ? this.fIMContext.getCommittedText(n2, n2 + n3, null) : (n2 >= n4 && n2 < n4 + this.fCurrentTextLength ? this.fCurrentText.getIterator(null, n2 - n4, n2 - n4 + n3) : this.fIMContext.getCommittedText(n2 - this.fCurrentTextLength, n2 - this.fCurrentTextLength + n3, null)));
        char[] cArray = new char[attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()];
        char c2 = attributedCharacterIterator.first();
        int n5 = 0;
        while (c2 != '\uffff') {
            cArray[n5++] = c2;
            c2 = attributedCharacterIterator.next();
        }
        return new String(cArray);
    }

    private synchronized int[] selectedRange() {
        AttributedCharacterIterator attributedCharacterIterator = this.fIMContext.getSelectedText(null);
        int[] nArray = null;
        if (attributedCharacterIterator != null) {
            int n2;
            if (this.fAwtFocussedComponent instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)this.fAwtFocussedComponent;
                n2 = jTextComponent.getSelectionStart();
            } else if (this.fAwtFocussedComponent instanceof TextComponent) {
                TextComponent textComponent = (TextComponent)this.fAwtFocussedComponent;
                n2 = textComponent.getSelectionStart();
            } else {
                n2 = this.fIMContext.getInsertPositionOffset() - (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
                if (n2 < 0) {
                    n2 = this.fIMContext.getInsertPositionOffset() + (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
                }
            }
            nArray = new int[]{n2, attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()};
        }
        return nArray;
    }

    private synchronized int[] markedRange() {
        if (this.fCurrentText == null) {
            return null;
        }
        int n2 = this.fIMContext.getInsertPositionOffset();
        int[] nArray = new int[]{n2, this.fCurrentTextLength};
        return nArray;
    }

    private synchronized int[] firstRectForCharacterRange() {
        Rectangle rectangle = this.fIMContext.getTextLocation(TextHitInfo.beforeOffset(0));
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        return nArray;
    }

    private synchronized int characterIndexForPoint(int n2, int n3) {
        TextHitInfo textHitInfo = this.fIMContext.getLocationOffset(n2, n3);
        if (textHitInfo == null) {
            textHitInfo = TextHitInfo.beforeOffset(0);
        }
        return textHitInfo.getCharIndex();
    }

    private native void nativeNotifyPeer(long var1, CInputMethod var3);

    private native void nativeActivate(long var1, boolean var3);

    private native void nativeDeactivate(long var1);

    private native void nativeEndComposition(long var1);

    private native void nativeHandleEvent(ComponentModel var1, AWTEvent var2);

    public static native Locale a();

    public static native boolean a(String var0, boolean var1);

    public static native void b();

    static {
        Map[] mapArray = new Map[4];
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        sHighlightStyles = mapArray;
        CInputMethod.b();
    }
}

