/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.security.AccessController;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.security.action.LoadLibraryAction;

public class CImage
extends Image {
    private long fNSImage = 0L;
    private BufferedImage fConvertedBI = null;
    private SurfaceData fSurfaceData = null;
    private long fConvertedCGImageRef = 0L;

    public CImage(long l2) {
        this.setNSImage(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CImage(Image image) {
        if (image != null) {
            BufferedImage bufferedImage = null;
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                Canvas canvas = new Canvas();
                MediaTracker mediaTracker = new MediaTracker(canvas);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("ImageTracker interrupted.");
                    Thread.dumpStack();
                    return;
                }
                int n2 = Math.max(image.getWidth(canvas), 1);
                int n3 = Math.max(image.getHeight(canvas), 1);
                bufferedImage = new BufferedImage(n2, n3, 3);
                Graphics graphics = bufferedImage.getGraphics();
                try {
                    graphics.drawImage(image, 0, 0, n2, n3, null);
                }
                finally {
                    graphics.dispose();
                }
            }
            this.setNSImage(bufferedImage);
        }
    }

    public CImage(String string) {
        long l2 = this.icon(string);
        this.setNSImage(l2);
    }

    public CImage(int n2) {
        long l2 = this.imageFromIconSelector(n2);
        this.setNSImage(l2);
    }

    private void setNSImage(BufferedImage bufferedImage) {
        long l2 = this.makeNSImage(bufferedImage);
        this.setNSImage(l2);
    }

    private synchronized void setNSImage(long l2) {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
        }
        this.fNSImage = l2;
    }

    public synchronized void dispose() {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
            this.fNSImage = 0L;
        }
    }

    private native void _release(long var1);

    public synchronized long d() {
        return this.fNSImage;
    }

    public void finalize() {
        this.dispose();
    }

    private native int width(long var1);

    private native int height(long var1);

    private native void flip(long var1);

    private native long createCGImageRef(SurfaceData var1, int var2, int var3);

    private native long icon(String var1);

    private native long imageFromIconSelector(int var1);

    public synchronized int getWidth(ImageObserver imageObserver) {
        return this.width(this.fNSImage);
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        return this.height(this.fNSImage);
    }

    public ImageProducer getSource() {
        throw new IllegalAccessError("getSource() not valid for CImage");
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError("getGraphics() not valid for CImage");
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        return Image.UndefinedProperty;
    }

    public void flush() {
    }

    private long makeNSImage(BufferedImage bufferedImage) {
        BufImgSurfaceData bufImgSurfaceData = (BufImgSurfaceData)BufImgSurfaceData.createData(bufferedImage);
        return bufImgSurfaceData.makeNSImage();
    }

    public synchronized boolean c() {
        return this.fConvertedBI != null;
    }

    public synchronized Image a() {
        return this.fConvertedBI;
    }

    public synchronized void b() {
        if (this.fConvertedBI != null) {
            return;
        }
        int n2 = this.width(this.fNSImage);
        int n3 = this.height(this.fNSImage);
        this.fConvertedBI = new BufferedImage(n2, n3, 3);
        SunGraphics2D sunGraphics2D = (SunGraphics2D)this.fConvertedBI.createGraphics();
        this.flip(this.fNSImage);
        CSurfaceData cfr_ignored_0 = (CSurfaceData)sunGraphics2D.surfaceData;
        ((CSurfaceData)sunGraphics2D.surfaceData).blitNSImage(CSurfaceData.fCRenderer, sunGraphics2D, this.fNSImage, 0, 0, n2, n3, 0, 0, n2, n3, Color.black);
        this.flip(this.fNSImage);
    }

    public synchronized SurfaceData e() {
        if (this.fSurfaceData == null) {
            this.fSurfaceData = BufImgSurfaceData.createData(this.fConvertedBI);
        }
        return this.fSurfaceData;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

