/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.AWTLockAccess;
import apple.awt.CDropTargetContextPeer;
import apple.awt.CImage;
import apple.awt.ComponentModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import sun.awt.dnd.SunDragSourceContextPeer;

public final class CDragSourceContextPeer
extends SunDragSourceContextPeer {
    private static final CDragSourceContextPeer fInstance = new CDragSourceContextPeer(null);
    private Image fDragImage;
    private CImage fDragCImage;
    private Point fDragImageOffset;

    private CDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent);
    }

    public static CDragSourceContextPeer a(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        fInstance.setTrigger(dragGestureEvent);
        return fInstance;
    }

    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.fDragImage = image;
        this.fDragImageOffset = point;
        super.startDrag(dragSourceContext, cursor, image, point);
    }

    public void startDrag(Transferable transferable, long[] lArray, Map map) {
        Point point;
        long l2;
        int n2;
        Object object;
        DragGestureEvent dragGestureEvent = this.getTrigger();
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        Point point2 = dragGestureEvent.getDragOrigin();
        int n3 = inputEvent.getModifiers() | inputEvent.getModifiersEx();
        long l3 = inputEvent.getWhen();
        int n4 = inputEvent instanceof MouseEvent ? ((MouseEvent)inputEvent).getClickCount() : 1;
        Component component = dragGestureEvent.getComponent();
        Point point3 = new Point();
        ComponentPeer componentPeer = component.getPeer();
        if (component.isLightweight()) {
            object = component.getLocation();
            point3.translate(((Point)object).x, ((Point)object).y);
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!container.isLightweight()) {
                    componentPeer = container.getPeer();
                    break;
                }
                object = container.getLocation();
                point3.translate(((Point)object).x, ((Point)object).y);
            }
        }
        if (!(componentPeer instanceof ComponentModel)) {
            throw new IllegalArgumentException("DragSource's peer must be a ComponentModel.");
        }
        object = (ComponentModel)componentPeer;
        long l4 = ((ComponentModel)object).c();
        Cursor cursor = this.getCursor();
        int n5 = n2 = cursor != null ? cursor.getType() : 0;
        if (this.fDragImage == null) {
            this.setDefaultDragImage(component);
        }
        if (this.fDragImage != null) {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = bufferedImage = this.fDragImage instanceof BufferedImage ? (BufferedImage)this.fDragImage : null;
            if (bufferedImage == null) {
                int n6 = this.fDragImage.getWidth(null);
                int n7 = this.fDragImage.getHeight(null);
                bufferedImage = new BufferedImage(n6, n7, 3);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(this.fDragImage, 0, 0, null);
                graphics.dispose();
            }
            this.fDragCImage = new CImage(bufferedImage);
            l2 = this.fDragCImage.d();
            point = this.fDragImageOffset;
        } else {
            this.fDragCImage = null;
            l2 = 0L;
            point = new Point(0, 0);
        }
        long l5 = this.fDragCImage != null ? this.fDragCImage.d() : 0L;
        try {
            long l6 = this.createNativeDragSource(component, componentPeer, l4, transferable, inputEvent, (int)(point2.getX() + (double)point3.x), (int)(point2.getY() + (double)point3.y), n3, n4, l3, cursor, n2, l2, point.x, point.y, this.getDragSourceContext().getSourceActions(), lArray, map);
            if (l6 == 0L) {
                throw new InvalidDnDOperationException("");
            }
            this.setNativeContext(l6);
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("failed to create native peer: " + exception);
        }
        CDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
        try {
            Thread thread = new Thread(this){
                private final CDragSourceContextPeer this$0;
                {
                    this.this$0 = cDragSourceContextPeer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    long l2 = CDragSourceContextPeer.b(this.this$0);
                    try {
                        try {
                            CDragSourceContextPeer.b(this.this$0, l2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var5_3 = null;
                            CDragSourceContextPeer.a(this.this$0, l2);
                            CDragSourceContextPeer.a(this.this$0, null);
                            if (CDragSourceContextPeer.a(this.this$0) == null) return;
                            CDragSourceContextPeer.a(this.this$0).dispose();
                            CDragSourceContextPeer.a(this.this$0, null);
                            return;
                        }
                        Object var5_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        CDragSourceContextPeer.a(this.this$0, l2);
                        CDragSourceContextPeer.a(this.this$0, null);
                        if (CDragSourceContextPeer.a(this.this$0) == null) throw throwable;
                        CDragSourceContextPeer.a(this.this$0).dispose();
                        CDragSourceContextPeer.a(this.this$0, null);
                        throw throwable;
                    }
                    CDragSourceContextPeer.a(this.this$0, l2);
                    CDragSourceContextPeer.a(this.this$0, null);
                    if (CDragSourceContextPeer.a(this.this$0) == null) return;
                    CDragSourceContextPeer.a(this.this$0).dispose();
                    CDragSourceContextPeer.a(this.this$0, null);
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            long l7 = this.getNativeContext();
            this.setNativeContext(0L);
            this.releaseNativeDragSource(l7);
            CDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
            throw new InvalidDnDOperationException("failed to start dragging thread: " + exception);
        }
    }

    public boolean isLightweightDragSource() {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        return component.isLightweight();
    }

    private void setDefaultDragImage(Component component) {
        boolean bl2 = false;
        if (component.isLightweight() && component instanceof JTextComponent) {
            this.setDefaultDragImage((JTextComponent)component);
            bl2 = true;
        }
        if (!bl2) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTextComponent jTextComponent) {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        int n2 = jTextComponent.getSelectionStart();
        int n3 = jTextComponent.getSelectionEnd();
        boolean bl2 = false;
        int n4 = jTextComponent.viewToModel(dragGestureEvent.getDragOrigin());
        if (n2 < n3 && n4 >= n2 && n4 <= n3) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n2);
                Rectangle rectangle2 = jTextComponent.modelToView(n3);
                Rectangle rectangle3 = null;
                if (rectangle.y == rectangle2.y) {
                    rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle2.x - rectangle.x + rectangle2.width, rectangle2.y - rectangle.y + rectangle2.height);
                } else {
                    AccessibleContext accessibleContext = jTextComponent.getAccessibleContext();
                    AccessibleText accessibleText = (AccessibleText)((Object)accessibleContext);
                    rectangle3 = jTextComponent.modelToView(n2);
                    for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                        Rectangle rectangle4 = accessibleText.getCharacterBounds(i2);
                        rectangle3.add(rectangle4);
                    }
                }
                this.setOutlineDragImage(rectangle3);
                bl2 = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (!bl2) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage() {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        Point point = dragGestureEvent.getDragOrigin();
        this.setOutlineDragImage(new Rectangle(0, 0, component.getWidth(), component.getHeight()));
    }

    private void setOutlineDragImage(Rectangle rectangle) {
        Object object;
        Object object2;
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        Point point = component.getLocation();
        if (component instanceof JComponent) {
            object2 = ((JComponent)component).getVisibleRect();
            object = rectangle.intersection((Rectangle)object2);
            if (!((Rectangle)object).isEmpty()) {
                rectangle = object;
            }
            rectangle.translate(point.x, point.y);
        }
        object2 = component.getGraphicsConfiguration();
        object = ((GraphicsConfiguration)object2).createCompatibleImage((int)rectangle.getWidth(), (int)rectangle.getHeight());
        Point point2 = dragGestureEvent.getDragOrigin();
        Point point3 = new Point(rectangle.x - point2.x, rectangle.y - point2.y);
        if (component instanceof JComponent) {
            point3.translate(-point.x, -point.y);
        }
        Color color = Color.gray;
        BasicStroke basicStroke = new BasicStroke(2.0f);
        int n2 = (int)(basicStroke.getLineWidth() + 1.0f) / 2;
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
        graphics2D.setPaint(color);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawRect(n2, n2, (int)rectangle.getWidth() - 2 * n2 - 1, (int)rectangle.getHeight() - 2 * n2 - 1);
        graphics2D.dispose();
        this.fDragImage = object;
        this.fDragImageOffset = point3;
    }

    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        AWTLockAccess.b();
        super.setCursor(cursor);
        AWTLockAccess.d();
    }

    public boolean needsBogusExitBeforeDrop() {
        return false;
    }

    private native long createNativeDragSource(Component var1, ComponentPeer var2, long var3, Transferable var5, InputEvent var6, int var7, int var8, int var9, int var10, long var11, Cursor var13, int var14, long var15, int var17, int var18, int var19, long[] var20, Map var21);

    private native void doDragging(long var1);

    private native void releaseNativeDragSource(long var1);

    public static long b(CDragSourceContextPeer cDragSourceContextPeer) {
        return cDragSourceContextPeer.getNativeContext();
    }

    public static void b(CDragSourceContextPeer cDragSourceContextPeer, long l2) {
        cDragSourceContextPeer.doDragging(l2);
    }

    public static void a(CDragSourceContextPeer cDragSourceContextPeer, long l2) {
        cDragSourceContextPeer.releaseNativeDragSource(l2);
    }

    public static Image a(CDragSourceContextPeer cDragSourceContextPeer, Image image) {
        cDragSourceContextPeer.fDragImage = image;
        return cDragSourceContextPeer.fDragImage;
    }

    public static CImage a(CDragSourceContextPeer cDragSourceContextPeer) {
        return cDragSourceContextPeer.fDragCImage;
    }

    public static CImage a(CDragSourceContextPeer cDragSourceContextPeer, CImage cImage) {
        cDragSourceContextPeer.fDragCImage = cImage;
        return cDragSourceContextPeer.fDragCImage;
    }
}

