#include "irit_sm.h"
#include "iritprsr.h"
#include "allocate.h"
#include "geom_lib.h"
#include "cagd_lib.h"

void main(int argc, char **argv)
{
    int Handler;

    if (argc == 2) {
        IPSetFlattenObjects(FALSE);

	if ((Handler = IPOpenDataFile(argv[1], TRUE, TRUE)) >= 0) {
	    IPObjectStruct
		*PObj = IPGetObjects(Handler);

	    /* Done with file - close it. */
	    IPCloseStream(Handler, TRUE);

	    if (IP_IS_OLST_OBJ(PObj)) {
	        IPObjectStruct
		    *PCrv = IPListObjectGet(PObj, 0),
		    *PSrf = IPListObjectGet(PObj, 1);

		if (PCrv && IP_IS_CRV_OBJ(PCrv) &&
		    PSrf && IP_IS_SRF_OBJ(PSrf)) {
		    int i;
		    CagdCrvStruct *Crv;

		    for (i = 0; i < 1000000; i++) {
		        Crv = SymbComposeSrfCrv(PSrf -> U.Srfs,
						PCrv -> U.Crvs);

			CagdCrvFree(Crv);
		    }
		}
		else {
		    fprintf(stderr, "Expected a crv + srf \"%s\"\n", argv[1]);
		    exit(1);
		}
	    }
	    else {
	        fprintf(stderr, "Expected a list \"%s\"\n", argv[1]);
		exit(1);
	    }
	}
	else {
	    fprintf(stderr, "Failed to open file \"%s\"\n", argv[1]);
	    exit(1);
	}
    }
    else {
	fprintf(stderr, "Usage: PolyArea geom.dat\n");
	exit(2);
    }

    exit(0);
}
