/******************************************************************************
* TrngCoer.c - Handle point coercesions/conversions.			      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Sep. 94.					      *
******************************************************************************/

#include "trng_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Coerces a triangular surface to point type PType.			     M
*                                                                            *
* PARAMETERS:                                                                M
*   TriSrf:   To coerce to a new point type PType.                           M
*   PType:    New point type for TriSrf.                                     M
*                                                                            *
* RETURN VALUE:                                                              M
*   TrngTriangSrfStruct *:   A new trngariate with PType as its point type.  M
*                                                                            *
* KEYWORDS:                                                                  M
*   TrngCoerceTriSrfTo, coercion                                             M
*****************************************************************************/
TrngTriangSrfStruct *TrngCoerceTriSrfTo(TrngTriangSrfStruct *TriSrf,
					CagdPointType PType)
{
    TriSrf = TrngTriSrfCopy(TriSrf);

    CagdCoercePointsTo(TriSrf -> Points, TRNG_TRISRF_MESH_SIZE(TriSrf),
		       TriSrf -> PType, PType);

    TriSrf -> PType = PType;
    return TriSrf;
}
