#ifndef _TRIANGLE_H
#define _TRIANGLE_H

#include "rndr_loc.h"
#include "color.h"
#include "scene.h"

/* Working structure describing polygon edge; some fields are used in scan   */
/* line converting and interpolation.                                        */
typedef struct EdgeStruct {
    int x;/* Current X coordinate on the scan line, the lowest end at start. */
    int dx, dy, Inc; /* Scan line converting integer algorithm data members. */
    int YMin;                             /* The lowest endpoint coordinate. */
    InterpolStruct Value; /* Starting and later current interpolation value. */
    InterpolStruct dValue;              /* Increment of interpolation value. */
} EdgeStruct;

typedef EdgeStruct const *EdgeCPtrType;

/* Triangle, which is a polygon abstraction. */
typedef struct TriangleStruct {
    EdgeStruct Edge[3];             /* Array of edges representing Triangle. */
    EdgeStruct *SortedEdge[3];
    int YMin, YMax;               /* Scan line range Triangle is located in. */
    IPPolygonStruct *Poly;         /* Pointer to the compliant Irit polygon. */
    ObjectStruct *Object;           /* Object that Triangle is contained in. */
    IntensivityStruct **Vals;
    IntensivityStruct **dVals;
} TriangleStruct;

void TriangleInit(TriangleStruct *Tri);

int TriangleSet(TriangleStruct *Tri,
                IPPolygonStruct *Poly,
                ObjectStruct *o,
                SceneStruct *Scene);

void TriangleRelease(TriangleStruct *Tri);

#endif
