#ifndef _SCENE_H_
#define _SCENE_H_

#include "rndr_loc.h"
#include "lights.h"

typedef struct MatrixContextStruct {
    MatrixType ViewMat;     /* Comulative matrix of viewing transformations. */
    MatrixType ViewInvMat;                 /* Inverse of accumulated matrix. */
    PointType  Viewer;                      /* Viewer position or direction. */
    MatrixType TransMat;
    MatrixType ScreenMat;
    int ParallelProjection;
} MatrixContextStruct;

typedef struct SceneStruct{
    int SizeX;
    int SizeY;
    MatrixContextStruct Matrices;
    LightListStruct Lights;
    IRndrColorType BackgroundColor;
    RealType  Ambient;
    int       ShadeModel;                 /* Type of shading model to apply. */
    int       BackFace;        /* Flag directing to remove back faced flats. */
    RealType ZNear;                                      /* Clipping planes. */
    RealType ZFar;
    int ZFarValid;
} SceneStruct;

void SceneSetMatrices(SceneStruct *Scene,
                      MatrixType ViewMat,
                      MatrixType PrspMat,
		      MatrixType ScrnMat);

void SceneGetClippingPlane(SceneStruct *Scene,
                           int Axis,
                           int Min,
                           PlaneType Result);

void SceneSetZClippingPlanes(SceneStruct *Scene,
                             RealType ZNear,
                             RealType ZFar);

void SceneRelease(SceneStruct *Scene);

#endif
