/*****************************************************************************
* Rendering algorithm definitions and data structures interface.         *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Bassarab Dmitri & Plavnik Michael       Ver 0.2, Apr. 1995    *
*****************************************************************************/

#ifndef _RNDR_LOC_H_
#define _RNDR_LOC_H_

#include <stdio.h>
#include <math.h>
#include "irit_sm.h"
#include "allocate.h"
#include "iritgrap.h"
#include "ip_cnvrt.h"
#include "misc_lib.h"
#include "rndr_lib.h"

#define X_AXIS        0
#define Y_AXIS        1
#define Z_AXIS        2
#define W_AXIS        3

#define RED_CLR      0
#define GREEN_CLR    1
#define BLUE_CLR     2
#define ALPHA_CLR    3

#define POINT_LIGHT     IRNDR_LIGHT_POINT
#define VECTOR_LIGHT    IRNDR_LIGHT_VECTOR
#define SHADING_FLAT    IRNDR_SHADING_FLAT
#define SHADING_GOURAUD IRNDR_SHADING_GOURAUD
#define SHADING_PHONG   IRNDR_SHADING_PHONG
#define SHADING_NONE    IRNDR_SHADING_NONE

#define MAX_NOISE	60

/* Left/right coordinate system dependences. */
#define NEAREST_Z	IRIT_INFNTY
#define FAREST_Z	-IRIT_INFNTY
#define VIEWER_SIGHT	1
#define NEAR_THAN	>
#define FARTHER_THAN	<
#define MAX_LIGHTS_NUM	24

#define IRIT_MAX_INT	0x7fffffff
#define APX_ZERO(x)	(APX_EQ(0.0, (x)))
#define MALLOC(type, n)	(type *) IritMalloc(sizeof(type) * (n))
#define FREE(p)		IritFree(p)
#define MAXM(a, b)	{ if ((a) < (b)) a = b; }
#define MINM(a, b)	{ if ((a) > (b)) a = b; }
#define IN(value, lower, upper) ((lower) <= (value) && (value) <= (upper))
#define PLANE_EQ_EVAL(pl, pt)   (DOT_PROD((pl), (pt)) + (pl)[3])

/* To use a an internal color representation other than RealType, define    */
/* one of the IRNDR_COLOR_* macros via -D switch or similar when building   */
/* rndr_lib.								    */
#define IRNDR_COLOR_INT8 1

#if defined IRNDR_COLOR_INT8
    #define REAL_TO_COL(x) ((unsigned char)(0.5 + (x) * 0xff))
    #define COL_TO_REAL(x) (((RealType)(x)) * (1.0/0xff))
    typedef unsigned char IRndrChannelType;
#elif defined IRNDR_COLOR_INT16
    #define REAL_TO_COL(x) ((unsigned short)(0.5 + (x) * 0xffff))
    #define COL_TO_REAL(x) (((RealType)(x)) * (1.0/0xffff))
    typedef unsigned short IRndrChannelType;
#elif defined IRNDR_COLOR_FP32
    #define REAL_TO_COL(x) ((float)(x))
    #define COL_TO_REAL(x) ((RealType)(x))
    typedef float IRndrChannelType;
#elif defined IRNDR_COLOR_FP64
    #define REAL_TO_COL(x) ((double)(x))
    #define COL_TO_REAL(x) ((RealType)(x))
    typedef double IRndrChannelType;
#else
    #define REAL_TO_COL(x) ((RealType)(x))
    #define COL_TO_REAL(x) ((RealType)(x))
    typedef RealType IRndrChannelType;
#endif

typedef IRndrChannelType IRndrPixelType[3];

#define SET_COL_FROM_REAL(x, y) {\
    (x)[RED_CLR]   = REAL_TO_COL(y[RED_CLR]);\
    (x)[GREEN_CLR] = REAL_TO_COL(y[GREEN_CLR]);\
    (x)[BLUE_CLR]  = REAL_TO_COL(y[BLUE_CLR]); }

#define SET_REAL_FROM_COL(x, y) {\
    (x)[RED_CLR]   = COL_TO_REAL(y[RED_CLR]);\
    (x)[GREEN_CLR] = COL_TO_REAL(y[GREEN_CLR]);\
    (x)[BLUE_CLR]  = COL_TO_REAL(y[BLUE_CLR]); }

#define REAL_TO_BYTE(x) ((ByteType)(0.5 + (x) * 0xff))

/* Mapping of predefined color constants to colors. */
extern GLOBAL_DATA IRndrColorType Colors[];

typedef PlaneType PointType4;
#define PT_COPY4(PlDest, PlSrc) memcpy((char *) (PlDest), (char *) (PlSrc), \
                            4 * sizeof(RealType))

void _IRndrReportWarning(const char *Fmt, ...);
void _IRndrReportError(const char *Fmt, ...);
void _IRndrReportFatal(const char *Fmt, ...);

#endif /* _RNDR_LOC_H_ */
