#ifndef _OBJECT_H_
#define _OBJECT_H_

#include "rndr_loc.h"
#include "texture.h"
#include "polyline.h"
#include "scene.h"

#define AMBIENT_DEFAULT        0.2
#define COSINE_DEFAULT        64
#define SRF_SPECULAR_DEFAULT    0.4
#define SRF_DIFFUSE_DEFAULT    0.4
#define TRANSP_DEFAULT        0

typedef struct ObjectStruct {
    int Power;              /* Power of cosine factor of specular component. */
    RealType KSpecular;                       /* Specular coefficient value. */
    RealType KDiffuse;                         /* Diffuse coefficient value. */
    IRndrColorType Color;                            /* Color of the object. */
    TextureStruct Txtr;
    RealType Transp;                          /* Transparency of the object. */
    int noShade;                            /* Pure color model (polylines). */
    IPObjectStruct *OriginalIritObject;
    MatrixType AnimationMatrix;
    int Transformed;
    int Animated;
} ObjectStruct;

void ObjectInit(ObjectStruct *PObject);

void ObjectRelease(ObjectStruct *PObject);

ObjectStruct *ObjectSet(ObjectStruct *PObject,
                        IPObjectStruct *Obj,
                        SceneStruct *Scene);

void VertexTransform(IPVertexStruct *Vertex,
                     MatrixContextStruct *Matrices,
                     ObjectStruct *o,
                     RealType *Result);

#endif
