/*****************************************************************************
* Default fatal error handler for the irit parser.			     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.2, April 1993  *
*****************************************************************************/

#include <stdio.h>
#include "irit_sm.h"
#include "prsr_loc.h"
#include "allocate.h"
#include "attribut.h"

#ifndef IRIT_QUIET_STRINGS

/*****************************************************************************
* DESCRIPTION:                                                               M
* Default trap for Irit parser errors.					     M
*   This function prints the provided error message and dies.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   Msg:      Error message.                                                 M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IPFatalError, error handling                                             M
*****************************************************************************/
void IPFatalError(char *Msg)
{
    fprintf(stderr, IRIT_EXP_STR("IP: %s\n"), Msg);

    exit(-1);
}

#endif /* !IRIT_QUIET_STRINGS */
