/******************************************************************************
* Mvar_ftl.c - default FatalError function for the mvar library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 97.					      *
******************************************************************************/

#include <stdio.h>
#include "mvar_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Mvar_lib errors right here. Provides a default error handler for the  M
* mvar library. Gets an error description using MvarDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MvarFatalError, error handling                                           M
*****************************************************************************/
void MvarFatalError(MvarFatalErrorType ErrID)
{
    char
	*ErrorMsg = MvarDescribeError(ErrID);

    fprintf(stderr, IRIT_EXP_STR("MVAR_LIB: %s\n"), ErrorMsg);

    exit(-1);
}
