/******************************************************************************
* Mvar_dbg.c - Provide a routine to print multi variate objects to stderr.    *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 97.					      *
******************************************************************************/

#include "mvar_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Prints multi-variates to stderr. Should be linked to programs for          M
* debugging purposes, so multi-variates may be inspected from a debugger.    M
*                                                                            *
* PARAMETERS:                                                                M
*   Obj:       A multi-variate - to be printed to stderr.  		     M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MvarDbg, debugging                                                       M
*****************************************************************************/
void MvarDbg(void *Obj)
{
    char *ErrorMsg;
    MvarMVStruct
	*MV = (MvarMVStruct *) Obj;
    MvarGeomType 
	GType = MV -> GType;

    switch (GType) {
	case MVAR_POWER_TYPE:
	case MVAR_BEZIER_TYPE:
	case MVAR_BSPLINE_TYPE:
	    MvarMVWriteToFile3(MV, stderr, 0, IRIT_EXP_STR("MvarDbg"),
			       &ErrorMsg);
	    break;
	case MVAR_UNDEF_TYPE:
	    break;
    }

    if (ErrorMsg)
	fprintf(stderr, IRIT_EXP_STR("MvarDbg Error: %s\n"), ErrorMsg);
}
