/*****************************************************************************
* Manipulate images.							     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber			       Ver 1.0,	Dec. 1998    *
*****************************************************************************/

#include <math.h>
#include "irit_sm.h"
#include "misc_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
*   Reads one image in from a file named ImageFileName.  The image is        M
* returned as a vector of RGBRGB... of size (MaxX+1) * (MaxY+1) * 3.         M
*                                                                            *
* PARAMETERS:                                                                M
*   Img:   Image to flip its X and Y axes.                                   M
*   MaxX:  Maximum X of Img image.			                     M
*   MaxY:  Maximum Y of Img image.			                     M
*                                                                            *
* RETURN VALUE:                                                              M
*   IrtImgPixelStruct *:  Flipped image.                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IrtImgFlipXYImage                                                        M
*****************************************************************************/
IrtImgPixelStruct *IrtImgFlipXYImage(IrtImgPixelStruct *Img,
				     int MaxX,
				     int MaxY)
{
    int x, y,
	SizeX = MaxX + 1,
	SizeY = MaxY + 1;
    IrtImgPixelStruct
	*FImg = (IrtImgPixelStruct *)
	    IritMalloc(sizeof(IrtImgPixelStruct) * SizeX * SizeY);

    for (y = 0; y < SizeY; y++) {
	for (x = 0; x < SizeX; x++) {
	    FImg[x * SizeY + y] = *Img++;
	}
    }

    return FImg;
}
