/******************************************************************************
* Mdl_Bbox.c - Handle bounding boxes freeform models.			      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Jan. 97.					      *
******************************************************************************/

#include "mdl_loc.h"
#include "geom_lib.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Computes a bounding box for a freeform model.				     M
*                                                                            *
* PARAMETERS:                                                                M
*   Mdl:      A model to compute a bounding box for.                         M
*   BBox:     Where bounding information is to be saved.                     M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* SEE ALSO:                                                                  M
*   MdlModelListBBox, CagdCrvListBBox, CagdSrfBBox, CagdTightBBox            M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlModelBBox, bbox, bounding box                                         M
*****************************************************************************/
void MdlModelBBox(MdlModelStruct *Mdl, CagdBBoxStruct *BBox)
{
    MdlTrimSrfStruct *TSrfs;
    CagdBBoxStruct TmpBBox;

    CAGD_RESET_BBOX(BBox);

    if (Mdl == NULL)
	return;

    for (TSrfs = Mdl -> TrimSrfList; TSrfs != NULL; TSrfs = TSrfs -> Pnext) {
	CagdSrfBBox(TSrfs -> Srf, &TmpBBox);
	CagdMergeBBox(BBox, &TmpBBox);
    }
}

/*****************************************************************************
* DESCRIPTION:                                                               M
* Computes a bounding box for freeform models.				     M
*                                                                            *
* PARAMETERS:                                                                M
*   Mdls:     List of models to compute a bounding box for.                  M
*   BBox:     Where bounding information is to be saved.                     M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* SEE ALSO:                                                                  M
*   MdlModelBBox, CagdCrvListBBox, CagdSrfBBox, CagdTightBBox                M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlModelListBBox, bbox, bounding box                                     M
*****************************************************************************/
void MdlModelListBBox(MdlModelStruct *Mdls, CagdBBoxStruct *BBox)
{
    CagdBBoxStruct TmpBBox;

    CAGD_RESET_BBOX(BBox);

    if (Mdls == NULL)
	return;

    for ( ; Mdls != NULL; Mdls = Mdls -> Pnext) {
	MdlModelBBox(Mdls, &TmpBBox);
	CagdMergeBBox(BBox, &TmpBBox);
    }
}
