/******************************************************************************
* Rndr_lib.h - header file for the RNDR library.			      *
* This header is also the interface header to the world.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Michael Plavnik and Dimitri Beserb, Mar. 95.		      *
* Modified by David Shafrir and Alex Reicher, Mar 2004.			      *
******************************************************************************/

#ifndef RNDR_LIB_H
#define RNDR_LIB_H

#include <irit_sm.h>
#include <iritprsr.h>

typedef enum IRndrLightType {
    IRNDR_LIGHT_POINT,
    IRNDR_LIGHT_VECTOR,
    IRNDR_LIGHT_LAST
} IRndrLightType;

typedef enum IRndrShadingType {
    IRNDR_SHADING_FLAT,
    IRNDR_SHADING_GOURAUD,
    IRNDR_SHADING_PHONG,
    IRNDR_SHADING_NONE,
    IRNDR_SHADING_LAST
} IRndrShadingType;

typedef enum IRndrFuncType {
    IRNDR_NEVER,
    IRNDR_LESS,
    IRNDR_LEQUAL,
    IRNDR_GREATER,
    IRNDR_GEQUAL,
    IRNDR_EQUAL,
    IRNDR_NOTEQUAL,
    IRNDR_ALWAYS
} IRndrFuncType;

typedef enum IRndrOpType {
    IRNDR_KEEP,
    IRNDR_ZERO,
    IRNDR_REPLACE,
    IRNDR_INCR,
    IRNDR_DECR,
    IRNDR_INVERT
} IRndrOpType;

typedef PointType IRndrColorType;
typedef int IRndrBoolType;
typedef float IRndrZDepthType;
typedef struct IRndrStruct *IRndrPtrType;
typedef IRndrBoolType (*IRndrZCmpPolicyType)(int x,
					     int y,
					     RealType OldZ,
					     RealType NewZ);
typedef void (*IRndrPixelClbkType)(int x,
                                   int y,
                                   IRndrColorType Color,
                                   RealType Z);

/* Construct a new IRndrer. */
IRndrPtrType IRndrInitialize(int SizeX,
                             int SizeY,
                             int SuperSampSize,
			     int ColorQuantization,
                             IRndrBoolType UseTransparency,
                             IRndrBoolType BackfaceCulling,
                             IRndrColorType BackgrCol,
                             RealType AmbientLight);

/* Dispose of an IRender. */
void IRndrDestroy(IRndrPtrType Rend);

/* Clearing functions. */
void IRndrClearDepth(IRndrPtrType Rend, IRndrZDepthType ClearZ);

void IRndrClearStencil(IRndrPtrType Rend);

void IRndrClearColor(IRndrPtrType Rend);

/* Specify light sources (must be called only before any scan conversion
takes place). */
void IRndrAddLightSource(IRndrPtrType Rend,
                         IRndrLightType Type,
                         PointType Where,
                         IRndrColorType Color);

/* Configure IRndrer (at initialization or on-the-fly). */
void IRndrSetFilter(IRndrPtrType Rend,
                    char *FilterName);

void IRndrSetShadeModel(IRndrPtrType Rend,
                        IRndrShadingType ShadeModel);

void IRndrSetViewPrsp(IRndrPtrType Rend,
                      MatrixType ViewMat,
                      MatrixType PrspMat,
		      MatrixType ScrnMat);

void IRndrSetPllParams(IRndrPtrType Rend,
                       RealType MinWidth,
                       RealType MaxWidth,
                       RealType ZNear,
                       RealType ZFar);

void IRndrSetRawMode(IRndrPtrType Rend,
                     IRndrBoolType UseRawMode);

void IRndrSetZCmpPolicy(IRndrPtrType Rend,
                        IRndrZCmpPolicyType ZCmpPol);

void IRndrSetPreZCmpClbk(IRndrPtrType Rend,
                         IRndrPixelClbkType PixelClbk);

void IRndrSetPostZCmpClbk(IRndrPtrType Rend,
                          IRndrPixelClbkType ZPassClbk,
                          IRndrPixelClbkType ZFailClbk);

/* Stencil operations, OpenGL-style. */
void IRndrStencilFunc(IRndrPtrType Rend,
                      IRndrFuncType Func,
                      int Ref,
                      unsigned Mask);

void IRndrStencilOp(IRndrPtrType Rend,
                    IRndrOpType Fail,
                    IRndrOpType ZFail,
                    IRndrOpType ZPass);

/* Object scan conversion. */
void IRndrBeginObject(IRndrPtrType Rend,
                      IPObjectStruct *Object,
		      int NoShading);

void IRndrPutTriangle(IRndrPtrType Rend,
                      IPPolygonStruct *Triangle);

void IRndrEndObject(IRndrPtrType Rend);

/* Polyline scan conversion. */
void IRndrBeginPll(IRndrPtrType Rend);

void IRndrPutPllVertex(IRndrPtrType Rend,
                       IPVertexStruct *Vertex);

void IRndrEndPll(IRndrPtrType Rend);

/* "Manual" pixel rendering. */
void IRndrPutPixel(IRndrPtrType Rend,
                   int x,
                   int y,
                   RealType z,
                   RealType Transparency,
                   IRndrColorType Color);

/* Z Buffer Access - Pixel Resolution. */
void IRndrGetPixelColor(IRndrPtrType Rend,
                        int x,
                        int y,
                        IRndrColorType *Result);

void IRndrGetPixelDepth(IRndrPtrType Rend,
                        int x,
                        int y,
                        RealType *Result);

void IRndrGetPixelStencil(IRndrPtrType Rend,
                          int x,
                          int y,
                          int *Result);

/* Z Buffer Access - Line Resolution. */
void IRndrGetLineColor(IRndrPtrType Rend,
                       int y,
                       IRndrColorType *Result);

void IRndrGetLineDepth(IRndrPtrType Rend,
                       int y,
                       RealType *Result);

void IRndrGetLineStencil(IRndrPtrType Rend,
                         int y,
                         int *Result);

/* Clipping support. */
void IRndrGetClippingPlanes(IRndrPtrType Rend,
                            PlaneType *ClipPlanes);

void IRndrSetZBounds(IRndrPtrType Rend,
                     RealType ZNear,
                     RealType ZFar);

/* Dump z-buffer contents to a file. */
void IRndrSaveFile(IRndrPtrType Rend,
                   char *BaseDirectory,
                   char *OutFileName,
                   char *Type);

void IRndrSaveFileDepth(IRndrPtrType Rend,
                   char *BaseDirectory,
                   char *OutFileName,
                   char *Type);

void IRndrSaveFileStencil(IRndrPtrType Rend,
                   char *BaseDirectory,
                   char *OutFileName,
                   char *Type);

#endif
