/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Global definitions of	Graphics interface.			             *
*****************************************************************************/

#ifndef	IRIT_GRAP_H	/* Define only once */
#define	IRIT_GRAP_H

#include "irit_sm.h"
#include "misc_lib.h"
#include "iritprsr.h"
#include "geom_lib.h"

#define IG_IRIT_BLACK		0
#define IG_IRIT_BLUE		1
#define IG_IRIT_GREEN		2
#define IG_IRIT_CYAN		3
#define IG_IRIT_RED		4
#define IG_IRIT_MAGENTA		5
#define IG_IRIT_BROWN		6
#define IG_IRIT_LIGHTGREY	7
#define IG_IRIT_DARKGRAY	8
#define IG_IRIT_LIGHTBLUE	9
#define IG_IRIT_LIGHTGREEN	10
#define IG_IRIT_LIGHTCYAN	11
#define IG_IRIT_LIGHTRED	12
#define IG_IRIT_LIGHTMAGENTA	13
#define IG_IRIT_YELLOW		14
#define IG_IRIT_WHITE		15

#define IG_MAX_COLOR		15

#define IG_LINE_SOLID		1
#define IG_LINE_DOTTED		2
#define IG_LINE_DASHED		3
#define IG_LINE_DOTTED_DASHED	4

#define IG_SHADING_NONE		0
#define IG_SHADING_BACKGROUND	1
#define IG_SHADING_FLAT		2
#define IG_SHADING_GOURAUD	3
#define IG_SHADING_PHONG	4

#define IG_SKETCHING_NONE		0
#define IG_SKETCHING_ISO_PARAM		1
#define IG_SKETCHING_CURVATURE		2
#define IG_SKETCHING_ISOCLINES		3
#define IG_SKETCHING_ORTHOCLINES	4

#define IG_SKETCH_TYPE_NONE		0
#define IG_SKETCH_TYPE_SILHOUETTE	1
#define IG_SKETCH_TYPE_SHADING		2
#define IG_SKETCH_TYPE_IMPORTANCE	3

#define IG_STATE_OFF		-32760
#define IG_STATE_ON		-32761
#define IG_STATE_DEC		IG_STATE_OFF
#define IG_STATE_INC		IG_STATE_ON
#define IG_STATE_TGL		-32762

#define IG_POLYGON_Z_TRANS 0.01       /* Z trans of polygons over polylines. */

/* The current NormalLength is divided by scalar to form real normal length: */
#define IG_NORMAL_DEFAULT_LENGTH	100
#define IG_NORMAL_SCALER_LENGTH		1000

/* The current point cross length is divided by scalar to form real length:  */
#define IG_POINT_DEFAULT_LENGTH	20
#define IG_POINT_SCALER_LENGTH	1000

#define IG_DEFAULT_COLOR	    1  /* For objects with no color defined. */

#define IG_VIEW_PERSPECTIVE		1		      /* View modes. */
#define IG_VIEW_ORTHOGRAPHIC		2
#define IG_DEFAULT_PERSPECTIVE_Z	-5.0	   /* Default Z focal point. */

#define IG_TRANS_SCREEN	1     /* Screen, Object coords. transformation mode. */
#define IG_TRANS_OBJECT	2

#define IG_DEFAULT_NUM_OF_ISOLINES	10
#define IG_DEFAULT_SAMPLES_PER_CURVE	64
#define IG_DEFAULT_PLLN_OPTI_FINENESS	0.005
#define IG_DEFAULT_POLYGON_FINENESS	20

#define IG_DEFAULT_IRIT_MAT		"irit.imd"
#define IG_DEFAULT_IRIT_PICK_SAVE	"iritpick"

#define IG_MAX_ROTATE_ANGLE	45.0 /* Max. rates used by interactive mode. */
#define IG_MAX_TRANSLATE_FACTOR	2.0
#define IG_MAX_SCALE_FACTOR	2.0
#define IG_MAX_CLIP_FACTOR	0.5

#define IG_IS_DRAG_EVENT(Event)	(Event == IG_EVENT_PERS_ORTHO_Z || \
				 Event == IG_EVENT_ROTATE || \
				 Event == IG_EVENT_ROTATE_X || \
				 Event == IG_EVENT_ROTATE_Y || \
				 Event == IG_EVENT_ROTATE_Z || \
				 Event == IG_EVENT_TRANSLATE || \
				 Event == IG_EVENT_TRANSLATE_X || \
				 Event == IG_EVENT_TRANSLATE_Y || \
				 Event == IG_EVENT_TRANSLATE_Z || \
				 Event == IG_EVENT_SCALE || \
				 Event == IG_EVENT_NEAR_CLIP || \
				 Event == IG_EVENT_FAR_CLIP)

#define IG_HIGHLIGHT1_OBJ_TAG	0x20
#define IG_HIGHLIGHT2_OBJ_TAG	0x40
#define IG_IS_HIGHLIGHT1_OBJ(Obj)   ((Obj) -> Tags & IG_HIGHLIGHT1_OBJ_TAG)
#define IG_SET_HIGHLIGHT1_OBJ(Obj)  ((Obj) -> Tags |= IG_HIGHLIGHT1_OBJ_TAG)
#define IG_RST_HIGHLIGHT1_OBJ(Obj)  ((Obj) -> Tags &= ~IG_HIGHLIGHT1_OBJ_TAG)
#define IG_IS_HIGHLIGHT2_OBJ(Obj)   ((Obj) -> Tags & IG_HIGHLIGHT2_OBJ_TAG)
#define IG_SET_HIGHLIGHT2_OBJ(Obj)  ((Obj) -> Tags |= IG_HIGHLIGHT2_OBJ_TAG)
#define IG_RST_HIGHLIGHT2_OBJ(Obj)  ((Obj) -> Tags &= ~IG_HIGHLIGHT2_OBJ_TAG)

#define IG_MAX_LIGHT_SOURCES 10          /* Maximal number of light sources. */

#define IG_PICK_POLY       (1 << IP_OBJ_POLY)
#define IG_PICK_NUMERIC    (1 << IP_OBJ_NUMERIC)
#define IG_PICK_POINT      (1 << IP_OBJ_POINT)
#define IG_PICK_VECTOR     (1 << IP_OBJ_VECTOR)
#define IG_PICK_PLANE      (1 << IP_OBJ_PLANE)
#define IG_PICK_MATRIX     (1 << IP_OBJ_MATRIX)
#define IG_PICK_CURVE      (1 << IP_OBJ_CURVE)
#define IG_PICK_SURFACE    (1 << IP_OBJ_SURFACE)
#define IG_PICK_STRING     (1 << IP_OBJ_STRING)
#define IG_PICK_LIST_OBJ   (1 << IP_OBJ_LIST_OBJ)
#define IG_PICK_CTLPT      (1 << IP_OBJ_CTLPT)
#define IG_PICK_TRIMSRF    (1 << IP_OBJ_TRIMSRF)
#define IG_PICK_TRIVAR     (1 << IP_OBJ_TRIVAR)
#define IG_PICK_INSTANCE   (1 << IP_OBJ_INSTANCE)
#define IG_PICK_TRISRF     (1 << IP_OBJ_TRISRF)
#define IG_PICK_MODEL      (1 << IP_OBJ_MODEL)
#define IG_PICK_MULTIVAR   (1 << IP_OBJ_MULTIVAR)
#define IG_PICK_ANY    (IG_PICK_POLY | IG_PICK_NUMERIC | IG_PICK_POINT | \
		        IG_PICK_VECTOR | IG_PICK_PLANE | IG_PICK_MATRIX | \
		        IG_PICK_CURVE | IG_PICK_SURFACE | IG_PICK_STRING | \
		        IG_PICK_LIST_OBJ | IG_PICK_CTLPT | IG_PICK_TRIMSRF | \
		        IG_PICK_TRIVAR | IG_PICK_INSTANCE | IG_PICK_TRISRF | \
		        IG_PICK_MODEL | IG_PICK_MULTIVAR)
#define IG_PICK_OBJ(IGObjType)  ((IGObjType) & IGGlblPickObjTypes)
#define IG_PICK_SET_TYPE(Type, Set) if (Set) \
				        IGGlblPickObjTypes |= Type; \
				    else \
				        IGGlblPickObjTypes &= ~(Type)
#define IG_ADD_ORIENT_NRML(P, N) \
				if (IGGlblFlipNormalOrient) { \
				    P[0] = P[0] - N[0] * IGGlblNormalLen; \
				    P[1] = P[1] - N[1] * IGGlblNormalLen; \
				    P[2] = P[2] - N[2] * IGGlblNormalLen; \
				} \
				else { \
				    P[0] = P[0] + N[0] * IGGlblNormalLen; \
				    P[1] = P[1] + N[1] * IGGlblNormalLen; \
				    P[2] = P[2] + N[2] * IGGlblNormalLen; \
				}

typedef enum {
    IG_WIDGET_ENVIRONMENT = 1,
    IG_WIDGET_ANIMATION   = 2,
    IG_WIDGET_CURVES      = 4,
    IG_WIDGET_SURFACES    = 8,
    IG_WIDGET_SHADING     = 16,
    IG_WIDGET_PICK_OBJS   = 32,
    IG_WIDGET_OBJS_TRANS  = 64
} IGWidgetType;

typedef enum {
    IG_EVENT_ZERO = 0,
    IG_EVENT_RESET,
    IG_EVENT_NONE = 2000,
    IG_EVENT_DISCONNECT,
    IG_EVENT_QUIT,
    IG_EVENT_SCR_OBJ_TGL,
    IG_EVENT_CONT_MOTION,
    IG_EVENT_NRML_ORIENT,
    IG_EVENT_PERS_ORTHO_TGL,
    IG_EVENT_PERS_ORTHO_Z,
    IG_EVENT_ROTATE,
    IG_EVENT_ROTATE_X,
    IG_EVENT_ROTATE_Y,
    IG_EVENT_ROTATE_Z,
    IG_EVENT_TRANSLATE,
    IG_EVENT_TRANSLATE_X,
    IG_EVENT_TRANSLATE_Y,
    IG_EVENT_TRANSLATE_Z,
    IG_EVENT_SCALE,
    IG_EVENT_NEAR_CLIP,
    IG_EVENT_FAR_CLIP,
    IG_EVENT_DEPTH_CUE,
    IG_EVENT_3D_GLASSES,
    IG_EVENT_DBL_BUFFER,
    IG_EVENT_ACCUM_MATRIX,
    IG_EVENT_SAVE_MATRIX,
    IG_EVENT_SUBMIT_MATRIX,
    IG_EVENT_PUSH_MATRIX,
    IG_EVENT_POP_MATRIX,
    IG_EVENT_ANIMATION,
    IG_EVENT_SHADE_PARAM,
    IG_EVENT_CRV_EDIT,
    IG_EVENT_SRF_EDIT,
    IG_EVENT_PICK_OBJS,
    IG_EVENT_OBJ_MANIP,
    IG_EVENT_STATE
} IGGraphicEventType;

typedef enum {   /* Note that some device drivers depends on this order. */
    IG_STATE_NONE,
    IG_STATE_OOPS,
    IG_STATE_MOUSE_SENSITIVE,
    IG_STATE_SCR_OBJ_TGL,
    IG_STATE_CONT_MOTION,
    IG_STATE_PERS_ORTHO_TGL,
    IG_STATE_DEPTH_CUE,
    IG_STATE_3D_GLASSES,
    IG_STATE_CACHE_GEOM,
    IG_STATE_DRAW_STYLE,
    IG_STATE_SHADING_MODEL,
    IG_STATE_BACK_FACE_CULL,
    IG_STATE_DOUBLE_BUFFER,
    IG_STATE_ANTI_ALIASING,
    IG_STATE_DRAW_INTERNAL,
    IG_STATE_DRAW_VNORMAL,
    IG_STATE_DRAW_PNORMAL,
    IG_STATE_DRAW_POLYGONS,
    IG_STATE_DRAW_SRF_MESH,
    IG_STATE_DRAW_SRF_WIRE,
    IG_STATE_DRAW_SRF_BNDRY,
    IG_STATE_DRAW_SRF_SILH,
    IG_STATE_DRAW_SRF_POLY,
    IG_STATE_DRAW_SRF_SKTCH,
    IG_STATE_DRAW_SRF_RFLCT_LNS,
    IG_STATE_FOUR_PER_FLAT,
    IG_STATE_NUM_ISOLINES,
    IG_STATE_POLYGON_APPROX,
    IG_STATE_SAMP_PER_CRV_APPROX,
    IG_STATE_LENGTH_VECTORS,
    IG_STATE_WIDTH_LINES,
    IG_STATE_WIDTH_POINTS,
    IG_STATE_POLYGON_OPTI,
    IG_STATE_POLYLINE_OPTI,
    IG_STATE_VIEW_FRONT,
    IG_STATE_VIEW_SIDE,
    IG_STATE_VIEW_TOP,
    IG_STATE_VIEW_ISOMETRY,
    IG_STATE_VIEW_4,
    IG_STATE_CLEAR_VIEW,
    IG_STATE_ANIMATION,

    IG_STATE_NUM_POLY_COUNT,
    IG_STATE_NRML_ORIENT,
    IG_STATE_POLY_APPROX,

    IG_STATE_RES_ADAP_ISO,
    IG_STATE_RES_RULED_SRF,
    IG_STATE_RULED_SRF_APPROX,
    IG_STATE_ADAP_ISO_DIR,

    IG_STATE_LOWRES_RATIO,

    IG_STATE_CLIP_TESS_POLES,

    IG_STATE_SKETCH_ISO_PARAM,
    IG_STATE_SKETCH_CURVATURE,
    IG_STATE_SKETCH_SILHOUETTE,

    IG_STATE_SKETCH_SIL_POWER,
    IG_STATE_SKETCH_SHADING_POWER,
    IG_STATE_SKETCH_IMP_DECAY,
    IG_STATE_SKETCH_IMP_FRNT_SPRT,
    IG_STATE_SKETCH_IMPORTANCE,

    IG_STATE_SHADE_PARAM,
    IG_STATE_SHADE_AMBIENT,
    IG_STATE_SHADE_DIFFUSE,
    IG_STATE_SHADE_SPECULAR,
    IG_STATE_SHADE_SHININESS,
    IG_STATE_SHADE_EMISSION,

    IG_STATE_SHADE_LGT_SRC_IDX,
    IG_STATE_SHADE_LGT_SRC_X,
    IG_STATE_SHADE_LGT_SRC_Y,
    IG_STATE_SHADE_LGT_SRC_Z,
    IG_STATE_SHADE_LGT_SRC_W,

    IG_STATE_SHADE_RESET,
    IG_STATE_SHADE_DISMISS,

    IG_STATE_DRAW_STYLE_SOLID,
    IG_STATE_DRAW_STYLE_WIREFRAME,
    IG_STATE_DRAW_STYLE_POINTS,

    IG_STATE_ANTI_ALIAS_OFF,
    IG_STATE_ANTI_ALIAS_ON,
    IG_STATE_ANTI_ALIAS_BLEND,

    IG_STATE_CRV_EDIT,

    IG_STATE_SAVE_IMAGE,

    IG_STATE_FRAME_PER_SEC
} IGGlblStateType;

typedef enum {               /* Mouse event reports on pick cursor requests. */
    IG_PICK_REP_NONE,
    IG_PICK_REP_MOTION,
    IG_PICK_REP_BTN1DOWN,
    IG_PICK_REP_BTN2DOWN,
    IG_PICK_REP_BTN3DOWN,
    IG_PICK_REP_BTN_UP
} IGPickReportType;

typedef enum {               /* Mouse event reports on pick cursor requests. */
    IG_PICK_ENTITY_NONE,
    IG_PICK_ENTITY_DONE,
    IG_PICK_ENTITY_OBJECT,
    IG_PICK_ENTITY_OBJ_NAME,
    IG_PICK_ENTITY_CURSOR
} IGPickEntityType;

typedef enum {
    IG_GLASSES_3D_NONE,
    IG_GLASSES_3D_CHROMADEPTH,
    IG_GLASSES_3D_RED_BLUE,
    IG_GLASSES_3D_RED_GREEN
} IGGlasses3DType;

typedef float IGLightType[4];

typedef struct IGShadeParamStruct {
    int NumOfLightSrcs;
    IGLightType LightPos[IG_MAX_LIGHT_SOURCES];
    IGLightType LightAmbient;
    IGLightType LightDiffuse;
    IGLightType LightSpecular;
    IGLightType LightEmissive;
    float Shininess;
} IGShadeParamStruct;

typedef struct IGSketchParamStruct {
    RealType ShadePower;
    RealType SilPower;
    int SketchSilType;
    int SketchShdType;
    int SketchImpType;
    int SketchImp;
    int SketchInvShd;
    RealType SketchImpDecay;
    RealType SketchImpFrntSprt;
} IGSketchParamStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern GLOBAL_DATA int
    IGGlblBackGroundColor[3],
    IGGlblHighlight1Color[3],
    IGGlblHighlight2Color[3],
    IGGlblDrawInternal,
    IGGlblDrawVNormal,
    IGGlblDrawPNormal,
    IGGlbl4Views,
    IGGlblMore,
    IGGlblForceUnitMat,
    IGGlblDrawStyle,
    IGGlblShadingModel,
    IGGlblBackFaceCull,
    IGGlblDoDoubleBuffer,
    IGGlblNumOfIsolines,
    IGGlblLineWidth,
    IGGlblAdapIsoDir,
    IGGlblPolygonOptiApprox,
    IGGlblDepthCue,
    IGGlblCacheGeom,
    IGGlblFourPerFlat,
    IGGlblAntiAliasing,
    IGGlblDrawPolygons,
    IGGlblDrawSurfaceMesh,
    IGGlblDrawSurfacePoly,
    IGGlblDrawSurfaceWire,
    IGGlblDrawSurfaceBndry,
    IGGlblDrawSurfaceSilh,
    IGGlblDrawSurfaceSketch,
    IGGlblDrawSurfaceRflctLns,
    IGGlblStandAlone,
    IGGlblTransformMode,
    IGGlblViewMode,
    IGGlblDebugObjectsFlag,
    IGGlblDebugEchoInputFlag,
    IGGlblDelayedClear,
    IGGlblIntensityHighState,
    IGGlblAbortKeyPressed,
    IGGlblAnimation,
    IGGlblPolygonStrips,
    IGGlblManipulationActive,
    IGLastWasSolidRendering,
    IGGlblContinuousMotion,
    IGGlblFlipNormalOrient,
    IGGlblLastLowResDraw,
    IGGlblClipAtPoles,
    IGGlblClientHandleNumber,
    IGGlblPickObjTypes,
    IGGlblSavePickedPoly,
    IGGlblCountNumPolys,
    IGGlblCountFramePerSec,
    IGGlblNumPolys,
    IGGlblNumFiles,
    IGGlblIOHandle,
    IGGlblInitWidgetDisplay,
    IGGlblActiveXMode,
    IGGlbl3DGlassesImgIndx;

extern GLOBAL_DATA SymbCrvApproxMethodType
    IGGlblPolylineOptiApprox;

extern GLOBAL_DATA char
    *IGGlblImageFileName,
    *IGGlblPolyPickFileName,
    *IGGlblExecAnimation,
    *IGGlblTransPrefPos,
    *IGGlblViewPrefPos,
    **IGGlblFileNames;

extern GLOBAL_DATA RealType
    IGGlblRelLowresFineNess,
    IGGlblMinPickDist,
    IGGlblPointWidth,
    IGGlblPlgnFineness,
    IGGlblPllnFineness,
    IGGlblChangeFactor,
    IGGlblZMinClip,
    IGGlblZMaxClip,
    IGGlblNormalLen,
    IGGlblEyeDistance,
    IGGlblFramePerSec,
    IGGlblOpacity;

extern GLOBAL_DATA PointType
    IGGlblPickPos,
    IGGlblPickPosE3;

extern IGGlasses3DType
    IGGlbl3DGlassesMode;

extern GLOBAL_DATA IPObjectStruct
    *IGGlblNewDisplayObjects,
    *IGGlblDisplayList,
    *IGGlblPickedObj,
    *IGGlblPickedPolyObj;

extern GLOBAL_DATA MatrixType
    IGGlblCrntViewMat,
    IGGlblInvCrntViewMat,
    IGGlblIsometryViewMat;

extern GLOBAL_DATA GMAnimationStruct IGAnimation;

extern GLOBAL_DATA IGShadeParamStruct IGShadeParam;

extern GLOBAL_DATA IGSketchParamStruct IGSketchParam;

#ifdef __WINNT__
void IGRedirectIOToConsole(void);
#endif /* __WINNT__ */

/* Gen_grap.c routines - generic graphic's driver routines. */
void IGConfigureGlobals(char *PrgmName, int argc, char **argv);
void IGConfigReset(void);
void IGConfirmConvexPolys(IPObjectStruct *PObj, int Depth);
void IGProcessCommandMessages(int ProcessCommandMessages);
int IGReadObjectsFromSocket(int ViewMode, IPObjectStruct **DisplayList);
void IGAddReplaceObjDisplayList(IPObjectStruct **DisplayList,
				IPObjectStruct *NewObj,
				char *ObjName);
int IGHandleObjectsFromSocket(int ViewMode,
			      IPObjectStruct *PObjs,
			      IPObjectStruct **DisplayList);
void IGSaveCurrentMat(int ViewMode, char *Name);
void IGSubmitCurrentMat(int ViewMode);
void IGHighlightSavePickedPoly(IPPolygonStruct *Pl, int IsPolyline);
void IGHandleContinuousMotion(void);
int IGProcessEvent(IGGraphicEventType Event, RealType *ChangeFactor);
void IGActiveListFreeNamedAttribute(IPObjectStruct *PObjs, char *Name);
void IGActiveFreeNamedAttribute(IPObjectStruct *PObj, char *Name);
void IGActiveListFreePolyIsoAttribute(IPObjectStruct *PObjs,
				      int FreePolygons,
				      int FreeIsolines,
				      int FreeSketches,
				      int FreeCtlMesh);
void IGActiveFreePolyIsoAttribute(IPObjectStruct *PObj,
				  int FreePolygons,
				  int FreeIsolines,
				  int FreeSketches,
				  int FreeCtlMesh);
void IGUpdateObjectBBox(IPObjectStruct *PObj);
int IGDefaultStateHandler(int State, int StateStatus, int Refresh);
int IGDeleteOneObject(IPObjectStruct *PObj);
void IGTraverseObjListHierarchy(IPObjectStruct *PObjList,
				MatrixType CrntViewMat,
				IPApplyObjFuncType ApplyFunc);
void IGPredefinedAnimation(void);
IPObjectStruct *IGFindObjectByName(char *Name);
void IGDrawPolySilhBndry(IPObjectStruct *PObj);
void IGDrawPolygonSketches(IPObjectStruct *PObj);
IPObjectStruct *IGGenPolygonSketches(IPObjectStruct *PObj, RealType FineNess);
void IGDrawPolySilhOpt(IPObjectStruct *PObj);
IPObjectStruct *IGGetObjIsoLines(IPObjectStruct *PObj);
IPObjectStruct *IGGetObjPolygons(IPObjectStruct *PObj);
int IGInitSrfTexture(IPObjectStruct *PObj);
void IGUpdateViewConsideringScale(MatrixType Mat);
void IGInitializeSubViewMat(void);
void IGUpdateFPS(void);

/* Functions that should be defined in most graphics driver. */
int IGHandleState(int State, int StateStatus, int Refresh);
void IGHandleInternalEvents(void);
void IGSaveDisplayAsImage(char *ImageFileName);
void IGPopupCrvEditor(IPObjectStruct *CrvObj);
void IGPopupSrfEditor(IPObjectStruct *SrfObj);
void IGPopupObjEditor(IPObjectStruct *PObj, int CloneIt);
void IGCreateStateMenu(void);
void IGSetColorIntensity(int High);
void IGSetColorObj(IPObjectStruct *PObj);
void IGSetColorRGB(int Color[3]);
void IGSetLightSource(IGLightType LightPos,
		      VectorType LightColor,
		      int LightIndex);
void IGSetWidthObj(int Width);
void IGSetLinePattern(int Pattern);
void IGSetTranspObj(RealType Transparency);
int IGSetTexture(IPObjectStruct *PObj);
void IGViewObject(IPObjectStruct *PObj, MatrixType Mat);
void IGIritBeep(void);
void IGPlotTo2D(RealType X, RealType Y);
void IGMoveTo2D(RealType X, RealType Y);
void IGLineTo2D(RealType X, RealType Y);
void IGSaveCurrentMatInFile(int ViewMode);
void IGIritError(char *Msg);
int IGIritYesNoQuestion(char *Msg);
int IGSetDisplay4Views(int Display4Views);

/* The primitive drawing routines. */
  void IGPlotTo3D(RealType *Pt);
void IGMoveTo3D(RealType *Pt);
void IGLineTo3D(RealType *Pt);
void IGDrawObject(IPObjectStruct *PObj);
void IGDrawPtVec(IPObjectStruct *PObj);
void IGDrawString(IPObjectStruct *PObj);
void IGDrawPoly(IPObjectStruct *PObj);
void IGDrawPolylineNormal(IPObjectStruct *PObj);
void IGDrawCurve(IPObjectStruct *PObj);
void IGDrawSurface(IPObjectStruct *PObj);
void IGDrawTrimSrf(IPObjectStruct *PObj);
void IGDrawTrivar(IPObjectStruct *PObj);
void IGDrawTriangSrf(IPObjectStruct *PObj);
void IGDrawModel(IPObjectStruct *PObj);
void IGRedrawViewWindow(void);
int IGRedrawViewWinInitRedGreen(int ImgIndx);
void IGRedrawViewWindowOGL(int ClearAll);

/* The picking routine. */
void IGReleasePickedObject(void);
IPObjectStruct *IGHandleGenericPickEvent(RealType ObjectX,
					 RealType ObjectY,
					 int PickTypes);
void IGHandleGenericCursorEvent(RealType ObjectX,
				RealType ObjectY,
				IGPickReportType PickReport);
void IGHandlePickObject(IGPickEntityType PickEntity);
char *IGGenerateWindowHeaderString(char *Str);
char *IGStrResGenericPickEvent(IPObjectStruct *PObj);
IPObjectStruct *IGHandlePickEvent(int ScreenX, int ScreenY, int PickTypes);
void IGHandleCursorEvent(int ScreenX,
			 int ScreenY,
			 IGPickReportType PickReport);
void IGGenericScreenToObject(RealType ScreenX,
			     RealType ScreenY,
			     PointType Pt,
			     VectorType Dir);
void IGScreenToObject(int ScreenX, int ScreenY, PointType Pt, VectorType Dir);

/* Sketching related routines for freeforms surfaces and polygonal meshes. */
IPObjectStruct *IGSketchGenSrfSketches(CagdSrfStruct *Srf,
				       RealType FineNess,
				       IPObjectStruct *PObj,
				       int Importance);
void IGSketchDrawSurface(IPObjectStruct *PObj);

IPObjectStruct *IGSketchGenPolySketches(IPObjectStruct *PlObj,
					RealType FineNess,
					int Importance);
IPObjectStruct *IGSketchGenPolyImportanceSketches(IPObjectStruct *PObj,
					    IGSketchParamStruct *SketchParams,
					    RealType FineNess);
void IGSketchDrawPolygons(IPObjectStruct *PObjSketches);

/* View dependent polygonization - using output sensitive silhouettes. */
IPObjectStruct *IGVGGenDataStruct(IPObjectStruct *PObj);
IPObjectStruct *IGVGSelect(IPObjectStruct *PObj);

/* Vertex shader hardware rendering routines. */
int IGDrawDTexture(IPObjectStruct *PObj);
void IGFreeDTexture(IPObjectStruct *PObj);

typedef int (*IGVertexHandleExtraFuncType)(IPVertexStruct *V);
IGVertexHandleExtraFuncType IGSetHandleVertexProcessingFunc(
				    IGVertexHandleExtraFuncType NewVertexFunc);
int IGFfdDraw(IPObjectStruct *PObj);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* IRIT_GRAP_H */

