/******************************************************************************
* Geom_err.c - handler for all geom library fatal errors.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 98.					      *
******************************************************************************/

#include "geom_loc.h"

typedef struct GeomErrorStruct {
    GeomFatalErrorType ErrorNum;
    char *ErrorDesc;
} GeomErrorStruct;

STATIC_DATA GeomErrorStruct ErrMsgs[] =
{
    { GEOM_ERR_NO_OGL_SUPPORT,       "Open GL is not supported in this environment" },
    { GEOM_ERR_OGL_NO_X_SERVER,      "OGL: Failed to access X server" },
    { GEOM_ERR_X_NO_OGL_SERVER,      "OGL: X server with no OGL support" },
    { GEOM_ERR_X_NO_VISUAL,          "OGL: X server failed in visual allocation" },
    { GEOM_ERR_X_NO_GCONTEXT,        "OGL: X failed to create graphics context" },
    { GEOM_ERR_CH_STACK_OVERFLOW,    "Stack overflow for convex hull computation" },
    { GEOM_ERR_CH_STACK_UNDERFLOW,   "Stack underflow for convex hull computation" },
    { GEOM_ERR_NO_INSTANCE_ORIGIN,   "Failed to find instance's origin" },
    { GEOM_ERR_ANIM_MAT_OR_CRV,      "Only matrics and curves are supported in animation" },
    { GEOM_ERR_UNKNOWN_ANIM_CRVS,    "Unknown animation curve is ignored" },
    { GEOM_ERR_NO_ANIM_CRVS,         "No animation attributes were found" },
    { GEOM_ERR_UNEQUAL_NUM_OF_POLYS, "Unequal number of polygons is given" },
    { GEOM_ERR_UNEQUAL_NUM_OF_VRTXS, "Unequal number of vertices is given" },
    { GEOM_ERR_TOO_MANY_ADJACENCIES, "More than one adjacency detected" },
    { GEOM_ERR_NO_IRIT_PATH,	     "IRIT_PATH env. not set. Cannot load irit font" },
    { GEOM_ERR_INVALID_FONT,	     "Unable to read font or invalid format" },
    { GEOM_ERR_MSC_TOO_FEW_PTS,	     "Too few points to use in minimum spanning circle" },
    { GEOM_ERR_MSC_COLIN_CIRC,	     "Collinear pts in attempt to derive min span circ" },
    { GEOM_ERR_TRIANGLES_ONLY,	     "Expecting only triangles at this time" },
    { GEOM_ERR_INVALID_POLYGON,	     "Invalid polygon (or NULL terminated poly)" },
    { GEOM_ERR_VRTX_MTCH_FAILED,     "Matching of vertices failed" },

    { GEOM_ERR_EXPCT_POLYHEDRA,      "Expecting a polyhedra model" },
    { GEOM_ERR_EXPCT_POLYLINE,       "Expecting a polyline model" },
    { GEOM_ERR_EXPCT_LIST_OBJ,       "Expecting a list object" },
    { GEOM_ERR_EXPCT_TWO_PTS,        "Expected at least two points" },
    { GEOM_ERR_PROJ_FAILED,	     "Failed to find a projection plane" },
    { GEOM_ERR_DECIM_BDRY_FAILED,    "Decimation for given object's boundaries failed" },
    { GEOM_ERR_OPEN_OBJ_VOL_COMP,    "Open object detected in volume computation" },
    { GEOM_ERR_NO_INV_MAT,	     "No inverse matrix exists" },
    { GEOM_ERR_NO_POLY_PLANE,	     "No polygon plane detected" },
    { GEOM_ERR_NO_VRTX_NRML,	     "No vertex normals detected" },
    { GEOM_ERR_REGULAR_POLY,	     "Regular model expected" },
    { GEOM_ERR_REORIENT_STACK_OF,    "Reorient stack overflow, object too large" },
    { GEOM_ERR_DISJOINT_PARTS,	     "Polygonal object with disjoint parts detected" },
    { GEOM_ERR_VRTX_MUST_HAVE_NRML,  "Vertices must have normals" },
    { GEOM_ERR_MISS_VRTX_IDX,	     "Vertices must have index" },


    { GEOM_ERR_UNDEFINE_ERR,	     NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this geom library as well as other users. Raised error will  M
* cause an invokation of GeomFatalError function which decides how to handle M
* this error. GeomFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   GeomDescribeError, error handling                                        M
*****************************************************************************/
char *GeomDescribeError(GeomFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
