/******************************************************************************
* CBzr_Tbl.c - Bezier curves handling routines - I Choose K table.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "cagd_loc.h"

/* See also CAGD_MAX_BEZIER_CACHE_ORDER in cagd_lib.h */

#ifdef CAGD_LARGE_BEZIER_CACHE		      /* This is I choose K upto 99. */

GLOBAL_DATA CagdRType CagdIChooseKTable[CAGD_MAX_BEZIER_CACHE_ORDER + 1]
		                       [CAGD_MAX_BEZIER_CACHE_ORDER + 1] = {
    { 1.0 },
    { 1.0, 1.0 },
    { 1.0, 2.0, 1.0 },
    { 1.0, 3.0, 3.0, 1.0 },
    { 1.0, 4.0, 6.0, 4.0, 1.0 },
    { 1.0, 5.0, 10.0, 10.0, 5.0, 1.0 },
    { 1.0, 6.0, 15.0, 20.0, 15.0, 6.0, 1.0 },
    { 1.0, 7.0, 21.0, 35.0, 35.0, 21.0, 7.0, 1.0 },
    { 1.0, 8.0, 28.0, 56.0, 70.0, 56.0, 28.0, 8.0, 1.0 },
    { 1.0, 9.0, 36.0, 84.0, 126.0, 126.0, 84.0, 36.0, 9.0, 1.0 },
    { 1.0, 10.0, 45.0, 120.0, 210.0, 252.0, 210.0, 120.0, 45.0, 10.0, 1.0 },
    { 1.0, 11.0, 55.0, 165.0, 330.0, 462.0, 462.0, 330.0, 165.0, 55.0, 11.0, 1.0 },
    { 1.0, 12.0, 66.0, 220.0, 495.0, 792.0, 924.0, 792.0, 495.0, 220.0, 66.0, 12.0, 1.0 },
    { 1.0, 13.0, 78.0, 286.0, 715.0, 1287.0, 1716.0, 1716.0, 1287.0, 715.0, 286.0, 78.0, 13.0, 1.0 },
    { 1.0, 14.0, 91.0, 364.0, 1001.0, 2002.0, 3003.0, 3432.0, 3003.0, 2002.0, 1001.0, 364.0, 91.0, 14.0, 1.0 },
    { 1.0, 15.0, 105.0, 455.0, 1365.0, 3003.0, 5005.0, 6435.0, 6435.0, 5005.0, 3003.0, 1365.0, 455.0, 105.0, 15.0, 1.0 },
    { 1.0, 16.0, 120.0, 560.0, 1820.0, 4368.0, 8008.0, 11440.0, 12870.0, 11440.0, 8008.0, 4368.0, 1820.0, 560.0, 120.0, 16.0, 1.0 },
    { 1.0, 17.0, 136.0, 680.0, 2380.0, 6188.0, 12376.0, 19448.0, 24310.0, 24310.0, 19448.0, 12376.0, 6188.0, 2380.0, 680.0, 136.0, 17.0, 1.0 },
    { 1.0, 18.0, 153.0, 816.0, 3060.0, 8568.0, 18564.0, 31824.0, 43758.0, 48620.0, 43758.0, 31824.0, 18564.0, 8568.0, 3060.0, 816.0, 153.0, 18.0, 1.0 },
    { 1.0, 19.0, 171.0, 969.0, 3876.0, 11628.0, 27132.0, 50388.0, 75582.0, 92378.0, 92378.0, 75582.0, 50388.0, 27132.0, 11628.0, 3876.0, 969.0, 171.0, 19.0, 1.0 },
    { 1.0, 20.0, 190.0, 1140.0, 4845.0, 15504.0, 38760.0, 77520.0, 125970.0, 167960.0, 184756.0, 167960.0, 125970.0, 77520.0, 38760.0, 15504.0, 4845.0, 1140.0, 190.0, 20.0, 1.0 },
    { 1.0, 21.0, 210.0, 1330.0, 5985.0, 20349.0, 54264.0, 116280.0, 203490.0, 293930.0, 352716.0, 352716.0, 293930.0, 203490.0, 116280.0, 54264.0, 20349.0, 5985.0, 1330.0, 210.0, 21.0, 1.0 },
    { 1.0, 22.0, 231.0, 1540.0, 7315.0, 26334.0, 74613.0, 170544.0, 319770.0, 497420.0, 646646.0, 705432.0, 646646.0, 497420.0, 319770.0, 170544.0, 74613.0, 26334.0, 7315.0, 1540.0, 231.0, 22.0, 1.0 },
    { 1.0, 23.0, 253.0, 1771.0, 8855.0, 33649.0, 100947.0, 245157.0, 490314.0, 817190.0, 1144066.0, 1352078.0, 1352078.0, 1144066.0, 817190.0, 490314.0, 245157.0, 100947.0, 33649.0, 8855.0, 1771.0, 253.0, 23.0, 1.0 },
    { 1.0, 24.0, 276.0, 2024.0, 10626.0, 42504.0, 134596.0, 346104.0, 735471.0, 1307504.0, 1961256.0, 2496144.0, 2704156.0, 2496144.0, 1961256.0, 1307504.0, 735471.0, 346104.0, 134596.0, 42504.0, 10626.0, 2024.0, 276.0, 24.0, 1.0 },
    { 1.0, 25.0, 300.0, 2300.0, 12650.0, 53130.0, 177100.0, 480700.0, 1081575.0, 2042975.0, 3268760.0, 4457400.0, 5200300.0, 5200300.0, 4457400.0, 3268760.0, 2042975.0, 1081575.0, 480700.0, 177100.0, 53130.0, 12650.0, 2300.0, 300.0, 25.0, 1.0 },
    { 1.0, 26.0, 325.0, 2600.0, 14950.0, 65780.0, 230230.0, 657800.0, 1562275.0, 3124550.0, 5311735.0, 7726160.0, 9657700.0, 10400600.0, 9657700.0, 7726160.0, 5311735.0, 3124550.0, 1562275.0, 657800.0, 230230.0, 65780.0, 14950.0, 2600.0, 325.0, 26.0, 1.0 },
    { 1.0, 27.0, 351.0, 2925.0, 17550.0, 80730.0, 296010.0, 888030.0, 2220075.0, 4686825.0, 8436285.0, 13037895.0, 17383860.0, 20058300.0, 20058300.0, 17383860.0, 13037895.0, 8436285.0, 4686825.0, 2220075.0, 888030.0, 296010.0, 80730.0, 17550.0, 2925.0, 351.0, 27.0, 1.0 },
    { 1.0, 28.0, 378.0, 3276.0, 20475.0, 98280.0, 376740.0, 1184040.0, 3108105.0, 6906900.0, 13123110.0, 21474180.0, 30421755.0, 37442160.0, 40116600.0, 37442160.0, 30421755.0, 21474180.0, 13123110.0, 6906900.0, 3108105.0, 1184040.0, 376740.0, 98280.0, 20475.0, 3276.0, 378.0, 28.0, 1.0 },
    { 1.0, 29.0, 406.0, 3654.0, 23751.0, 118755.0, 475020.0, 1560780.0, 4292145.0, 10015005.0, 20030010.0, 34597290.0, 51895935.0, 67863915.0, 77558760.0, 77558760.0, 67863915.0, 51895935.0, 34597290.0, 20030010.0, 10015005.0, 4292145.0, 1560780.0, 475020.0, 118755.0, 23751.0, 3654.0, 406.0, 29.0, 1.0 },
    { 1.0, 30.0, 435.0, 4060.0, 27405.0, 142506.0, 593775.0, 2035800.0, 5852925.0, 14307150.0, 30045015.0, 54627300.0, 86493225.0, 119759850.0, 145422675.0, 155117520.0, 145422675.0, 119759850.0, 86493225.0, 54627300.0, 30045015.0, 14307150.0, 5852925.0, 2035800.0, 593775.0, 142506.0, 27405.0, 4060.0, 435.0, 30.0, 1.0 },
    { 1.0, 31.0, 465.0, 4495.0, 31465.0, 169911.0, 736281.0, 2629575.0, 7888725.0, 20160075.0, 44352165.0, 84672315.0, 141120525.0, 206253075.0, 265182525.0, 300540195.0, 300540195.0, 265182525.0, 206253075.0, 141120525.0, 84672315.0, 44352165.0, 20160075.0, 7888725.0, 2629575.0, 736281.0, 169911.0, 31465.0, 4495.0, 465.0, 31.0, 1.0 },
    { 1.0, 32.0, 496.0, 4960.0, 35960.0, 201376.0, 906192.0, 3365856.0, 10518300.0, 28048800.0, 64512240.0, 129024480.0, 225792840.0, 347373600.0, 471435600.0, 565722720.0, 601080390.0, 565722720.0, 471435600.0, 347373600.0, 225792840.0, 129024480.0, 64512240.0, 28048800.0, 10518300.0, 3365856.0, 906192.0, 201376.0, 35960.0, 4960.0, 496.0, 32.0, 1.0 },
    { 1.0, 33.0, 528.0, 5456.0, 40920.0, 237336.0, 1107568.0, 4272048.0, 13884156.0, 38567100.0, 92561040.0, 193536720.0, 354817320.0, 573166440.0, 818809200.0, 1037158320.0, 1166803110.0, 1166803110.0, 1037158320.0, 818809200.0, 573166440.0, 354817320.0, 193536720.0, 92561040.0, 38567100.0, 13884156.0, 4272048.0, 1107568.0, 237336.0, 40920.0, 5456.0, 528.0, 33.0, 1.0 },
    { 1.0, 34.0, 561.0, 5984.0, 46376.0, 278256.0, 1344904.0, 5379616.0, 18156204.0, 52451256.0, 131128140.0, 286097760.0, 548354040.0, 927983760.0, 1391975640.0, 1855967520.0, 2203961430.0, 2333606220.0, 2203961430.0, 1855967520.0, 1391975640.0, 927983760.0, 548354040.0, 286097760.0, 131128140.0, 52451256.0, 18156204.0, 5379616.0, 1344904.0, 278256.0, 46376.0, 5984.0, 561.0, 34.0, 1.0 },
    { 1.0, 35.0, 595.0, 6545.0, 52360.0, 324632.0, 1623160.0, 6724520.0, 23535820.0, 70607460.0, 183579396.0, 417225900.0, 834451800.0, 1476337800.0, 2319959400.0, 3247943160.0, 4059928950.0, 4537567650.0, 4537567650.0, 4059928950.0, 3247943160.0, 2319959400.0, 1476337800.0, 834451800.0, 417225900.0, 183579396.0, 70607460.0, 23535820.0, 6724520.0, 1623160.0, 324632.0, 52360.0, 6545.0, 595.0, 35.0, 1.0 },
    { 1.0, 36.0, 630.0, 7140.0, 58905.0, 376992.0, 1947792.0, 8347680.0, 30260340.0, 94143280.0, 254186856.0, 600805296.0, 1251677700.0, 2310789600.0, 3796297200.0, 5567902560.0, 7307872110.0, 8597496600.0, 9075135300.0, 8597496600.0, 7307872110.0, 5567902560.0, 3796297200.0, 2310789600.0, 1251677700.0, 600805296.0, 254186856.0, 94143280.0, 30260340.0, 8347680.0, 1947792.0, 376992.0, 58905.0, 7140.0, 630.0, 36.0, 1.0 },
    { 1.0, 37.0, 666.0, 7770.0, 66045.0, 435897.0, 2324784.0, 10295472.0, 38608020.0, 124403620.0, 348330136.0, 854992152.0, 1852482996.0, 3562467300.0, 6107086800.0, 9364199760.0, 12875774670.0, 15905368710.0, 17672631900.0, 17672631900.0, 15905368710.0, 12875774670.0, 9364199760.0, 6107086800.0, 3562467300.0, 1852482996.0, 854992152.0, 348330136.0, 124403620.0, 38608020.0, 10295472.0, 2324784.0, 435897.0, 66045.0, 7770.0, 666.0, 37.0, 1.0 },
    { 1.0, 38.0, 703.0, 8436.0, 73815.0, 501942.0, 2760681.0, 12620256.0, 48903492.0, 163011640.0, 472733756.0, 1203322288.0, 2707475148.0, 5414950296.0, 9669554100.0, 15471286560.0, 22239974430.0, 28781143380.0, 33578000610.0, 35345263800.0, 33578000610.0, 28781143380.0, 22239974430.0, 15471286560.0, 9669554100.0, 5414950296.0, 2707475148.0, 1203322288.0, 472733756.0, 163011640.0, 48903492.0, 12620256.0, 2760681.0, 501942.0, 73815.0, 8436.0, 703.0, 38.0, 1.0 },
    { 1.0, 39.0, 741.0, 9139.0, 82251.0, 575757.0, 3262623.0, 15380937.0, 61523748.0, 211915132.0, 635745396.0, 1676056044.0, 3910797436.0, 8122425444.0, 15084504396.0, 25140840660.0, 37711260990.0, 51021117810.0, 62359143990.0, 68923264410.0, 68923264410.0, 62359143990.0, 51021117810.0, 37711260990.0, 25140840660.0, 15084504396.0, 8122425444.0, 3910797436.0, 1676056044.0, 635745396.0, 211915132.0, 61523748.0, 15380937.0, 3262623.0, 575757.0, 82251.0, 9139.0, 741.0, 39.0, 1.0 },
    { 1.0, 40.0, 780.0, 9880.0, 91390.0, 658008.0, 3838380.0, 18643560.0, 76904685.0, 273438880.0, 847660528.0, 2311801440.0, 5586853480.0, 12033222880.0, 23206929840.0, 40225345056.0, 62852101650.0, 88732378800.0, 113380261800.0, 131282408400.0, 137846528820.0, 131282408400.0, 113380261800.0, 88732378800.0, 62852101650.0, 40225345056.0, 23206929840.0, 12033222880.0, 5586853480.0, 2311801440.0, 847660528.0, 273438880.0, 76904685.0, 18643560.0, 3838380.0, 658008.0, 91390.0, 9880.0, 780.0, 40.0, 1.0 },
    { 1.0, 41.0, 820.0, 10660.0, 101270.0, 749398.0, 4496388.0, 22481940.0, 95548245.0, 350343565.0, 1121099408.0, 3159461968.0, 7898654920.0, 17620076360.0, 35240152720.0, 63432274896.0, 103077446706.0, 151584480450.0, 202112640600.0, 244662670200.0, 269128937220.0, 269128937220.0, 244662670200.0, 202112640600.0, 151584480450.0, 103077446706.0, 63432274896.0, 35240152720.0, 17620076360.0, 7898654920.0, 3159461968.0, 1121099408.0, 350343565.0, 95548245.0, 22481940.0, 4496388.0, 749398.0, 101270.0, 10660.0, 820.0, 41.0, 1.0 },
    { 1.0, 42.0, 861.0, 11480.0, 111930.0, 850668.0, 5245786.0, 26978328.0, 118030185.0, 445891810.0, 1471442973.0, 4280561376.0, 11058116888.0, 25518731280.0, 52860229080.0, 98672427616.0, 166509721602.0, 254661927156.0, 353697121050.0, 446775310800.0, 513791607420.0, 538257874440.0, 513791607420.0, 446775310800.0, 353697121050.0, 254661927156.0, 166509721602.0, 98672427616.0, 52860229080.0, 25518731280.0, 11058116888.0, 4280561376.0, 1471442973.0, 445891810.0, 118030185.0, 26978328.0, 5245786.0, 850668.0, 111930.0, 11480.0, 861.0, 42.0, 1.0 },
    { 1.0, 43.0, 903.0, 12341.0, 123410.0, 962598.0, 6096454.0, 32224114.0, 145008513.0, 563921995.0, 1917334783.0, 5752004349.0, 15338678264.0, 36576848168.0, 78378960360.0, 151532656696.0, 265182149218.0, 421171648758.0, 608359048206.0, 800472431850.0, 960566918220.0, 1052049481860.0, 1052049481860.0, 960566918220.0, 800472431850.0, 608359048206.0, 421171648758.0, 265182149218.0, 151532656696.0, 78378960360.0, 36576848168.0, 15338678264.0, 5752004349.0, 1917334783.0, 563921995.0, 145008513.0, 32224114.0, 6096454.0, 962598.0, 123410.0, 12341.0, 903.0, 43.0, 1.0 },
    { 1.0, 44.0, 946.0, 13244.0, 135751.0, 1086008.0, 7059052.0, 38320568.0, 177232627.0, 708930508.0, 2481256778.0, 7669339132.0, 21090682613.0, 51915526432.0, 114955808528.0, 229911617056.0, 416714805914.0, 686353797976.0, 1029530696964.0, 1408831480056.0, 1761039350070.0, 2012616400080.0, 2104098963720.0, 2012616400080.0, 1761039350070.0, 1408831480056.0, 1029530696964.0, 686353797976.0, 416714805914.0, 229911617056.0, 114955808528.0, 51915526432.0, 21090682613.0, 7669339132.0, 2481256778.0, 708930508.0, 177232627.0, 38320568.0, 7059052.0, 1086008.0, 135751.0, 13244.0, 946.0, 44.0, 1.0 },
    { 1.0, 45.0, 990.0, 14190.0, 148995.0, 1221759.0, 8145060.0, 45379620.0, 215553195.0, 886163135.0, 3190187286.0, 10150595910.0, 28760021745.0, 73006209045.0, 166871334960.0, 344867425584.0, 646626422970.0, 1103068603890.0, 1715884494940.0, 2438362177020.0, 3169870830126.0, 3773655750150.0, 4116715363800.0, 4116715363800.0, 3773655750150.0, 3169870830126.0, 2438362177020.0, 1715884494940.0, 1103068603890.0, 646626422970.0, 344867425584.0, 166871334960.0, 73006209045.0, 28760021745.0, 10150595910.0, 3190187286.0, 886163135.0, 215553195.0, 45379620.0, 8145060.0, 1221759.0, 148995.0, 14190.0, 990.0, 45.0, 1.0 },
    { 1.0, 46.0, 1035.0, 15180.0, 163185.0, 1370754.0, 9366819.0, 53524680.0, 260932815.0, 1101716330.0, 4076350421.0, 13340783196.0, 38910617655.0, 101766230790.0, 239877544005.0, 511738760544.0, 991493848554.0, 1749695026860.0, 2818953098830.0, 4154246671960.0, 5608233007146.0, 6943526580276.0, 7890371113950.0, 8233430727600.0, 7890371113950.0, 6943526580276.0, 5608233007146.0, 4154246671960.0, 2818953098830.0, 1749695026860.0, 991493848554.0, 511738760544.0, 239877544005.0, 101766230790.0, 38910617655.0, 13340783196.0, 4076350421.0, 1101716330.0, 260932815.0, 53524680.0, 9366819.0, 1370754.0, 163185.0, 15180.0, 1035.0, 46.0, 1.0 },
    { 1.0, 47.0, 1081.0, 16215.0, 178365.0, 1533939.0, 10737573.0, 62891499.0, 314457495.0, 1362649145.0, 5178066751.0, 17417133617.0, 52251400851.0, 140676848445.0, 341643774795.0, 751616304549.0, 1503232609098.0, 2741188875414.0, 4568648125690.0, 6973199770790.0, 9762479679106.0, 12551759587422.0, 14833897694226.0, 16123801841550.0, 16123801841550.0, 14833897694226.0, 12551759587422.0, 9762479679106.0, 6973199770790.0, 4568648125690.0, 2741188875414.0, 1503232609098.0, 751616304549.0, 341643774795.0, 140676848445.0, 52251400851.0, 17417133617.0, 5178066751.0, 1362649145.0, 314457495.0, 62891499.0, 10737573.0, 1533939.0, 178365.0, 16215.0, 1081.0, 47.0, 1.0 },
    { 1.0, 48.0, 1128.0, 17296.0, 194580.0, 1712304.0, 12271512.0, 73629072.0, 377348994.0, 1677106640.0, 6540715896.0, 22595200368.0, 69668534468.0, 192928249296.0, 482320623240.0, 1093260079344.0, 2254848913647.0, 4244421484512.0, 7309837001104.0, 11541847896480.0, 16735679449896.0, 22314239266528.0, 27385657281648.0, 30957699535776.0, 32247603683100.0, 30957699535776.0, 27385657281648.0, 22314239266528.0, 16735679449896.0, 11541847896480.0, 7309837001104.0, 4244421484512.0, 2254848913647.0, 1093260079344.0, 482320623240.0, 192928249296.0, 69668534468.0, 22595200368.0, 6540715896.0, 1677106640.0, 377348994.0, 73629072.0, 12271512.0, 1712304.0, 194580.0, 17296.0, 1128.0, 48.0, 1.0 },
    { 1.0, 49.0, 1176.0, 18424.0, 211876.0, 1906884.0, 13983816.0, 85900584.0, 450978066.0, 2054455634.0, 8217822536.0, 29135916264.0, 92263734836.0, 262596783764.0, 675248872536.0, 1575580702584.0, 3348108992991.0, 6499270398159.0, 11554258485616.0, 18851684897584.0, 28277527346376.0, 39049918716424.0, 49699896548176.0, 58343356817424.0, 63205303218876.0, 63205303218876.0, 58343356817424.0, 49699896548176.0, 39049918716424.0, 28277527346376.0, 18851684897584.0, 11554258485616.0, 6499270398159.0, 3348108992991.0, 1575580702584.0, 675248872536.0, 262596783764.0, 92263734836.0, 29135916264.0, 8217822536.0, 2054455634.0, 450978066.0, 85900584.0, 13983816.0, 1906884.0, 211876.0, 18424.0, 1176.0, 49.0, 1.0 },
    { 1.0, 50.0, 1225.0, 19600.0, 230300.0, 2118760.0, 15890700.0, 99884400.0, 536878650.0, 2505433700.0, 10272278170.0, 37353738800.0, 121399651100.0, 354860518600.0, 937845656300.0, 2250829575120.0, 4923689695575.0, 9847379391150.0, 18053528883775.0, 30405943383200.0, 47129212243960.0, 67327446062800.0, 88749815264600.0, 108043253365600.0, 121548660036300.0, 126410606437752.0, 121548660036300.0, 108043253365600.0, 88749815264600.0, 67327446062800.0, 47129212243960.0, 30405943383200.0, 18053528883775.0, 9847379391150.0, 4923689695575.0, 2250829575120.0, 937845656300.0, 354860518600.0, 121399651100.0, 37353738800.0, 10272278170.0, 2505433700.0, 536878650.0, 99884400.0, 15890700.0, 2118760.0, 230300.0, 19600.0, 1225.0, 50.0, 1.0 },
    { 1.0, 51.0, 1275.0, 20825.0, 249900.0, 2349060.0, 18009460.0, 115775100.0, 636763050.0, 3042312350.0, 12777711870.0, 47626016970.0, 158753389900.0, 476260169700.0, 1292706174900.0, 3188675231420.0, 7174519270695.0, 14771069086725.0, 27900908274925.0, 48459472266975.0, 77535155627160.0, 114456658306760.0, 156077261327400.0, 196793068630200.0, 229591913401900.0, 247959266474052.0, 247959266474052.0, 229591913401900.0, 196793068630200.0, 156077261327400.0, 114456658306760.0, 77535155627160.0, 48459472266975.0, 27900908274925.0, 14771069086725.0, 7174519270695.0, 3188675231420.0, 1292706174900.0, 476260169700.0, 158753389900.0, 47626016970.0, 12777711870.0, 3042312350.0, 636763050.0, 115775100.0, 18009460.0, 2349060.0, 249900.0, 20825.0, 1275.0, 51.0, 1.0 },
    { 1.0, 52.0, 1326.0, 22100.0, 270725.0, 2598960.0, 20358520.0, 133784560.0, 752538150.0, 3679075400.0, 15820024220.0, 60403728840.0, 206379406870.0, 635013559600.0, 1768966344600.0, 4481381406320.0, 10363194502115.0, 21945588357420.0, 42671977361650.0, 76360380541900.0, 125994627894135.0, 191991813933920.0, 270533919634160.0, 352870329957600.0, 426384982032100.0, 477551179875952.0, 495918532948104.0, 477551179875952.0, 426384982032100.0, 352870329957600.0, 270533919634160.0, 191991813933920.0, 125994627894135.0, 76360380541900.0, 42671977361650.0, 21945588357420.0, 10363194502115.0, 4481381406320.0, 1768966344600.0, 635013559600.0, 206379406870.0, 60403728840.0, 15820024220.0, 3679075400.0, 752538150.0, 133784560.0, 20358520.0, 2598960.0, 270725.0, 22100.0, 1326.0, 52.0, 1.0 },
    { 1.0, 53.0, 1378.0, 23426.0, 292825.0, 2869685.0, 22957480.0, 154143080.0, 886322710.0, 4431613550.0, 19499099620.0, 76223753060.0, 266783135710.0, 841392966470.0, 2403979904200.0, 6250347750920.0, 14844575908435.0, 32308782859535.0, 64617565719070.0, 119032357903550.0, 202355008436035.0, 317986441828055.0, 462525733568080.0, 623404249591760.0, 779255311989700.0, 903936161908052.0, 973469712824056.0, 973469712824056.0, 903936161908052.0, 779255311989700.0, 623404249591760.0, 462525733568080.0, 317986441828055.0, 202355008436035.0, 119032357903550.0, 64617565719070.0, 32308782859535.0, 14844575908435.0, 6250347750920.0, 2403979904200.0, 841392966470.0, 266783135710.0, 76223753060.0, 19499099620.0, 4431613550.0, 886322710.0, 154143080.0, 22957480.0, 2869685.0, 292825.0, 23426.0, 1378.0, 53.0, 1.0 },
    { 1.0, 54.0, 1431.0, 24804.0, 316251.0, 3162510.0, 25827165.0, 177100560.0, 1040465790.0, 5317936260.0, 23930713170.0, 95722852680.0, 343006888770.0, 1108176102180.0, 3245372870670.0, 8654327655120.0, 21094923659355.0, 47153358767970.0, 96926348578605.0, 183649923622620.0, 321387366339585.0, 520341450264090.0, 780512175396135.0, 1085929983159840.0, 1402659561581460.0, 1683191473897752.0, 1877405874732108.0, 1946939425648112.0, 1877405874732108.0, 1683191473897752.0, 1402659561581460.0, 1085929983159840.0, 780512175396135.0, 520341450264090.0, 321387366339585.0, 183649923622620.0, 96926348578605.0, 47153358767970.0, 21094923659355.0, 8654327655120.0, 3245372870670.0, 1108176102180.0, 343006888770.0, 95722852680.0, 23930713170.0, 5317936260.0, 1040465790.0, 177100560.0, 25827165.0, 3162510.0, 316251.0, 24804.0, 1431.0, 54.0, 1.0 },
    { 1.0, 55.0, 1485.0, 26235.0, 341055.0, 3478761.0, 28989675.0, 202927725.0, 1217566350.0, 6358402050.0, 29248649430.0, 119653565850.0, 438729741450.0, 1451182990950.0, 4353548972850.0, 11899700525790.0, 29749251314475.0, 68248282427325.0, 144079707346575.0, 280576272201225.0, 505037289962205.0, 841728816603675.0, 1300853625660225.0, 1866442158555975.0, 2488589544741300.0, 3085851035479212.0, 3560597348629860.0, 3824345300380220.0, 3824345300380220.0, 3560597348629860.0, 3085851035479212.0, 2488589544741300.0, 1866442158555975.0, 1300853625660225.0, 841728816603675.0, 505037289962205.0, 280576272201225.0, 144079707346575.0, 68248282427325.0, 29749251314475.0, 11899700525790.0, 4353548972850.0, 1451182990950.0, 438729741450.0, 119653565850.0, 29248649430.0, 6358402050.0, 1217566350.0, 202927725.0, 28989675.0, 3478761.0, 341055.0, 26235.0, 1485.0, 55.0, 1.0 },
    { 1.0, 56.0, 1540.0, 27720.0, 367290.0, 3819816.0, 32468436.0, 231917400.0, 1420494075.0, 7575968400.0, 35607051480.0, 148902215280.0, 558383307300.0, 1889912732400.0, 5804731963800.0, 16253249498640.0, 41648951840265.0, 97997533741800.0, 212327989773900.0, 424655979547800.0, 785613562163430.0, 1346766106565880.0, 2142582442263900.0, 3167295784216200.0, 4355031703297275.0, 5574440580220512.0, 6646448384109072.0, 7384942649010080.0, 7648690600760440.0, 7384942649010080.0, 6646448384109072.0, 5574440580220512.0, 4355031703297275.0, 3167295784216200.0, 2142582442263900.0, 1346766106565880.0, 785613562163430.0, 424655979547800.0, 212327989773900.0, 97997533741800.0, 41648951840265.0, 16253249498640.0, 5804731963800.0, 1889912732400.0, 558383307300.0, 148902215280.0, 35607051480.0, 7575968400.0, 1420494075.0, 231917400.0, 32468436.0, 3819816.0, 367290.0, 27720.0, 1540.0, 56.0, 1.0 },
    { 1.0, 57.0, 1596.0, 29260.0, 395010.0, 4187106.0, 36288252.0, 264385836.0, 1652411475.0, 8996462475.0, 43183019880.0, 184509266760.0, 707285522580.0, 2448296039700.0, 7694644696200.0, 22057981462440.0, 57902201338905.0, 139646485582065.0, 310325523515700.0, 636983969321700.0, 1210269541711230.0, 2132379668729310.0, 3489348548829780.0, 5309878226480100.0, 7522327487513475.0, 9929472283517787.0, 12220888964329584.0, 14031391033119152.0, 15033633249770520.0, 15033633249770520.0, 14031391033119152.0, 12220888964329584.0, 9929472283517787.0, 7522327487513475.0, 5309878226480100.0, 3489348548829780.0, 2132379668729310.0, 1210269541711230.0, 636983969321700.0, 310325523515700.0, 139646485582065.0, 57902201338905.0, 22057981462440.0, 7694644696200.0, 2448296039700.0, 707285522580.0, 184509266760.0, 43183019880.0, 8996462475.0, 1652411475.0, 264385836.0, 36288252.0, 4187106.0, 395010.0, 29260.0, 1596.0, 57.0, 1.0 },
    { 1.0, 58.0, 1653.0, 30856.0, 424270.0, 4582116.0, 40475358.0, 300674088.0, 1916797311.0, 10648873950.0, 52179482355.0, 227692286640.0, 891794789340.0, 3155581562280.0, 10142940735900.0, 29752626158640.0, 79960182801345.0, 197548686920970.0, 449972009097765.0, 947309492837400.0, 1847253511032930.0, 3342649210440540.0, 5621728217559090.0, 8799226775309880.0, 12832205713993575.0, 17451799771031262.0, 22150361247847371.0, 26252279997448736.0, 29065024282889672.0, 30067266499541040.0, 29065024282889672.0, 26252279997448736.0, 22150361247847371.0, 17451799771031262.0, 12832205713993575.0, 8799226775309880.0, 5621728217559090.0, 3342649210440540.0, 1847253511032930.0, 947309492837400.0, 449972009097765.0, 197548686920970.0, 79960182801345.0, 29752626158640.0, 10142940735900.0, 3155581562280.0, 891794789340.0, 227692286640.0, 52179482355.0, 10648873950.0, 1916797311.0, 300674088.0, 40475358.0, 4582116.0, 424270.0, 30856.0, 1653.0, 58.0, 1.0 },
    { 1.0, 59.0, 1711.0, 32509.0, 455126.0, 5006386.0, 45057474.0, 341149446.0, 2217471399.0, 12565671261.0, 62828356305.0, 279871768995.0, 1119487075980.0, 4047376351620.0, 13298522298180.0, 39895566894540.0, 109712808959985.0, 277508869722315.0, 647520696018735.0, 1397281501935165.0, 2794563003870330.0, 5189902721473470.0, 8964377427999630.0, 14420954992868970.0, 21631432489303455.0, 30284005485024837.0, 39602161018878633.0, 48402641245296107.0, 55317304280338408.0, 59132290782430712.0, 59132290782430712.0, 55317304280338408.0, 48402641245296107.0, 39602161018878633.0, 30284005485024837.0, 21631432489303455.0, 14420954992868970.0, 8964377427999630.0, 5189902721473470.0, 2794563003870330.0, 1397281501935165.0, 647520696018735.0, 277508869722315.0, 109712808959985.0, 39895566894540.0, 13298522298180.0, 4047376351620.0, 1119487075980.0, 279871768995.0, 62828356305.0, 12565671261.0, 2217471399.0, 341149446.0, 45057474.0, 5006386.0, 455126.0, 32509.0, 1711.0, 59.0, 1.0 },
    { 1.0, 60.0, 1770.0, 34220.0, 487635.0, 5461512.0, 50063860.0, 386206920.0, 2558620845.0, 14783142660.0, 75394027566.0, 342700125300.0, 1399358844975.0, 5166863427600.0, 17345898649800.0, 53194089192720.0, 149608375854525.0, 387221678682300.0, 925029565741050.0, 2044802197953900.0, 4191844505805495.0, 7984465725343800.0, 14154280149473100.0, 23385332420868600.0, 36052387482172425.0, 51915437974328292.0, 69886166503903470.0, 88004802264174740.0, 103719945525634515.0, 114449595062769120.0, 118264581564861424.0, 114449595062769120.0, 103719945525634515.0, 88004802264174740.0, 69886166503903470.0, 51915437974328292.0, 36052387482172425.0, 23385332420868600.0, 14154280149473100.0, 7984465725343800.0, 4191844505805495.0, 2044802197953900.0, 925029565741050.0, 387221678682300.0, 149608375854525.0, 53194089192720.0, 17345898649800.0, 5166863427600.0, 1399358844975.0, 342700125300.0, 75394027566.0, 14783142660.0, 2558620845.0, 386206920.0, 50063860.0, 5461512.0, 487635.0, 34220.0, 1770.0, 60.0, 1.0 },
    { 1.0, 61.0, 1830.0, 35990.0, 521855.0, 5949147.0, 55525372.0, 436270780.0, 2944827765.0, 17341763505.0, 90177170226.0, 418094152866.0, 1742058970275.0, 6566222272575.0, 22512762077400.0, 70539987842520.0, 202802465047245.0, 536830054536825.0, 1312251244423350.0, 2969831763694950.0, 6236646703759395.0, 12176310231149295.0, 22138745874816900.0, 37539612570341700.0, 59437719903041025.0, 87967825456500717.0, 121801604478231762.0, 157890968768078210.0, 191724747789809255.0, 218169540588403635.0, 232714176627630544.0, 232714176627630544.0, 218169540588403635.0, 191724747789809255.0, 157890968768078210.0, 121801604478231762.0, 87967825456500717.0, 59437719903041025.0, 37539612570341700.0, 22138745874816900.0, 12176310231149295.0, 6236646703759395.0, 2969831763694950.0, 1312251244423350.0, 536830054536825.0, 202802465047245.0, 70539987842520.0, 22512762077400.0, 6566222272575.0, 1742058970275.0, 418094152866.0, 90177170226.0, 17341763505.0, 2944827765.0, 436270780.0, 55525372.0, 5949147.0, 521855.0, 35990.0, 1830.0, 61.0, 1.0 },
    { 1.0, 62.0, 1891.0, 37820.0, 557845.0, 6471002.0, 61474519.0, 491796152.0, 3381098545.0, 20286591270.0, 107518933731.0, 508271323092.0, 2160153123141.0, 8308281242850.0, 29078984349975.0, 93052749919920.0, 273342452889765.0, 739632519584070.0, 1849081298960175.0, 4282083008118300.0, 9206478467454345.0, 18412956934908690.0, 34315056105966195.0, 59678358445158600.0, 96977332473382725.0, 147405545359541742.0, 209769429934732479.0, 279692573246309972.0, 349615716557887465.0, 409894288378212890.0, 450883717216034179.0, 465428353255261088.0, 450883717216034179.0, 409894288378212890.0, 349615716557887465.0, 279692573246309972.0, 209769429934732479.0, 147405545359541742.0, 96977332473382725.0, 59678358445158600.0, 34315056105966195.0, 18412956934908690.0, 9206478467454345.0, 4282083008118300.0, 1849081298960175.0, 739632519584070.0, 273342452889765.0, 93052749919920.0, 29078984349975.0, 8308281242850.0, 2160153123141.0, 508271323092.0, 107518933731.0, 20286591270.0, 3381098545.0, 491796152.0, 61474519.0, 6471002.0, 557845.0, 37820.0, 1891.0, 62.0, 1.0 },
    { 1.0, 63.0, 1953.0, 39711.0, 595665.0, 7028847.0, 67945521.0, 553270671.0, 3872894697.0, 23667689815.0, 127805525001.0, 615790256823.0, 2668424446233.0, 10468434365991.0, 37387265592825.0, 122131734269895.0, 366395202809685.0, 1012974972473835.0, 2588713818544245.0, 6131164307078475.0, 13488561475572645.0, 27619435402363035.0, 52728013040874885.0, 93993414551124795.0, 156655690918541325.0, 244382877832924467.0, 357174975294274221.0, 489462003181042451.0, 629308289804197437.0, 759510004936100355.0, 860778005594247069.0, 916312070471295267.0, 916312070471295267.0, 860778005594247069.0, 759510004936100355.0, 629308289804197437.0, 489462003181042451.0, 357174975294274221.0, 244382877832924467.0, 156655690918541325.0, 93993414551124795.0, 52728013040874885.0, 27619435402363035.0, 13488561475572645.0, 6131164307078475.0, 2588713818544245.0, 1012974972473835.0, 366395202809685.0, 122131734269895.0, 37387265592825.0, 10468434365991.0, 2668424446233.0, 615790256823.0, 127805525001.0, 23667689815.0, 3872894697.0, 553270671.0, 67945521.0, 7028847.0, 595665.0, 39711.0, 1953.0, 63.0, 1.0 },
    { 1.0, 64.0, 2016.0, 41664.0, 635376.0, 7624512.0, 74974368.0, 621216192.0, 4426165368.0, 27540584512.0, 151473214816.0, 743595781824.0, 3284214703056.0, 13136858812224.0, 47855699958816.0, 159518999862720.0, 488526937079580.0, 1379370175283520.0, 3601688791018080.0, 8719878125622720.0, 19619725782651120.0, 41107996877935680.0, 80347448443237920.0, 146721427591999680.0, 250649105469666120.0, 401038568751465792.0, 601557853127198688.0, 846636978475316672.0, 1118770292985239888.0, 1388818294740297792.0, 1620288010530347424.0, 1777090076065542336.0, 1832624140942590534.0, 1777090076065542336.0, 1620288010530347424.0, 1388818294740297792.0, 1118770292985239888.0, 846636978475316672.0, 601557853127198688.0, 401038568751465792.0, 250649105469666120.0, 146721427591999680.0, 80347448443237920.0, 41107996877935680.0, 19619725782651120.0, 8719878125622720.0, 3601688791018080.0, 1379370175283520.0, 488526937079580.0, 159518999862720.0, 47855699958816.0, 13136858812224.0, 3284214703056.0, 743595781824.0, 151473214816.0, 27540584512.0, 4426165368.0, 621216192.0, 74974368.0, 7624512.0, 635376.0, 41664.0, 2016.0, 64.0, 1.0 },
    { 1.0, 65.0, 2080.0, 43680.0, 677040.0, 8259888.0, 82598880.0, 696190560.0, 5047381560.0, 31966749880.0, 179013799328.0, 895068996640.0, 4027810484880.0, 16421073515280.0, 60992558771040.0, 207374699821536.0, 648045936942300.0, 1867897112363100.0, 4981058966301600.0, 12321566916640800.0, 28339603908273840.0, 60727722660586800.0, 121455445321173600.0, 227068876035237600.0, 397370533061665800.0, 651687674221131912.0, 1002596421878664480.0, 1448194831602515360.0, 1965407271460556560.0, 2507588587725537680.0, 3009106305270645216.0, 3397378086595889760.0, 3609714217008132870.0, 3609714217008132870.0, 3397378086595889760.0, 3009106305270645216.0, 2507588587725537680.0, 1965407271460556560.0, 1448194831602515360.0, 1002596421878664480.0, 651687674221131912.0, 397370533061665800.0, 227068876035237600.0, 121455445321173600.0, 60727722660586800.0, 28339603908273840.0, 12321566916640800.0, 4981058966301600.0, 1867897112363100.0, 648045936942300.0, 207374699821536.0, 60992558771040.0, 16421073515280.0, 4027810484880.0, 895068996640.0, 179013799328.0, 31966749880.0, 5047381560.0, 696190560.0, 82598880.0, 8259888.0, 677040.0, 43680.0, 2080.0, 65.0, 1.0 },
    { 1.0, 66.0, 2145.0, 45760.0, 720720.0, 8936928.0, 90858768.0, 778789440.0, 5743572120.0, 37014131440.0, 210980549208.0, 1074082795968.0, 4922879481520.0, 20448884000160.0, 77413632286320.0, 268367258592576.0, 855420636763836.0, 2515943049305400.0, 6848956078664700.0, 17302625882942400.0, 40661170824914640.0, 89067326568860640.0, 182183167981760400.0, 348524321356411200.0, 624439409096903400.0, 1049058207282797712.0, 1654284096099796392.0, 2450791253481179840.0, 3413602103063071920.0, 4472995859186094240.0, 5516694892996182896.0, 6406484391866534976.0, 7007092303604022630.0, 7219428434016265740.0, 7007092303604022630.0, 6406484391866534976.0, 5516694892996182896.0, 4472995859186094240.0, 3413602103063071920.0, 2450791253481179840.0, 1654284096099796392.0, 1049058207282797712.0, 624439409096903400.0, 348524321356411200.0, 182183167981760400.0, 89067326568860640.0, 40661170824914640.0, 17302625882942400.0, 6848956078664700.0, 2515943049305400.0, 855420636763836.0, 268367258592576.0, 77413632286320.0, 20448884000160.0, 4922879481520.0, 1074082795968.0, 210980549208.0, 37014131440.0, 5743572120.0, 778789440.0, 90858768.0, 8936928.0, 720720.0, 45760.0, 2145.0, 66.0, 1.0 },
    { 1.0, 67.0, 2211.0, 47905.0, 766480.0, 9657648.0, 99795696.0, 869648208.0, 6522361560.0, 42757703560.0, 247994680648.0, 1285063345176.0, 5996962277488.0, 25371763481680.0, 97862516286480.0, 345780890878896.0, 1123787895356412.0, 3371363686069236.0, 9364899127970100.0, 24151581961607100.0, 57963796707857040.0, 129728497393775280.0, 271250494550621040.0, 530707489338171600.0, 972963730453314600.0, 1673497616379701112.0, 2703342303382594104.0, 4105075349580976232.0, 5864393356544251760.0, 7886597962249166160.0, 9989690752182277136.0, 11923179284862717872.0, 13413576695470557606.0, 14226520737620288370.0, 14226520737620288370.0, 13413576695470557606.0, 11923179284862717872.0, 9989690752182277136.0, 7886597962249166160.0, 5864393356544251760.0, 4105075349580976232.0, 2703342303382594104.0, 1673497616379701112.0, 972963730453314600.0, 530707489338171600.0, 271250494550621040.0, 129728497393775280.0, 57963796707857040.0, 24151581961607100.0, 9364899127970100.0, 3371363686069236.0, 1123787895356412.0, 345780890878896.0, 97862516286480.0, 25371763481680.0, 5996962277488.0, 1285063345176.0, 247994680648.0, 42757703560.0, 6522361560.0, 869648208.0, 99795696.0, 9657648.0, 766480.0, 47905.0, 2211.0, 67.0, 1.0 },
    { 1.0, 68.0, 2278.0, 50116.0, 814385.0, 10424128.0, 109453344.0, 969443904.0, 7392009768.0, 49280065120.0, 290752384208.0, 1533058025824.0, 7282025622664.0, 31368725759168.0, 123234279768160.0, 443643407165376.0, 1469568786235308.0, 4495151581425648.0, 12736262814039336.0, 33516481089577200.0, 82115378669464140.0, 187692294101632320.0, 400978991944396320.0, 801957983888792640.0, 1503671219791486200.0, 2646461346833015712.0, 4376839919762295216.0, 6808417652963570336.0, 9969468706125227992.0, 13750991318793417920.0, 17876288714431443296.0, 21912870037044995008.0, 25336755980333275478.0, 27640097433090845976.0, 28453041475240576740.0, 27640097433090845976.0, 25336755980333275478.0, 21912870037044995008.0, 17876288714431443296.0, 13750991318793417920.0, 9969468706125227992.0, 6808417652963570336.0, 4376839919762295216.0, 2646461346833015712.0, 1503671219791486200.0, 801957983888792640.0, 400978991944396320.0, 187692294101632320.0, 82115378669464140.0, 33516481089577200.0, 12736262814039336.0, 4495151581425648.0, 1469568786235308.0, 443643407165376.0, 123234279768160.0, 31368725759168.0, 7282025622664.0, 1533058025824.0, 290752384208.0, 49280065120.0, 7392009768.0, 969443904.0, 109453344.0, 10424128.0, 814385.0, 50116.0, 2278.0, 68.0, 1.0 },
    { 1.0, 69.0, 2346.0, 52394.0, 864501.0, 11238513.0, 119877472.0, 1078897248.0, 8361453672.0, 56672074888.0, 340032449328.0, 1823810410032.0, 8815083648488.0, 38650751381832.0, 154603005527328.0, 566877686933536.0, 1913212193400684.0, 5964720367660956.0, 17231414395464984.0, 46252743903616536.0, 115631859759041340.0, 269807672771096460.0, 588671286046028640.0, 1202936975833188960.0, 2305629203680278840.0, 4150132566624501912.0, 7023301266595310928.0, 11185257572725865552.0, 16777886359088798328.0, 23720460024918645912.0, 31627280033224861216.0, 39789158751476438304.0, 47249626017378270486.0, 52976853413424121454.0, 56093138908331422716.0, 56093138908331422716.0, 52976853413424121454.0, 47249626017378270486.0, 39789158751476438304.0, 31627280033224861216.0, 23720460024918645912.0, 16777886359088798328.0, 11185257572725865552.0, 7023301266595310928.0, 4150132566624501912.0, 2305629203680278840.0, 1202936975833188960.0, 588671286046028640.0, 269807672771096460.0, 115631859759041340.0, 46252743903616536.0, 17231414395464984.0, 5964720367660956.0, 1913212193400684.0, 566877686933536.0, 154603005527328.0, 38650751381832.0, 8815083648488.0, 1823810410032.0, 340032449328.0, 56672074888.0, 8361453672.0, 1078897248.0, 119877472.0, 11238513.0, 864501.0, 52394.0, 2346.0, 69.0, 1.0 },
    { 1.0, 70.0, 2415.0, 54740.0, 916895.0, 12103014.0, 131115985.0, 1198774720.0, 9440350920.0, 65033528560.0, 396704524216.0, 2163842859360.0, 10638894058520.0, 47465835030320.0, 193253756909160.0, 721480692460864.0, 2480089880334220.0, 7877932561061640.0, 23196134763125940.0, 63484158299081520.0, 161884603662657876.0, 385439532530137800.0, 858478958817125100.0, 1791608261879217600.0, 3508566179513467800.0, 6455761770304780752.0, 11173433833219812840.0, 18208558839321176480.0, 27963143931814663880.0, 40498346384007444240.0, 55347740058143507128.0, 71416438784701299520.0, 87038784768854708790.0, 100226479430802391940.0, 109069992321755544170.0, 112186277816662845432.0, 109069992321755544170.0, 100226479430802391940.0, 87038784768854708790.0, 71416438784701299520.0, 55347740058143507128.0, 40498346384007444240.0, 27963143931814663880.0, 18208558839321176480.0, 11173433833219812840.0, 6455761770304780752.0, 3508566179513467800.0, 1791608261879217600.0, 858478958817125100.0, 385439532530137800.0, 161884603662657876.0, 63484158299081520.0, 23196134763125940.0, 7877932561061640.0, 2480089880334220.0, 721480692460864.0, 193253756909160.0, 47465835030320.0, 10638894058520.0, 2163842859360.0, 396704524216.0, 65033528560.0, 9440350920.0, 1198774720.0, 131115985.0, 12103014.0, 916895.0, 54740.0, 2415.0, 70.0, 1.0 },
    { 1.0, 71.0, 2485.0, 57155.0, 971635.0, 13019909.0, 143218999.0, 1329890705.0, 10639125640.0, 74473879480.0, 461738052776.0, 2560547383576.0, 12802736917880.0, 58104729088840.0, 240719591939480.0, 914734449370024.0, 3201570572795084.0, 10358022441395860.0, 31074067324187580.0, 86680293062207460.0, 225368761961739396.0, 547324136192795676.0, 1243918491347262900.0, 2650087220696342700.0, 5300174441392685400.0, 9964327949818248552.0, 17629195603524593592.0, 29381992672540989320.0, 46171702771135840360.0, 68461490315822108120.0, 95846086442150951368.0, 126764178842844806648.0, 158455223553556008310.0, 187265264199657100730.0, 209296471752557936110.0, 221256270138418389602.0, 221256270138418389602.0, 209296471752557936110.0, 187265264199657100730.0, 158455223553556008310.0, 126764178842844806648.0, 95846086442150951368.0, 68461490315822108120.0, 46171702771135840360.0, 29381992672540989320.0, 17629195603524593592.0, 9964327949818248552.0, 5300174441392685400.0, 2650087220696342700.0, 1243918491347262900.0, 547324136192795676.0, 225368761961739396.0, 86680293062207460.0, 31074067324187580.0, 10358022441395860.0, 3201570572795084.0, 914734449370024.0, 240719591939480.0, 58104729088840.0, 12802736917880.0, 2560547383576.0, 461738052776.0, 74473879480.0, 10639125640.0, 1329890705.0, 143218999.0, 13019909.0, 971635.0, 57155.0, 2485.0, 71.0, 1.0 },
    { 1.0, 72.0, 2556.0, 59640.0, 1028790.0, 13991544.0, 156238908.0, 1473109704.0, 11969016345.0, 85113005120.0, 536211932256.0, 3022285436352.0, 15363284301456.0, 70907466006720.0, 298824321028320.0, 1155454041309504.0, 4116305022165108.0, 13559593014190944.0, 41432089765583440.0, 117754360386395040.0, 312049055023946856.0, 772692898154535072.0, 1791242627540058576.0, 3894005712043605600.0, 7950261662089028100.0, 15264502391210933952.0, 27593523553342842144.0, 47011188276065582912.0, 75553695443676829680.0, 114633193086957948480.0, 164307576757973059488.0, 222610265284995758016.0, 285219402396400814958.0, 345720487753213109040.0, 396561735952215036840.0, 430552741890976325712.0, 442512540276836779204.0, 430552741890976325712.0, 396561735952215036840.0, 345720487753213109040.0, 285219402396400814958.0, 222610265284995758016.0, 164307576757973059488.0, 114633193086957948480.0, 75553695443676829680.0, 47011188276065582912.0, 27593523553342842144.0, 15264502391210933952.0, 7950261662089028100.0, 3894005712043605600.0, 1791242627540058576.0, 772692898154535072.0, 312049055023946856.0, 117754360386395040.0, 41432089765583440.0, 13559593014190944.0, 4116305022165108.0, 1155454041309504.0, 298824321028320.0, 70907466006720.0, 15363284301456.0, 3022285436352.0, 536211932256.0, 85113005120.0, 11969016345.0, 1473109704.0, 156238908.0, 13991544.0, 1028790.0, 59640.0, 2556.0, 72.0, 1.0 },
    { 1.0, 73.0, 2628.0, 62196.0, 1088430.0, 15020334.0, 170230452.0, 1629348612.0, 13442126049.0, 97082021465.0, 621324937376.0, 3558497368608.0, 18385569737808.0, 86270750308176.0, 369731787035040.0, 1454278362337824.0, 5271759063474612.0, 17675898036356052.0, 54991682779774384.0, 159186450151978480.0, 429803415410341896.0, 1084741953178481928.0, 2563935525694593648.0, 5685248339583664176.0, 11844267374132633700.0, 23214764053299962052.0, 42858025944553776096.0, 74604711829408425056.0, 122564883719742412592.0, 190186888530634778160.0, 278940769844931007968.0, 386917842042968817504.0, 507829667681396572974.0, 630939890149613923998.0, 742282223705428145880.0, 827114477843191362552.0, 873065282167813104916.0, 873065282167813104916.0, 827114477843191362552.0, 742282223705428145880.0, 630939890149613923998.0, 507829667681396572974.0, 386917842042968817504.0, 278940769844931007968.0, 190186888530634778160.0, 122564883719742412592.0, 74604711829408425056.0, 42858025944553776096.0, 23214764053299962052.0, 11844267374132633700.0, 5685248339583664176.0, 2563935525694593648.0, 1084741953178481928.0, 429803415410341896.0, 159186450151978480.0, 54991682779774384.0, 17675898036356052.0, 5271759063474612.0, 1454278362337824.0, 369731787035040.0, 86270750308176.0, 18385569737808.0, 3558497368608.0, 621324937376.0, 97082021465.0, 13442126049.0, 1629348612.0, 170230452.0, 15020334.0, 1088430.0, 62196.0, 2628.0, 73.0, 1.0 },
    { 1.0, 74.0, 2701.0, 64824.0, 1150626.0, 16108764.0, 185250786.0, 1799579064.0, 15071474661.0, 110524147514.0, 718406958841.0, 4179822305984.0, 21944067106416.0, 104656320045984.0, 456002537343216.0, 1824010149372864.0, 6726037425812436.0, 22947657099830664.0, 72667580816130436.0, 214178132931752864.0, 588989865562320376.0, 1514545368588823824.0, 3648677478873075576.0, 8249183865278257824.0, 17529515713716297876.0, 35059031427432595752.0, 66072789997853738148.0, 117462737773962201152.0, 197169595549150837648.0, 312751772250377190752.0, 469127658375565786128.0, 665858611887899825472.0, 894747509724365390478.0, 1138769557831010496972.0, 1373222113855042069878.0, 1569396701548619508432.0, 1700179760011004467468.0, 1746130564335626209832.0, 1700179760011004467468.0, 1569396701548619508432.0, 1373222113855042069878.0, 1138769557831010496972.0, 894747509724365390478.0, 665858611887899825472.0, 469127658375565786128.0, 312751772250377190752.0, 197169595549150837648.0, 117462737773962201152.0, 66072789997853738148.0, 35059031427432595752.0, 17529515713716297876.0, 8249183865278257824.0, 3648677478873075576.0, 1514545368588823824.0, 588989865562320376.0, 214178132931752864.0, 72667580816130436.0, 22947657099830664.0, 6726037425812436.0, 1824010149372864.0, 456002537343216.0, 104656320045984.0, 21944067106416.0, 4179822305984.0, 718406958841.0, 110524147514.0, 15071474661.0, 1799579064.0, 185250786.0, 16108764.0, 1150626.0, 64824.0, 2701.0, 74.0, 1.0 },
    { 1.0, 75.0, 2775.0, 67525.0, 1215450.0, 17259390.0, 201359550.0, 1984829850.0, 16871053725.0, 125595622175.0, 828931106355.0, 4898229264825.0, 26123889412400.0, 126600387152400.0, 560658857389200.0, 2280012686716080.0, 8550047575185300.0, 29673694525643100.0, 95615237915961100.0, 286845713747883300.0, 803167998494073240.0, 2103535234151144200.0, 5163222847461899400.0, 11897861344151333400.0, 25778699578994555700.0, 52588547141148893628.0, 101131821425286333900.0, 183535527771815939300.0, 314632333323113038800.0, 509921367799528028400.0, 781879430625942976880.0, 1134986270263465611600.0, 1560606121612265215950.0, 2033517067555375887450.0, 2511991671686052566850.0, 2942618815403661578310.0, 3269576461559623975900.0, 3446310324346630677300.0, 3446310324346630677300.0, 3269576461559623975900.0, 2942618815403661578310.0, 2511991671686052566850.0, 2033517067555375887450.0, 1560606121612265215950.0, 1134986270263465611600.0, 781879430625942976880.0, 509921367799528028400.0, 314632333323113038800.0, 183535527771815939300.0, 101131821425286333900.0, 52588547141148893628.0, 25778699578994555700.0, 11897861344151333400.0, 5163222847461899400.0, 2103535234151144200.0, 803167998494073240.0, 286845713747883300.0, 95615237915961100.0, 29673694525643100.0, 8550047575185300.0, 2280012686716080.0, 560658857389200.0, 126600387152400.0, 26123889412400.0, 4898229264825.0, 828931106355.0, 125595622175.0, 16871053725.0, 1984829850.0, 201359550.0, 17259390.0, 1215450.0, 67525.0, 2775.0, 75.0, 1.0 },
    { 1.0, 76.0, 2850.0, 70300.0, 1282975.0, 18474840.0, 218618940.0, 2186189400.0, 18855883575.0, 142466675900.0, 954526728530.0, 5727160371180.0, 31022118677225.0, 152724276564800.0, 687259244541600.0, 2840671544105280.0, 10830060261901380.0, 38223742100828400.0, 125288932441604200.0, 382460951663844400.0, 1090013712241956540.0, 2906703232645217440.0, 7266758081613043600.0, 17061084191613232800.0, 37676560923145889100.0, 78367246720143449328.0, 153720368566435227528.0, 284667349197102273200.0, 498167861094928978100.0, 824553701122641067200.0, 1291800798425471005280.0, 1916865700889408588480.0, 2695592391875730827550.0, 3594123189167641103400.0, 4545508739241428454300.0, 5454610487089714145160.0, 6212195276963285554210.0, 6715886785906254653200.0, 6892620648693261354600.0, 6715886785906254653200.0, 6212195276963285554210.0, 5454610487089714145160.0, 4545508739241428454300.0, 3594123189167641103400.0, 2695592391875730827550.0, 1916865700889408588480.0, 1291800798425471005280.0, 824553701122641067200.0, 498167861094928978100.0, 284667349197102273200.0, 153720368566435227528.0, 78367246720143449328.0, 37676560923145889100.0, 17061084191613232800.0, 7266758081613043600.0, 2906703232645217440.0, 1090013712241956540.0, 382460951663844400.0, 125288932441604200.0, 38223742100828400.0, 10830060261901380.0, 2840671544105280.0, 687259244541600.0, 152724276564800.0, 31022118677225.0, 5727160371180.0, 954526728530.0, 142466675900.0, 18855883575.0, 2186189400.0, 218618940.0, 18474840.0, 1282975.0, 70300.0, 2850.0, 76.0, 1.0 },
    { 1.0, 77.0, 2926.0, 73150.0, 1353275.0, 19757815.0, 237093780.0, 2404808340.0, 21042072975.0, 161322559475.0, 1096993404430.0, 6681687099710.0, 36749279048405.0, 183746395242025.0, 839983521106400.0, 3527930788646880.0, 13670731806006660.0, 49053802362729780.0, 163512674542432600.0, 507749884105448600.0, 1472474663905800940.0, 3996716944887173980.0, 10173461314258261040.0, 24327842273226276400.0, 54737645114759121900.0, 116043807643289338428.0, 232087615286578676856.0, 438387717763537500728.0, 782835210292031251300.0, 1322721562217570045300.0, 2116354499548112072480.0, 3208666499314879593760.0, 4612458092765139416030.0, 6289715581043371930950.0, 8139631928409069557700.0, 10000119226331142599460.0, 11666805764052999699370.0, 12928082062869540207410.0, 13608507434599516007800.0, 13608507434599516007800.0, 12928082062869540207410.0, 11666805764052999699370.0, 10000119226331142599460.0, 8139631928409069557700.0, 6289715581043371930950.0, 4612458092765139416030.0, 3208666499314879593760.0, 2116354499548112072480.0, 1322721562217570045300.0, 782835210292031251300.0, 438387717763537500728.0, 232087615286578676856.0, 116043807643289338428.0, 54737645114759121900.0, 24327842273226276400.0, 10173461314258261040.0, 3996716944887173980.0, 1472474663905800940.0, 507749884105448600.0, 163512674542432600.0, 49053802362729780.0, 13670731806006660.0, 3527930788646880.0, 839983521106400.0, 183746395242025.0, 36749279048405.0, 6681687099710.0, 1096993404430.0, 161322559475.0, 21042072975.0, 2404808340.0, 237093780.0, 19757815.0, 1353275.0, 73150.0, 2926.0, 77.0, 1.0 },
    { 1.0, 78.0, 3003.0, 76076.0, 1426425.0, 21111090.0, 256851595.0, 2641902120.0, 23446881315.0, 182364632450.0, 1258315963905.0, 7778680504140.0, 43430966148115.0, 220495674290430.0, 1023729916348425.0, 4367914309753280.0, 17198662594653540.0, 62724534168736440.0, 212566476905162380.0, 671262558647881200.0, 1980224548011249540.0, 5469191608792974920.0, 14170178259145435020.0, 34501303587484537440.0, 79065487387985398300.0, 170781452758048460328.0, 348131422929868015284.0, 670475333050116177584.0, 1221222928055568752028.0, 2105556772509601296600.0, 3439076061765682117780.0, 5325020998862991666240.0, 7821124592080019009790.0, 10902173673808511346980.0, 14429347509452441488650.0, 18139751154740212157160.0, 21666924990384142298830.0, 24594887826922539906780.0, 26536589497469056215210.0, 27217014869199032015600.0, 26536589497469056215210.0, 24594887826922539906780.0, 21666924990384142298830.0, 18139751154740212157160.0, 14429347509452441488650.0, 10902173673808511346980.0, 7821124592080019009790.0, 5325020998862991666240.0, 3439076061765682117780.0, 2105556772509601296600.0, 1221222928055568752028.0, 670475333050116177584.0, 348131422929868015284.0, 170781452758048460328.0, 79065487387985398300.0, 34501303587484537440.0, 14170178259145435020.0, 5469191608792974920.0, 1980224548011249540.0, 671262558647881200.0, 212566476905162380.0, 62724534168736440.0, 17198662594653540.0, 4367914309753280.0, 1023729916348425.0, 220495674290430.0, 43430966148115.0, 7778680504140.0, 1258315963905.0, 182364632450.0, 23446881315.0, 2641902120.0, 256851595.0, 21111090.0, 1426425.0, 76076.0, 3003.0, 78.0, 1.0 },
    { 1.0, 79.0, 3081.0, 79079.0, 1502501.0, 22537515.0, 277962685.0, 2898753715.0, 26088783435.0, 205811513765.0, 1440680596355.0, 9036996468045.0, 51209646652255.0, 263926640438545.0, 1244225590638855.0, 5391644226101705.0, 21566576904406820.0, 79923196763389980.0, 275291011073898820.0, 883829035553043580.0, 2651487106659130740.0, 7449416156804224460.0, 19639369867938409940.0, 48671481846629972460.0, 113566790975469935740.0, 249846940146033858628.0, 518912875687916475612.0, 1018606755979984192868.0, 1891698261105684929612.0, 3326779700565170048628.0, 5544632834275283414380.0, 8764097060628673784020.0, 13146145590943010676030.0, 18723298265888530356770.0, 25331521183260952835630.0, 32569098664192653645810.0, 39806676145124354455990.0, 46261812817306682205610.0, 51131477324391596121990.0, 53753604366668088230810.0, 53753604366668088230810.0, 51131477324391596121990.0, 46261812817306682205610.0, 39806676145124354455990.0, 32569098664192653645810.0, 25331521183260952835630.0, 18723298265888530356770.0, 13146145590943010676030.0, 8764097060628673784020.0, 5544632834275283414380.0, 3326779700565170048628.0, 1891698261105684929612.0, 1018606755979984192868.0, 518912875687916475612.0, 249846940146033858628.0, 113566790975469935740.0, 48671481846629972460.0, 19639369867938409940.0, 7449416156804224460.0, 2651487106659130740.0, 883829035553043580.0, 275291011073898820.0, 79923196763389980.0, 21566576904406820.0, 5391644226101705.0, 1244225590638855.0, 263926640438545.0, 51209646652255.0, 9036996468045.0, 1440680596355.0, 205811513765.0, 26088783435.0, 2898753715.0, 277962685.0, 22537515.0, 1502501.0, 79079.0, 3081.0, 79.0, 1.0 },
    { 1.0, 80.0, 3160.0, 82160.0, 1581580.0, 24040016.0, 300500200.0, 3176716400.0, 28987537150.0, 231900297200.0, 1646492110120.0, 10477677064400.0, 60246643120300.0, 315136287090800.0, 1508152231077400.0, 6635869816740560.0, 26958221130508525.0, 101489773667796800.0, 355214207837288800.0, 1159120046626942400.0, 3535316142212174320.0, 10100903263463355200.0, 27088786024742634400.0, 68310851714568382400.0, 162238272822099908200.0, 363413731121503794368.0, 768759815833950334240.0, 1537519631667900668480.0, 2910305017085669122480.0, 5218477961670854978240.0, 8871412534840453463008.0, 14308729894903957198400.0, 21910242651571684460050.0, 31869443856831541032800.0, 44054819449149483192400.0, 57900619847453606481440.0, 72375774809317008101800.0, 86068488962431036661600.0, 97393290141698278327600.0, 104885081691059684352800.0, 107507208733336176461620.0, 104885081691059684352800.0, 97393290141698278327600.0, 86068488962431036661600.0, 72375774809317008101800.0, 57900619847453606481440.0, 44054819449149483192400.0, 31869443856831541032800.0, 21910242651571684460050.0, 14308729894903957198400.0, 8871412534840453463008.0, 5218477961670854978240.0, 2910305017085669122480.0, 1537519631667900668480.0, 768759815833950334240.0, 363413731121503794368.0, 162238272822099908200.0, 68310851714568382400.0, 27088786024742634400.0, 10100903263463355200.0, 3535316142212174320.0, 1159120046626942400.0, 355214207837288800.0, 101489773667796800.0, 26958221130508525.0, 6635869816740560.0, 1508152231077400.0, 315136287090800.0, 60246643120300.0, 10477677064400.0, 1646492110120.0, 231900297200.0, 28987537150.0, 3176716400.0, 300500200.0, 24040016.0, 1581580.0, 82160.0, 3160.0, 80.0, 1.0 },
    { 1.0, 81.0, 3240.0, 85320.0, 1663740.0, 25621596.0, 324540216.0, 3477216600.0, 32164253550.0, 260887834350.0, 1878392407320.0, 12124169174520.0, 70724320184700.0, 375382930211100.0, 1823288518168200.0, 8144022047817960.0, 33594090947249085.0, 128447994798305325.0, 456703981505085600.0, 1514334254464231200.0, 4694436188839116720.0, 13636219405675529520.0, 37189689288205989600.0, 95399637739311016800.0, 230549124536668290600.0, 525652003943603702568.0, 1132173546955454128608.0, 2306279447501851002720.0, 4447824648753569790960.0, 8128782978756524100720.0, 14089890496511308441248.0, 23180142429744410661408.0, 36218972546475641658450.0, 53779686508403225492850.0, 75924263305981024225200.0, 101955439296603089673840.0, 130276394656770614583240.0, 158444263771748044763400.0, 183461779104129314989200.0, 202278371832757962680400.0, 212392290424395860814420.0, 212392290424395860814420.0, 202278371832757962680400.0, 183461779104129314989200.0, 158444263771748044763400.0, 130276394656770614583240.0, 101955439296603089673840.0, 75924263305981024225200.0, 53779686508403225492850.0, 36218972546475641658450.0, 23180142429744410661408.0, 14089890496511308441248.0, 8128782978756524100720.0, 4447824648753569790960.0, 2306279447501851002720.0, 1132173546955454128608.0, 525652003943603702568.0, 230549124536668290600.0, 95399637739311016800.0, 37189689288205989600.0, 13636219405675529520.0, 4694436188839116720.0, 1514334254464231200.0, 456703981505085600.0, 128447994798305325.0, 33594090947249085.0, 8144022047817960.0, 1823288518168200.0, 375382930211100.0, 70724320184700.0, 12124169174520.0, 1878392407320.0, 260887834350.0, 32164253550.0, 3477216600.0, 324540216.0, 25621596.0, 1663740.0, 85320.0, 3240.0, 81.0, 1.0 },
    { 1.0, 82.0, 3321.0, 88560.0, 1749060.0, 27285336.0, 350161812.0, 3801756816.0, 35641470150.0, 293052087900.0, 2139280241670.0, 14002561581840.0, 82848489359220.0, 446107250395800.0, 2198671448379300.0, 9967310565986160.0, 41738112995067045.0, 162042085745554410.0, 585151976303390925.0, 1971038235969316800.0, 6208770443303347920.0, 18330655594514646240.0, 50825908693881519120.0, 132589327027517006400.0, 325948762275979307400.0, 756201128480271993168.0, 1657825550899057831176.0, 3438452994457305131328.0, 6754104096255420793680.0, 12576607627510093891680.0, 22218673475267832541968.0, 37270032926255719102656.0, 59399114976220052319858.0, 89998659054878867151300.0, 129703949814384249718050.0, 177879702602584113899040.0, 232231833953373704257080.0, 288720658428518659346640.0, 341906042875877359752600.0, 385740150936887277669600.0, 414670662257153823494820.0, 424784580848791721628840.0, 414670662257153823494820.0, 385740150936887277669600.0, 341906042875877359752600.0, 288720658428518659346640.0, 232231833953373704257080.0, 177879702602584113899040.0, 129703949814384249718050.0, 89998659054878867151300.0, 59399114976220052319858.0, 37270032926255719102656.0, 22218673475267832541968.0, 12576607627510093891680.0, 6754104096255420793680.0, 3438452994457305131328.0, 1657825550899057831176.0, 756201128480271993168.0, 325948762275979307400.0, 132589327027517006400.0, 50825908693881519120.0, 18330655594514646240.0, 6208770443303347920.0, 1971038235969316800.0, 585151976303390925.0, 162042085745554410.0, 41738112995067045.0, 9967310565986160.0, 2198671448379300.0, 446107250395800.0, 82848489359220.0, 14002561581840.0, 2139280241670.0, 293052087900.0, 35641470150.0, 3801756816.0, 350161812.0, 27285336.0, 1749060.0, 88560.0, 3321.0, 82.0, 1.0 },
    { 1.0, 83.0, 3403.0, 91881.0, 1837620.0, 29034396.0, 377447148.0, 4151918628.0, 39443226966.0, 328693558050.0, 2432332329570.0, 16141841823510.0, 96851050941060.0, 528955739755020.0, 2644778698775100.0, 12165982014365460.0, 51705423561053205.0, 203780198740621455.0, 747194062048945335.0, 2556190212272707725.0, 8179808679272664720.0, 24539426037817994160.0, 69156564288396165360.0, 183415235721398525520.0, 458538089303496313800.0, 1082149890756251300568.0, 2414026679379329824344.0, 5096278545356362962504.0, 10192557090712725925008.0, 19330711723765514685360.0, 34795281102777926433648.0, 59488706401523551644624.0, 96669147902475771422514.0, 149397774031098919471158.0, 219702608869263116869350.0, 307583652416968363617090.0, 410111536555957818156120.0, 520952492381892363603720.0, 630626701304396019099240.0, 727646193812764637422200.0, 800410813194041101164420.0, 839455243105945545123660.0, 839455243105945545123660.0, 800410813194041101164420.0, 727646193812764637422200.0, 630626701304396019099240.0, 520952492381892363603720.0, 410111536555957818156120.0, 307583652416968363617090.0, 219702608869263116869350.0, 149397774031098919471158.0, 96669147902475771422514.0, 59488706401523551644624.0, 34795281102777926433648.0, 19330711723765514685360.0, 10192557090712725925008.0, 5096278545356362962504.0, 2414026679379329824344.0, 1082149890756251300568.0, 458538089303496313800.0, 183415235721398525520.0, 69156564288396165360.0, 24539426037817994160.0, 8179808679272664720.0, 2556190212272707725.0, 747194062048945335.0, 203780198740621455.0, 51705423561053205.0, 12165982014365460.0, 2644778698775100.0, 528955739755020.0, 96851050941060.0, 16141841823510.0, 2432332329570.0, 328693558050.0, 39443226966.0, 4151918628.0, 377447148.0, 29034396.0, 1837620.0, 91881.0, 3403.0, 83.0, 1.0 },
    { 1.0, 84.0, 3486.0, 95284.0, 1929501.0, 30872016.0, 406481544.0, 4529365776.0, 43595145594.0, 368136785016.0, 2761025887620.0, 18574174153080.0, 112992892764570.0, 625806790696080.0, 3173734438530120.0, 14810760713140560.0, 63871405575418665.0, 255485622301674660.0, 950974260789566790.0, 3303384274321653060.0, 10735998891545372445.0, 32719234717090658880.0, 93695990326214159520.0, 252571800009794690880.0, 641953325024894839320.0, 1540687980059747614368.0, 3496176570135581124912.0, 7510305224735692786848.0, 15288835636069088887512.0, 29523268814478240610368.0, 54125992826543441119008.0, 94283987504301478078272.0, 156157854303999323067138.0, 246066921933574690893672.0, 369100382900362036340508.0, 527286261286231480486440.0, 717695188972926181773210.0, 931064028937850181759840.0, 1151579193686288382702960.0, 1358272895117160656521440.0, 1528057007006805738586620.0, 1639866056299986646288080.0, 1678910486211891090247320.0, 1639866056299986646288080.0, 1528057007006805738586620.0, 1358272895117160656521440.0, 1151579193686288382702960.0, 931064028937850181759840.0, 717695188972926181773210.0, 527286261286231480486440.0, 369100382900362036340508.0, 246066921933574690893672.0, 156157854303999323067138.0, 94283987504301478078272.0, 54125992826543441119008.0, 29523268814478240610368.0, 15288835636069088887512.0, 7510305224735692786848.0, 3496176570135581124912.0, 1540687980059747614368.0, 641953325024894839320.0, 252571800009794690880.0, 93695990326214159520.0, 32719234717090658880.0, 10735998891545372445.0, 3303384274321653060.0, 950974260789566790.0, 255485622301674660.0, 63871405575418665.0, 14810760713140560.0, 3173734438530120.0, 625806790696080.0, 112992892764570.0, 18574174153080.0, 2761025887620.0, 368136785016.0, 43595145594.0, 4529365776.0, 406481544.0, 30872016.0, 1929501.0, 95284.0, 3486.0, 84.0, 1.0 },
    { 1.0, 85.0, 3570.0, 98770.0, 2024785.0, 32801517.0, 437353560.0, 4935847320.0, 48124511370.0, 411731930610.0, 3129162672636.0, 21335200040700.0, 131567066917650.0, 738799683460650.0, 3799541229226200.0, 17984495151670680.0, 78682166288559225.0, 319357027877093325.0, 1206459883091241450.0, 4254358535111219850.0, 14039383165867025505.0, 43455233608636031325.0, 126415225043304818400.0, 346267790336008850400.0, 894525125034689530200.0, 2182641305084642453688.0, 5036864550195328739280.0, 11006481794871273911760.0, 22799140860804781674360.0, 44812104450547329497880.0, 83649261641021681729376.0, 148409980330844919197280.0, 250441841808300801145410.0, 402224776237574013960810.0, 615167304833936727234180.0, 896386644186593516826948.0, 1244981450259157662259650.0, 1648759217910776363533050.0, 2082643222624138564462800.0, 2509852088803449039224400.0, 2886329902123966395108060.0, 3167923063306792384874700.0, 3318776542511877736535400.0, 3318776542511877736535400.0, 3167923063306792384874700.0, 2886329902123966395108060.0, 2509852088803449039224400.0, 2082643222624138564462800.0, 1648759217910776363533050.0, 1244981450259157662259650.0, 896386644186593516826948.0, 615167304833936727234180.0, 402224776237574013960810.0, 250441841808300801145410.0, 148409980330844919197280.0, 83649261641021681729376.0, 44812104450547329497880.0, 22799140860804781674360.0, 11006481794871273911760.0, 5036864550195328739280.0, 2182641305084642453688.0, 894525125034689530200.0, 346267790336008850400.0, 126415225043304818400.0, 43455233608636031325.0, 14039383165867025505.0, 4254358535111219850.0, 1206459883091241450.0, 319357027877093325.0, 78682166288559225.0, 17984495151670680.0, 3799541229226200.0, 738799683460650.0, 131567066917650.0, 21335200040700.0, 3129162672636.0, 411731930610.0, 48124511370.0, 4935847320.0, 437353560.0, 32801517.0, 2024785.0, 98770.0, 3570.0, 85.0, 1.0 },
    { 1.0, 86.0, 3655.0, 102340.0, 2123555.0, 34826302.0, 470155077.0, 5373200880.0, 53060358690.0, 459856441980.0, 3540894603246.0, 24464362713336.0, 152902266958350.0, 870366750378300.0, 4538340912686850.0, 21784036380896880.0, 96666661440229905.0, 398039194165652550.0, 1525816910968334775.0, 5460818418202461300.0, 18293741700978245355.0, 57494616774503056830.0, 169870458651940849725.0, 472683015379313668800.0, 1240792915370698380600.0, 3077166430119331983888.0, 7219505855279971192968.0, 16043346345066602651040.0, 33805622655676055586120.0, 67611245311352111172240.0, 128461366091569011227256.0, 232059241971866600926656.0, 398851822139145720342690.0, 652666618045874815106220.0, 1017392081071510741194990.0, 1511553949020530244061128.0, 2141368094445751179086598.0, 2893740668169934025792700.0, 3731402440534914927995850.0, 4592495311427587603687200.0, 5396181990927415434332460.0, 6054252965430758779982760.0, 6486699605818670121410100.0, 6637553085023755473070800.0, 6486699605818670121410100.0, 6054252965430758779982760.0, 5396181990927415434332460.0, 4592495311427587603687200.0, 3731402440534914927995850.0, 2893740668169934025792700.0, 2141368094445751179086598.0, 1511553949020530244061128.0, 1017392081071510741194990.0, 652666618045874815106220.0, 398851822139145720342690.0, 232059241971866600926656.0, 128461366091569011227256.0, 67611245311352111172240.0, 33805622655676055586120.0, 16043346345066602651040.0, 7219505855279971192968.0, 3077166430119331983888.0, 1240792915370698380600.0, 472683015379313668800.0, 169870458651940849725.0, 57494616774503056830.0, 18293741700978245355.0, 5460818418202461300.0, 1525816910968334775.0, 398039194165652550.0, 96666661440229905.0, 21784036380896880.0, 4538340912686850.0, 870366750378300.0, 152902266958350.0, 24464362713336.0, 3540894603246.0, 459856441980.0, 53060358690.0, 5373200880.0, 470155077.0, 34826302.0, 2123555.0, 102340.0, 3655.0, 86.0, 1.0 },
    { 1.0, 87.0, 3741.0, 105995.0, 2225895.0, 36949857.0, 504981379.0, 5843355957.0, 58433559570.0, 512916800670.0, 4000751045226.0, 28005257316582.0, 177366629671686.0, 1023269017336650.0, 5408707663065150.0, 26322377293583730.0, 118450697821126785.0, 494705855605882455.0, 1923856105133987325.0, 6986635329170796075.0, 23754560119180706655.0, 75788358475481302185.0, 227365075426443906555.0, 642553474031254518525.0, 1713475930750012049400.0, 4317959345490030364488.0, 10296672285399303176856.0, 23262852200346573844008.0, 49848969000742658237160.0, 101416867967028166758360.0, 196072611402921122399496.0, 360520608063435612153912.0, 630911064111012321269346.0, 1051518440185020535448910.0, 1670058699117385556301210.0, 2528946030092040985256118.0, 3652922043466281423147726.0, 5035108762615685204879298.0, 6625143108704848953788550.0, 8323897751962502531683050.0, 9988677302355003038019660.0, 11450434956358174214315220.0, 12540952571249428901392860.0, 13124252690842425594480900.0, 13124252690842425594480900.0, 12540952571249428901392860.0, 11450434956358174214315220.0, 9988677302355003038019660.0, 8323897751962502531683050.0, 6625143108704848953788550.0, 5035108762615685204879298.0, 3652922043466281423147726.0, 2528946030092040985256118.0, 1670058699117385556301210.0, 1051518440185020535448910.0, 630911064111012321269346.0, 360520608063435612153912.0, 196072611402921122399496.0, 101416867967028166758360.0, 49848969000742658237160.0, 23262852200346573844008.0, 10296672285399303176856.0, 4317959345490030364488.0, 1713475930750012049400.0, 642553474031254518525.0, 227365075426443906555.0, 75788358475481302185.0, 23754560119180706655.0, 6986635329170796075.0, 1923856105133987325.0, 494705855605882455.0, 118450697821126785.0, 26322377293583730.0, 5408707663065150.0, 1023269017336650.0, 177366629671686.0, 28005257316582.0, 4000751045226.0, 512916800670.0, 58433559570.0, 5843355957.0, 504981379.0, 36949857.0, 2225895.0, 105995.0, 3741.0, 87.0, 1.0 },
    { 1.0, 88.0, 3828.0, 109736.0, 2331890.0, 39175752.0, 541931236.0, 6348337336.0, 64276915527.0, 571350360240.0, 4513667845896.0, 32006008361808.0, 205371886988268.0, 1200635647008336.0, 6431976680401800.0, 31731084956648880.0, 144773075114710515.0, 613156553427009240.0, 2418561960739869780.0, 8910491434304783400.0, 30741195448351502730.0, 99542918594662008840.0, 303153433901925208740.0, 869918549457698425080.0, 2356029404781266567925.0, 6031435276240042413888.0, 14614631630889333541344.0, 33559524485745877020864.0, 73111821201089232081168.0, 151265836967770824995520.0, 297489479369949289157856.0, 556593219466356734553408.0, 991431672174447933423258.0, 1682429504296032856718256.0, 2721577139302406091750120.0, 4199004729209426541557328.0, 6181868073558322408403844.0, 8688030806081966628027024.0, 11660251871320534158667848.0, 14949040860667351485471600.0, 18312575054317505569702710.0, 21439112258713177252334880.0, 23991387527607603115708080.0, 25665205262091854495873760.0, 26248505381684851188961800.0, 25665205262091854495873760.0, 23991387527607603115708080.0, 21439112258713177252334880.0, 18312575054317505569702710.0, 14949040860667351485471600.0, 11660251871320534158667848.0, 8688030806081966628027024.0, 6181868073558322408403844.0, 4199004729209426541557328.0, 2721577139302406091750120.0, 1682429504296032856718256.0, 991431672174447933423258.0, 556593219466356734553408.0, 297489479369949289157856.0, 151265836967770824995520.0, 73111821201089232081168.0, 33559524485745877020864.0, 14614631630889333541344.0, 6031435276240042413888.0, 2356029404781266567925.0, 869918549457698425080.0, 303153433901925208740.0, 99542918594662008840.0, 30741195448351502730.0, 8910491434304783400.0, 2418561960739869780.0, 613156553427009240.0, 144773075114710515.0, 31731084956648880.0, 6431976680401800.0, 1200635647008336.0, 205371886988268.0, 32006008361808.0, 4513667845896.0, 571350360240.0, 64276915527.0, 6348337336.0, 541931236.0, 39175752.0, 2331890.0, 109736.0, 3828.0, 88.0, 1.0 },
    { 1.0, 89.0, 3916.0, 113564.0, 2441626.0, 41507642.0, 581106988.0, 6890268572.0, 70625252863.0, 635627275767.0, 5085018206136.0, 36519676207704.0, 237377895350076.0, 1406007533996604.0, 7632612327410136.0, 38163061637050680.0, 176504160071359395.0, 757929628541719755.0, 3031718514166879020.0, 11329053395044653180.0, 39651686882656286130.0, 130284114043013511570.0, 402696352496587217580.0, 1173071983359623633820.0, 3225947954238964993005.0, 8387464681021308981813.0, 20646066907129375955232.0, 48174156116635210562208.0, 106671345686835109102032.0, 224377658168860057076688.0, 448755316337720114153376.0, 854082698836306023711264.0, 1548024891640804667976666.0, 2673861176470480790141514.0, 4404006643598438948468376.0, 6920581868511832633307448.0, 10380872802767748949961172.0, 14869898879640289036430868.0, 20348282677402500786694872.0, 26609292731987885644139448.0, 33261615914984857055174310.0, 39751687313030682822037590.0, 45430499786320780368042960.0, 49656592789699457611581840.0, 51913710643776705684835560.0, 51913710643776705684835560.0, 49656592789699457611581840.0, 45430499786320780368042960.0, 39751687313030682822037590.0, 33261615914984857055174310.0, 26609292731987885644139448.0, 20348282677402500786694872.0, 14869898879640289036430868.0, 10380872802767748949961172.0, 6920581868511832633307448.0, 4404006643598438948468376.0, 2673861176470480790141514.0, 1548024891640804667976666.0, 854082698836306023711264.0, 448755316337720114153376.0, 224377658168860057076688.0, 106671345686835109102032.0, 48174156116635210562208.0, 20646066907129375955232.0, 8387464681021308981813.0, 3225947954238964993005.0, 1173071983359623633820.0, 402696352496587217580.0, 130284114043013511570.0, 39651686882656286130.0, 11329053395044653180.0, 3031718514166879020.0, 757929628541719755.0, 176504160071359395.0, 38163061637050680.0, 7632612327410136.0, 1406007533996604.0, 237377895350076.0, 36519676207704.0, 5085018206136.0, 635627275767.0, 70625252863.0, 6890268572.0, 581106988.0, 41507642.0, 2441626.0, 113564.0, 3916.0, 89.0, 1.0 },
    { 1.0, 90.0, 4005.0, 117480.0, 2555190.0, 43949268.0, 622614630.0, 7471375560.0, 77515521435.0, 706252528630.0, 5720645481903.0, 41604694413840.0, 273897571557780.0, 1643385429346680.0, 9038619861406740.0, 45795673964460816.0, 214667221708410075.0, 934433788613079150.0, 3789648142708598775.0, 14360771909211532200.0, 50980740277700939310.0, 169935800925669797700.0, 532980466539600729150.0, 1575768335856210851400.0, 4399019937598588626825.0, 11613412635260273974818.0, 29033531588150684937045.0, 68820223023764586517440.0, 154845501803470319664240.0, 331049003855695166178720.0, 673132974506580171230064.0, 1302838015174026137864640.0, 2402107590477110691687930.0, 4221886068111285458118180.0, 7077867820068919738609890.0, 11324588512110271581775824.0, 17301454671279581583268620.0, 25250771682408037986392040.0, 35218181557042789823125740.0, 46957575409390386430834320.0, 59870908646972742699313758.0, 73013303228015539877211900.0, 85182187099351463190080550.0, 95087092576020237979624800.0, 101570303433476163296417400.0, 103827421287553411369671120.0, 101570303433476163296417400.0, 95087092576020237979624800.0, 85182187099351463190080550.0, 73013303228015539877211900.0, 59870908646972742699313758.0, 46957575409390386430834320.0, 35218181557042789823125740.0, 25250771682408037986392040.0, 17301454671279581583268620.0, 11324588512110271581775824.0, 7077867820068919738609890.0, 4221886068111285458118180.0, 2402107590477110691687930.0, 1302838015174026137864640.0, 673132974506580171230064.0, 331049003855695166178720.0, 154845501803470319664240.0, 68820223023764586517440.0, 29033531588150684937045.0, 11613412635260273974818.0, 4399019937598588626825.0, 1575768335856210851400.0, 532980466539600729150.0, 169935800925669797700.0, 50980740277700939310.0, 14360771909211532200.0, 3789648142708598775.0, 934433788613079150.0, 214667221708410075.0, 45795673964460816.0, 9038619861406740.0, 1643385429346680.0, 273897571557780.0, 41604694413840.0, 5720645481903.0, 706252528630.0, 77515521435.0, 7471375560.0, 622614630.0, 43949268.0, 2555190.0, 117480.0, 4005.0, 90.0, 1.0 },
    { 1.0, 91.0, 4095.0, 121485.0, 2672670.0, 46504458.0, 666563898.0, 8093990190.0, 84986896995.0, 783768050065.0, 6426898010533.0, 47325339895743.0, 315502265971620.0, 1917283000904460.0, 10682005290753420.0, 54834293825867556.0, 260462895672870891.0, 1149101010321489225.0, 4724081931321677925.0, 18150420051920130975.0, 65341512186912471510.0, 220916541203370737010.0, 702916267465270526850.0, 2108748802395811580550.0, 5974788273454799478225.0, 16012432572858862601643.0, 40646944223410958911863.0, 97853754611915271454485.0, 223665724827234906181680.0, 485894505659165485842960.0, 1004181978362275337408784.0, 1975970989680606309094704.0, 3704945605651136829552570.0, 6623993658588396149806110.0, 11299753888180205196728070.0, 18402456332179191320385714.0, 28626043183389853165044444.0, 42552226353687619569660660.0, 60468953239450827809517780.0, 82175756966433176253960060.0, 106828484056363129130148078.0, 132884211874988282576525658.0, 158195490327367003067292450.0, 180269279675371701169705350.0, 196657396009496401276042200.0, 205397724721029574666088520.0, 205397724721029574666088520.0, 196657396009496401276042200.0, 180269279675371701169705350.0, 158195490327367003067292450.0, 132884211874988282576525658.0, 106828484056363129130148078.0, 82175756966433176253960060.0, 60468953239450827809517780.0, 42552226353687619569660660.0, 28626043183389853165044444.0, 18402456332179191320385714.0, 11299753888180205196728070.0, 6623993658588396149806110.0, 3704945605651136829552570.0, 1975970989680606309094704.0, 1004181978362275337408784.0, 485894505659165485842960.0, 223665724827234906181680.0, 97853754611915271454485.0, 40646944223410958911863.0, 16012432572858862601643.0, 5974788273454799478225.0, 2108748802395811580550.0, 702916267465270526850.0, 220916541203370737010.0, 65341512186912471510.0, 18150420051920130975.0, 4724081931321677925.0, 1149101010321489225.0, 260462895672870891.0, 54834293825867556.0, 10682005290753420.0, 1917283000904460.0, 315502265971620.0, 47325339895743.0, 6426898010533.0, 783768050065.0, 84986896995.0, 8093990190.0, 666563898.0, 46504458.0, 2672670.0, 121485.0, 4095.0, 91.0, 1.0 },
    { 1.0, 92.0, 4186.0, 125580.0, 2794155.0, 49177128.0, 713068356.0, 8760554088.0, 93080887185.0, 868754947060.0, 7210666060598.0, 53752237906276.0, 362827605867363.0, 2232785266876080.0, 12599288291657880.0, 65516299116620976.0, 315297189498738447.0, 1409563905994360116.0, 5873182941643167150.0, 22874501983241808900.0, 83491932238832602485.0, 286258053390283208520.0, 923832808668641263860.0, 2811665069861082107400.0, 8083537075850611058775.0, 21987220846313662079868.0, 56659376796269821513506.0, 138500698835326230366348.0, 321519479439150177636165.0, 709560230486400392024640.0, 1490076484021440823251744.0, 2980152968042881646503488.0, 5680916595331743138647274.0, 10328939264239532979358680.0, 17923747546768601346534180.0, 29702210220359396517113784.0, 47028499515569044485430158.0, 71178269537077472734705104.0, 103021179593138447379178440.0, 142644710205884004063477840.0, 189004241022796305384108138.0, 239712695931351411706673736.0, 291079702202355285643818108.0, 338464770002738704236997800.0, 376926675684868102445747550.0, 402055120730525975942130720.0, 410795449442059149332177040.0, 402055120730525975942130720.0, 376926675684868102445747550.0, 338464770002738704236997800.0, 291079702202355285643818108.0, 239712695931351411706673736.0, 189004241022796305384108138.0, 142644710205884004063477840.0, 103021179593138447379178440.0, 71178269537077472734705104.0, 47028499515569044485430158.0, 29702210220359396517113784.0, 17923747546768601346534180.0, 10328939264239532979358680.0, 5680916595331743138647274.0, 2980152968042881646503488.0, 1490076484021440823251744.0, 709560230486400392024640.0, 321519479439150177636165.0, 138500698835326230366348.0, 56659376796269821513506.0, 21987220846313662079868.0, 8083537075850611058775.0, 2811665069861082107400.0, 923832808668641263860.0, 286258053390283208520.0, 83491932238832602485.0, 22874501983241808900.0, 5873182941643167150.0, 1409563905994360116.0, 315297189498738447.0, 65516299116620976.0, 12599288291657880.0, 2232785266876080.0, 362827605867363.0, 53752237906276.0, 7210666060598.0, 868754947060.0, 93080887185.0, 8760554088.0, 713068356.0, 49177128.0, 2794155.0, 125580.0, 4186.0, 92.0, 1.0 },
    { 1.0, 93.0, 4278.0, 129766.0, 2919735.0, 51971283.0, 762245484.0, 9473622444.0, 101841441273.0, 961835834245.0, 8079421007658.0, 60962903966874.0, 416579843773639.0, 2595612872743443.0, 14832073558533960.0, 78115587408278856.0, 380813488615359423.0, 1724861095493098563.0, 7282746847637527266.0, 28747684924884976050.0, 106366434222074411385.0, 369749985629115811005.0, 1210090862058924472380.0, 3735497878529723371260.0, 10895202145711693166175.0, 30070757922164273138643.0, 78646597642583483593374.0, 195160075631596051879854.0, 460020178274476408002513.0, 1031079709925550569660805.0, 2199636714507841215276384.0, 4470229452064322469755232.0, 8661069563374624785150762.0, 16009855859571276118005954.0, 28252686811008134325892860.0, 47625957767127997863647964.0, 76730709735928441002543942.0, 118206769052646517220135262.0, 174199449130215920113883544.0, 245665889799022451442656280.0, 331648951228680309447585978.0, 428716936954147717090781874.0, 530792398133706697350491844.0, 629544472205093989880815908.0, 715391445687606806682745350.0, 778981796415394078387878270.0, 812850570172585125274307760.0, 812850570172585125274307760.0, 778981796415394078387878270.0, 715391445687606806682745350.0, 629544472205093989880815908.0, 530792398133706697350491844.0, 428716936954147717090781874.0, 331648951228680309447585978.0, 245665889799022451442656280.0, 174199449130215920113883544.0, 118206769052646517220135262.0, 76730709735928441002543942.0, 47625957767127997863647964.0, 28252686811008134325892860.0, 16009855859571276118005954.0, 8661069563374624785150762.0, 4470229452064322469755232.0, 2199636714507841215276384.0, 1031079709925550569660805.0, 460020178274476408002513.0, 195160075631596051879854.0, 78646597642583483593374.0, 30070757922164273138643.0, 10895202145711693166175.0, 3735497878529723371260.0, 1210090862058924472380.0, 369749985629115811005.0, 106366434222074411385.0, 28747684924884976050.0, 7282746847637527266.0, 1724861095493098563.0, 380813488615359423.0, 78115587408278856.0, 14832073558533960.0, 2595612872743443.0, 416579843773639.0, 60962903966874.0, 8079421007658.0, 961835834245.0, 101841441273.0, 9473622444.0, 762245484.0, 51971283.0, 2919735.0, 129766.0, 4278.0, 93.0, 1.0 },
    { 1.0, 94.0, 4371.0, 134044.0, 3049501.0, 54891018.0, 814216767.0, 10235867928.0, 111315063717.0, 1063677275518.0, 9041256841903.0, 69042324974532.0, 477542747740513.0, 3012192716517082.0, 17427686431277403.0, 92947660966812816.0, 458929076023638279.0, 2105674584108457986.0, 9007607943130625829.0, 36030431772522503316.0, 135114119146959387435.0, 476116419851190222390.0, 1579840847688040283385.0, 4945588740588647843640.0, 14630700024241416537435.0, 40965960067875966304818.0, 108717355564747756732017.0, 273806673274179535473228.0, 655180253906072459882367.0, 1491099888200026977663318.0, 3230716424433391784937189.0, 6669866166572163685031616.0, 13131299015438947254905994.0, 24670925422945900903156716.0, 44262542670579410443898814.0, 75878644578136132189540824.0, 124356667503056438866191906.0, 194937478788574958222679204.0, 292406218182862437334018806.0, 419865338929238371556539824.0, 577314841027702760890242258.0, 760365888182828026538367852.0, 959509335087854414441273718.0, 1160336870338800687231307752.0, 1344935917892700796563561258.0, 1494373242103000885070623620.0, 1591832366587979203662186030.0, 1625701140345170250548615520.0, 1591832366587979203662186030.0, 1494373242103000885070623620.0, 1344935917892700796563561258.0, 1160336870338800687231307752.0, 959509335087854414441273718.0, 760365888182828026538367852.0, 577314841027702760890242258.0, 419865338929238371556539824.0, 292406218182862437334018806.0, 194937478788574958222679204.0, 124356667503056438866191906.0, 75878644578136132189540824.0, 44262542670579410443898814.0, 24670925422945900903156716.0, 13131299015438947254905994.0, 6669866166572163685031616.0, 3230716424433391784937189.0, 1491099888200026977663318.0, 655180253906072459882367.0, 273806673274179535473228.0, 108717355564747756732017.0, 40965960067875966304818.0, 14630700024241416537435.0, 4945588740588647843640.0, 1579840847688040283385.0, 476116419851190222390.0, 135114119146959387435.0, 36030431772522503316.0, 9007607943130625829.0, 2105674584108457986.0, 458929076023638279.0, 92947660966812816.0, 17427686431277403.0, 3012192716517082.0, 477542747740513.0, 69042324974532.0, 9041256841903.0, 1063677275518.0, 111315063717.0, 10235867928.0, 814216767.0, 54891018.0, 3049501.0, 134044.0, 4371.0, 94.0, 1.0 },
    { 1.0, 95.0, 4465.0, 138415.0, 3183545.0, 57940519.0, 869107785.0, 11050084695.0, 121550931645.0, 1174992339235.0, 10104934117421.0, 78083581816435.0, 546585072715045.0, 3489735464257595.0, 20439879147794485.0, 110375347398090219.0, 551876736990451095.0, 2564603660132096265.0, 11113282527239083815.0, 45038039715653129145.0, 171144550919481890751.0, 611230538998149609825.0, 2055957267539230505775.0, 6525429588276688127025.0, 19576288764830064381075.0, 55596660092117382842253.0, 149683315632623723036835.0, 382524028838927292205245.0, 928986927180251995355595.0, 2146280142106099437545685.0, 4721816312633418762600507.0, 9900582591005555469968805.0, 19801165182011110939937610.0, 37802224438384848158062710.0, 68933468093525311347055530.0, 120141187248715542633439638.0, 200235312081192571055732730.0, 319294146291631397088871110.0, 487343696971437395556698010.0, 712271557112100808890558630.0, 997180179956941132446782082.0, 1337680729210530787428610110.0, 1719875223270682440979641570.0, 2119846205426655101672581470.0, 2505272788231501483794869010.0, 2839309159995701681634184878.0, 3086205608690980088732809650.0, 3217533506933149454210801550.0, 3217533506933149454210801550.0, 3086205608690980088732809650.0, 2839309159995701681634184878.0, 2505272788231501483794869010.0, 2119846205426655101672581470.0, 1719875223270682440979641570.0, 1337680729210530787428610110.0, 997180179956941132446782082.0, 712271557112100808890558630.0, 487343696971437395556698010.0, 319294146291631397088871110.0, 200235312081192571055732730.0, 120141187248715542633439638.0, 68933468093525311347055530.0, 37802224438384848158062710.0, 19801165182011110939937610.0, 9900582591005555469968805.0, 4721816312633418762600507.0, 2146280142106099437545685.0, 928986927180251995355595.0, 382524028838927292205245.0, 149683315632623723036835.0, 55596660092117382842253.0, 19576288764830064381075.0, 6525429588276688127025.0, 2055957267539230505775.0, 611230538998149609825.0, 171144550919481890751.0, 45038039715653129145.0, 11113282527239083815.0, 2564603660132096265.0, 551876736990451095.0, 110375347398090219.0, 20439879147794485.0, 3489735464257595.0, 546585072715045.0, 78083581816435.0, 10104934117421.0, 1174992339235.0, 121550931645.0, 11050084695.0, 869107785.0, 57940519.0, 3183545.0, 138415.0, 4465.0, 95.0, 1.0 },
    { 1.0, 96.0, 4560.0, 142880.0, 3321960.0, 61124064.0, 927048304.0, 11919192480.0, 132601016340.0, 1296543270880.0, 11279926456656.0, 88188515933856.0, 624668654531480.0, 4036320536972640.0, 23929614612052080.0, 130815226545884704.0, 662252084388541314.0, 3116480397122547360.0, 13677886187371180080.0, 56151322242892212960.0, 216182590635135019896.0, 782375089917631500576.0, 2667187806537380115600.0, 8581386855815918632800.0, 26101718353106752508100.0, 75172948856947447223328.0, 205279975724741105879088.0, 532207344471551015242080.0, 1311510956019179287560840.0, 3075267069286351432901280.0, 6868096454739518200146192.0, 14622398903638974232569312.0, 29701747773016666409906415.0, 57603389620395959098000320.0, 106735692531910159505118240.0, 189074655342240853980495168.0, 320376499329908113689172368.0, 519529458372823968144603840.0, 806637843263068792645569120.0, 1199615254083538204447256640.0, 1709451737069041941337340712.0, 2334860909167471919875392192.0, 3057555952481213228408251680.0, 3839721428697337542652223040.0, 4625118993658156585467450480.0, 5344581948227203165429053888.0, 5925514768686681770366994528.0, 6303739115624129542943611200.0, 6435067013866298908421603100.0, 6303739115624129542943611200.0, 5925514768686681770366994528.0, 5344581948227203165429053888.0, 4625118993658156585467450480.0, 3839721428697337542652223040.0, 3057555952481213228408251680.0, 2334860909167471919875392192.0, 1709451737069041941337340712.0, 1199615254083538204447256640.0, 806637843263068792645569120.0, 519529458372823968144603840.0, 320376499329908113689172368.0, 189074655342240853980495168.0, 106735692531910159505118240.0, 57603389620395959098000320.0, 29701747773016666409906415.0, 14622398903638974232569312.0, 6868096454739518200146192.0, 3075267069286351432901280.0, 1311510956019179287560840.0, 532207344471551015242080.0, 205279975724741105879088.0, 75172948856947447223328.0, 26101718353106752508100.0, 8581386855815918632800.0, 2667187806537380115600.0, 782375089917631500576.0, 216182590635135019896.0, 56151322242892212960.0, 13677886187371180080.0, 3116480397122547360.0, 662252084388541314.0, 130815226545884704.0, 23929614612052080.0, 4036320536972640.0, 624668654531480.0, 88188515933856.0, 11279926456656.0, 1296543270880.0, 132601016340.0, 11919192480.0, 927048304.0, 61124064.0, 3321960.0, 142880.0, 4560.0, 96.0, 1.0 },
    { 1.0, 97.0, 4656.0, 147440.0, 3464840.0, 64446024.0, 988172368.0, 12846240784.0, 144520208820.0, 1429144287220.0, 12576469727536.0, 99468442390512.0, 712857170465336.0, 4660989191504120.0, 27965935149024720.0, 154744841157936784.0, 793067310934426018.0, 3778732481511088674.0, 16794366584493727440.0, 69829208430263393040.0, 272333912878027232856.0, 998557680552766520472.0, 3449562896455011616176.0, 11248574662353298748400.0, 34683105208922671140900.0, 101274667210054199731428.0, 280452924581688553102416.0, 737487320196292121121168.0, 1843718300490730302802920.0, 4386778025305530720462120.0, 9943363524025869633047472.0, 21490495358378492432715504.0, 44324146676655640642475727.0, 87305137393412625507906735.0, 164339082152306118603118560.0, 295810347874151013485613408.0, 509451154672148967669667536.0, 839905957702732081833776208.0, 1326167301635892760790172960.0, 2006253097346606997092825760.0, 2909066991152580145784597352.0, 4044312646236513861212732904.0, 5392416861648685148283643872.0, 6897277381178550771060474720.0, 8464840422355494128119673520.0, 9969700941885359750896504368.0, 11270096716913884935796048416.0, 12229253884310811313310605728.0, 12738806129490428451365214300.0, 12738806129490428451365214300.0, 12229253884310811313310605728.0, 11270096716913884935796048416.0, 9969700941885359750896504368.0, 8464840422355494128119673520.0, 6897277381178550771060474720.0, 5392416861648685148283643872.0, 4044312646236513861212732904.0, 2909066991152580145784597352.0, 2006253097346606997092825760.0, 1326167301635892760790172960.0, 839905957702732081833776208.0, 509451154672148967669667536.0, 295810347874151013485613408.0, 164339082152306118603118560.0, 87305137393412625507906735.0, 44324146676655640642475727.0, 21490495358378492432715504.0, 9943363524025869633047472.0, 4386778025305530720462120.0, 1843718300490730302802920.0, 737487320196292121121168.0, 280452924581688553102416.0, 101274667210054199731428.0, 34683105208922671140900.0, 11248574662353298748400.0, 3449562896455011616176.0, 998557680552766520472.0, 272333912878027232856.0, 69829208430263393040.0, 16794366584493727440.0, 3778732481511088674.0, 793067310934426018.0, 154744841157936784.0, 27965935149024720.0, 4660989191504120.0, 712857170465336.0, 99468442390512.0, 12576469727536.0, 1429144287220.0, 144520208820.0, 12846240784.0, 988172368.0, 64446024.0, 3464840.0, 147440.0, 4656.0, 97.0, 1.0 },
    { 1.0, 98.0, 4753.0, 152096.0, 3612280.0, 67910864.0, 1052618392.0, 13834413152.0, 157366449604.0, 1573664496040.0, 14005614014756.0, 112044912118048.0, 812325612855848.0, 5373846361969456.0, 32626924340528840.0, 182710776306961504.0, 947812152092362802.0, 4571799792445514692.0, 20573099066004816114.0, 86623575014757120480.0, 342163121308290625896.0, 1270891593430793753328.0, 4448120577007778136648.0, 14698137558808310364576.0, 45931679871275969889300.0, 135957772418976870872328.0, 381727591791742752833844.0, 1017940244777980674223584.0, 2581205620687022423924088.0, 6230496325796261023265040.0, 14330141549331400353509592.0, 31433858882404362065762976.0, 65814642035034133075191231.0, 131629284070068266150382462.0, 251644219545718744111025295.0, 460149430026457132088731968.0, 805261502546299981155280944.0, 1349357112374881049503443744.0, 2166073259338624842623949168.0, 3332420398982499757882998720.0, 4915320088499187142877423112.0, 6953379637389094006997330256.0, 9436729507885199009496376776.0, 12289694242827235919344118592.0, 15362117803534044899180148240.0, 18434541364240853879016177888.0, 21239797658799244686692552784.0, 23499350601224696249106654144.0, 24968060013801239764675820028.0, 25477612258980856902730428600.0, 24968060013801239764675820028.0, 23499350601224696249106654144.0, 21239797658799244686692552784.0, 18434541364240853879016177888.0, 15362117803534044899180148240.0, 12289694242827235919344118592.0, 9436729507885199009496376776.0, 6953379637389094006997330256.0, 4915320088499187142877423112.0, 3332420398982499757882998720.0, 2166073259338624842623949168.0, 1349357112374881049503443744.0, 805261502546299981155280944.0, 460149430026457132088731968.0, 251644219545718744111025295.0, 131629284070068266150382462.0, 65814642035034133075191231.0, 31433858882404362065762976.0, 14330141549331400353509592.0, 6230496325796261023265040.0, 2581205620687022423924088.0, 1017940244777980674223584.0, 381727591791742752833844.0, 135957772418976870872328.0, 45931679871275969889300.0, 14698137558808310364576.0, 4448120577007778136648.0, 1270891593430793753328.0, 342163121308290625896.0, 86623575014757120480.0, 20573099066004816114.0, 4571799792445514692.0, 947812152092362802.0, 182710776306961504.0, 32626924340528840.0, 5373846361969456.0, 812325612855848.0, 112044912118048.0, 14005614014756.0, 1573664496040.0, 157366449604.0, 13834413152.0, 1052618392.0, 67910864.0, 3612280.0, 152096.0, 4753.0, 98.0, 1.0 },
    { 1.0, 99.0, 4851.0, 156849.0, 3764376.0, 71523144.0, 1120529256.0, 14887031544.0, 171200862756.0, 1731030945644.0, 15579278510796.0, 126050526132804.0, 924370524973896.0, 6186171974825304.0, 38000770702498296.0, 215337700647490344.0, 1130522928399324306.0, 5519611944537877494.0, 25144898858450330806.0, 107196674080761936594.0, 428786696323047746376.0, 1613054714739084379224.0, 5719012170438571889976.0, 19146258135816088501224.0, 60629817430084280253876.0, 181889452290252840761628.0, 517685364210719623706172.0, 1399667836569723427057428.0, 3599145865465003098147672.0, 8811701946483283447189128.0, 20560637875127661376774632.0, 45764000431735762419272568.0, 97248500917438495140954207.0, 197443926105102399225573693.0, 383273503615787010261407757.0, 711793649572175876199757263.0, 1265410932572757113244012912.0, 2154618614921181030658724688.0, 3515430371713505892127392912.0, 5498493658321124600506947888.0, 8247740487481686900760421832.0, 11868699725888281149874753368.0, 16390109145274293016493707032.0, 21726423750712434928840495368.0, 27651812046361280818524266832.0, 33796659167774898778196326128.0, 39674339023040098565708730672.0, 44739148260023940935799206928.0, 48467410615025936013782474172.0, 50445672272782096667406248628.0, 50445672272782096667406248628.0, 48467410615025936013782474172.0, 44739148260023940935799206928.0, 39674339023040098565708730672.0, 33796659167774898778196326128.0, 27651812046361280818524266832.0, 21726423750712434928840495368.0, 16390109145274293016493707032.0, 11868699725888281149874753368.0, 8247740487481686900760421832.0, 5498493658321124600506947888.0, 3515430371713505892127392912.0, 2154618614921181030658724688.0, 1265410932572757113244012912.0, 711793649572175876199757263.0, 383273503615787010261407757.0, 197443926105102399225573693.0, 97248500917438495140954207.0, 45764000431735762419272568.0, 20560637875127661376774632.0, 8811701946483283447189128.0, 3599145865465003098147672.0, 1399667836569723427057428.0, 517685364210719623706172.0, 181889452290252840761628.0, 60629817430084280253876.0, 19146258135816088501224.0, 5719012170438571889976.0, 1613054714739084379224.0, 428786696323047746376.0, 107196674080761936594.0, 25144898858450330806.0, 5519611944537877494.0, 1130522928399324306.0, 215337700647490344.0, 38000770702498296.0, 6186171974825304.0, 924370524973896.0, 126050526132804.0, 15579278510796.0, 1731030945644.0, 171200862756.0, 14887031544.0, 1120529256.0, 71523144.0, 3764376.0, 156849.0, 4851.0, 99.0, 1.0 }
};

#ifdef I_CHOOSE_K_GEN

define e(i, k) {
    auto c, j;

    c = 1;

    if (k / 2 > i) {
	for (j = k - i + 1; j <= k; j++) {
	    c = c * j;
	}
	for (j = 2; j <= i; j++) {
	    c = c / j;
	}
    }

    if (k / 2 <= i) {
	for (j = i + 1; j <= k; j++) {
	    c = c * j;
	}
	for (j = 2; j <= k - i; j++) {
	    c = c / j;
	}
    }
    return (c);
}

for (k = 0; k < 100; k++) {
    print "},\n    { ";
    for (i = 0; i <= k; i++) {
        print e(i, k), ".0, "
    }
}

#endif /* I_CHOOSE_K_GEN */

#else					      /* This is I choose K upto 28. */

GLOBAL_DATA CagdRType CagdIChooseKTable[CAGD_MAX_BEZIER_CACHE_ORDER + 1]
		                       [CAGD_MAX_BEZIER_CACHE_ORDER + 1] =
{
    { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 4, 6, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 5, 10, 10, 5, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 6, 15, 20, 15, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 7, 21, 35, 35, 21, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 8, 28, 56, 70, 56, 28, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 9, 36, 84, 126, 126, 84, 36, 9, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 10, 45, 120, 210, 252, 210, 120, 45, 10, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 11, 55, 165, 330, 462, 462, 330, 165, 55, 11, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 12, 66, 220, 495, 792, 924, 792, 495, 220, 66, 12, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 13, 78, 286, 715, 1287, 1716, 1716, 1287, 715, 286, 78, 13, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 14, 91, 364, 1001, 2002, 3003, 3432, 3003, 2002, 1001, 364, 91, 14, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 15, 105, 455, 1365, 3003, 5005, 6435, 6435, 5005, 3003, 1365, 455, 105, 15, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 16, 120, 560, 1820, 4368, 8008, 11440, 12870, 11440, 8008, 4368, 1820, 560, 120, 16, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 17, 136, 680, 2380, 6188, 12376, 19448, 24310, 24310, 19448, 12376, 6188, 2380, 680, 136, 17, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 18, 153, 816, 3060, 8568, 18564, 31824, 43758, 48620, 43758, 31824, 18564, 8568, 3060, 816, 153, 18, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 19, 171, 969, 3876, 11628, 27132, 50388, 75582, 92378, 92378, 75582, 50388, 27132, 11628, 3876, 969, 171, 19, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 20, 190, 1140, 4845, 15504, 38760, 77520, 125970, 167960, 184756, 167960, 125970, 77520, 38760, 15504, 4845, 1140, 190, 20, 1, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 21, 210, 1330, 5985, 20349, 54264, 116280, 203490, 293930, 352716, 352716, 293930, 203490, 116280, 54264, 20349, 5985, 1330, 210, 21, 1, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 22, 231, 1540, 7315, 26334, 74613, 170544, 319770, 497420, 646646, 705432, 646646, 497420, 319770, 170544, 74613, 26334, 7315, 1540, 231, 22, 1, 0, 0, 0, 0, 0, 0 },
    { 1, 23, 253, 1771, 8855, 33649, 100947, 245157, 490314, 817190, 1144066, 1352078, 1352078, 1144066, 817190, 490314, 245157, 100947, 33649, 8855, 1771, 253, 23, 1, 0, 0, 0, 0, 0 },
    { 1, 24, 276, 2024, 10626, 42504, 134596, 346104, 735471, 1307504, 1961256, 2496144, 2704156, 2496144, 1961256, 1307504, 735471, 346104, 134596, 42504, 10626, 2024, 276, 24, 1, 0, 0, 0, 0 },
    { 1, 25, 300, 2300, 12650, 53130, 177100, 480700, 1081575, 2042975, 3268760, 4457400, 5200300, 5200300, 4457400, 3268760, 2042975, 1081575, 480700, 177100, 53130, 12650, 2300, 300, 25, 1, 0, 0, 0 },
    { 1, 26, 325, 2600, 14950, 65780, 230230, 657800, 1562275, 3124550, 5311735, 7726160, 9657700, 10400600, 9657700, 7726160, 5311735, 3124550, 1562275, 657800, 230230, 65780, 14950, 2600, 325, 26, 1, 0, 0 },
    { 1, 27, 351, 2925, 17550, 80730, 296010, 888030, 2220075, 4686825, 8436285, 13037895, 17383860, 20058300, 20058300, 17383860, 13037895, 8436285, 4686825, 2220075, 888030, 296010, 80730, 17550, 2925, 351, 27, 1, 0 },
    { 1, 28, 378, 3276, 20475, 98280, 376740, 1184040, 3108105, 6906900, 13123110, 21474180, 30421755, 37442160, 40116600, 37442160, 30421755, 21474180, 13123110, 6906900, 3108105, 1184040, 376740, 98280, 20475, 3276, 378, 28, 1 }
};

#ifdef I_CHOOSE_K_GEN

/*****************************************************************************
* DESCRIPTION:                                                               *
* Evaluate the following (in integer arithmetic):			     *
*			 k         k!					     *
*			( ) = -------------				     *
*			 i    i! * (k - i)!				     *
*                                                                            *
* PARAMETERS:                                                                *
*   i, k:   Coefficients of i choose k.                                      *
*                                                                            *
* RETURN VALUE:                                                              *
*   int: Result of i choose k.                                               *
*****************************************************************************/
static int IChooseKGenOne(int i, int k)
{
    int j;
    long c = 1;

    if ((k >> 1) > i) {				/* i is less than half of k: */
	for (j = k - i + 1; j <= k; j++)
	    c *= j;
	for (j = 2; j <= i; j++)
	    c /= j;
    }
    else {
	for (j = i + 1; j <= k; j++)
	    c *= j;
	for (j = 2; j <= k - i; j++)
	    c /= j;
    }

    return (int) c;
}

/*****************************************************************************
* DESCRIPTION:                                                               *
* Evaluate the following (in real arithmetic):				     *
*			 k         k!					     *
*			( ) = -------------				     *
*			 i    i! * (k - i)!				     *
*                                                                            *
* PARAMETERS:                                                                *
*   i, k:   Coefficients of i choose k.                                      *
*                                                                            *
* RETURN VALUE:                                                              *
*   int: Result of i choose k.                                               *
*****************************************************************************/
static double IChooseKGenTwo(int i, int k)
{
    int j;
    double c = 1;

    if ((k >> 1) > i) {				/* i is less than half of k: */
	for (j = k - i + 1; j <= k; j++)
	    c *= j;
	for (j = 2; j <= i; j++)
	    c /= j;
    }
    else {
	for (j = i + 1; j <= k; j++)
	    c *= j;
	for (j = 2; j <= k - i; j++)
	    c /= j;
    }

    return c;
}

/*****************************************************************************
* DESCRIPTION:                                                               *
* Evaluates IChooseK for all possibilities and prints them for the	     *
* CagdIChooseKTable table defined in the beginning of this file.	     *
*                                                                            *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
void IChooseKGen(void)
{
    int i, j;

    for (i = 0; i <= CAGD_MAX_BEZIER_CACHE_ORDER; i++) {
	printf("},\n    { ");
	for (j = 0; j <= CAGD_MAX_BEZIER_CACHE_ORDER; j++) {
	    printf("%ld, ", j <= i ? IChooseKGenOne(j ,i) : 0);
	    fprintf(stderr, IRIT_EXP_STR("%d choose %d - diff = %f\n"), i, j,
		    IChooseKGenTwo(j ,i) - IChooseKGenOne(j ,i));
	}
    }
}

/*****************************************************************************
* DESCRIPTION:                                                               *
* Main routine to create the table in the beginning of this file.	     *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
void main(void)
{
    IChooseKGen();
}

#endif /* I_CHOOSE_K_GEN */

#endif /* CAGD_LARGE_BEZIER_CACHE */
