/******************************************************************************
* Cagd_loc.h - header file for the CAGD library.			      *
* This header is local to the library - it is NOT external.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#ifndef CAGD_LOC_H
#define CAGD_LOC_H

#include <math.h>

#define W 0	 /* Positions of points in Points array (see structs below). */
#define X 1
#define Y 2
#define Z 3

#define CAGD_MAX_FINENESS	     10000

//#define CAGD_CACHE_CRV_SRF_ALLOC	1
#define CAGD_CACHE_CRV_MAX_LEN		100
#define CAGD_CACHE_SRF_MAX_LEN		30

#include "iritprsr.h"
#include "cagd_lib.h"		     /* Include the extrenal header as well. */

typedef struct CagdSrfEvalCashStruct {
    CagdCrvStruct *IsoSubCrv;
} CagdSrfEvalCashStruct;

/* Declaration of extrenal variables local to the cagd library only. */
extern GLOBAL_DATA CagdLin2PolyType _CagdLin2Poly;/* Lin srf conv. to polys. */
extern GLOBAL_DATA int _CagdSrf2PolygonStrips;  /* Should build poly strips? */
extern GLOBAL_DATA int _CagdSrf2PolygonFast;		   /* Fast/approx.?. */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Declarations of functions local to the Cagd library only. */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* CAGD_LOC_H */
