/******************************************************************************
* Cagd_dbg.c - Provide a routine to print Surface/Curve objects to stderr.    *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Sep. 91.					      *
******************************************************************************/

#include "cagd_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Prints curves and surfaces to stderr.	Should be linked to programs for     M
* debugging purposes, so curves and surfaces may be inspected from the       M
* debugger.                                                                  M
*                                                                            *
* PARAMETERS:                                                                M
*   Obj:       Either a curve or a surface - to be printed to stderr.        M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   CagdDbg, debugging                                                       M
*****************************************************************************/
void CagdDbg(void *Obj)
{
    char *ErrorMsg;
    CagdCrvStruct
	*Crv = (CagdCrvStruct *) Obj;
    CagdSrfStruct
	*Srf = (CagdSrfStruct *) Obj;
    CagdGeomType 
	GType = Crv -> GType;

    switch (GType) {
	case CAGD_CBEZIER_TYPE:
	case CAGD_CBSPLINE_TYPE:
	case CAGD_CPOWER_TYPE:
	    CagdCrvWriteToFile3(Crv, stderr, 0, IRIT_EXP_STR("CagdDbg"),
				&ErrorMsg);
	    break;
	case CAGD_SBEZIER_TYPE:
	case CAGD_SBSPLINE_TYPE:
	case CAGD_SPOWER_TYPE:
	    CagdSrfWriteToFile3(Srf, stderr, 0, IRIT_EXP_STR("CagdDbg"),
				&ErrorMsg);
	    break;
	case CAGD_UNDEF_TYPE:
	    break;
    }

    if (ErrorMsg)
	fprintf(stderr, IRIT_EXP_STR("CagdDbg Error: %s\n"), ErrorMsg);
}
