# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libtokyocabinet.

FIND_PATH(TOKYOCABINET_INCLUDE_DIR tcutil.h tcbdb.h)

SET(TOKYOCABINET_NAMES ${TOKYOCABINET_NAMES} tokyocabinet libtokyocabinet)
FIND_LIBRARY(TOKYOCABINET_LIBRARY NAMES ${TOKYOCABINET_NAMES} PATH)

IF(TOKYOCABINET_INCLUDE_DIR AND TOKYOCABINET_LIBRARY)
	SET(TOKYOCABINET_FOUND TRUE)
ENDIF(TOKYOCABINET_INCLUDE_DIR AND TOKYOCABINET_LIBRARY)

IF(TOKYOCABINET_FOUND)
	IF(NOT TokyoCabinet_FIND_QUIETLY)
		MESSAGE(STATUS "Found TokyoCabinet: ${TOKYOCABINET_LIBRARY}")
	ENDIF (NOT TokyoCabinet_FIND_QUIETLY)
ELSE(TOKYOCABINET_FOUND)
	IF(TokyoCabinet_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find tokyocabinet")
	ENDIF(TokyoCabinet_FIND_REQUIRED)
ENDIF (TOKYOCABINET_FOUND)
