# - Try to find the sqlite library
# Once done this will define
#
#  SQLITE_FOUND - system has sqlite
#  SQLITE_INCLUDE_DIRS - the sqlite include directory
#  SQLITE_LIBRARIES - Link these to use sqlite
#
# Define SQLITE_MIN_VERSION for which version desired.
#

INCLUDE(FindPkgConfig)

IF(Sqlite_FIND_REQUIRED)
	SET(_pkgconfig_REQUIRED "REQUIRED")
ELSE(Sqlite_FIND_REQUIRED)
	SET(_pkgconfig_REQUIRED "")
ENDIF(Sqlite_FIND_REQUIRED)

IF(SQLITE_MIN_VERSION)
	PKG_SEARCH_MODULE(SQLITE ${_pkgconfig_REQUIRED} sqlite>=${SQLITE_MIN_VERSION} sqlite${SQLITE_MIN_VERSION})
ELSE(SQLITE_MIN_VERSION)
	PKG_SEARCH_MODULE(SQLITE ${_pkgconfig_REQUIRED} sqlite)
ENDIF(SQLITE_MIN_VERSION)

IF(NOT SQLITE_FOUND AND NOT PKG_CONFIG_FOUND)
	FIND_PATH(SQLITE_INCLUDE_DIRS sqlite${SQLITE_MIN_VERSION}.h)
	FIND_LIBRARY(SQLITE_LIBRARIES sqlite${SQLITE_MIN_VERSION})

	# Report results
	IF(SQLITE_LIBRARIES AND SQLITE_INCLUDE_DIRS)
		SET(SQLITE_FOUND 1)
		IF(NOT Sqlite_FIND_QUIETLY)
			MESSAGE(STATUS "Found Sqlite: ${SQLITE_LIBRARIES}")
		ENDIF(NOT Sqlite_FIND_QUIETLY)
	ELSE(SQLITE_LIBRARIES AND SQLITE_INCLUDE_DIRS)	
		IF(Sqlite_FIND_REQUIRED)
			MESSAGE(SEND_ERROR "Could not find Sqlite")
		ELSE(Sqlite_FIND_REQUIRED)
			IF(NOT Sqlite_FIND_QUIETLY)
				MESSAGE(STATUS "Could not find Sqlite")	
			ENDIF(NOT Sqlite_FIND_QUIETLY)
		ENDIF(Sqlite_FIND_REQUIRED)
	ENDIF(SQLITE_LIBRARIES AND SQLITE_INCLUDE_DIRS)
ENDIF(NOT SQLITE_FOUND AND NOT PKG_CONFIG_FOUND)

# Hide advanced variables from CMake GUIs
MARK_AS_ADVANCED(SQLITE_LIBRARIES SQLITE_INCLUDE_DIRS)

