//
// Widget2.h:
//
// Trivial "Widget" class wrapping an int value.
// Methods:
//		a c'tor (value defaults to 0),
//		== and != operators,
//		inserter/extractor using format: "(val)"
//				(for testing InitUtil.h)
//		draw()
//

#if !defined(__WIDGET_H)
#define __WIDGET_H

#include <iostream>

class Widget {
public:
	Widget(int i = 0) : val(i) {}
	void draw(double ScaleFactor = 1) const;
	friend std::ostream &operator<<(std::ostream &, const Widget &);
	friend std::istream &operator>>(std::istream &, Widget &);
	friend bool operator!=(const Widget &, const Widget &);
	friend bool operator==(const Widget &, const Widget &);
private:
	int val;
};

void Widget::draw(double ScaleFactor) const
{
	std::cout << "Drawing widget (" << val << ") using ScaleFactor " <<
			ScaleFactor << "..." << std::endl;
}

inline bool operator!=(const Widget &w1, const Widget &w2)
{
	return (w1.val != w2.val);
}

inline bool operator==(const Widget &w1, const Widget &w2)
{
	return (w1.val == w2.val);
}


inline std::ostream &operator<<(std::ostream &o, const Widget &w)
{
	return o << '(' << w.val << ')';
}

inline std::istream &operator>>(std::istream &o, Widget &w)
{
	char c;
	return o >> c >> w.val >> c;
}

// End Widget2.h

#endif
