//
// Test Driver for the InitUtil.h v2 template library
// This (so far) compiles with:
//	MSVC 7.1 Native lib (must use /Za option!) and Dinkum Unabridged Lib. (no /Za)
//	Comeau 4.3 (libcomo or Dinkumware Unabridged Lib)
//  gcc 3.2
//  Intel C++ 7/8 (but only with HASHED_CONTAINERS_SUPPORTED set to 0)
//

#define HASHED_CONTAINERS_SUPPORTED 1			// 0 if not supported, 1 if supported
												// (if not defined, InitUtil.h defaults to 1)

#include <iostream>
#include <string>
#include <vector>
#include <deque>
#include <list>
#include <set>
#include <map>
#include <fstream>
#include <iterator>
#include <cstddef>

#if HASHED_CONTAINERS_SUPPORTED
				// Figure out the right namespace name for hashed containers:
#	include <hash_set>
#	include <hash_map>
#	if defined(__GNUC__) && (__GNUC__ == 3)
#		define HASH_NS __gnu_cxx
		namespace __gnu_cxx
		{
			template<> struct hash<std::string>
			{
				std::size_t operator()(const std::string& s) const
				{
					return hash<char const*>()(s.c_str());
				}
			};
		}
#	elif defined(__MWERKS__)
#		define HASH_NS Metrowerks
#	elif defined(_MSC_VER) && (_MSC_VER >= 1310)
#		if defined(_C99)
#			define HASH_NS std
#		else
#			define HASH_NS stdext
#		endif
#	else
#		define HASH_NS std
#	endif
#endif		// HASHED_CONTAINERS_SUPPORTED


#include "InitUtil.h"
#include "ESTLUtil.h"
#include "widget2.h"

int main()
{
	using namespace std;
	using namespace ESTLUtils;	// for show() macro and printContainer templates
	using namespace bds;

	Timer t;
	
	{
	vector<int> vi = make_cont("1,2,3,4,5");
	show(vi);
	vector<string> vs = make_cont("these,are,strings");
	show(vs);
	vector<string> vs2 = make_cont("   these,  are ,  strings   ", false);
	show(vs2);
	}

	{
	vector<int> v = make_cont(10);
	vector<int> v2 = make_cont(10, 5);
	vector<int> v3 = make_cont(10, 5, 3);
	
	show(v);
	show(v2);
	show(v3);
	cout << endl;
	}

	{
	vector<int> v = make_cont(10);
	vector<int> v2 = make_cont(10, 5);
	vector<int> v3 = make_cont(10);
	
	show(v);
	show(v2);
	show(v3);
	cout << endl;

	set_cont(v, 50);
	show(v);
	
	set_cont(v, 5, 50);
	show(v);

	set_cont(v, "100,200,300,-400,500,-600,-700");
	show(v);
	cout << endl;
	}

	{
	cout << endl;
	vector<double> v = make_cont(10);
	vector<double> v2 = make_cont(10, 3);
	vector<double> v3 = make_cont(10, 3, .5);
	
	show(v);
	show(v2);
	show(v3);

	set_cont(v3, 5);
	show(v3);

	set_cont(v3, 5, .1);
	show(v3);
	cout << endl;
	}

	{
	vector<double> v = make_cont(10);
	vector<double> v2 = make_cont(10, 3);
	vector<double> v3 = make_cont(10, 3, .5);

	show(v);
	show(v2);
	show(v3);

	cout << endl;

	}

	{
	cout << endl;
	vector<double> v = make_cont("1.2, 3.4, 9.9, -10.5e10");
	vector<double> v2 = make_cont("-20.5, 100.7, 34");

	show(v);
	show(v2);

	cout << endl;

	vector<string> vs = make_cont("       this , is , a, test , of this , new, thing ");
	vector<string> vs2 = make_cont("      this , is , a, test , of this , new, thing ", false);
	ostream_iterator<string> os(cout, "+");

	cout << "vs: ";
	copy(vs.begin(), vs.end(), os);
	cout << endl;

	cout << "vs2: ";
	copy(vs2.begin(), vs2.end(), os);
	cout << endl;

	set_cont(vs, "here, are, another, bunch, of, strings, for, the, new, vs");
	cout << "vs after reassigning: ";
	copy(vs.begin(), vs.end(), os);
	cout << endl;
	
	cout << "Timer value: " << t << endl;

	vector<Widget> vw = make_cont("(77),(78),(79)");
	show(vw);

	set<int> si = make_cont("1:2:3:4:500:600:700",true,':');
	show(si);

	multiset<int> mi = make_cont("1,2,2,3,3,4,4,5,6,7,9,9,0,1");
	show(mi);

	deque<char> dc = make_cont("a,b,c,d,e,f,g,h,i,j,k,L,M,0,1,2");
	show(dc);
	}
	
	{
	cout << endl;
	int i = 10, j = 20, k = 30;
	vector<int *> v = make_cont_p(v, &i, &j, &k, NULL);
	show(v);
	vector<int *> v2 = make_cont_p<vector<int *> >(&i, &j, &k, NULL);
	show(v2);
	set_cont_p(v2, &k, &j, &i, NULL);
	show(v2);
	}
	
	{
	list<string> ls = make_cont("this, is, a, list, of, strings");
	show(ls);
	}



	{
	map<string,int> mtest;
	mtest.insert(make_pair(string("leor"), 10));
	mtest.insert(make_pair(string("lisa"), 100));
	mtest.insert(make_pair(string("ray"), 1000));
	mtest.insert(make_pair(string("katie"), 10000));
	show(mtest);
	
	map<string, int> msi = make_cont("(leor, 10), (lisa, 20), (ray, 30), (katie, 40)");
	show(msi);
	app_cont(msi, "(john, 100), (joe, 200)", true, ',');
	show(msi);

	multimap<string, int> mmsi = make_cont("(leor, 10), (leor, 20), (ray, 30), (katie, 40)");
	show(mmsi);

#if HASHED_CONTAINERS_SUPPORTED
	// Note: This fails to compile under gcc 3.2 due to platform-specific bugs 
	HASH_NS::hash_set<int> si = make_cont("1:2:3:4:500:600:700",true,':');
	show(si);

	HASH_NS::hash_set<string> hsi0 = make_cont("these,are,strings,in,a,hash,set", false, ',');
	show(hsi0);

	HASH_NS::hash_set<string> hsi = make_cont("these,are,strings,in,a,hash,set");
	show(hsi);

	HASH_NS::hash_map<string, int> hmsi =
			make_cont("(this, 10), (is, 20), (a, 30), (hash_map, 40)");
	show(hmsi);

	HASH_NS::hash_multimap<string, int> hmmsi =
			make_cont("(this, 10), (is, 20), (a, 30), (hash_map, 40)");
	show(hmmsi);

#endif		// HASHED_CONTAINERS_SUPPORTED
	}
	cout << "\nTotal Run time: " << t << endl;
	return 0;

}
