<?php
/**
 * Creates a form styled by a table
 *
 * @copyright	http://www.xoops.org/ The XOOPS Project
 * @copyright	XOOPS_copyrights.txt
 * @copyright	http://www.impresscms.org/ The ImpressCMS Project
 * @license	LICENSE.txt
 * @package	XoopsForms
 * @since	XOOPS
 * @author	http://www.xoops.org The XOOPS Project
 * @author	modified by UnderDog <underdog@impresscms.org>
 * @version	$Id: tableform.php 10749 2010-11-04 03:57:45Z skenow $
 */

defined('ICMS_ROOT_PATH') or die('ImpressCMS root path not defined');

/**
 *
 *
 * @package     kernel
 * @subpackage  form
 *
 * @author	    Kazumi Ono	<onokazu@xoops.org>
 * @copyright	copyright (c) 2000-2003 XOOPS.org
 */

/**
 * Form that will output formatted as a HTML table
 *
 * No styles and no JavaScript to check for required fields.
 *
 * @author	Kazumi Ono	<onokazu@xoops.org>
 * @copyright	copyright (c) 2000-2003 XOOPS.org
 *
 * @package     kernel
 * @subpackage  form
 */
class XoopsTableForm extends icms_form_Table {
	private $_deprecated;
	public function __construct($title, $name, $action, $method = "post", $addtoken = false) {
		parent::__construct($title, $name, $action, $method, $addtoken);
		$this->_deprecated = icms_core_Debug::setDeprecated('icms_form_Table', sprintf(_CORE_REMOVE_IN_VERSION, '1.4'));
	}
}

?>