#------------------------------------------------------------------------------
#    I  M  P  A  C  T     I  N  P  U  T     D  A  T  A     D  E  C  K
#------------------------------------------------------------------------------
#
#    Generated by GiD to Impact Interface Module 
#
#    Version 05.05.2011
#
#------------------------------------------------------------------------------
#    D A T A  F O R M A T:      Fembic I M P A C T
#                                                       
#    developed by:
#    http://impact.sourceforge.net 
#    Impact is an open source FEA program
#------------------------------------------------------------------------------
#    P R E P R O C E S S O R:   G i D
#           
#    developed by:
#    International Center for Numerical Methods in Engineering
#    Campus Norte UPC; Gran Capitan s/n
#    08034 Barcelona, Spain
#    http://www.gid.cimne.com
#------------------------------------------------------------------------------    
#    T I T L E  : *GenData(TITLE) / *GenData(SUBTITLE)
#    USER     : *GenData(USER)
#    DATE     : *GenData(DATE)
#------------------------------------------------------------------------------
#    Dimension of Analysis Model            : *ndime
#
#    Total Number of Elements               : *nelem
#
#    Total Number of Grid Points            : *npoin
#
#    Total Number of different Materials: *nmats
#
#    (contant line/contact element/spring element will be accounted as Materials)
#-------------------------------------------------------------------------------
*Set var linNum=0
*Set var triaNum=0
*Set var quadNum=0
*Set var hexaNum=0
*Set var spcInit=0
*Set var beenthere=0

#-------------------------------------------------------------------
#    ANALYSIS RUN TIME CONTROL
#-------------------------------------------------------------------
CONTROLS
*if(GenData(START_TIME,real)>=0. && GenData(STEP_SIZE,real)>0.)
*format "run from %10.5f to %10.5f step %9.6f"
*GenData(START_TIME,real)*GenData(END_TIME,real)*GenData(STEP_SIZE,real)
*else
*format "run from %10.5f to %10.5f"
*GenData(START_TIME,real)*GenData(END_TIME,real)
*endif
*if(GenData(STEP_PRINT_OUTPUT,real)>0.)
*format "print every %9.6f step"
*GenData(STEP_PRINT_OUTPUT,real)
*else
*messagebox ERROR: The print interval must be set positive
*endif
*if(GenData(STEP_PRINT_TRACKER_OUTPUT,real)>0.)
*format "print tracker every %9.6f step"
*GenData(STEP_PRINT_TRACKER_OUTPUT,real)
*else
*messagebox ERROR: The tracker print interval must be set positive
*endif
*if(strcmp(GenData(SAVE_PROCESS),"PREVIOUS")==0)
restore save previous
*endif
*if(strcmp(GenData(SAVE_PROCESS),"ALL")==0)
restore save all
*endif


#-------------------------------------------------------------------
#    ANALYSIS MODEL MATERIAL CONFIGURATION
#-------------------------------------------------------------------
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTIC")==0)
*if(t==0)

MATERIALS OF TYPE ELASTIC
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTIC")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)
*endif
*end materials
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTO-PLASTIC")==0)
*if(t==0)

MATERIALS OF TYPE ELASTOPLASTIC
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTO-PLASTIC")==0)
*if(strcmp(matprop(FAILURE),"OFF")==0)
*format "mat_%li E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f EP = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(HARDENING_FACTOR,real)
*endif
*if(strcmp(matprop(FAILURE),"FAILURE_STRAIN")==0)
*format "mat_%li E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f EP = %6.2f FAILURE_STRAIN = %6.2f"
*matnum*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(HARDENING_FACTOR,real)*matprop(FAILURE_STRAIN,real)
*endif
*if(strcmp(matprop(FAILURE),"FAILURE_STRESS")==0) 
*format "mat_%li E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f EP = %6.2f FAILURE_STRESS = %6.2f"
*matnum(),matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(HARDENING_FACTOR,real)*matprop(FAILURE_STRESS,real)
*endif
*if(strcmp(matprop(FAILURE),"FAILURE_BOTH")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f EP = %6.2f FAILURE_STRAIN = %6.2f FAILURE_STRESS = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(HARDENING_FACTOR,real)*matprop(FAILURE_STRAIN,real)*matprop(FAILURE_STRESS,real)
*endif
*endif
*end materials
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"THERMO-ELASTO-PLASTIC")==0)
*if(t==0)

MATERIALS OF TYPE THERMOELASTOPLASTIC
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"THERMO-ELASTO-PLASTIC")==0)
*if(strcmp(matprop(FAILURE),"OFF")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f T= %6.3f A= %10.7f EP = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(TEMPERATURE,real)*matprop(COEFF_OF_EXPANSION,real)*matprop(HARDENING_FACTOR,real)
*endif
*if(strcmp(matprop(FAILURE),"FAILURE_STRAIN")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f T= %6.3f A= %10.7f EP = %6.2f FAILURE_STRAIN = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(TEMPERATURE,real)*matprop(COEFF_OF_EXPANSION,real)*matprop(HARDENING_FACTOR,real)*matprop(FAILURE_STRAIN,real)
*endif
*if(strcmp(matprop(FAILURE),"FAILURE_STRESS")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f T= %6.3f A= %10.7f EP = %6.2f FAILURE_STRESS = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(TEMPERATURE,real)*matprop(COEFF_OF_EXPANSION,real)*matprop(HARDENING_FACTOR,real)*matprop(FAILURE_STRESS,real)
*endif
*if(strcmp(matprop(FAILURE),"FAILURE_BOTH")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f T= %6.3f A= %10.7f EP = %6.2f FAILURE_STRAIN = %6.2f FAILURE_STRESS = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(TEMPERATURE,real)*matprop(COEFF_OF_EXPANSION,real)*matprop(HARDENING_FACTOR,real)*matprop(FAILURE_STRAIN,real)*matprop(FAILURE_STRESS,real)
*endif
*endif
*end materials
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"SPRING")==0)
*if(t==0)

MATERIALS OF TYPE SPRING
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"SPRING")==0)
*format "mat_%1i KX = %10.5f KY = %10.5f KZ = %10.5f KRX = %10.5f KRY = %10.5f KRZ = %10.5f CX = %10.5f CY = %10.5f CZ = %10.5f CRX = %10.5f CRY = %10.5f CRZ = %10.5f"
*matnum()*matprop(KX,real)*matprop(KY,real)*matprop(KZ,real)*matprop(KRX,real)*matprop(KRY,real)*matprop(KRZ,real)*matprop(CX,real)*matprop(CY,real)*matprop(CZ,real)*matprop(CRX,real)*matprop(CRY,real)*matprop(CRZ,real)
*endif
*end materials

#-------------------------------------------------------------------
#    ANALYSIS MODEL NODAL POINT CONFIGURATION
#-------------------------------------------------------------------
NODES
*Set cond Boundary_Condition_P *nodes *or(2,int)
*Add cond Boundary_Condition_L *nodes *or(2,int)
*Add cond Boundary_Condition_S *nodes *or(2,int)
*Add cond Rigid_Body_P *nodes *or(2,int)
*Add cond Rigid_Body_L *nodes *or(2,int)
*Add cond Rigid_Body_S *nodes *or(2,int)
*Add cond Force_Load *nodes *or(1,int)
*Add cond Reserved(Not-available) *nodes *or(1,int) *or(2,int)
*loop nodes
*format "%8i  x = %15.8f  y = %15.8f  z = %15.8f"
*NodesNum*NodesCoord(1)*NodesCoord(2)*NodesCoord(3) *\
*if(cond(1,int) > 0)
*format "%1i"
constraint = Constr_*cond(1,int) *\
*endif
*if(cond(2,int) > 0)
*format "%1i"
load = Load_*cond(2,int)
*else

*endif
*end nodes

#-------------------------------------------------------------------
#    ANALYSIS MODEL ROD ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var linNum=0
*Set elems(linear)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"CONTACT_ONLY")!=0)
*if(strcmp(matprop(PROPERTY),"SPRING")!=0)
*Set var linNum=1
*endif
*endif
*endif
*end materials
*endif
*end elems
*if(linNum>0)
ELEMENTS OF TYPE Rod_2
*Set cond Pressure_Load
*Add cond Reserved(Not-available)
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Rod elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"CONTACT_ONLY")!=0)
*if(strcmp(matprop(PROPERTY),"SPRING")!=0)
*Set var thick=matprop(THICKNESS/DIAMETER,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(INTEGRATIONPOINTS,int)
*format "%8i nodes = [%1i,%1i] D = %6.3f material = mat_%1i"
*ElemsNum*ElemsConec*thick*matset *\
*if(strcmp(matprop(CONTACT_TYPE),"OFF")==0)
factor = *matprop(CONTACT_FACTOR) *\
*endif
*if(strcmp(matprop(CONTACT_TYPE),"BASIC")==0)
factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*endif
*if(strcmp(matprop(CONTACT_TYPE),"ADVANCED")==0)
*messagebox - ERROR: Rod elements only allows OFF or BASIC contact functions
*endif
*if(strcmp(matprop(CONTACT_TYPE),"ADVANCED_EDGE")==0)
*messagebox - ERROR: Rod elements only allows OFF or BASIC contact functions
*endif
*if(strcmp(matprop(CONTACT_TYPE),"EDGE")==0)
*messagebox - ERROR: Rod elements only allows OFF or BASIC contact functions
*endif

*endif
*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL SPRING ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var linNum=0
*Set elems(linear)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"SPRING")==0)
*Set var linNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(linNum>0)
ELEMENTS OF TYPE Beam_Spring_2
*Set cond Pressure_Load
*Add cond Reserved(Not-available)
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Spring elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"SPRING")==0)
*Set var matset=ElemsMat
*format "%8i nodes = [%1i,%1i] material = mat_%1i"
*ElemsNum*ElemsConec*matset *\
*if(strcmp(matprop(15),"BASIC")==0)
factor = *matprop(CONTACT_FACTOR) *\
*endif

*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL CONTACT LINE ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var linNum=0
*Set elems(linear)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"CONTACT_ONLY")==0)
*Set var linNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(linNum>0)
ELEMENTS OF TYPE Contact_Line
*Set cond Pressure_Load
*Add cond Reserved(Not-available)
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Rod elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"CONTACT_ONLY")==0)
*Set var diam=matprop(DIAMETER,real)
*format "%8i nodes = [%1i,%1i] D = %6.3f "
*ElemsNum*ElemsConec*diam *\
*if(strcmp(matprop(CONTACT_TYPE),"OFF")==0)
contact = matprop(CONTACT_TYPE) *\
*endif
*if(strcmp(matprop(CONTACT_TYPE),"BASIC")==0)
factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*endif

*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL TRIANGULAR ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set elems(triangle)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var triaNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(triaNum>0)
ELEMENTS OF TYPE shell_C0_3
*Set cond Pressure_Load
*Add cond Reserved(Not-available)
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Triangular shell elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var thick=matprop(THICKNESS/DIAMETER,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(INTEGRATIONPOINTS,int)
*format "%8i nodes = [%1i,%1i,%1i] nip = %1i t = %6.3f material = mat_%1i"
*ElemsNum*ElemsConec*intpoint*thick*matset *\
*if(strcmp(matprop(CONTACT_TYPE),"OFF")==0)
contact = *matprop(CONTACT_TYPE) *\
*end if
*if(strcmp(matprop(CONTACT_TYPE),"BASIC")==0)
factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*end if
*if(strcmp(matprop(CONTACT_TYPE),"EDGE")==0)
contact = *matprop(CONTACT_TYPE) factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*end if
*if(strcmp(matprop(CONTACT_TYPE),"ADVANCED")==0)
*messagebox - ERROR: Triangle elements only allows OFF, BASIC or EDGE contact functions
*endif
*if(strcmp(matprop(CONTACT_TYPE),"ADVANCED_EDGE")==0)
*messagebox - ERROR: Triangle elements only allows OFF, BASIC or EDGE contact functions
*endif
*if(Cond(2,int)>0)
*format "load = Load_%1i"
*Cond(2,int)
*else

*endif
*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL CONTACT TRIANGLE ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var triaNum=0
*Set elems(triangle)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")==0)
*Set var triaNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(triaNum>0)
ELEMENTS OF TYPE contact_triangle
*Set cond Pressure_Load
*Add cond Reserved(Not-available)
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No contact_only materials defined for the Contact Triangle elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")==0)
*Set var thick=matprop(THICKNESS,real)
*format "%8i nodes = [%1i,%1i,%1i] t = %6.3f"
*ElemsNum*ElemsConec*thick  *\
*if(strcmp(matprop(CONTACT_TYPE),"BASIC")==0)
factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*endif

*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL QUADRILATERAL ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set elems(quadrilateral)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var quadNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(quadNum>0)
ELEMENTS OF TYPE shell_BT_4
*Set cond Pressure_Load
*Add cond Reserved(Not-available)
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Quad shell elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(PROPERTY),"CONTACT_ONLY")!=0)
*Set var thick=matprop(THICKNESS/DIAMETER,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(INTEGRATIONPOINTS,int)
*if(strcmp(GenData(HOURGLASS_CONTROL),"YES")==0)
*format "%8i nodes = [%1i,%1i,%1i,%1i] nip = %1i t = %6.3f material = mat_%1i shear_factor = %4.3f mhc = %4.3f oophc = %4.3f rhc = %4.3f"
*ElemsNum*ElemsConec*intpoint*thick*matset*GenData(SHEAR_FACTOR,real)*GenData(MEMBRANE_HGLASS,real)*GenData(OUT_OF_PLANE_HGLASS,real)*GenData(ROTATIONAL_HGLASS,real) *\
*else
*format "%8i nodes = [%1i,%1i,%1i,%1i] nip = %1i t = %6.3f material = mat_%1i shear_factor = %4.3f hourglass = off"
*ElemsNum*ElemsConec*intpoint*thick*matset*GenData(SHEAR_FACTOR,real) *\
*endif
*if(strcmp(matprop(CONTACT_TYPE),"OFF")==0)
contact = *matprop(CONTACT_TYPE) *\
*endif
*if(strcmp(matprop(CONTACT_TYPE),"BASIC")==0)
factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*endif
*if(strcmp(matprop(CONTACT_TYPE),"BASIC")!=0)
*if(strcmp(matprop(CONTACT_TYPE),"OFF")!=0)
contact = *matprop(CONTACT_TYPE) factor = *matprop(CONTACT_FACTOR) friction = *matprop(CONTACT_FRICTION) *\
*endif
*endif
*if(Cond(2,int)>0)
*format "load = Load_%1i"
*Cond(2,int)
*else

*endif
*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL HEXAHEDRONAL ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set elems(hexahedra)
*loop elems
*if(ElemsNum>0)
*Set var hexaNum=1
*endif
*end elems
*if(hexaNum>0)
ELEMENTS OF TYPE solid_iso_6
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*Set var matset=ElemsMat
*Set var intpoint=matprop(INTEGRATIONPOINTS,int)
*if(intpoint>1)
*Set var intpoint=8
*endif
*endif
*end materials
*format "%8i nodes = [%1i,%1i,%1i,%1i,%1i,%1i,%1i,%1i] nip = %1i material = mat_%1i"
*ElemsNum*ElemsConec*intpoint*matset
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL TETRAHEDRONAL ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set elems(tetrahedra)
*loop elems
*if(ElemsNum>0)
*Set var hexaNum=1
*endif
*end elems
*if(hexaNum>0)
ELEMENTS OF TYPE solid_iso_4
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*Set var matset=ElemsMat
*Set var intpoint=matprop(INTEGRATIONPOINTS,int)
*if(intpoint>1)
*Set var intpoint=1
*endif
*endif
*end materials
*format "%8i nodes = [%1i,%1i,%1i,%1i] nip = %1i material = mat_%1i"
*ElemsNum*ElemsConec*intpoint*matset
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL BOUNDARY CONDITIONS
#-------------------------------------------------------------------
*Set cond Boundary_Condition_P *nodes
*Add cond Boundary_Condition_L *nodes
*Add cond Boundary_Condition_S *nodes
*for(i=1;i<10;i=i+1)
*set var beenhere=0
*if(i!=1)
*set var beenhere=1
*endif
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
*if(beenhere==0)
CONSTRAINTS OF TYPE Boundary_Condition
*set var beenhere=1
*end if
*endif
*end nodes
*end for
*Set cond Boundary_Condition_P *nodes
*Add cond Boundary_Condition_L *nodes
*Add cond Boundary_Condition_S *nodes
*for(i=1;i<10;i=i+1)
*set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i"
Constr_*Cond(1,int) *\
*if(strcmp(Cond(4),"OFF")!=0)
ax = *Cond(4) *\
*endif
*if(strcmp(Cond(5),"OFF")!=0)
ay = *Cond(5) *\
*endif
*if(strcmp(Cond(6),"OFF")!=0)
az = *Cond(6) *\
*endif
*if(strcmp(Cond(7),"OFF")!=0)
vx = *Cond(7) *\
*endif
*if(strcmp(Cond(8),"OFF")!=0)
vy = *Cond(8) *\
*endif
*if(strcmp(Cond(9),"OFF")!=0)
vz = *Cond(9) *\
*endif
*if(strcmp(Cond(10),"OFF")!=0)
arx = *Cond(10) *\
*endif
*if(strcmp(Cond(11),"OFF")!=0)
ary = *Cond(11) *\
*endif
*if(strcmp(Cond(12),"OFF")!=0)
arz = *Cond(12) *\
*endif
*if(strcmp(Cond(13),"OFF")!=0)
vrx = *Cond(13) *\
*endif
*if(strcmp(Cond(14),"OFF")!=0)
vry = *Cond(14) *\
*endif
*if(strcmp(Cond(15),"OFF")!=0)
vrz = *Cond(15) *\
*endif

*endif
*endif
*end nodes
*end for

*Set cond Rigid_Body_P *nodes
*Add cond Rigid_Body_L *nodes
*Add cond Rigid_Body_S *nodes
*for(i=51;i<80;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
*if(beenthere==0)
*set var beenthere=1

*endif
*endif
*end nodes
*end for
*Set cond Rigid_Body_P *nodes
*Add cond Rigid_Body_L *nodes
*Add cond Rigid_Body_S *nodes
*for(i=51;i<80;i=i+1)
*Set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
*if(beenthere==0)
*set var beenthere=1

CONSTRAINTS OF TYPE Rigid_Body
*set var newmaster=9999900+Cond(1,int)
*format "%1i master_node = %1i"
Constr_*Cond(1,int)*newmaster *\
*if(strcmp(Cond(Update-Node-COG),"OFF")==0)
*set var xcord=Cond(X-COORD,real)
*set var ycord=Cond(Y-COORD,real)
*set var zcord=Cond(Z-COORD,real)


*if(strcmp(cond(Master-Node-Force),"ON")== 0)
NODES
*format "%8i x = %15.8f y = %15.8f z = %15.8f"
*newmaster*xcord*ycord*zcord  *\
constraint = Constr_*newmaster load = load_*newmaster *\
*if(strcmp(cond(Master-Node-Mass),"ON")== 0)
M = *Cond(MasterNode-Mass)
*endif

*if(strcmp(cond(Master-Node-Constraint),"OFF")== 0)

CONSTRAINTS OF TYPE Boundary_Condition
Constr_*newmaster *\

*endif
*if(strcmp(cond(Master-Node-Constraint),"ON")== 0)

CONSTRAINTS OF TYPE Boundary_Condition
Constr_*newmaster *\
*if(strcmp(Cond(A-X),"OFF")!=0)
*if(strcmp(Cond(A-X),"off")!=0)
ax = *Cond(A-X) *\
*endif
*endif
*if(strcmp(Cond(A-Y),"OFF")!=0)
*if(strcmp(Cond(A-Y),"off")!=0)
ay = *Cond(A-Y) *\
*endif
*endif
*if(strcmp(Cond(A-Z),"OFF")!=0)
*if(strcmp(Cond(A-Z),"off")!=0)
az = *Cond(A-Z) *\
*endif
*endif
*if(strcmp(Cond(V-X),"OFF")!=0)
*if(strcmp(Cond(V-X),"off")!=0)
vx = *Cond(V-X) *\
*endif
*endif
*if(strcmp(Cond(V-Y),"OFF")!=0)
*if(strcmp(Cond(V-Y),"off")!=0)
vy = *Cond(V-Y) *\
*endif
*endif
*if(strcmp(Cond(V-Z),"OFF")!=0)
*if(strcmp(Cond(V-Z),"off")!=0)
vz = *Cond(V-Z) *\
*endif
*endif
*if(strcmp(Cond(AR-X),"OFF")!=0)
*if(strcmp(Cond(AR-X),"off")!=0)
arx = *Cond(AR-X) *\
*endif
*endif
*if(strcmp(Cond(AR-Y),"OFF")!=0)
*if(strcmp(Cond(AR-Y),"off")!=0)
ary = *Cond(AR-Y) *\
*endif
*endif
*if(strcmp(Cond(AR-Z),"OFF")!=0)
*if(strcmp(Cond(AR-Z),"off")!=0)
arz = *Cond(AR-Z) *\
*endif
*endif
*if(strcmp(Cond(VR-X),"OFF")!=0)
*if(strcmp(Cond(VR-X),"off")!=0)
vrx = *Cond(VR-X) *\
*endif
*endif
*if(strcmp(Cond(VR-Y),"OFF")!=0)
*if(strcmp(Cond(VR-Y),"off")!=0)
vry = *Cond(VR-Y) *\
*endif
*endif
*if(strcmp(Cond(VR-Z),"OFF")!=0)
*if(strcmp(Cond(VR-Z),"off")!=0)
vrz = *Cond(VR-Z) *\
*endif
*endif

*endif

LOADS
load_*newmaster *\
*if(strcmp(Cond(Master-x-force),"OFF")!=0)
*if(strcmp(Cond(Master-x-force),"off")!=0)
fx = *Cond(Master-x-force) *\
*endif
*endif
*if(strcmp(Cond(Master-y-force),"OFF")!=0)
*if(strcmp(Cond(Master-y-force),"off")!=0)
fy = *Cond(Master-y-force) *\
*endif
*endif
*if(strcmp(Cond(Master-z-force),"OFF")!=0)
*if(strcmp(Cond(Master-z-force),"off")!=0)
fz = *Cond(Master-z-force) *\
*endif
*endif
*if(strcmp(Cond(Master-x-accel),"OFF")!=0)
*if(strcmp(Cond(Master-x-accel),"off")!=0)
ax = *Cond(Master-x-accel) *\
*endif
*endif
*if(strcmp(Cond(Master-y-accel),"OFF")!=0)
*if(strcmp(Cond(Master-y-accel),"off")!=0)
ay = *Cond(Master-y-accel) *\
*endif
*endif
*if(strcmp(Cond(Master-z-accel),"OFF")!=0)
*if(strcmp(Cond(Master-z-accel),"off")!=0)
az = *Cond(Master-z-accel) *\
*endif
*endif


*endif

*if(strcmp(cond(Master-Node-Force),"OFF")== 0) *\
NODES
*format "%8i x = %15.8f y = %15.8f z = %15.8f"
*newmaster*xcord*ycord*zcord  *\
constraint = Constr_*newmaster *\
*if(strcmp(cond(Master-Node-Mass),"ON")== 0)
M = *Cond(MasterNode-Mass)

*endif


CONSTRAINTS OF TYPE Boundary_Condition
Constr_*newmaster *\
*if(strcmp(Cond(A-X),"OFF")!=0)
*if(strcmp(Cond(A-X),"off")!=0)
ax = *Cond(A-X) *\
*endif
*endif
*if(strcmp(Cond(A-Y),"OFF")!=0)
*if(strcmp(Cond(A-Y),"off")!=0)
ay = *Cond(A-Y) *\
*endif
*endif
*if(strcmp(Cond(A-Z),"OFF")!=0)
*if(strcmp(Cond(A-Z),"off")!=0)
az = *Cond(A-Z) *\
*endif
*endif
*if(strcmp(Cond(V-X),"OFF")!=0)
*if(strcmp(Cond(V-X),"off")!=0)
vx = *Cond(V-X) *\
*endif
*endif
*if(strcmp(Cond(V-Y),"OFF")!=0)
*if(strcmp(Cond(V-Y),"off")!=0)
vy = *Cond(V-Y) *\
*endif
*endif
*if(strcmp(Cond(V-Z),"OFF")!=0)
*if(strcmp(Cond(V-Z),"off")!=0)
vz = *Cond(V-Z) *\
*endif
*endif
*if(strcmp(Cond(AR-X),"OFF")!=0)
*if(strcmp(Cond(AR-X),"off")!=0)
arx = *Cond(AR-X) *\
*endif
*endif
*if(strcmp(Cond(AR-Y),"OFF")!=0)
*if(strcmp(Cond(AR-Y),"off")!=0)
ary = *Cond(AR-Y) *\
*endif
*endif
*if(strcmp(Cond(AR-Z),"OFF")!=0)
*if(strcmp(Cond(AR-Z),"off")!=0)
arz = *Cond(AR-Z) *\
*endif
*endif
*if(strcmp(Cond(VR-X),"OFF")!=0)
*if(strcmp(Cond(VR-X),"off")!=0)
vrx = *Cond(VR-X) *\
*endif
*endif
*if(strcmp(Cond(VR-Y),"OFF")!=0)
*if(strcmp(Cond(VR-Y),"off")!=0)
vry = *Cond(VR-Y) *\
*endif
*endif
*if(strcmp(Cond(VR-Z),"OFF")!=0)
*if(strcmp(Cond(VR-Z),"off")!=0)
vrz = *Cond(VR-Z) *\
*endif
*endif

*endif

*endif
*if(strcmp(Cond(Update-Node-COG),"ON")==0)
*set var mult=Cond(1,real)
*set var xx=0.0001 * mult
*set var yy=0.0001
*set var zz=0.0001
update_position = *Cond(Update-Node-COG) *\


*if(strcmp(cond(Master-Node-Force),"ON")== 0)
NODES
*format "%8i x = %15.8f y = %15.8f z = %15.8f"
*newmaster*xx*yy*zz  *\
constraint = Constr_*newmaster load = load_*newmaster *\
*if(strcmp(cond(Master-Node-Mass),"ON")== 0)
M = *Cond(MasterNode-Mass)
*endif

*if(strcmp(cond(Master-Node-Constraint),"OFF")== 0)

CONSTRAINTS OF TYPE Boundary_Condition
Constr_*newmaster *\

*endif
*if(strcmp(cond(Master-Node-Constraint),"ON")== 0)

CONSTRAINTS OF TYPE Boundary_Condition
Constr_*newmaster *\
*if(strcmp(Cond(A-X),"OFF")!=0)
*if(strcmp(Cond(A-X),"off")!=0)
ax = *Cond(A-X) *\
*endif
*endif
*if(strcmp(Cond(A-Y),"OFF")!=0)
*if(strcmp(Cond(A-Y),"off")!=0)
ay = *Cond(A-Y) *\
*endif
*endif
*if(strcmp(Cond(A-Z),"OFF")!=0)
*if(strcmp(Cond(A-Z),"off")!=0)
az = *Cond(A-Z) *\
*endif
*endif
*if(strcmp(Cond(V-X),"OFF")!=0)
*if(strcmp(Cond(V-X),"off")!=0)
vx = *Cond(V-X) *\
*endif
*endif
*if(strcmp(Cond(V-Y),"OFF")!=0)
*if(strcmp(Cond(V-Y),"off")!=0)
vy = *Cond(V-Y) *\
*endif
*endif
*if(strcmp(Cond(V-Z),"OFF")!=0)
*if(strcmp(Cond(V-Z),"off")!=0)
vz = *Cond(V-Z) *\
*endif
*endif
*if(strcmp(Cond(AR-X),"OFF")!=0)
*if(strcmp(Cond(AR-X),"off")!=0)
arx = *Cond(AR-X) *\
*endif
*endif
*if(strcmp(Cond(AR-Y),"OFF")!=0)
*if(strcmp(Cond(AR-Y),"off")!=0)
ary = *Cond(AR-Y) *\
*endif
*endif
*if(strcmp(Cond(AR-Z),"OFF")!=0)
*if(strcmp(Cond(AR-Z),"off")!=0)
arz = *Cond(AR-Z) *\
*endif
*endif
*if(strcmp(Cond(VR-X),"OFF")!=0)
*if(strcmp(Cond(VR-X),"off")!=0)
vrx = *Cond(VR-X) *\
*endif
*endif
*if(strcmp(Cond(VR-Y),"OFF")!=0)
*if(strcmp(Cond(VR-Y),"off")!=0)
vry = *Cond(VR-Y) *\
*endif
*endif
*if(strcmp(Cond(VR-Z),"OFF")!=0)
*if(strcmp(Cond(VR-Z),"off")!=0)
vrz = *Cond(VR-Z) *\
*endif
*endif

*endif

LOADS
load_*newmaster *\
*if(strcmp(Cond(Master-x-force),"OFF")!=0)
*if(strcmp(Cond(Master-x-force),"off")!=0)
fx = *Cond(Master-x-force) *\
*endif
*endif
*if(strcmp(Cond(Master-y-force),"OFF")!=0)
*if(strcmp(Cond(Master-y-force),"off")!=0)
fy = *Cond(Master-y-force) *\
*endif
*endif
*if(strcmp(Cond(Master-z-force),"OFF")!=0)
*if(strcmp(Cond(Master-z-force),"off")!=0)
fz = *Cond(Master-z-force) *\
*endif
*endif
*if(strcmp(Cond(Master-x-accel),"OFF")!=0)
*if(strcmp(Cond(Master-x-accel),"off")!=0)
ax = *Cond(Master-x-accel) *\
*endif
*endif
*if(strcmp(Cond(Master-y-accel),"OFF")!=0)
*if(strcmp(Cond(Master-y-accel),"off")!=0)
ay = *Cond(Master-y-accel) *\
*endif
*endif
*if(strcmp(Cond(Master-z-accel),"OFF")!=0)
*if(strcmp(Cond(Master-z-accel),"off")!=0)
az = *Cond(Master-z-accel) *\
*endif
*endif
*endif
*if(strcmp(cond(Master-Node-Force),"OFF")== 0) *\
NODES
*format "%8i x = %15.8f y = %15.8f z = %15.8f"
*newmaster*xx*yy*zz  *\
constraint = Constr_*newmaster *\
*if(strcmp(cond(Master-Node-Mass),"ON")== 0)
M = *Cond(MasterNode-Mass)

*endif


CONSTRAINTS OF TYPE Boundary_Condition
Constr_*newmaster *\
*if(strcmp(Cond(A-X),"OFF")!=0)
*if(strcmp(Cond(A-X),"off")!=0)
ax = *Cond(A-X) *\
*endif
*endif
*if(strcmp(Cond(A-Y),"OFF")!=0)
*if(strcmp(Cond(A-Y),"off")!=0)
ay = *Cond(A-Y) *\
*endif
*endif
*if(strcmp(Cond(A-Z),"OFF")!=0)
*if(strcmp(Cond(A-Z),"off")!=0)
az = *Cond(A-Z) *\
*endif
*endif
*if(strcmp(Cond(V-X),"OFF")!=0)
*if(strcmp(Cond(V-X),"off")!=0)
vx = *Cond(V-X) *\
*endif
*endif
*if(strcmp(Cond(V-Y),"OFF")!=0)
*if(strcmp(Cond(V-Y),"off")!=0)
vy = *Cond(V-Y) *\
*endif
*endif
*if(strcmp(Cond(V-Z),"OFF")!=0)
*if(strcmp(Cond(V-Z),"off")!=0)
vz = *Cond(V-Z) *\
*endif
*endif
*if(strcmp(Cond(AR-X),"OFF")!=0)
*if(strcmp(Cond(AR-X),"off")!=0)
arx = *Cond(AR-X) *\
*endif
*endif
*if(strcmp(Cond(AR-Y),"OFF")!=0)
*if(strcmp(Cond(AR-Y),"off")!=0)
ary = *Cond(AR-Y) *\
*endif
*endif
*if(strcmp(Cond(AR-Z),"OFF")!=0)
*if(strcmp(Cond(AR-Z),"off")!=0)
arz = *Cond(AR-Z) *\
*endif
*endif
*if(strcmp(Cond(VR-X),"OFF")!=0)
*if(strcmp(Cond(VR-X),"off")!=0)
vrx = *Cond(VR-X) *\
*endif
*endif
*if(strcmp(Cond(VR-Y),"OFF")!=0)
*if(strcmp(Cond(VR-Y),"off")!=0)
vry = *Cond(VR-Y) *\
*endif
*endif
*if(strcmp(Cond(VR-Z),"OFF")!=0)
*if(strcmp(Cond(VR-Z),"off")!=0)
vrz = *Cond(VR-Z) *\
*endif
*endif

*endif

*endif

*endif
*endif
*end nodes
*end for



#-------------------------------------------------------------------
#    ANALYSIS MODEL LOADS
#-------------------------------------------------------------------
*Set cond Force_Load *nodes
*for(i=1;i<10;i=i+1)
*Set var beenthere=0
*if(i!=1)
*set var beenthere=1
*endif
*loop nodes *OnlyInCond
*if(Cond(2,int)==i)
*if(beenthere==0)
*set var beenthere=1
LOADS
*endif
*endif
*end nodes
*end for
*Set cond Force_Load *nodes
*for(i=1;i<10;i=i+1)
*Set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(2,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i"
Load_*Cond(2,int) *\
fx = *Cond(x-force) *\
fy = *Cond(y-force) *\
fz = *Cond(z-force) *\
ax = *Cond(x-accel) *\
ay = *Cond(y-accel) *\
az = *Cond(z-accel) *\
mx = *Cond(x-moment) *\
my = *Cond(y-moment) *\
mz = *Cond(z-moment) *\
arx = *Cond(x-accel-rotation) *\
ary = *Cond(y-accel-rotation) *\
arz = *Cond(z-accel-rotation)
*endif
*endif
*end nodes
*end
*Set cond Pressure_Load *nodes
*for(i=1;i<10;i=i+1)
*Set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(2,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i"
Load_*Cond(2,int) *\
p = *Cond(4)
*endif
*endif
*end nodes
*end for

#-------------------------------------------------------------------
#    TRACKERS
#-------------------------------------------------------------------
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"FORCE")==0)

TRACKERS OF TYPE NODEFORCE
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"FORCE")==0)
*format "%1i" *\
*Cond(3) nodes = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"MOMENT")==0)

TRACKERS OF TYPE NODEMOMENT
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"MOMENT")==0)
*format "%1i" *\
*Cond(3) nodes = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"DISPLACEMENT")==0)

TRACKERS OF TYPE NODEDISPLACEMENT
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"DISPLACEMENT")==0)
*format "%1i" *\
*Cond(3) node = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"ACCELERATION")==0)

TRACKERS OF TYPE NODEACCELERATION
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"ACCELERATION")==0)
*format "%1i" *\
*Cond(3) node = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end

*if(strcmp(GenData(CONTACT),"YES") == 0 || strcmp(GenData(INTERNAL),"YES") == 0 || strcmp(GenData(EXTERNAL),"YES") == 0 || strcmp(GenData(HGLASS),"YES") == 0)
TRACKERS OF TYPE ENERGY
*endif
*if(strcmp(GenData(CONTACT),"YES") == 0)
11 type = contact filename = *GenData(FILENAME_CONTACT)
*endif
*if(strcmp(GenData(INTERNAL),"YES") == 0)
12 type = internal filename = *GenData(FILENAME_INTERNAL)
*endif
*if(strcmp(GenData(EXTERNAL),"YES") == 0)
13 type = external filename = *GenData(FILENAME_EXTERNAL)
*endif
*if(strcmp(GenData(HGLASS),"YES") == 0)
14 type = hourglass filename = *GenData(FILENAME_HOURGLASS)
*endif

#-------------------------------------------------------------------
#    END OF FILE
#-------------------------------------------------------------------
#-------------------------------------------------------------------
