/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.util.Stack;
import jp.lang.DistributedRuntime;
import jp.lang.Marker;
import jp.lang.MovedException;
import jp.lang.RemoteObject;
import jp.lang.RemoteObject_instance_impl;
import jp.lang.RemoteTools;
import jp.lang.RuntimeEnvironment;
import jp.tools.scheduler.ItemCache;
import jp.tools.scheduler.Job;
import jp.tools.scheduler.Schedule;
import jp.tools.scheduler.ScheduleException;
import jp.tools.scheduler.Scheduler;
import jp.tools.scheduler.Scheduler_instance_intf;
import jp.tools.scheduler.Worker;
import jp.tools.scheduler.WorkerEvent;
import uka.karmi.rmi.RemoteException;

public class Scheduler_instance_impl
extends RemoteObject_instance_impl
implements Scheduler_instance_intf {
    private Schedule schedule;
    private Stack unemployedWorkers;
    private ItemCache itemCache;
    private ScheduleException scheduleException;
    private Object lock;

    public final Schedule jp_tools_scheduler_Scheduler_schedule_get_() throws MovedException {
        this._inc();
        try {
            Schedule schedule = this.schedule;
            Object var3_2 = null;
            this._dec();
            return schedule;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._dec();
            throw throwable;
        }
    }

    public final Schedule jp_tools_scheduler_Scheduler_schedule_set_(Schedule schedule) throws MovedException {
        this._inc();
        try {
            Schedule schedule2 = this.schedule = schedule;
            Object var4_3 = null;
            this._dec();
            return schedule2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._dec();
            throw throwable;
        }
    }

    public final Stack jp_tools_scheduler_Scheduler_unemployedWorkers_get_() throws MovedException {
        this._inc();
        try {
            Stack stack = this.unemployedWorkers;
            Object var3_2 = null;
            this._dec();
            return stack;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._dec();
            throw throwable;
        }
    }

    public final Stack jp_tools_scheduler_Scheduler_unemployedWorkers_set_(Stack stack) throws MovedException {
        this._inc();
        try {
            Stack stack2 = this.unemployedWorkers = stack;
            Object var4_3 = null;
            this._dec();
            return stack2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._dec();
            throw throwable;
        }
    }

    public final ItemCache jp_tools_scheduler_Scheduler_itemCache_get_() throws MovedException {
        this._inc();
        try {
            ItemCache itemCache = this.itemCache;
            Object var3_2 = null;
            this._dec();
            return itemCache;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._dec();
            throw throwable;
        }
    }

    public final ItemCache jp_tools_scheduler_Scheduler_itemCache_set_(ItemCache itemCache) throws MovedException {
        this._inc();
        try {
            ItemCache itemCache2 = this.itemCache = itemCache;
            Object var4_3 = null;
            this._dec();
            return itemCache2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._dec();
            throw throwable;
        }
    }

    public final ScheduleException jp_tools_scheduler_Scheduler_scheduleException_get_() throws MovedException {
        this._inc();
        try {
            ScheduleException scheduleException = this.scheduleException;
            Object var3_2 = null;
            this._dec();
            return scheduleException;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._dec();
            throw throwable;
        }
    }

    public final ScheduleException jp_tools_scheduler_Scheduler_scheduleException_set_(ScheduleException scheduleException) throws MovedException {
        this._inc();
        try {
            ScheduleException scheduleException2 = this.scheduleException = scheduleException;
            Object var4_3 = null;
            this._dec();
            return scheduleException2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._dec();
            throw throwable;
        }
    }

    public final Object jp_tools_scheduler_Scheduler_lock_get_() throws MovedException {
        this._inc();
        try {
            Object object = this.lock;
            Object var3_2 = null;
            this._dec();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._dec();
            throw throwable;
        }
    }

    public final Object jp_tools_scheduler_Scheduler_lock_set_(Object object) throws MovedException {
        this._inc();
        try {
            Object object2 = this.lock = object;
            Object var4_3 = null;
            this._dec();
            return object2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._dec();
            throw throwable;
        }
    }

    public Scheduler_instance_impl(Schedule schedule, int n) throws RemoteException {
        this.schedule = schedule;
        this.lock = new Object();
        this.itemCache = new ItemCache(schedule.getSize());
        this.unemployedWorkers = new Stack();
        this.scheduleException = null;
        for (int i = 0; i < n; ++i) {
            DistributedRuntime.setTarget(i % DistributedRuntime.getMachineCnt());
            Worker worker = new Worker();
            worker.addListener((Scheduler)this._this);
            this.unemployedWorkers.push(worker);
        }
    }

    public void schedule() throws ScheduleException, MovedException {
        this._inc();
        try {
            block20: {
                Object _syncedObject2;
                Object _syncedObject0 = this.lock;
                Object object = _syncedObject2 = _syncedObject0 instanceof RemoteObject ? ((RemoteObject)_syncedObject0)._getImpl() : _syncedObject0;
                if (_syncedObject2 == null) {
                    Object _syncedObject1 = RemoteTools.rmaAcquire((RemoteObject)_syncedObject0);
                    try {
                        RuntimeEnvironment.isNotReplicatedObject(this.lock, "Replicated objects must be synchronized 'collective', 'exclusive' or 'shared'.'");
                        while (!this.schedule.getRoot().isDone()) {
                            if (!this.unemployedWorkers.isEmpty()) {
                                Schedule.Item item = this.schedule.selectItemForScheduling();
                                while (item != null) {
                                    Worker worker = (Worker)this.unemployedWorkers.pop();
                                    Job job = item.getJob();
                                    int jobID = this.itemCache.store(item);
                                    Schedule.Item[] _requisites = item.getRequisites();
                                    Job[] requisites = new Job[_requisites.length];
                                    for (int i = 0; i < requisites.length; ++i) {
                                        requisites[i] = _requisites[i].getJob();
                                    }
                                    worker.startActivity(job, jobID, requisites);
                                    item = !this.unemployedWorkers.isEmpty() ? this.schedule.selectItemForScheduling() : null;
                                }
                            }
                            try {
                                RemoteTools.doWait(this.lock);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (this.scheduleException == null) continue;
                            throw this.scheduleException;
                        }
                        Object var12_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_22 = null;
                        RemoteTools.rmaRelease(_syncedObject1);
                        throw throwable;
                    }
                    RemoteTools.rmaRelease(_syncedObject1);
                    {
                        break block20;
                    }
                }
                Object object2 = _syncedObject2;
                synchronized (object2) {
                    try {
                        RuntimeEnvironment.isNotReplicatedObject(this.lock, "Replicated objects must be synchronized 'collective', 'exclusive' or 'shared'.'");
                        while (!this.schedule.getRoot().isDone()) {
                            if (!this.unemployedWorkers.isEmpty()) {
                                Schedule.Item item = this.schedule.selectItemForScheduling();
                                while (item != null) {
                                    Worker worker = (Worker)this.unemployedWorkers.pop();
                                    Job job = item.getJob();
                                    int jobID = this.itemCache.store(item);
                                    Schedule.Item[] itemArray = item.getRequisites();
                                    Job[] jobArray = new Job[itemArray.length];
                                    for (int i = 0; i < jobArray.length; ++i) {
                                        jobArray[i] = itemArray[i].getJob();
                                    }
                                    worker.startActivity(job, jobID, jobArray);
                                    item = !this.unemployedWorkers.isEmpty() ? this.schedule.selectItemForScheduling() : null;
                                }
                            }
                            try {
                                RemoteTools.doWait(this.lock);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this.scheduleException == null) continue;
                            throw this.scheduleException;
                        }
                        Object var14_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_25 = null;
                        throw throwable;
                    }
                }
            }
            Object var16_27 = null;
            this._dec();
        }
        catch (Throwable throwable) {
            Object var16_28 = null;
            this._dec();
            throw throwable;
        }
    }

    public void jobDone(WorkerEvent event) throws MovedException {
        this._inc();
        try {
            block10: {
                Object _syncedObject5;
                Object _syncedObject3 = this.lock;
                Object object = _syncedObject5 = _syncedObject3 instanceof RemoteObject ? ((RemoteObject)_syncedObject3)._getImpl() : _syncedObject3;
                if (_syncedObject5 == null) {
                    Object _syncedObject4 = RemoteTools.rmaAcquire((RemoteObject)_syncedObject3);
                    try {
                        RuntimeEnvironment.isNotReplicatedObject(this.lock, "Replicated objects must be synchronized 'collective', 'exclusive' or 'shared'.'");
                        this.unemployedWorkers.push(event.getSource());
                        int jobID = event.getJobID();
                        Schedule.Item item = this.itemCache.getItemFor(jobID);
                        Job job = item.getJob();
                        item.setDone();
                        this.itemCache.delete(jobID);
                        Throwable throwable = event.getThrowable();
                        if (throwable != null && this.scheduleException == null) {
                            this.scheduleException = new ScheduleException("user-level exception occurred while performing work on scheduled job", throwable, job);
                        }
                        RemoteTools.doNotify(this.lock);
                        Object var10_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        RemoteTools.rmaRelease(_syncedObject4);
                        throw throwable;
                    }
                    RemoteTools.rmaRelease(_syncedObject4);
                    {
                        break block10;
                    }
                }
                Object object2 = _syncedObject5;
                synchronized (object2) {
                    try {
                        RuntimeEnvironment.isNotReplicatedObject(this.lock, "Replicated objects must be synchronized 'collective', 'exclusive' or 'shared'.'");
                        this.unemployedWorkers.push(event.getSource());
                        int n = event.getJobID();
                        Schedule.Item item = this.itemCache.getItemFor(n);
                        Job job = item.getJob();
                        item.setDone();
                        this.itemCache.delete(n);
                        Throwable throwable = event.getThrowable();
                        if (throwable != null && this.scheduleException == null) {
                            this.scheduleException = new ScheduleException("user-level exception occurred while performing work on scheduled job", throwable, job);
                        }
                        RemoteTools.doNotify(this.lock);
                        Object var12_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        throw throwable;
                    }
                }
            }
            Object var14_20 = null;
            this._dec();
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            this._dec();
            throw throwable;
        }
    }

    protected void __init() {
        this._this = new Scheduler((Marker)null);
        this._this._init(this._getRef());
    }

    protected void _cleanup() {
        super._cleanup();
        this.schedule = null;
        this.unemployedWorkers = null;
        this.itemCache = null;
        this.scheduleException = null;
        this.lock = null;
    }
}

