/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.IOException;
import jp.tools.scheduler.Job;
import jp.tools.scheduler.ScheduleException;
import jp.tools.scheduler.Scheduler;
import jp.tools.scheduler.SimpleSchedule;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.Patchable;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.TransportDescriptor;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class ScheduleExample
implements Patchable,
Transportable {
    public static final TransportDescriptor TRANSPORT_DESCRIPTOR = new TransportDescriptor(){

        public Object unmarshalReference(UnmarshalStream s, int n) throws IOException, ClassNotFoundException {
            return new ScheduleExample(s, n);
        }

        public boolean unmarshal(Object obj, UnmarshalStream unmarshalStream) throws ClassNotFoundException, IOException {
            ((ScheduleExample)obj).unmarshal(unmarshalStream);
            return false;
        }

        public void marshalReference(Object obj, MarshalStream marshalStream) throws IOException {
            ((ScheduleExample)obj).marshalReference(marshalStream);
        }

        public void marshal(Object obj, MarshalStream marshalStream) throws IOException {
            ((ScheduleExample)obj).marshal(marshalStream);
        }

        public Object deepClone(Object orig, int id, DeepClone _helper) throws CloneNotSupportedException {
            try {
                return new ScheduleExample((ScheduleExample)orig, id, _helper);
            }
            catch (IOException iOException) {
                throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(iOException);
            }
        }

        public boolean deepCloneReferences(Object orig, Object copy, DeepClone deepClone) throws CloneNotSupportedException {
            ((ScheduleExample)copy).deepCloneReferences((ScheduleExample)orig, deepClone);
            return false;
        }

        public Class getType() {
            return Class.forName("jp.tools.scheduler.ScheduleExample");
        }
    };

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        ScheduleExample scheduleExample = (ScheduleExample)_copy;
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        ScheduleExample scheduleExample = (ScheduleExample)_copy;
    }

    public void descendReferences(ReferenceConsumer referenceConsumer) throws IOException {
    }

    public void filterReferences(ReferenceFilter referenceFilter) {
    }

    public Object flatClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Declared Cloneable but clone() is still unsupported");
        }
    }

    public TransportDescriptor getTransportDescriptor() {
        return TRANSPORT_DESCRIPTOR;
    }

    public ScheduleExample(UnmarshalStream _stream, int n) throws IOException, ClassNotFoundException {
        _stream.register((Object)this, n);
    }

    public void unmarshal(UnmarshalStream unmarshalStream) throws IOException, ClassNotFoundException {
    }

    public void marshalReference(MarshalStream marshalStream) throws IOException {
    }

    public void marshal(MarshalStream marshalStream) throws IOException {
    }

    public ScheduleExample(ScheduleExample _orig, int _id, DeepClone deepClone) throws CloneNotSupportedException, IOException {
        deepClone.add(_id, (Object)this);
    }

    public void deepCloneReferences(ScheduleExample _orig, DeepClone deepClone) throws CloneNotSupportedException {
    }

    public ScheduleExample() {
    }

    public static void main(String[] argv) {
        SimpleSchedule schedule = new SimpleSchedule();
        SimpleSchedule.SimpleItem item1 = (SimpleSchedule.SimpleItem)schedule.getRoot();
        item1.setJob(new ExampleJob("1", 2000L));
        SimpleSchedule.SimpleItem item2 = (SimpleSchedule.SimpleItem)item1.createRequisite();
        item2.setJob(new ExampleJob("2", 5000L));
        SimpleSchedule.SimpleItem item3 = (SimpleSchedule.SimpleItem)item1.createRequisite();
        item3.setJob(new ExampleJob("3", 10000L));
        SimpleSchedule.SimpleItem item4 = (SimpleSchedule.SimpleItem)item2.createRequisite();
        item4.setJob(new ExampleJob("4", 5000L));
        item3.addRequisite(item4);
        Scheduler scheduler = new Scheduler(schedule, 2);
        try {
            scheduler.schedule();
        }
        catch (ScheduleException e) {
            System.err.println(String.valueOf(String.valueOf("user-level exception occurred in job ").concat(String.valueOf(e.getJob()))).concat(String.valueOf(" while scheduling:")));
            e.getCause().printStackTrace(System.err);
        }
    }

    private static class ExampleJob
    implements Job {
        private String name;
        private long sleepTime;

        private ExampleJob(String name, long l) {
            this.name = name;
            this.sleepTime = l;
        }

        private void println(Object object) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Job '").concat(String.valueOf(this.name))).concat(String.valueOf("': "))).concat(String.valueOf(object)));
        }

        public void performWork(Job[] requisites) {
            this.println("Starting work.");
            for (int i = 0; i < requisites.length; ++i) {
                this.println(String.valueOf("  Requisite: ").concat(String.valueOf(requisites[i])));
            }
            this.println(String.valueOf(String.valueOf("Sleeping ").concat(String.valueOf(this.sleepTime))).concat(String.valueOf("ms...")));
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                this.println(String.valueOf("Sleep interrupted: ").concat(String.valueOf(interruptedException.getMessage())));
            }
            this.println("Finishing work.");
        }

        public String toString() {
            return this.name;
        }
    }
}

