/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jp.lang.VirtualMachine;
import jp.tools.monitor.ActionHandler;
import jp.tools.monitor.ClassTablePanel;

public class JVMStatusPanel
extends JPanel {
    private static final String TITLE = "JVM Status";
    private static final String RESET_BUTTON_TITLE = "Reset JVM";
    private ActionHandler handler;
    private VirtualMachine vm;
    private JLabel labelID;
    private ClassTablePanel classTablePanel;
    private ResetButton resetButton;

    private JVMStatusPanel() {
    }

    public JVMStatusPanel(ActionHandler handler) {
        this.handler = handler;
        this.setLayout(new BorderLayout());
        this.labelID = new JLabel();
        this.add((Component)this.labelID, "North");
        this.resetButton = new ResetButton();
        this.add((Component)this.resetButton, "South");
        this.classTablePanel = new ClassTablePanel(handler);
        this.add((Component)this.classTablePanel, "Center");
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createTitledBorder(etchedBorder, TITLE, 2, 2));
    }

    public void validate() {
        if (this.vm != null) {
            this.labelID.setText("JVM #" + this.vm.getID());
            this.classTablePanel.setEnabled(true);
            this.classTablePanel.validate();
            this.resetButton.setEnabled(true);
        } else {
            this.resetButton.setEnabled(false);
            this.labelID.setText("<N.N.>");
            this.classTablePanel.setEnabled(false);
            this.classTablePanel.validate();
        }
        super.validate();
    }

    public void selectVM(VirtualMachine vm) {
        this.classTablePanel.selectVM(vm);
        this.vm = vm;
        this.validate();
    }

    public void updateVM() {
        this.classTablePanel.invalidate();
        this.validate();
    }

    public int getMachineID() {
        return this.vm != null ? this.vm.getID() : -1;
    }

    private class ResetButton
    extends JButton
    implements ActionListener {
        public ResetButton() {
            super(JVMStatusPanel.RESET_BUTTON_TITLE);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            if (JVMStatusPanel.this.vm != null) {
                JVMStatusPanel.this.handler.resetVM(JVMStatusPanel.this.vm);
            }
        }
    }
}

