/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.lang.RemoteError;
import jp.lang.RemoteObject_class_impl;
import jp.lang.RemoteObject_class_intf;
import jp.lang.RuntimeEnvironment;
import jp.lang.RuntimeExplorer;
import jp.lang.RuntimeExplorer_class_intf;
import jp.lang.RuntimeExplorer_instance_impl;
import jp.lang.VirtualMachine;
import uka.karmi.rmi.RemoteException;

public final class RuntimeExplorer_class_impl
extends RemoteObject_class_impl
implements RuntimeExplorer_class_intf {
    public static RuntimeExplorer_class_intf _class;
    StreamTokenizer st;
    int JVMIdx;

    public RuntimeExplorer_class_impl(boolean bl) throws RemoteException {
        super(bl);
    }

    private static final RuntimeExplorer_class_impl _ClassType_(RuntimeExplorer x) {
        return null;
    }

    public final RuntimeExplorer_class_intf jp_lang_RuntimeExplorer__class_get_() {
        return _class;
    }

    public Object _new() throws RemoteException {
        RuntimeExplorer_instance_impl runtimeExplorer_instance_impl = new RuntimeExplorer_instance_impl();
        return runtimeExplorer_instance_impl._getRef();
    }

    public final StreamTokenizer jp_lang_RuntimeExplorer_st_get_() {
        return this.st;
    }

    public final StreamTokenizer jp_lang_RuntimeExplorer_st_set_(StreamTokenizer streamTokenizer) {
        this.st = streamTokenizer;
        return this.st;
    }

    public final int jp_lang_RuntimeExplorer_JVMIdx_get_() {
        return this.JVMIdx;
    }

    public final int jp_lang_RuntimeExplorer_JVMIdx_set_(int n) {
        this.JVMIdx = n;
        return this.JVMIdx;
    }

    public final int jp_lang_RuntimeExplorer_JVMIdx_inc_(int _value_, boolean _post_) {
        if (_post_) {
            int n = this.JVMIdx;
            this.JVMIdx += _value_;
            return n;
        }
        return this.JVMIdx += _value_;
    }

    public VirtualMachine[] getMachines() {
        int vmcnt = RuntimeEnvironment.getMachineCnt();
        VirtualMachine[] machines = new VirtualMachine[vmcnt];
        for (int i = 0; i < vmcnt; ++i) {
            machines[i] = RuntimeEnvironment.getMachine(i);
        }
        return machines;
    }

    public VirtualMachine getJVM(int n) {
        return RuntimeEnvironment.getMachine(n);
    }

    public void JVMLocation(int n) {
        VirtualMachine virtualMachine = this.getJVM(n);
        System.out.println(String.valueOf("  ").concat(String.valueOf(virtualMachine.host())));
    }

    public void machinesOfHost(String hostname) {
        InetAddress host;
        VirtualMachine[] machines = this.getMachines();
        try {
            host = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            System.out.println("host unknown.");
            return;
        }
        if (machines == null) {
            return;
        }
        for (int i = 0; i < machines.length; ++i) {
            try {
                if (!host.equals(InetAddress.getByName(machines[i].host()))) continue;
                System.out.println(String.valueOf("  jvm#").concat(String.valueOf(machines[i].getID())));
                continue;
            }
            catch (Exception exception) {
                System.err.println(String.valueOf("could not eval host ID: ").concat(String.valueOf(exception)));
            }
        }
    }

    public void listMachines() {
        VirtualMachine[] machines = this.getMachines();
        if (machines == null) {
            return;
        }
        if (machines.length == 0) {
            System.out.println("no local machines registered.");
        } else {
            for (int i = 0; i < machines.length; ++i) {
                int n = machines[i].getID();
                String string = machines[i].host();
                if (i < 10) {
                    System.out.print(String.valueOf("  ").concat(String.valueOf(i)));
                } else {
                    System.out.print(String.valueOf(" ").concat(String.valueOf(i)));
                }
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(") jvm#").concat(String.valueOf(n))).concat(String.valueOf(" at host '"))).concat(String.valueOf(string))).concat(String.valueOf("'")));
            }
        }
    }

    public void listClasses(int n) {
        VirtualMachine vm = this.getJVM(n);
        if (vm == null) {
            return;
        }
        Hashtable classTable = vm.getClassTable();
        Enumeration names = classTable.keys();
        while (names.hasMoreElements()) {
            String string = (String)names.nextElement();
            System.out.println(String.valueOf("  ").concat(String.valueOf(string)));
        }
    }

    public void listAllClasses() {
        VirtualMachine[] machines = this.getMachines();
        if (machines == null) {
            return;
        }
        for (int i = 0; i < machines.length; ++i) {
            int n = machines[i].getID();
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" jvm#").concat(String.valueOf(n))).concat(String.valueOf(" ("))).concat(String.valueOf(machines[i].host()))).concat(String.valueOf("): ")));
            this.listClasses(n);
        }
    }

    public void listHosts() {
        VirtualMachine[] machines = this.getMachines();
        if (machines == null) {
            return;
        }
        String[] hosts = new String[machines.length];
        int num = 0;
        for (int i = 0; i < machines.length; ++i) {
            int j;
            String host = machines[i].host();
            for (j = 0; j < num && !host.equals(hosts[j]); ++j) {
            }
            if (j != num) continue;
            hosts[num++] = host;
        }
        for (int i = 0; i < num; ++i) {
            System.out.println(String.valueOf("  ").concat(String.valueOf(hosts[i])));
        }
    }

    public void listConstr(int n) {
        VirtualMachine vm = this.getJVM(n);
        if (vm == null) {
            return;
        }
        Hashtable constrTable = vm.getConstructorTable();
        Enumeration names = constrTable.keys();
        while (names.hasMoreElements()) {
            String string = (String)names.nextElement();
            System.out.println(String.valueOf("  ").concat(String.valueOf(string)));
        }
    }

    public void classLocation(String classname, int n) {
        VirtualMachine vm = this.getJVM(n);
        if (vm == null) {
            return;
        }
        Hashtable classTable = vm.getClassTable();
        RemoteObject_class_intf cl = (RemoteObject_class_intf)classTable.get(classname);
        if (cl != null) {
            System.out.println(String.valueOf("class object on jvm#").concat(String.valueOf(n)));
        }
        Hashtable hashtable = vm.getConstructorTable();
        cl = (RemoteObject_class_intf)hashtable.get(classname);
        if (cl != null) {
            System.out.println(String.valueOf("constructor object on jvm#").concat(String.valueOf(n)));
        }
    }

    public void resetRuntime() {
        RuntimeEnvironment.rm.reset();
    }

    public void killRuntime() {
        RuntimeEnvironment.kill(0);
    }

    public int error() throws IOException {
        return this.error("syntax error");
    }

    public int error(String message) throws IOException {
        System.out.println(message);
        int n = this.st.ttype;
        while (n != -1 && n != 10) {
            n = this.st.nextToken();
        }
        if (n == 10) {
            return n;
        }
        return n;
    }

    public boolean acceptEOL() throws IOException {
        if (this.st.nextToken() == 10) {
            return true;
        }
        this.error("eol expected");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int acceptNumber() throws IOException {
        if (this.st.nextToken() == -2) {
            int n = new Double(this.st.nval).intValue();
            if (n >= 0) return n;
            this.error("illegal number");
            return -1;
        } else {
            this.error("JVM number expected.");
        }
        return -1;
    }

    public String acceptName() throws IOException {
        if (this.st.nextToken() == -3) {
            return this.st.sval;
        }
        this.error("class name expected.");
        return null;
    }

    public int doList() throws IOException {
        if (this.st.nextToken() != -3) {
            return this.error("identifier expected as parameter for 'list'.");
        }
        if (this.st.sval.equals("jvms")) {
            if (this.acceptEOL()) {
                this.listMachines();
            }
        } else if (this.st.sval.equals("classes")) {
            if (this.acceptEOL()) {
                this.listAllClasses();
            }
        } else if (this.st.sval.equals("hosts")) {
            if (this.acceptEOL()) {
                this.listHosts();
            }
        } else {
            return this.error("'jvms', 'classes' or 'hosts' expected");
        }
        return this.st.ttype;
    }

    public int doWhere() throws IOException {
        if (this.st.nextToken() != -3) {
            return this.error("class or JVM expected as parameter for 'where'.");
        }
        if (this.st.sval.equals("cl")) {
            String name = this.acceptName();
            if (name != null && this.acceptEOL()) {
                for (int i = 0; i < RuntimeEnvironment.getMachineCnt(); ++i) {
                    this.classLocation(name, i);
                }
            }
        } else if (this.st.sval.equals("jvm")) {
            int n = this.acceptNumber();
            if (n >= 0 && this.acceptEOL()) {
                this.JVMLocation(n);
            }
        } else {
            return this.error("class or JVM expected");
        }
        return this.st.ttype;
    }

    public int doMachines() throws IOException {
        if (this.st.nextToken() != -3) {
            return this.error("hostname expected.");
        }
        String string = this.st.sval;
        if (this.acceptEOL()) {
            this.machinesOfHost(string);
        }
        return this.st.ttype;
    }

    public int doClasses() throws IOException {
        if (this.st.nextToken() != -3 || !this.st.sval.equals("jvm")) {
            return this.error("JVM expected.");
        }
        int n = this.acceptNumber();
        if (n >= 0 && this.acceptEOL()) {
            this.listClasses(n);
        }
        return this.st.ttype;
    }

    public int doConstr() throws IOException {
        if (this.st.nextToken() != -3 || !this.st.sval.equals("jvm")) {
            return this.error("JVM expected.");
        }
        int n = this.acceptNumber();
        if (n >= 0 && this.acceptEOL()) {
            this.listConstr(n);
        }
        return this.st.ttype;
    }

    public int doPing() throws IOException {
        VirtualMachine serv;
        if (this.st.nextToken() != -3 || !this.st.sval.equals("jvm")) {
            return this.error("JVM expected.");
        }
        int n = this.acceptNumber();
        if (n >= 0 && this.acceptEOL() && (serv = this.getJVM(n)) != null) {
            long l = System.currentTimeMillis();
            serv.getID();
            long stop = System.currentTimeMillis();
            System.out.println(String.valueOf(String.valueOf("answer returned within ").concat(String.valueOf(stop - l))).concat(String.valueOf("ms.")));
        }
        return this.st.ttype;
    }

    public int doHelp() throws IOException {
        if (this.acceptEOL()) {
            System.out.println("  COMMANDS");
            System.out.println();
            System.out.println("    list (jvms | classes | hosts)       displays a list of all known machines, ");
            System.out.println("                                        classes or hosts");
            System.out.println("    where (<jvm> | <class>)             location (host) of a JVM or the JVM");
            System.out.println("                                        for a class object");
            System.out.println("    machines <host>                     displays all machines located at the");
            System.out.println("                                        given host");
            System.out.println("    classes <jvm>                       displays all classnames for classes");
            System.out.println("                                        loaded at <jvm>");
            System.out.println("    constr <jvm>                        displays the names of classes that have");
            System.out.println("                                        a constructor object at <jvm>");
            System.out.println("    ping <jvm>                          messure time to make a remote method");
            System.out.println("                                        invocation to <jvm>");
            System.out.println("    reset                               reset runtime environment");
            System.out.println();
            System.out.println("    kill                                kill all local machines (but not the");
            System.out.println("                                        RuntimeManager)");
            System.out.println("    exit                                exit program");
            System.out.println();
            System.out.println("  SYNTAX");
            System.out.println();
            System.out.println("    <jvm>    ::= jvm#<number>");
            System.out.println("    <class>  ::= cl:<classname>");
            System.out.println("    <host>   ::= <hostname>");
        }
        return this.st.ttype;
    }

    public int doReset() throws IOException {
        if (this.acceptEOL()) {
            this.resetRuntime();
        }
        return this.st.ttype;
    }

    public int doKill() throws IOException {
        if (this.acceptEOL()) {
            this.killRuntime();
        }
        return this.st.ttype;
    }

    public boolean doExit() throws IOException {
        return this.acceptEOL();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        System.setSecurityManager(new RMISecurityManager());
        if (args.length != 0) {
            if (args.length > 1 || args.length == 1 && (args[0].equals("-?") || args[0].equals("-h"))) {
                System.out.println("usage: jprx [-r | -k | -lj | -lc | -lh]");
                return;
            }
            if (args[0].equals("-r")) {
                this.resetRuntime();
                return;
            }
            if (args[0].equals("-k")) {
                this.killRuntime();
                return;
            }
            if (args[0].equals("-lj")) {
                this.listMachines();
                return;
            }
            if (args[0].equals("-lc")) {
                this.listAllClasses();
                return;
            }
            if (args[0].equals("-lh")) {
                this.listHosts();
                return;
            }
            System.out.println(String.valueOf(String.valueOf("unknown option '").concat(String.valueOf(args[0]))).concat(String.valueOf("'.")));
            return;
        }
        System.out.println("JAVA-PARTY RUNTIME EXPLORER");
        System.out.println("JavaParty, Version 1.9.5");
        this.st.eolIsSignificant(true);
        this.st.slashStarComments(true);
        this.st.slashSlashComments(true);
        this.st.whitespaceChars(35, 35);
        this.st.whitespaceChars(58, 58);
        tt = 9999;
lbl31:
        // 12 sources

        try {
            block6: while (tt != -1) {
                System.out.print("? ");
                System.out.flush();
                tt = this.st.nextToken();
                switch (tt) {
                    case -3: {
                        if (!this.st.sval.equals("list") && !this.st.sval.equals("ls")) ** GOTO lbl41
                        tt = this.doList();
                        ** GOTO lbl31
lbl41:
                        // 1 sources

                        if (!this.st.sval.equals("where") && !this.st.sval.equals("wh")) ** GOTO lbl44
                        tt = this.doWhere();
                        ** GOTO lbl31
lbl44:
                        // 1 sources

                        if (!this.st.sval.equals("machines") && !this.st.sval.equals("se")) ** GOTO lbl47
                        tt = this.doMachines();
                        ** GOTO lbl31
lbl47:
                        // 1 sources

                        if (!this.st.sval.equals("classes") && !this.st.sval.equals("cl")) ** GOTO lbl50
                        tt = this.doClasses();
                        ** GOTO lbl31
lbl50:
                        // 1 sources

                        if (!this.st.sval.equals("constr") && !this.st.sval.equals("co")) ** GOTO lbl53
                        tt = this.doConstr();
                        ** GOTO lbl31
lbl53:
                        // 1 sources

                        if (!this.st.sval.equals("ping") && !this.st.sval.equals("pg")) ** GOTO lbl56
                        tt = this.doPing();
                        ** GOTO lbl31
lbl56:
                        // 1 sources

                        if (!this.st.sval.equals("help") && !this.st.sval.equals("h") && !this.st.sval.equals("?")) ** GOTO lbl59
                        tt = this.doHelp();
                        ** GOTO lbl31
lbl59:
                        // 1 sources

                        if (!this.st.sval.equals("reset")) ** GOTO lbl62
                        tt = this.doReset();
                        ** GOTO lbl31
lbl62:
                        // 1 sources

                        if (!this.st.sval.equals("kill")) ** GOTO lbl65
                        tt = this.doKill();
                        ** GOTO lbl31
lbl65:
                        // 1 sources

                        if (!this.st.sval.equals("exit") && !this.st.sval.equals("x")) continue block6;
                        if (this.doExit()) break block6;
                        tt = this.st.ttype;
                        ** GOTO lbl31
                    }
                    case 10: {
                        ** GOTO lbl31
                    }
                    default: {
                        this.error();
                        tt = this.st.ttype;
                        continue block6;
                    }
                }
            }
            System.exit(0);
            return;
        }
        catch (IOException var3_3) {
            System.out.println("I/O failure");
            return;
        }
    }

    protected void _init() {
        this.st = new StreamTokenizer(System.in);
    }

    static {
        int _location = RuntimeEnvironment.getMachineID();
        try {
            _class = (RuntimeExplorer_class_intf)RuntimeEnvironment.rm.getClassInitializer("jp.lang.RuntimeExplorer", _location);
            if (_class == null) {
                RuntimeExplorer_class_impl _classImpl = new RuntimeExplorer_class_impl(false);
                _class = (RuntimeExplorer_class_intf)_classImpl._getStub();
                RuntimeEnvironment.rm.setClassObject("jp.lang.RuntimeExplorer", _class);
            }
        }
        catch (RemoteException _e) {
            throw new RemoteError("RuntimeExplorer_class_impl.<clinit>()", (Exception)((Object)_e));
        }
        catch (Exception _e) {
            _e.printStackTrace();
            throw new InternalError(String.valueOf("RuntimeExplorer_class_impl.<clinit>(): ").concat(String.valueOf(_e)));
        }
    }
}

