/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jp.lang.ClassDistributor;
import jp.lang.ConfigJP;
import jp.lang.ConfigurationException;
import jp.lang.Distributor;
import jp.lang.Monitor;
import jp.lang.ObjectDistributor;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.Patchable;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.TransportDescriptor;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class ConfigRM
extends ConfigJP
implements Patchable,
Transportable {
    public static final TransportDescriptor TRANSPORT_DESCRIPTOR = new TransportDescriptor(){

        public Object unmarshalReference(UnmarshalStream s, int n) throws IOException, ClassNotFoundException {
            return new ConfigRM(s, n);
        }

        public boolean unmarshal(Object obj, UnmarshalStream unmarshalStream) throws ClassNotFoundException, IOException {
            ((ConfigRM)obj).unmarshal(unmarshalStream);
            return false;
        }

        public void marshalReference(Object obj, MarshalStream marshalStream) throws IOException {
            ((ConfigRM)obj).marshalReference(marshalStream);
        }

        public void marshal(Object obj, MarshalStream marshalStream) throws IOException {
            ((ConfigRM)obj).marshal(marshalStream);
        }

        public Object deepClone(Object orig, int id, DeepClone _helper) throws CloneNotSupportedException {
            try {
                return new ConfigRM((ConfigRM)orig, id, _helper);
            }
            catch (IOException iOException) {
                throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(iOException);
            }
        }

        public boolean deepCloneReferences(Object orig, Object copy, DeepClone deepClone) throws CloneNotSupportedException {
            ((ConfigRM)copy).deepCloneReferences((ConfigRM)orig, deepClone);
            return false;
        }

        public Class getType() {
            return Class.forName("jp.lang.ConfigRM");
        }
    };
    private static final int _SIZE = 2;
    public boolean compatibility = true;
    public Distributor objDistr = null;
    public Distributor classDistr = null;
    public Monitor monitor = null;
    public boolean passive = false;
    public ArrayList nodeNames;

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        ConfigRM configRM = (ConfigRM)_copy;
        super.createPatch(configRM, po);
        if (po.writeDiff(this.passive, configRM.passive)) {
            configRM.passive = this.passive;
        }
        if (po.writeDiff(this.compatibility, configRM.compatibility)) {
            configRM.compatibility = this.compatibility;
        }
        configRM.nodeNames = this.nodeNames = (ArrayList)po.writeDiff((Object)this.nodeNames, (Object)configRM.nodeNames);
        configRM.monitor = this.monitor = (Monitor)po.writeDiff((Object)this.monitor, (Object)configRM.monitor);
        configRM.classDistr = this.classDistr = (Distributor)po.writeDiff((Object)this.classDistr, (Object)configRM.classDistr);
        configRM.objDistr = this.objDistr = (Distributor)po.writeDiff((Object)this.objDistr, (Object)configRM.objDistr);
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        ConfigRM configRM = (ConfigRM)_copy;
        super.applyPatch(configRM, pi);
        if (pi.hasDiff()) {
            configRM.passive = this.passive = pi.getDiffAsBoolean();
        }
        if (pi.hasDiff()) {
            configRM.compatibility = this.compatibility = pi.getDiffAsBoolean();
        }
        if (pi.hasDiff()) {
            configRM.nodeNames = this.nodeNames = (ArrayList)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            configRM.monitor = this.monitor = (Monitor)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            configRM.classDistr = this.classDistr = (Distributor)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            configRM.objDistr = this.objDistr = (Distributor)pi.getDiffAsObject();
        }
    }

    public void descendReferences(ReferenceConsumer referenceConsumer) throws IOException {
        super.descendReferences(referenceConsumer);
        referenceConsumer.descend((Object)this.nodeNames);
        referenceConsumer.descend((Object)this.monitor);
        referenceConsumer.descend((Object)this.classDistr);
        referenceConsumer.descend((Object)this.objDistr);
    }

    public void filterReferences(ReferenceFilter referenceFilter) {
        super.filterReferences(referenceFilter);
        this.nodeNames = (ArrayList)referenceFilter.filter((Object)this.nodeNames);
        this.monitor = (Monitor)referenceFilter.filter((Object)this.monitor);
        this.classDistr = (Distributor)referenceFilter.filter((Object)this.classDistr);
        this.objDistr = (Distributor)referenceFilter.filter((Object)this.objDistr);
    }

    public TransportDescriptor getTransportDescriptor() {
        return TRANSPORT_DESCRIPTOR;
    }

    public ConfigRM(UnmarshalStream _stream, int n) throws IOException, ClassNotFoundException {
        super(_stream, n);
    }

    public void unmarshal(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        super.unmarshal(_stream);
        _stream.request(2);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.passive = BasicIO.extractBoolean((byte[])_buffer, (int)n);
        this.compatibility = BasicIO.extractBoolean((byte[])_buffer, (int)(++n));
        ++n;
        _stream.accept(2);
        this.nodeNames = (ArrayList)_stream.readReference();
        this.monitor = (Monitor)_stream.readReference();
        this.classDistr = (Distributor)_stream.readReference();
        this.objDistr = (Distributor)_stream.readReference();
    }

    public void marshal(MarshalStream _stream) throws IOException {
        super.marshal(_stream);
        _stream.reserve(2);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        n = BasicIO.insert((byte[])_buffer, (int)n, (boolean)this.passive);
        n = BasicIO.insert((byte[])_buffer, (int)n, (boolean)this.compatibility);
        _stream.deliver(2);
        _stream.writeReference((Object)this.nodeNames);
        _stream.writeReference((Object)this.monitor);
        _stream.writeReference((Object)this.classDistr);
        _stream.writeReference((Object)this.objDistr);
    }

    public ConfigRM(ConfigRM _orig, int _id, DeepClone deepClone) throws CloneNotSupportedException, IOException {
        super(_orig, _id, deepClone);
        this.passive = _orig.passive;
        this.compatibility = _orig.compatibility;
    }

    public void deepCloneReferences(ConfigRM _orig, DeepClone deepClone) throws CloneNotSupportedException {
        super.deepCloneReferences(_orig, deepClone);
        this.nodeNames = (ArrayList)deepClone.internalDeepClone((Object)_orig.nodeNames);
        this.monitor = (Monitor)deepClone.internalDeepClone((Object)_orig.monitor);
        this.classDistr = (Distributor)deepClone.internalDeepClone((Object)_orig.classDistr);
        this.objDistr = (Distributor)deepClone.internalDeepClone((Object)_orig.objDistr);
    }

    public ConfigRM() {
        this.objDistr = new ObjectDistributor();
        this.classDistr = new ClassDistributor();
    }

    public String programName() {
        return "jprm";
    }

    public String argumentDescription() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.argumentDescription()).concat(String.valueOf("[-nodenames <comma separated list of node names>] "))).concat(String.valueOf("[-passive] "))).concat(String.valueOf("[-initLazy] "))).concat(String.valueOf("[-initStrict] "))).concat(String.valueOf("[-objDistr <object distributor class>] "))).concat(String.valueOf("[-classDistr <class distributor class>] "))).concat(String.valueOf("[-monitor <monitor class>] "));
    }

    public void setObjectDistributor(Distributor distributor) {
        this.objDistr = distributor;
    }

    public void setClassDistributor(Distributor distributor) {
        this.classDistr = distributor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public int init(String[] args, int n) throws ConfigurationException {
        String arg = args[n++];
        try {
            if (arg.equals("-initLazy")) {
                this.compatibility = false;
                return n;
            }
            if (arg.equals("-initStrict")) {
                this.compatibility = true;
                return n;
            }
            if (arg.equals("-objDistr")) {
                this.setObjectDistributor((Distributor)Class.forName(args[n++]).newInstance());
                return n;
            }
            if (arg.equals("-classDistr")) {
                this.setClassDistributor((Distributor)Class.forName(args[n++]).newInstance());
                return n;
            }
            if (arg.equals("-monitor")) {
                this.setMonitor((Monitor)Class.forName(args[n++]).newInstance());
                return n;
            }
            if (arg.equals("-passive")) {
                this.passive = true;
                return n;
            }
            if (arg.equals("-nodenames")) {
                if (this.nodeNames != null) {
                    throw new ConfigurationException("only one -nodenames or -nodefile argument possible");
                }
                this.nodeNames = new ArrayList();
                if (args[n].startsWith("-")) {
                    throw new ConfigurationException("missing list of node names");
                }
                StringTokenizer tokens = new StringTokenizer(args[n++], ", ");
                while (tokens.hasMoreTokens()) {
                    this.nodeNames.add(tokens.nextToken());
                }
                return n;
            }
            if (arg.equals("-nodefile")) {
                if (this.nodeNames != null) {
                    throw new ConfigurationException("only one -nodenames or -nodefile argument possible");
                }
                this.nodeNames = new ArrayList();
                try {
                    String nodeName;
                    File nodefile = new File(args[n++]);
                    BufferedReader nodeReader = new BufferedReader(new FileReader(nodefile));
                    while ((nodeName = nodeReader.readLine()) != null) {
                        if ((nodeName = nodeName.trim()).length() == 0 || nodeName.startsWith("#")) continue;
                        this.nodeNames.add(nodeName);
                    }
                    return n;
                }
                catch (IOException ex) {
                    throw new ConfigurationException(String.valueOf("can not read nodefile: ").concat(String.valueOf(ex)));
                }
            }
            return super.init(args, n - 1);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf("distributor/monitor class '").concat(String.valueOf(args[n - 1]))).concat(String.valueOf("' specified in option '"))).concat(String.valueOf(arg))).concat(String.valueOf("' not found")));
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("can't access distributor/monitor class '").concat(String.valueOf(args[n - 1]))).concat(String.valueOf("' specified in option '"))).concat(String.valueOf(arg))).concat(String.valueOf("': "))).concat(String.valueOf(ex)));
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("distributor/monitor class '").concat(String.valueOf(args[n - 1]))).concat(String.valueOf("' specified in option '"))).concat(String.valueOf(arg))).concat(String.valueOf("' could not be instantiated: "))).concat(String.valueOf(ex)));
        }
        catch (ClassCastException classCastException) {
            if (arg.equals("-objDistr") || arg.equals("-classDistr")) {
                throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("argument specified in option '").concat(String.valueOf(arg))).concat(String.valueOf("' is not a subclass of "))).concat(String.valueOf(Class.forName("jp.lang.Distributor").getName()))).concat(String.valueOf(" ('"))).concat(String.valueOf(args[n - 1]))).concat(String.valueOf("')")));
            }
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("argument specified in option '").concat(String.valueOf(arg))).concat(String.valueOf("' is not a subclass of "))).concat(String.valueOf(Class.forName("jp.lang.Monitor").getName()))).concat(String.valueOf(" ('"))).concat(String.valueOf(args[n - 1]))).concat(String.valueOf("')")));
        }
    }
}

