/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.IOException;
import jp.lang.ConfigBase;
import jp.lang.ConfigurationException;
import jp.lang.Constants;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.Patchable;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public abstract class ConfigJP
extends ConfigBase
implements Patchable,
Transportable,
Constants {
    private static final int _SIZE = 10;
    public String host = null;
    public int port = -1;
    public String code = null;
    public int timeout = 10;
    public boolean verbose = false;
    public boolean debug = false;

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        ConfigJP configJP = (ConfigJP)_copy;
        super.createPatch(configJP, po);
        if (po.writeDiff(this.debug, configJP.debug)) {
            configJP.debug = this.debug;
        }
        if (po.writeDiff(this.verbose, configJP.verbose)) {
            configJP.verbose = this.verbose;
        }
        if (po.writeDiff(this.timeout, configJP.timeout)) {
            configJP.timeout = this.timeout;
        }
        if (po.writeDiff(this.port, configJP.port)) {
            configJP.port = this.port;
        }
        configJP.code = this.code = (String)po.writeDiff((Object)this.code, (Object)configJP.code);
        configJP.host = this.host = (String)po.writeDiff((Object)this.host, (Object)configJP.host);
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        ConfigJP configJP = (ConfigJP)_copy;
        super.applyPatch(configJP, pi);
        if (pi.hasDiff()) {
            configJP.debug = this.debug = pi.getDiffAsBoolean();
        }
        if (pi.hasDiff()) {
            configJP.verbose = this.verbose = pi.getDiffAsBoolean();
        }
        if (pi.hasDiff()) {
            configJP.timeout = this.timeout = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            configJP.port = this.port = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            configJP.code = this.code = (String)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            configJP.host = this.host = (String)pi.getDiffAsObject();
        }
    }

    public void descendReferences(ReferenceConsumer referenceConsumer) throws IOException {
        super.descendReferences(referenceConsumer);
        referenceConsumer.descend((Object)this.code);
        referenceConsumer.descend((Object)this.host);
    }

    public void filterReferences(ReferenceFilter referenceFilter) {
        super.filterReferences(referenceFilter);
        this.code = (String)referenceFilter.filter((Object)this.code);
        this.host = (String)referenceFilter.filter((Object)this.host);
    }

    public ConfigJP(UnmarshalStream _stream, int n) throws IOException, ClassNotFoundException {
        super(_stream, n);
    }

    public void unmarshal(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        super.unmarshal(_stream);
        _stream.request(10);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.debug = BasicIO.extractBoolean((byte[])_buffer, (int)n);
        this.verbose = BasicIO.extractBoolean((byte[])_buffer, (int)(++n));
        this.timeout = BasicIO.extractInt((byte[])_buffer, (int)(++n));
        this.port = BasicIO.extractInt((byte[])_buffer, (int)(n += 4));
        n += 4;
        _stream.accept(10);
        this.code = (String)_stream.readReference();
        this.host = (String)_stream.readReference();
    }

    public void marshal(MarshalStream _stream) throws IOException {
        super.marshal(_stream);
        _stream.reserve(10);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        n = BasicIO.insert((byte[])_buffer, (int)n, (boolean)this.debug);
        n = BasicIO.insert((byte[])_buffer, (int)n, (boolean)this.verbose);
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.timeout);
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.port);
        _stream.deliver(10);
        _stream.writeReference((Object)this.code);
        _stream.writeReference((Object)this.host);
    }

    public ConfigJP(ConfigJP _orig, int _id, DeepClone deepClone) throws CloneNotSupportedException, IOException {
        super(_orig, _id, deepClone);
        this.debug = _orig.debug;
        this.verbose = _orig.verbose;
        this.timeout = _orig.timeout;
        this.port = _orig.port;
    }

    public void deepCloneReferences(ConfigJP _orig, DeepClone deepClone) throws CloneNotSupportedException {
        super.deepCloneReferences(_orig, deepClone);
        this.code = (String)deepClone.internalDeepClone((Object)_orig.code);
        this.host = (String)deepClone.internalDeepClone((Object)_orig.host);
    }

    public ConfigJP() {
    }

    public String argumentDescription() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.argumentDescription()).concat(String.valueOf("[-host <runtime manager host>] "))).concat(String.valueOf("[-port <runtime manager port>] "))).concat(String.valueOf("[-code <runtime manager access code>] "))).concat(String.valueOf("[-timeout <sec>] "))).concat(String.valueOf("[-verbose] "))).concat(String.valueOf("[-debug] "))).concat(String.valueOf("[-version] "));
    }

    public int init(String[] args, int n) throws NumberFormatException, ConfigurationException {
        String string;
        if ((string = args[n++]).equals("-host")) {
            this.host = args[n++];
            return n;
        }
        if (string.equals("-port")) {
            this.port = Integer.parseInt(args[n++]);
            return n;
        }
        if (string.equals("-timeout")) {
            this.timeout = Integer.parseInt(args[n++]);
            return n;
        }
        if (string.equals("-code")) {
            this.code = args[n++];
            return n;
        }
        if (string.equals("-verbose")) {
            this.verbose = true;
            return n;
        }
        if (string.equals("-debug")) {
            this.debug = true;
            return n;
        }
        if (string.equals("-version")) {
            System.out.println("JavaParty, Version 1.9.5");
            this.stop();
            return n;
        }
        return super.init(args, n - 1);
    }
}

