/*
 * Decompiled with CFR 0.152.
 */
package jp.example.rmiserver;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import jp.example.rmiserver.PartyConfig;
import jp.example.rmiserver.PartyServer_intf;
import jp.example.rmiserver.PartyWorker;
import jp.lang.ApplicationContext;
import jp.lang.Configuration;
import jp.lang.DistributedRuntime;
import jp.lang.RuntimeEnvironment;
import jp.lang.RuntimeManager;

public class PartyServer
extends UnicastRemoteObject
implements PartyServer_intf {
    PartyConfig config;
    int size;
    int nr = 0;

    PartyServer(PartyConfig config) throws RemoteException {
        this.config = config;
        this.size = DistributedRuntime.getMachineCnt();
    }

    public void gotoParty() {
        if (this.config.verbose) {
            System.err.println("Request for party");
        }
        PartyWorker worker = new PartyWorker(this.nr++);
        if (this.config.verbose) {
            System.err.println("Starting party");
        }
        worker.party();
    }

    public static void main(String[] args) throws Exception {
        PartyConfig config = new PartyConfig();
        config.init(args);
        Configuration configuration = new Configuration(config.debug, config.host, config.port, config.code);
        if (config.verbose) {
            System.err.println("Looking up the RuntimeManager");
        }
        RuntimeManager rm = configuration.getRuntimeManager(0);
        ApplicationContext context = rm.allocateContext();
        RuntimeEnvironment.init(rm, context);
        if (config.verbose) {
            System.err.println("Creating the local RMI registry");
        }
        Registry registry = LocateRegistry.createRegistry(1099);
        if (config.verbose) {
            System.err.println("Binding the PartyServer in the registry");
        }
        registry.bind("PartyServer", new PartyServer(config));
    }
}

