/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class List<A> {
    public A head;
    public List<A> tail;

    public List(A head, List<A> list) {
        this.tail = list;
        this.head = head;
    }

    public List() {
        this(null, null);
    }

    public List(A a) {
        this(a, new List<A>());
    }

    public static <A> List<A> make(A x1) {
        return new List<A>(x1, new List<A>());
    }

    public static <A> List<A> make(A x1, A x2) {
        return new List<A>(x1, new List<A>(x2, new List<A>()));
    }

    public static <A> List<A> make(A x1, A x2, A x3) {
        return new List<A>(x1, new List<A>(x2, new List<A>(x3, new List<A>())));
    }

    public static <A> List<A> make(A[] vec) {
        List<A> xs = new List<A>();
        for (int i = vec.length - 1; i >= 0; --i) {
            xs = new List<A>(vec[i], xs);
        }
        return xs;
    }

    public static <A> List<A> make(int len, A init) {
        List<A> l = new List<A>();
        for (int i = 0; i < len; ++i) {
            l = new List<A>(init, l);
        }
        return l;
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        List<A> l = this;
        int n = 0;
        while (l.tail != null) {
            l = l.tail;
            ++n;
        }
        return n;
    }

    public List<A> prepend(A a) {
        return new List<A>(a, this);
    }

    public List<A> prepend(List<A> list) {
        if (this.isEmpty()) {
            return list;
        }
        if (list.isEmpty()) {
            return this;
        }
        return this.prepend(list.tail).prepend(list.head);
    }

    public List<A> reverse() {
        List<A> rev = new List<A>();
        List<A> list = this;
        while (list.nonEmpty()) {
            rev = new List<A>(list.head, rev);
            list = list.tail;
        }
        return rev;
    }

    public A[] copy(A[] vec) {
        List<A> list = this;
        for (int i = 0; list.nonEmpty() && i < vec.length; ++i) {
            vec[i] = list.head;
            list = list.tail;
        }
        return vec;
    }

    public String toString(String sep) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.head.toString());
        List<A> list = this.tail;
        while (list.nonEmpty()) {
            buf.append(sep);
            buf.append(list.head.toString());
            list = list.tail;
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(",");
    }

    public int hashCode() {
        List<A> l = this;
        int n = 0;
        while (l.tail != null) {
            n = n * 41 + (this.head != null ? this.head.hashCode() : 0);
            l = l.tail;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof List && List.equals(this, (List)object);
    }

    public static boolean equals(List xs, List ys) {
        while (xs.tail != null && ys.tail != null) {
            if (xs.head == null ? ys.head != null : !xs.head.equals(ys.head)) {
                return false;
            }
            xs = xs.tail;
            ys = ys.tail;
        }
        return xs.tail == null && ys.tail == null;
    }

    public boolean contains(A x) {
        List<A> list = this;
        while (list.tail != null && !list.head.equals(x)) {
            list = list.tail;
        }
        return list.tail != null;
    }

    public boolean subset(List<A> ys) {
        List<A> list = this;
        while (list.tail != null && ys.contains(list.head)) {
            list = list.tail;
        }
        return list.tail == null;
    }
}

