/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

import gjc.v6.util.Name;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int n) {
        this.elems = new byte[n];
        this.length = 0;
    }

    private void copy(int size) {
        byte[] byArray = new byte[size];
        System.arraycopy(this.elems, 0, byArray, 0, this.elems.length);
        this.elems = byArray;
    }

    public void appendByte(int n) {
        if (this.length >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length++] = (byte)n;
    }

    public void appendBytes(byte[] bs, int start, int n) {
        while (this.length + n > this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        System.arraycopy(bs, start, this.elems, this.length, n);
        this.length += n;
    }

    public void appendBytes(byte[] byArray) {
        this.appendBytes(byArray, 0, byArray.length);
    }

    public void appendChar(int n) {
        while (this.length + 1 >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(n & 0xFF);
        this.length += 2;
    }

    public void appendInt(int n) {
        while (this.length + 3 >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length] = (byte)(n >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(n >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(n & 0xFF);
        this.length += 4;
    }

    public void appendLong(long x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeLong(x);
            this.appendBytes(buffer.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    public void appendFloat(float x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeFloat(x);
            this.appendBytes(buffer.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    public void appendDouble(double x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeDouble(x);
            this.appendBytes(buffer.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    public void appendName(Name name) {
        this.appendBytes(Name.names, name.index, name.len);
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName() {
        return Name.fromUtf(this.elems, 0, this.length);
    }
}

