/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.tree;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.tree.Tree;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMaker
implements Tree.Factory,
Kinds,
Flags,
TypeTags {
    public int pos;
    public int internalPos;
    public Tree.TopLevel toplevel;
    public static TreeMaker make = new TreeMaker();

    public TreeMaker() {
        this.pos = 0;
        this.internalPos = 0;
        this.toplevel = null;
    }

    public TreeMaker(Tree.TopLevel topLevel) {
        this.pos = 1025;
        this.internalPos = 1025;
        this.toplevel = topLevel;
    }

    public TreeMaker at(int n) {
        this.pos = n;
        this.internalPos = n;
        return this;
    }

    @Override
    public Tree.TopLevel TopLevel(Tree pid, List<Tree> defs) {
        Tree.TopLevel topLevel = new Tree.TopLevel(pid, defs, null, null, null, null);
        topLevel.setPos(this.pos, this.internalPos);
        return topLevel;
    }

    @Override
    public Tree.Import Import(Tree qualid) {
        Tree.Import import_ = new Tree.Import(qualid);
        import_.setPos(this.pos, this.internalPos);
        return import_;
    }

    @Override
    public Tree.ClassDef ClassDef(int flags, Name name, List<Tree.TypeParameter> typarams, Tree extending, List<Tree> implementing, List<Tree> defs) {
        Tree.ClassDef classDef = new Tree.ClassDef(flags, name, typarams, extending, implementing, defs, null);
        classDef.setPos(this.pos, this.internalPos);
        return classDef;
    }

    @Override
    public Tree.MethodDef MethodDef(int flags, Name name, Tree restype, List<Tree.TypeParameter> typarams, List<Tree.VarDef> params, List<Tree> thrown, Tree.Block body) {
        Tree.MethodDef methodDef = new Tree.MethodDef(flags, name, restype, typarams, params, thrown, body, null);
        methodDef.setPos(this.pos, this.internalPos);
        return methodDef;
    }

    @Override
    public Tree.VarDef VarDef(int flags, Name name, Tree vartype, Tree init) {
        Tree.VarDef varDef = new Tree.VarDef(flags, name, vartype, init, null);
        varDef.setPos(this.pos, this.internalPos);
        return varDef;
    }

    @Override
    public Tree.Block Block(int flags, List<Tree> stats) {
        Tree.Block block = new Tree.Block(flags, stats);
        block.setPos(this.pos, this.internalPos);
        return block;
    }

    @Override
    public Tree.DoLoop DoLoop(Tree body, Tree cond) {
        Tree.DoLoop doLoop = new Tree.DoLoop(body, cond);
        doLoop.setPos(this.pos, this.internalPos);
        return doLoop;
    }

    @Override
    public Tree.WhileLoop WhileLoop(Tree cond, Tree body) {
        Tree.WhileLoop whileLoop = new Tree.WhileLoop(cond, body);
        whileLoop.setPos(this.pos, this.internalPos);
        return whileLoop;
    }

    @Override
    public Tree.ForLoop ForLoop(List<Tree> init, Tree cond, List<Tree> step, Tree body) {
        Tree.ForLoop forLoop = new Tree.ForLoop(init, cond, step, body);
        forLoop.setPos(this.pos, this.internalPos);
        return forLoop;
    }

    @Override
    public Tree.Labelled Labelled(Name label, Tree body) {
        Tree.Labelled labelled = new Tree.Labelled(label, body);
        labelled.setPos(this.pos, this.internalPos);
        return labelled;
    }

    @Override
    public Tree.Switch Switch(Tree selector, List<Tree.Case> cases) {
        Tree.Switch switch_ = new Tree.Switch(selector, cases);
        switch_.setPos(this.pos, this.internalPos);
        return switch_;
    }

    @Override
    public Tree.Case Case(Tree pat, List<Tree> stats) {
        Tree.Case case_ = new Tree.Case(pat, stats);
        case_.setPos(this.pos, this.internalPos);
        return case_;
    }

    @Override
    public Tree.Synchronized Synchronized(Tree lock, Tree body) {
        Tree.Synchronized synchronized_ = new Tree.Synchronized(lock, body);
        synchronized_.setPos(this.pos, this.internalPos);
        return synchronized_;
    }

    @Override
    public Tree.Try Try(Tree body, List<Tree.Catch> catchers, Tree finalizer) {
        Tree.Try try_ = new Tree.Try(body, catchers, finalizer);
        try_.setPos(this.pos, this.internalPos);
        return try_;
    }

    @Override
    public Tree.Catch Catch(Tree.VarDef param, Tree body) {
        Tree.Catch catch_ = new Tree.Catch(param, body);
        catch_.setPos(this.pos, this.internalPos);
        return catch_;
    }

    @Override
    public Tree.Conditional Conditional(int tag, Tree cond, Tree thenpart, Tree elsepart) {
        Tree.Conditional conditional = new Tree.Conditional(tag, cond, thenpart, elsepart);
        conditional.setPos(this.pos, this.internalPos);
        return conditional;
    }

    @Override
    public Tree.Assert Assert(Tree cond, Tree msg) {
        Tree.Assert assert_ = new Tree.Assert(cond, msg);
        assert_.setPos(this.pos, this.internalPos);
        return assert_;
    }

    @Override
    public Tree.Exec Exec(Tree expr) {
        Tree.Exec exec = new Tree.Exec(expr);
        exec.setPos(this.pos, this.internalPos);
        return exec;
    }

    @Override
    public Tree.Break Break(Name label) {
        Tree.Break break_ = new Tree.Break(label, null);
        break_.setPos(this.pos, this.internalPos);
        return break_;
    }

    @Override
    public Tree.Continue Continue(Name label) {
        Tree.Continue continue_ = new Tree.Continue(label, null);
        continue_.setPos(this.pos, this.internalPos);
        return continue_;
    }

    @Override
    public Tree.Return Return(Tree expr) {
        Tree.Return return_ = new Tree.Return(expr);
        return_.setPos(this.pos, this.internalPos);
        return return_;
    }

    @Override
    public Tree.Throw Throw(Tree expr) {
        Tree.Throw throw_ = new Tree.Throw(expr);
        throw_.setPos(this.pos, this.internalPos);
        return throw_;
    }

    @Override
    public Tree.Apply Apply(Tree fn, List<Tree> args) {
        Tree.Apply apply = new Tree.Apply(fn, args);
        apply.setPos(this.pos, this.internalPos);
        return apply;
    }

    @Override
    public Tree.NewClass NewClass(Tree encl, Tree clazz, List<Tree> args, Tree.ClassDef def) {
        Tree.NewClass newClass = new Tree.NewClass(encl, clazz, args, def, null);
        newClass.setPos(this.pos, this.internalPos);
        return newClass;
    }

    @Override
    public Tree.NewArray NewArray(Tree elemtype, List<Tree> dims, List<Tree> elems) {
        Tree.NewArray newArray = new Tree.NewArray(elemtype, dims, elems);
        newArray.setPos(this.pos, this.internalPos);
        return newArray;
    }

    @Override
    public Tree.Assign Assign(Tree lhs, Tree rhs) {
        Tree.Assign assign = new Tree.Assign(lhs, rhs);
        assign.setPos(this.pos, this.internalPos);
        return assign;
    }

    @Override
    public Tree.Assignop Assignop(int opcode, Tree lhs, Tree rhs) {
        Tree.Assignop assignop = new Tree.Assignop(opcode, lhs, rhs, null);
        assignop.setPos(this.pos, this.internalPos);
        return assignop;
    }

    @Override
    public Tree.Operation Operation(int opcode, List<Tree> args) {
        Tree.Operation operation = new Tree.Operation(opcode, args, null);
        operation.setPos(this.pos, this.internalPos);
        return operation;
    }

    @Override
    public Tree.TypeCast TypeCast(Tree clazz, Tree expr) {
        Tree.TypeCast typeCast = new Tree.TypeCast(clazz, expr);
        typeCast.setPos(this.pos, this.internalPos);
        return typeCast;
    }

    @Override
    public Tree.TypeTest TypeTest(Tree expr, Tree clazz) {
        Tree.TypeTest typeTest = new Tree.TypeTest(expr, clazz);
        typeTest.setPos(this.pos, this.internalPos);
        return typeTest;
    }

    @Override
    public Tree.Indexed Indexed(Tree indexed, Tree index) {
        Tree.Indexed indexed2 = new Tree.Indexed(indexed, index);
        indexed2.setPos(this.pos, this.internalPos);
        return indexed2;
    }

    @Override
    public Tree.Select Select(Tree selected, Name selector) {
        Tree.Select select = new Tree.Select(selected, selector, null);
        select.setPos(this.pos, this.internalPos);
        return select;
    }

    @Override
    public Tree.Ident Ident(Name name) {
        Tree.Ident ident = new Tree.Ident(name, null);
        ident.setPos(this.pos, this.internalPos);
        return ident;
    }

    @Override
    public Tree.Literal Literal(int tag, Object value) {
        Tree.Literal literal = new Tree.Literal(tag, value);
        literal.setPos(this.pos, this.internalPos);
        return literal;
    }

    @Override
    public Tree.TypeIdent TypeIdent(int typetag) {
        Tree.TypeIdent typeIdent = new Tree.TypeIdent(typetag);
        typeIdent.setPos(this.pos, this.internalPos);
        return typeIdent;
    }

    @Override
    public Tree.TypeArray TypeArray(Tree elemtype) {
        Tree.TypeArray typeArray = new Tree.TypeArray(elemtype);
        typeArray.setPos(this.pos, this.internalPos);
        return typeArray;
    }

    @Override
    public Tree.TypeApply TypeApply(Tree clazz, List<Tree> arguments) {
        Tree.TypeApply typeApply = new Tree.TypeApply(clazz, arguments);
        typeApply.setPos(this.pos, this.internalPos);
        return typeApply;
    }

    @Override
    public Tree.TypeParameter TypeParameter(Name name, Tree extBound, Tree implBound) {
        Tree.TypeParameter typeParameter = new Tree.TypeParameter(name, extBound, implBound);
        typeParameter.setPos(this.pos, this.internalPos);
        return typeParameter;
    }

    @Override
    public Tree.Erroneous Erroneous() {
        Tree.Erroneous erroneous = new Tree.Erroneous();
        erroneous.setPos(this.pos, this.internalPos);
        return erroneous;
    }

    public Tree.TopLevel setTopLevel(Tree.TopLevel toplevel) {
        Tree.TopLevel topLevel = this.toplevel;
        this.toplevel = toplevel;
        return topLevel;
    }

    public Tree Ident(Symbol symbol) {
        return new Tree.Ident(symbol.name, symbol).setPos(this.pos, this.internalPos).setType(symbol.type);
    }

    public Tree Select(Tree base, Symbol symbol) {
        return new Tree.Select(base, symbol.name, symbol).setPos(this.pos, this.internalPos).setType(symbol.type);
    }

    public Tree QualIdent(Symbol symbol) {
        return this.unqualifiable(symbol) ? this.Ident(symbol) : this.Select(this.QualIdent(symbol.owner), symbol);
    }

    public Tree Ident(Tree.VarDef varDef) {
        return this.Ident(varDef.sym);
    }

    public Tree App(Tree meth, List<Tree> args) {
        Type type = meth.type;
        meth.type = type.restype();
        return this.Apply(meth, args).setType(type.restype());
    }

    public List<Tree> Idents(List<Tree.VarDef> params) {
        ListBuffer<Tree> ids = new ListBuffer<Tree>();
        List<Tree.VarDef> list = params;
        while (list.nonEmpty()) {
            ids.append(this.Ident((Tree.VarDef)list.head));
            list = list.tail;
        }
        return ids.toList();
    }

    public Tree This(Type type) {
        return this.Ident(new Symbol.VarSymbol(16, Names._this, type, type.tsym));
    }

    public Tree Super(Type type) {
        return this.Ident(new Symbol.VarSymbol(16, Names._super, type, type.tsym));
    }

    public Tree Type(Type t) {
        Tree tp;
        if (t == null) {
            return null;
        }
        switch (t.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                tp = this.TypeIdent(t.tag);
                break;
            }
            case 14: {
                tp = this.Ident(t.tsym.name);
                break;
            }
            case 10: {
                Type outer = t.outer();
                Tree tree = outer.tag != 17 ? this.Select(this.Type(outer), t.tsym) : this.QualIdent(t.tsym);
                tp = t.typarams().isEmpty() ? tree : this.TypeApply(tree, this.Types(t.typarams()));
                break;
            }
            case 11: {
                tp = this.TypeArray(this.Type(t.elemtype()));
                break;
            }
            case 18: {
                tp = this.TypeIdent(18);
                break;
            }
            default: {
                throw new InternalError(String.valueOf("unexpected type: ").concat(String.valueOf(t)));
            }
        }
        return tp.setType(t);
    }

    public List<Tree> Types(List<Type> ts) {
        ListBuffer<Tree> types = new ListBuffer<Tree>();
        List<Type> list = ts;
        while (list.nonEmpty()) {
            types.append(this.Type((Type)list.head));
            list = list.tail;
        }
        return types.toList();
    }

    public List<Tree> Classes(List<Symbol.ClassSymbol> ts) {
        ListBuffer<Tree> classes = new ListBuffer<Tree>();
        List<Symbol.ClassSymbol> list = ts;
        while (list.nonEmpty()) {
            classes.append(this.Type(((Symbol.ClassSymbol)list.head).type.erasure()));
            list = list.tail;
        }
        return classes.toList();
    }

    public Tree.VarDef VarDef(Symbol.VarSymbol v, Tree tree) {
        return (Tree.VarDef)new Tree.VarDef(v.flags(), v.name, this.Type(v.type), tree, v).setPos(this.pos, this.internalPos).setType(v.type);
    }

    public Tree.MethodDef MethodDef(Symbol.MethodSymbol m, Tree.Block block) {
        return (Tree.MethodDef)new Tree.MethodDef(m.flags(), m.name, this.Type(m.type.restype()), this.TypeParams(m.type.typarams()), this.Params(m.type.argtypes(), m), this.Classes(m.type.thrown()), block, m).setPos(this.pos, this.internalPos).setType(m.type);
    }

    public Tree.TypeParameter TypeParam(Name name, Type.TypeVar tvar) {
        Tree extBound = null;
        Tree tree = null;
        if ((tvar.bound.tsym.flags() & 0x200) == 0) {
            extBound = this.Type(tvar.bound);
        } else {
            tree = this.Type(tvar.bound);
        }
        return (Tree.TypeParameter)this.TypeParameter(name, extBound, tree).setPos(this.pos, this.internalPos).setType(tvar);
    }

    public List<Tree.TypeParameter> TypeParams(List<Type> typarams) {
        ListBuffer<Tree.TypeParameter> tparams = new ListBuffer<Tree.TypeParameter>();
        int i = 0;
        List<Type> list = typarams;
        while (list.nonEmpty()) {
            tparams.append(this.TypeParam(this.typaramName(i++), (Type.TypeVar)list.head));
            list = list.tail;
        }
        return tparams.toList();
    }

    public Tree.VarDef Param(Name name, Type argtype, Symbol symbol) {
        return this.VarDef(new Symbol.VarSymbol(0, name, argtype, symbol), null);
    }

    public List<Tree.VarDef> Params(List<Type> argtypes, Symbol owner) {
        ListBuffer<Tree.VarDef> params = new ListBuffer<Tree.VarDef>();
        int i = 0;
        List<Type> list = argtypes;
        while (list.nonEmpty()) {
            params.append(this.Param(this.paramName(i++), (Type)list.head, owner));
            list = list.tail;
        }
        return params.toList();
    }

    public Tree Call(Tree tree) {
        return tree.type.tag == 9 ? this.Exec(tree) : this.Return(tree);
    }

    public Tree Assignment(Symbol v, Tree tree) {
        return this.Exec(this.Assign(this.Ident(v), tree).setType(v.type));
    }

    boolean unqualifiable(Symbol sym) {
        if (sym.kind == 2 && this.toplevel != null) {
            Scope.Entry entry = this.toplevel.namedImportScope.lookup(sym.name);
            if (entry.scope != null) {
                return entry.sym == sym && entry.next().scope == null;
            }
            entry = this.toplevel.packge.members().lookup(sym.name);
            if (entry.scope != null) {
                return entry.sym == sym && entry.next().scope == null;
            }
            entry = this.toplevel.starImportScope.lookup(sym.name);
            if (entry.scope != null) {
                return entry.sym == sym && entry.next().scope == null;
            }
            return false;
        }
        return sym.owner == null || sym.owner.name == Names.empty || (sym.owner.kind & 0x24) != 0;
    }

    Name paramName(int n) {
        return Name.fromString(String.valueOf("x").concat(String.valueOf(n)));
    }

    Name typaramName(int n) {
        return Name.fromString(String.valueOf("A").concat(String.valueOf(n)));
    }
}

