/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.tree;

import gjc.v6.code.Flags;
import gjc.v6.code.Symbol;
import gjc.v6.tree.Tree;
import gjc.v6.util.List;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeInfo
implements Flags {
    private static final String[] flagName = new String[]{"public", "private", "protected", "static", "final", "synchronized", "volatile", "transient", "native", "interface", "abstract", "remote", "const", "/** @embedded */"};
    private static Name[] opname = new Name[27];
    public static final int noPrec = 0;
    public static final int assignPrec = 1;
    public static final int assignopPrec = 2;
    public static final int condPrec = 3;
    public static final int orPrec = 4;
    public static final int andPrec = 5;
    public static final int bitorPrec = 6;
    public static final int bitxorPrec = 7;
    public static final int bitandPrec = 8;
    public static final int eqPrec = 9;
    public static final int ordPrec = 10;
    public static final int shiftPrec = 11;
    public static final int addPrec = 12;
    public static final int mulPrec = 13;
    public static final int prefixPrec = 14;
    public static final int postfixPrec = 15;
    public static final int precCount = 16;

    public static boolean isConstructor(Tree tree) {
        return tree.tag == 4 && ((Tree.MethodDef)tree).name == Names.init;
    }

    public static boolean hasConstructors(List<Tree> trees) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            if (TreeInfo.isConstructor((Tree)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public static boolean isSyntheticInit(Tree stat) {
        if (stat.tag == 18) {
            Tree.Exec exec = (Tree.Exec)stat;
            if (exec.expr.tag == 26) {
                Tree.Assign assign = (Tree.Assign)exec.expr;
                if (assign.lhs.tag == 30) {
                    Tree.Select select = (Tree.Select)assign.lhs;
                    if ((select.sym.flags() & 0x10000) != 0 && TreeInfo.name(select.selected) == Names._this) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isInitialConstructor(Tree tree) {
        if (tree.tag != 4) {
            return false;
        }
        Tree.MethodDef md = (Tree.MethodDef)tree;
        if (md.name != Names.init && md.name != Names.clinit) {
            return false;
        }
        if (md.body != null && md.body.stats.nonEmpty() && ((Tree)md.body.stats.head).tag == 18) {
            Tree.Exec exec = (Tree.Exec)md.body.stats.head;
            if (exec.expr.tag == 23) {
                Tree.Apply apply = (Tree.Apply)exec.expr;
                if (TreeInfo.name(apply.meth) == Names._this) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Name name(Tree tree) {
        switch (tree.tag) {
            case 31: {
                return ((Tree.Ident)tree).name;
            }
            case 30: {
                return ((Tree.Select)tree).name;
            }
            case 35: {
                return TreeInfo.name(((Tree.TypeApply)tree).clazz);
            }
        }
        return null;
    }

    public static Name fullName(Tree tree) {
        switch (tree.tag) {
            case 31: {
                return ((Tree.Ident)tree).name;
            }
            case 30: {
                Name sname = TreeInfo.fullName(((Tree.Select)tree).selected);
                return sname == null ? null : Name.fromString(String.valueOf(String.valueOf(sname).concat(String.valueOf("."))).concat(String.valueOf(TreeInfo.name(tree))));
            }
        }
        return null;
    }

    public static Symbol symbol(Tree tree) {
        switch (tree.tag) {
            case 31: {
                return ((Tree.Ident)tree).sym;
            }
            case 30: {
                return ((Tree.Select)tree).sym;
            }
        }
        return null;
    }

    public static void setSymbol(Tree tree, Symbol sym) {
        switch (tree.tag) {
            case 31: {
                ((Tree.Ident)tree).sym = sym;
                break;
            }
            case 30: {
                ((Tree.Select)tree).sym = sym;
                break;
            }
        }
    }

    public static int flags(Tree tree) {
        switch (tree.tag) {
            case 5: {
                return ((Tree.VarDef)tree).flags;
            }
            case 4: {
                return ((Tree.MethodDef)tree).flags;
            }
            case 3: {
                return ((Tree.ClassDef)tree).flags;
            }
            case 6: {
                return ((Tree.Block)tree).flags;
            }
            case 30: {
                return ((Tree.Select)tree).sym.flags();
            }
        }
        return 0;
    }

    public static int firstFlag(int flags) {
        int flag = 1;
        while ((flag & 0x2FFF) != 0 && (flag & flags) == 0) {
            flag <<= 1;
        }
        return flag;
    }

    public static String flagNames(int flags) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        int f = flags & 0x2FFF;
        while (f != 0) {
            if ((f & 1) != 0) {
                if (sbuf.length() != 0) {
                    sbuf.append(" ");
                }
                sbuf.append(flagName[i]);
            }
            f >>= 1;
            ++i;
        }
        return sbuf.toString();
    }

    public static Name operatorName(int tag) {
        return opname[tag - 38];
    }

    public static int opPrec(int op) {
        switch (op) {
            case 38: {
                return 14;
            }
            case 39: {
                return 14;
            }
            case 40: {
                return 14;
            }
            case 41: {
                return 14;
            }
            case 42: {
                return 14;
            }
            case 43: {
                return 14;
            }
            case 44: {
                return 15;
            }
            case 45: {
                return 15;
            }
            case 26: {
                return 1;
            }
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return 2;
            }
            case 46: {
                return 4;
            }
            case 47: {
                return 5;
            }
            case 51: {
                return 9;
            }
            case 52: {
                return 9;
            }
            case 53: {
                return 10;
            }
            case 54: {
                return 10;
            }
            case 55: {
                return 10;
            }
            case 56: {
                return 10;
            }
            case 48: {
                return 6;
            }
            case 49: {
                return 7;
            }
            case 50: {
                return 8;
            }
            case 57: {
                return 11;
            }
            case 58: {
                return 11;
            }
            case 59: {
                return 11;
            }
            case 60: {
                return 12;
            }
            case 61: {
                return 12;
            }
            case 62: {
                return 13;
            }
            case 63: {
                return 13;
            }
            case 64: {
                return 13;
            }
            case 28: {
                return 10;
            }
        }
        throw new InternalError();
    }

    static {
        TreeInfo.opname[0] = Name.fromString("+");
        TreeInfo.opname[1] = Name.fromString("-");
        TreeInfo.opname[2] = Name.fromString("!");
        TreeInfo.opname[3] = Name.fromString("~");
        TreeInfo.opname[4] = Name.fromString("++");
        TreeInfo.opname[5] = Name.fromString("--");
        TreeInfo.opname[6] = Name.fromString("++");
        TreeInfo.opname[7] = Name.fromString("--");
        TreeInfo.opname[8] = Name.fromString("||");
        TreeInfo.opname[9] = Name.fromString("&&");
        TreeInfo.opname[13] = Name.fromString("==");
        TreeInfo.opname[14] = Name.fromString("!=");
        TreeInfo.opname[15] = Name.fromString("<");
        TreeInfo.opname[16] = Name.fromString(">");
        TreeInfo.opname[17] = Name.fromString("<=");
        TreeInfo.opname[18] = Name.fromString(">=");
        TreeInfo.opname[10] = Name.fromString("|");
        TreeInfo.opname[11] = Name.fromString("^");
        TreeInfo.opname[12] = Name.fromString("&");
        TreeInfo.opname[19] = Name.fromString("<<");
        TreeInfo.opname[20] = Name.fromString(">>");
        TreeInfo.opname[21] = Name.fromString(">>>");
        TreeInfo.opname[22] = Name.fromString("+");
        TreeInfo.opname[23] = Name.fromString("-");
        TreeInfo.opname[24] = Name.fromString("*");
        TreeInfo.opname[25] = Name.fromString("/");
        TreeInfo.opname[26] = Name.fromString("%");
    }
}

