/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.parser;

import gjc.v6.parser.Scanner;
import gjc.v6.parser.Tokens;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Base;
import gjc.v6.util.Convert;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Position;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements Tokens {
    private static final int infixPrecedenceLevels = 10;
    Scanner S;
    TreeMaker F;
    Log log;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    private int mode = 0;
    private int lastmode = 0;
    static Tree errorTree = new Tree.Erroneous();
    ListBuffer<Tree[]> odStackSupply = new ListBuffer();
    ListBuffer<int[]> opStackSupply = new ListBuffer();

    public Parser(Scanner S, TreeMaker F, Log log) {
        this.S = S;
        this.F = F;
        this.log = log;
    }

    private void skip() {
        int nbraces = 0;
        int n = 0;
        while (true) {
            switch (this.S.token) {
                case 0: 
                case 10: 
                case 29: {
                    return;
                }
                case 71: {
                    if (nbraces != 0 || n != 0) break;
                    return;
                }
                case 68: {
                    if (nbraces == 0) {
                        return;
                    }
                    --nbraces;
                    break;
                }
                case 66: {
                    if (n <= 0) break;
                    --n;
                    break;
                }
                case 67: {
                    ++nbraces;
                    break;
                }
                case 65: {
                    ++n;
                    break;
                }
            }
            this.S.nextToken();
        }
    }

    private Tree syntaxError(int pos, String string) {
        if (pos != this.S.errPos) {
            this.log.error(pos, string);
        }
        this.skip();
        this.S.errPos = pos;
        return errorTree;
    }

    private Tree syntaxError(String string) {
        return this.syntaxError(this.S.pos, string);
    }

    private void accept(int token) {
        if (this.S.token == token) {
            this.S.nextToken();
        } else {
            int n = Position.line(this.S.pos) > Position.line(this.S.lastPos) ? this.S.lastPos : this.S.pos;
            this.syntaxError(n, String.valueOf(this.S.token2string(token)).concat(String.valueOf(" expected")));
            if (this.S.token == token) {
                this.S.nextToken();
            }
        }
    }

    Tree illegal(int n) {
        return this.syntaxError(n, String.valueOf("illegal start of ").concat(String.valueOf((this.mode & 1) != 0 ? "expression" : "type")));
    }

    Tree illegal() {
        return this.illegal(this.S.pos);
    }

    Name ident() {
        if (this.S.token == 2) {
            Name name = this.S.name;
            this.S.nextToken();
            return name;
        }
        this.accept(2);
        return Names.error;
    }

    Tree qualident() {
        Tree t = this.F.at(this.S.pos).Ident(this.ident());
        while (this.S.token == 73) {
            int n = this.S.pos;
            this.S.nextToken();
            t = this.F.at(n).Select(t, this.ident());
        }
        return t;
    }

    Tree literal(Name prefix) {
        int pos = this.S.pos;
        Tree t = errorTree;
        switch (this.S.token) {
            case 56: {
                try {
                    t = this.F.at(pos).Literal(4, new Integer(Convert.string2int(this.strval(prefix), this.S.radix)));
                }
                catch (NumberFormatException ex) {
                    this.log.error(this.S.pos, String.valueOf("integer number too large: ").concat(String.valueOf(this.strval(prefix))));
                }
                break;
            }
            case 57: {
                try {
                    t = this.F.at(pos).Literal(5, new Long(Convert.string2long(this.strval(prefix), this.S.radix)));
                }
                catch (NumberFormatException ex) {
                    this.log.error(this.S.pos, String.valueOf("integer number too large: ").concat(String.valueOf(this.strval(prefix))));
                }
                break;
            }
            case 58: {
                Float n = Float.valueOf(this.S.stringVal());
                if (n.floatValue() == 0.0f && !this.iszero(this.S.stringVal())) {
                    this.log.error(this.S.pos, "floating point number too small");
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos, "floating point number too large");
                    break;
                }
                t = this.F.at(pos).Literal(6, n);
                break;
            }
            case 59: {
                Double d = Double.valueOf(this.S.stringVal());
                if (d == 0.0 && !this.iszero(this.S.stringVal())) {
                    this.log.error(this.S.pos, "floating point number too small");
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos, "floating point number too large");
                    break;
                }
                t = this.F.at(pos).Literal(7, d);
                break;
            }
            case 60: {
                t = this.F.at(pos).Literal(2, new Integer(this.S.stringVal().charAt(0)));
                break;
            }
            case 61: {
                t = this.F.at(pos).Literal(10, this.S.stringVal());
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                t = this.F.at(pos).Ident(this.S.name);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.S.nextToken();
        return t;
    }

    boolean iszero(String s) {
        int n;
        char[] cs = s.toCharArray();
        for (n = 0; n < cs.length && (cs[n] == '0' || cs[n] == '.'); ++n) {
        }
        return n >= cs.length || '1' > cs[n] || cs[n] > '9';
    }

    String strval(Name prefix) {
        String string = this.S.stringVal();
        return prefix.len == 0 ? string : String.valueOf(prefix).concat(String.valueOf(string));
    }

    public Tree expression() {
        return this.term(1);
    }

    public final Tree type() {
        return this.term(2);
    }

    Tree term(int newmode) {
        int prevmode = this.mode;
        this.mode = newmode;
        Tree tree = this.term();
        this.lastmode = this.mode;
        this.mode = prevmode;
        return tree;
    }

    Tree term() {
        Tree tree = this.term1();
        if ((this.mode & 1) != 0 && this.S.token == 74 || 100 <= this.S.token && this.S.token <= 110) {
            return this.termRest(tree);
        }
        return tree;
    }

    Tree termRest(Tree t) {
        switch (this.S.token) {
            case 74: {
                int pos = this.S.pos;
                this.S.nextToken();
                this.mode = 1;
                Tree t1 = this.term();
                return this.F.at(pos).Assign(t, t1);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                int pos = this.S.pos;
                int token = this.S.token;
                this.S.nextToken();
                this.mode = 1;
                Tree tree = this.term();
                return this.F.at(pos).Assignop(Parser.opcode(token), t, tree);
            }
        }
        return t;
    }

    Tree term1() {
        Tree tree = this.term2();
        if ((this.mode & 1) != 0 & this.S.token == 79) {
            this.mode = 1;
            return this.term1Rest(tree);
        }
        return tree;
    }

    Tree term1Rest(Tree t) {
        if (this.S.token == 79) {
            int pos = this.S.pos;
            this.S.nextToken();
            Tree t1 = this.term();
            this.accept(80);
            Tree tree = this.term1();
            return this.F.at(pos).Conditional(16, t, t1, tree);
        }
        return t;
    }

    Tree term2() {
        Tree tree = this.term3();
        if ((this.mode & 1) != 0 && Parser.prec(this.S.token) >= 4) {
            this.mode = 1;
            return this.term2Rest(tree, 4);
        }
        return tree;
    }

    Tree term2Rest(Tree t, int minprec) {
        List savedOd = this.odStackSupply.elems;
        Tree[] odStack = this.newOdStack();
        List savedOp = this.opStackSupply.elems;
        int[] opStack = this.newOpStack();
        int top = 0;
        odStack[0] = t;
        int topOp = 1;
        while (Parser.prec(this.S.token) >= minprec) {
            opStack[top] = topOp;
            topOp = this.S.token;
            int n = this.S.pos;
            this.S.nextToken();
            Tree tree = odStack[++top] = topOp == 27 ? this.type() : this.term3();
            while (top > 0 && Parser.prec(topOp) >= Parser.prec(this.S.token)) {
                odStack[top - 1] = topOp == 27 ? this.F.at(n).TypeTest(odStack[top - 1], odStack[top]) : this.F.at(n).Operation(Parser.opcode(topOp), List.make(odStack[top - 1], odStack[top]));
                topOp = opStack[--top];
            }
        }
        Base._assert(top == 0);
        t = odStack[0];
        this.odStackSupply.elems = savedOd;
        this.opStackSupply.elems = savedOp;
        return t;
    }

    public Tree[] newOdStack() {
        if (this.odStackSupply.elems == this.odStackSupply.last) {
            this.odStackSupply.append(new Tree[11]);
        }
        Tree[] treeArray = (Tree[])this.odStackSupply.elems.head;
        this.odStackSupply.elems = this.odStackSupply.elems.tail;
        return treeArray;
    }

    public int[] newOpStack() {
        if (this.opStackSupply.elems == this.opStackSupply.last) {
            this.opStackSupply.append(new int[11]);
        }
        int[] nArray = (int[])this.opStackSupply.elems.head;
        this.opStackSupply.elems = this.opStackSupply.elems.tail;
        return nArray;
    }

    Tree term3() {
        Tree t1;
        Tree t2;
        int pos = this.S.pos;
        switch (this.S.token) {
            case 77: 
            case 78: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    int token = this.S.token;
                    this.S.nextToken();
                    if (token == 90 && (this.S.token == 56 || this.S.token == 57) && this.S.radix == 10) {
                        t2 = this.literal(Names.hyphen);
                        break;
                    }
                    Tree t2 = this.term3();
                    return this.F.at(pos).Operation(Parser.unopcode(token), List.make(t2));
                }
                return this.illegal();
            }
            case 65: {
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    this.mode = 7;
                    t2 = this.term3();
                    if ((this.mode & 2) != 0 && this.S.token == 76) {
                        int pos1 = this.S.pos;
                        this.S.nextToken();
                        this.mode &= 3;
                        t1 = this.term3();
                        if ((this.mode & 2) != 0 && (this.S.token == 72 || this.S.token == 75)) {
                            this.mode = 2;
                            ListBuffer<Tree> args = new ListBuffer<Tree>();
                            args.append(t1);
                            while (this.S.token == 72) {
                                this.S.nextToken();
                                args.append(this.type());
                            }
                            this.accept(75);
                            t2 = this.F.at(pos1).TypeApply(t2, args.toList());
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            t2 = this.termRest(this.term1Rest(this.term2Rest(this.F.at(pos1).Operation(53, List.make(t2, this.term2Rest(t1, 11))), 4)));
                        } else {
                            this.accept(75);
                        }
                    } else {
                        t2 = this.termRest(this.term1Rest(this.term2Rest(t2, 4)));
                    }
                    this.accept(66);
                    this.lastmode = this.mode;
                    this.mode = 1;
                    if ((this.lastmode & 1) == 0) {
                        Tree t12 = this.term3();
                        return this.F.at(pos).TypeCast(t2, t12);
                    }
                    if ((this.lastmode & 2) == 0) break;
                    switch (this.S.token) {
                        case 2: 
                        case 32: 
                        case 45: 
                        case 48: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 77: 
                        case 78: 
                        case 87: 
                        case 88: {
                            Tree t13 = this.term3();
                            return this.F.at(pos).TypeCast(t2, t13);
                        }
                    }
                    break;
                }
                return this.illegal();
            }
            case 48: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t2 = this.F.at(pos).Ident(Names._this);
                    this.S.nextToken();
                    t2 = this.argumentsOpt(t2);
                    break;
                }
                return this.illegal();
            }
            case 45: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t2 = this.F.at(pos).Ident(Names._super);
                    this.S.nextToken();
                    if (this.S.token == 65) {
                        t2 = this.arguments(t2);
                        break;
                    }
                    int pos1 = this.S.pos;
                    this.accept(73);
                    t2 = this.argumentsOpt(this.F.at(pos1).Select(t2, this.ident()));
                    break;
                }
                return this.illegal();
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t2 = this.literal(Names.empty);
                    break;
                }
                return this.illegal();
            }
            case 32: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.S.nextToken();
                    t2 = this.creator(pos);
                    break;
                }
                return this.illegal();
            }
            case 2: {
                t2 = this.F.at(this.S.pos).Ident(this.ident());
                block26: while (true) {
                    pos = this.S.pos;
                    switch (this.S.token) {
                        case 69: {
                            this.S.nextToken();
                            if (this.S.token == 70) {
                                this.S.nextToken();
                                t2 = this.bracketsSuffix(this.bracketsOpt(this.F.at(pos).TypeArray(t2)));
                                break block26;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                Tree t14 = this.term();
                                t2 = this.F.at(pos).Indexed(t2, t14);
                            }
                            this.accept(70);
                            break block26;
                        }
                        case 65: {
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                t2 = this.arguments(t2);
                            }
                            break block26;
                        }
                        case 73: {
                            this.S.nextToken();
                            if ((this.mode & 1) != 0) {
                                switch (this.S.token) {
                                    case 10: {
                                        this.mode = 1;
                                        t2 = this.F.at(pos).Select(t2, Names._class);
                                        this.S.nextToken();
                                        break block26;
                                    }
                                    case 48: {
                                        this.mode = 1;
                                        t2 = this.F.at(pos).Select(t2, Names._this);
                                        this.S.nextToken();
                                        break block26;
                                    }
                                    case 45: {
                                        this.mode = 1;
                                        t2 = this.F.at(pos).Select(t2, Names._super);
                                        this.S.nextToken();
                                        t2 = this.arguments(t2);
                                        break block26;
                                    }
                                    case 32: {
                                        this.mode = 1;
                                        int pos1 = this.S.pos;
                                        this.S.nextToken();
                                        t2 = this.innerCreator(pos1, t2);
                                        break block26;
                                    }
                                }
                            }
                            t2 = this.F.at(pos).Select(t2, this.ident());
                            continue block26;
                        }
                    }
                    break;
                }
                t2 = this.typeArgumentsOpt(t2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 20: 
            case 28: 
            case 30: 
            case 43: {
                t2 = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case 53: {
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    if (this.S.token == 73) {
                        t2 = this.bracketsSuffix(this.F.at(pos).TypeIdent(9));
                        break;
                    }
                    return this.illegal(pos);
                }
                return this.illegal();
            }
            default: {
                return this.illegal();
            }
        }
        while (true) {
            int pos1 = this.S.pos;
            if (this.S.token == 69) {
                this.S.nextToken();
                if (this.S.token == 70 && (this.mode & 2) != 0) {
                    this.mode = 2;
                    this.S.nextToken();
                    return this.bracketsOpt(this.F.at(pos1).TypeArray(t2));
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t1 = this.term();
                    t2 = this.F.at(pos1).Indexed(t2, t1);
                }
                this.accept(70);
                continue;
            }
            if (this.S.token != 73) break;
            this.S.nextToken();
            if (this.S.token == 45 && (this.mode & 1) != 0) {
                this.mode = 1;
                t2 = this.F.at(pos1).Select(t2, Names._super);
                this.S.nextToken();
                t2 = this.arguments(t2);
                continue;
            }
            if (this.S.token == 32 && (this.mode & 1) != 0) {
                this.mode = 1;
                int n = this.S.pos;
                this.S.nextToken();
                t2 = this.innerCreator(n, t2);
                continue;
            }
            t2 = this.argumentsOpt(this.typeArgumentsOpt(this.F.at(pos1).Select(t2, this.ident())));
        }
        while ((this.S.token == 87 || this.S.token == 88) && (this.mode & 1) != 0) {
            this.mode = 1;
            t2 = this.F.at(this.S.pos).Operation(this.S.token == 87 ? 44 : 45, List.make(t2));
            this.S.nextToken();
        }
        return t2;
    }

    Tree basicType() {
        Tree.TypeIdent typeIdent = this.F.at(this.S.pos).TypeIdent(Parser.typetag(this.S.token));
        this.S.nextToken();
        return typeIdent;
    }

    Tree argumentsOpt(Tree tree) {
        if ((this.mode & 1) != 0 && this.S.token == 65) {
            this.mode = 1;
            return this.arguments(tree);
        }
        return tree;
    }

    List<Tree> arguments() {
        int pos = this.S.pos;
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token == 65) {
            this.S.nextToken();
            if (this.S.token != 66) {
                listBuffer.append(this.expression());
                while (this.S.token == 72) {
                    this.S.nextToken();
                    listBuffer.append(this.expression());
                }
            }
            this.accept(66);
        } else {
            this.log.error(this.S.pos, "'(' expected");
        }
        return listBuffer.toList();
    }

    Tree arguments(Tree t) {
        int pos = this.S.pos;
        List<Tree> list = this.arguments();
        return this.F.at(pos).Apply(t, list);
    }

    Tree typeArgumentsOpt(Tree tree) {
        if (this.S.token == 76 && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            return this.typeArguments(tree);
        }
        return tree;
    }

    List<Tree> typeArguments() {
        int pos = this.S.pos;
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token == 76) {
            this.S.nextToken();
            listBuffer.append(this.type());
            while (this.S.token == 72) {
                this.S.nextToken();
                listBuffer.append(this.type());
            }
            switch (this.S.token) {
                case 110: {
                    this.S.token = 109;
                    break;
                }
                case 109: {
                    this.S.token = 83;
                    break;
                }
                case 83: {
                    this.S.token = 74;
                    break;
                }
                case 99: {
                    this.S.token = 98;
                    break;
                }
                case 98: {
                    this.S.token = 75;
                    break;
                }
                default: {
                    this.accept(75);
                    break;
                }
            }
        } else {
            this.log.error(this.S.pos, "'<' expected");
        }
        return listBuffer.toList();
    }

    Tree typeArguments(Tree t) {
        int pos = this.S.pos;
        List<Tree> list = this.typeArguments();
        return this.F.at(pos).TypeApply(t, list);
    }

    private Tree bracketsOpt(Tree t) {
        while (this.S.token == 69) {
            int n = this.S.pos;
            this.S.nextToken();
            this.accept(70);
            t = this.F.at(n).TypeArray(t);
        }
        return t;
    }

    Tree bracketsSuffix(Tree t) {
        if ((this.mode & 1) != 0 && this.S.token == 73) {
            this.mode = 1;
            int n = this.S.pos;
            this.S.nextToken();
            this.accept(10);
            t = this.F.at(n).Select(t, Names._class);
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.log.error(this.S.pos, "'.class' expected");
        }
        return t;
    }

    private Tree at(Tree t, Tree tree) {
        ((Tree.NewClass)tree).at = t;
        return tree;
    }

    private Tree node() {
        Tree tree = this.S.tagAt;
        this.S.tagAt = null;
        return tree;
    }

    Tree creator(int newpos) {
        switch (this.S.token) {
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 20: 
            case 28: 
            case 30: 
            case 43: {
                return this.arrayCreatorRest(newpos, this.basicType());
            }
        }
        Tree tree = this.qualident();
        if (this.S.token == 76) {
            tree = this.typeArguments(tree);
        }
        if (this.S.token == 69) {
            return this.arrayCreatorRest(newpos, tree);
        }
        if (this.S.token == 65) {
            return this.at(this.node(), this.classCreatorRest(newpos, null, tree));
        }
        return this.syntaxError("'(' or '[' expected");
    }

    Tree innerCreator(int newpos, Tree encl) {
        Tree tree = this.F.at(this.S.pos).Ident(this.ident());
        if (this.S.token == 76) {
            tree = this.typeArguments(tree);
        }
        return this.at(this.node(), this.classCreatorRest(newpos, encl, tree));
    }

    Tree arrayCreatorRest(int newpos, Tree elemtype) {
        int pos = this.S.pos;
        this.accept(69);
        if (this.S.token == 70) {
            this.S.nextToken();
            elemtype = this.bracketsOpt(elemtype);
            if (this.S.token == 67) {
                return this.arrayInitializer(elemtype);
            }
            this.log.error(this.S.pos, "'{' expected");
            return errorTree;
        }
        ListBuffer<Tree> dims = new ListBuffer<Tree>();
        dims.append(this.expression());
        this.accept(70);
        while (this.S.token == 69) {
            int n = this.S.pos;
            this.S.nextToken();
            if (this.S.token == 70) {
                this.S.nextToken();
                elemtype = this.bracketsOpt(this.F.at(n).TypeArray(elemtype));
                continue;
            }
            dims.append(this.expression());
            this.accept(70);
        }
        return this.F.at(newpos).NewArray(elemtype, dims.toList(), null);
    }

    Tree classCreatorRest(int newpos, Tree encl, Tree t) {
        List<Tree> args = this.arguments();
        Tree.ClassDef body = null;
        if (this.S.token == 67) {
            body = this.F.at(this.S.pos).ClassDef(0, Names.empty, Tree.TypeParameter.emptyList, null, Tree.emptyList, this.classOrInterfaceBody(Names.empty, false));
        }
        Tree.NewClass newClass = this.F.at(newpos).NewClass(encl, t, args, body);
        return newClass;
    }

    Tree arrayInitializer(Tree t) {
        int pos = this.S.pos;
        this.accept(67);
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token == 72) {
            this.accept(72);
        } else if (this.S.token != 68) {
            listBuffer.append(this.variableInitializer());
            while (this.S.token == 72) {
                this.S.nextToken();
                if (this.S.token == 68) break;
                listBuffer.append(this.variableInitializer());
            }
        }
        this.accept(68);
        return this.F.at(pos).NewArray(t, Tree.emptyList, listBuffer.toList());
    }

    Tree variableInitializer() {
        return this.S.token == 67 ? this.arrayInitializer(null) : this.expression();
    }

    Tree parExpression() {
        this.accept(65);
        Tree tree = this.expression();
        this.accept(66);
        return tree;
    }

    Tree.Block block(int flags) {
        int pos = this.S.pos;
        this.accept(67);
        List<Tree> stats = this.blockStatements();
        Tree.Block block = this.F.at(pos).Block(flags, stats);
        while (this.S.token == 7 || this.S.token == 13) {
            this.syntaxError(String.valueOf("orphaned ").concat(String.valueOf(this.S.token2string(this.S.token))));
            this.blockStatements();
        }
        this.accept(68);
        return block;
    }

    Tree.Block block() {
        return this.block(0);
    }

    List<Tree> blockStatements() {
        ListBuffer<Tree> stats = new ListBuffer<Tree>();
        while (true) {
            int pos = this.S.pos;
            switch (this.S.token) {
                case 0: 
                case 7: 
                case 13: 
                case 68: {
                    return stats.toList();
                }
                case 5: 
                case 8: 
                case 12: 
                case 14: 
                case 16: 
                case 19: 
                case 21: 
                case 23: 
                case 24: 
                case 38: 
                case 46: 
                case 47: 
                case 49: 
                case 52: 
                case 55: 
                case 67: 
                case 71: {
                    stats.append(this.statement());
                    break;
                }
                case 40: 
                case 41: 
                case 42: {
                    int flags = this.modifiersOpt();
                    stats.append(this.replicatedStatement(flags));
                    break;
                }
                case 11: 
                case 18: {
                    int flags = this.modifiersOpt();
                    if (this.S.token == 29 || this.S.token == 10) {
                        stats.append(this.classOrInterfaceDeclaration(flags));
                        break;
                    }
                    pos = this.S.pos;
                    Name name = this.S.name;
                    Tree t = this.type();
                    stats.append(this.variableDeclarators(flags, t));
                    this.accept(71);
                    break;
                }
                case 3: {
                    int flags = this.modifiersOpt();
                    stats.append(this.classOrInterfaceDeclaration(flags));
                    break;
                }
                case 10: 
                case 29: {
                    stats.append(this.classOrInterfaceDeclaration(0));
                    break;
                }
                default: {
                    Name name = this.S.name;
                    Tree t = this.term(3);
                    if (this.S.token == 80 && t.tag == 31) {
                        this.S.nextToken();
                        Tree tree = this.statement();
                        stats.append(this.F.at(pos).Labelled(name, tree));
                        break;
                    }
                    if ((this.lastmode & 2) != 0 && this.S.token == 2) {
                        stats.append(this.variableDeclarators(0, t));
                        this.accept(71);
                        break;
                    }
                    stats.append(this.F.at(pos).Exec(this.checkExprStat(t)));
                    this.accept(71);
                }
            }
        }
    }

    Tree statement() {
        int pos = this.S.pos;
        switch (this.S.token) {
            case 67: {
                return this.block();
            }
            case 23: {
                this.S.nextToken();
                Tree cond = this.parExpression();
                Tree thenpart = this.statement();
                Tree elsepart = null;
                if (this.S.token == 16) {
                    this.S.nextToken();
                    elsepart = this.statement();
                }
                return this.F.at(pos).Conditional(17, cond, thenpart, elsepart);
            }
            case 24: {
                this.S.nextToken();
                Tree cond = this.expression();
                Tree msg = null;
                if (this.S.token == 80) {
                    this.S.nextToken();
                    msg = this.expression();
                }
                return this.F.at(pos).Assert(cond, msg);
            }
            case 21: {
                this.S.nextToken();
                this.accept(65);
                List<Tree> inits = this.S.token == 71 ? Tree.emptyList : this.forInit();
                this.accept(71);
                Tree cond = this.S.token == 71 ? null : this.expression();
                this.accept(71);
                List<Tree> steps = this.S.token == 66 ? Tree.emptyList : this.forUpdate();
                this.accept(66);
                Tree body = this.statement();
                return this.F.at(pos).ForLoop(inits, cond, steps, body);
            }
            case 55: {
                this.S.nextToken();
                Tree cond = this.parExpression();
                Tree body = this.statement();
                return this.F.at(pos).WhileLoop(cond, body);
            }
            case 14: {
                this.S.nextToken();
                Tree body = this.statement();
                this.accept(55);
                Tree cond = this.parExpression();
                this.accept(71);
                return this.F.at(pos).DoLoop(body, cond);
            }
            case 52: {
                this.S.nextToken();
                Tree.Block body = this.block();
                ListBuffer<Tree.Catch> catchers = new ListBuffer<Tree.Catch>();
                Tree.Block finalizer = null;
                if (this.S.token == 8 || this.S.token == 19) {
                    while (this.S.token == 8) {
                        catchers.append(this.catchClause());
                    }
                    if (this.S.token == 19) {
                        this.S.nextToken();
                        finalizer = this.block();
                    }
                } else {
                    this.log.error(pos, "'try' without 'catch' or 'finally'");
                }
                return this.F.at(pos).Try(body, catchers.toList(), finalizer);
            }
            case 46: {
                this.S.nextToken();
                Tree selector = this.parExpression();
                this.accept(67);
                List<Tree.Case> cases = this.switchBlockStatementGroups();
                this.accept(68);
                return this.F.at(pos).Switch(selector, cases);
            }
            case 40: 
            case 41: 
            case 42: {
                int flags = this.modifiersOpt();
                return this.replicatedStatement(flags);
            }
            case 47: {
                this.S.nextToken();
                Tree lock = this.parExpression();
                Tree.Block body = this.block();
                return this.F.at(pos).Synchronized(lock, body);
            }
            case 38: {
                this.S.nextToken();
                Tree result = this.S.token == 71 ? null : this.expression();
                this.accept(71);
                return this.F.at(pos).Return(result);
            }
            case 49: {
                this.S.nextToken();
                Tree exc = this.expression();
                this.accept(71);
                return this.F.at(pos).Throw(exc);
            }
            case 5: {
                this.S.nextToken();
                Name label = this.S.token == 2 ? this.ident() : null;
                this.accept(71);
                return this.F.at(pos).Break(label);
            }
            case 12: {
                this.S.nextToken();
                Name label = this.S.token == 2 ? this.ident() : null;
                this.accept(71);
                return this.F.at(pos).Continue(label);
            }
            case 71: {
                this.S.nextToken();
                return this.F.at(pos).Block(0, Tree.emptyList);
            }
            case 16: {
                return this.syntaxError("'else' without 'if'");
            }
            case 19: {
                return this.syntaxError("'finally' without 'try'");
            }
            case 8: {
                return this.syntaxError("'catch' without 'try'");
            }
        }
        Name name = this.S.name;
        Tree expr = this.expression();
        if (this.S.token == 80 && expr.tag == 31) {
            this.S.nextToken();
            Tree stat = this.statement();
            return this.F.at(pos).Labelled(name, stat);
        }
        Tree.Exec exec = this.F.at(pos).Exec(this.checkExprStat(expr));
        this.accept(71);
        return exec;
    }

    Tree replicatedStatement(int flags) {
        int pos = this.S.pos;
        if ((flags & 0x20) != 0) {
            Tree lock = this.parExpression();
            Tree.Block body = this.block(flags);
            return this.F.at(pos).Synchronized(lock, body);
        }
        Name name = this.S.name;
        Tree expr = this.expression();
        if (this.S.token == 80 && expr.tag == 31) {
            this.S.nextToken();
            Tree stat = this.statement();
            return this.F.at(pos).Labelled(name, stat);
        }
        Tree.Exec exec = this.F.at(pos).Exec(this.checkExprStat(expr));
        this.accept(71);
        return exec;
    }

    Tree.Catch catchClause() {
        int pos = this.S.pos;
        this.accept(8);
        this.accept(65);
        Tree.VarDef formal = this.formalParameter();
        this.accept(66);
        Tree.Block block = this.block();
        return this.F.at(pos).Catch(formal, block);
    }

    List<Tree.Case> switchBlockStatementGroups() {
        ListBuffer<Tree.Case> cases = new ListBuffer<Tree.Case>();
        block5: while (true) {
            int pos = this.S.pos;
            switch (this.S.token) {
                case 7: {
                    this.S.nextToken();
                    Tree pat = this.expression();
                    this.accept(80);
                    List<Tree> stats = this.blockStatements();
                    cases.append(this.F.at(pos).Case(pat, stats));
                    continue block5;
                }
                case 13: {
                    this.S.nextToken();
                    this.accept(80);
                    List<Tree> list = this.blockStatements();
                    cases.append(this.F.at(pos).Case(null, list));
                    continue block5;
                }
                case 0: 
                case 68: {
                    return cases.toList();
                }
            }
            this.S.nextToken();
            this.syntaxError(pos, "'case', 'default' or '}' expected");
        }
    }

    List<Tree> moreStatementExpressions(int pos, Tree first) {
        ListBuffer<Tree.Exec> stats = new ListBuffer<Tree.Exec>();
        stats.append(this.F.at(pos).Exec(this.checkExprStat(first)));
        while (this.S.token == 72) {
            this.S.nextToken();
            pos = this.S.pos;
            Tree tree = this.expression();
            stats.append(this.F.at(pos).Exec(this.checkExprStat(tree)));
        }
        return stats.toList();
    }

    List<Tree> forInit() {
        int pos = this.S.pos;
        if (this.S.token == 18 || this.S.token == 11) {
            return this.variableDeclarators(this.localVariableFlags(), this.type());
        }
        Tree tree = this.term(3);
        if ((this.lastmode & 2) != 0 && this.S.token == 2) {
            return this.variableDeclarators(0, tree);
        }
        return this.moreStatementExpressions(pos, tree);
    }

    List<Tree> forUpdate() {
        return this.moreStatementExpressions(this.S.pos, this.expression());
    }

    int modifiersOpt() {
        int flags = 0;
        if (this.S.deprecatedFlag) {
            flags = 131072;
            this.S.deprecatedFlag = false;
        }
        while (true) {
            int n;
            switch (this.S.token) {
                case 34: {
                    n = 2;
                    break;
                }
                case 35: {
                    n = 4;
                    break;
                }
                case 36: {
                    n = 1;
                    break;
                }
                case 37: {
                    n = 2048;
                    if ((flags & 0x2000000) == 0) break;
                    this.syntaxError(this.S.pos, "'class' expected");
                    break;
                }
                case 11: {
                    n = 4096;
                    break;
                }
                case 39: {
                    n = 0x2000000;
                    if ((flags & 0x800) == 0) break;
                    this.syntaxError(this.S.pos, "'class' expected");
                    break;
                }
                case 40: {
                    n = 0x4000000;
                    if ((flags & 0x18000000) == 0) break;
                    this.syntaxError(this.S.pos, "methods can either be 'collective' or 'exclusive' or 'shared'");
                    break;
                }
                case 41: {
                    n = 0x8000000;
                    if ((flags & 0x14000000) == 0) break;
                    this.syntaxError(this.S.pos, "methods can either be 'collective' or 'exclusive' or 'shared'");
                    break;
                }
                case 42: {
                    n = 0x10000000;
                    if ((flags & 0x4000000) == 0) break;
                    this.syntaxError(this.S.pos, "methods can either be 'collective' or 'exclusive' or 'shared'");
                    break;
                }
                case 44: {
                    n = 8;
                    break;
                }
                case 51: {
                    n = 128;
                    break;
                }
                case 18: {
                    n = 16;
                    break;
                }
                case 3: {
                    n = 1024;
                    break;
                }
                case 31: {
                    n = 256;
                    break;
                }
                case 54: {
                    n = 64;
                    break;
                }
                case 47: {
                    n = 32;
                    break;
                }
                default: {
                    return flags;
                }
            }
            if ((flags & n) != 0) {
                this.log.error(this.S.pos, "repeated modifier");
            }
            flags |= n;
            this.S.nextToken();
        }
    }

    List<Tree> variableDeclarators(int flags, Tree tree) {
        return this.variableDeclaratorsRest(this.S.pos, flags, tree, this.ident(), false);
    }

    List<Tree> variableDeclaratorsRest(int pos, int flags, Tree type, Name name, boolean reqInit) {
        ListBuffer<Tree.VarDef> listBuffer = new ListBuffer<Tree.VarDef>();
        listBuffer.append(this.variableDeclaratorRest(pos, flags, type, name, reqInit));
        while (this.S.token == 72) {
            this.S.nextToken();
            listBuffer.append(this.variableDeclarator(flags, type));
        }
        this.S.tagMerge = null;
        this.S.tagEmbedded = false;
        return listBuffer.toList();
    }

    Tree.VarDef variableDeclarator(int flags, Tree tree) {
        return this.variableDeclaratorRest(this.S.pos, flags, tree, this.ident(), false);
    }

    Tree.VarDef variableDeclaratorRest(int pos, int flags, Tree type, Name name, boolean reqInit) {
        type = this.bracketsOpt(type);
        Tree init = null;
        if (this.S.token == 74) {
            this.S.nextToken();
            init = this.variableInitializer();
        } else if (reqInit) {
            this.log.error(this.S.pos, "'=' expected");
        }
        if (this.S.tagEmbedded) {
            flags |= 0x2000;
        }
        Tree.VarDef varDef = this.F.at(pos).VarDef(flags, name, type, init);
        varDef.merge = this.S.tagMerge;
        return varDef;
    }

    Tree.VarDef variableDeclaratorId(int flags, Tree type) {
        int pos = this.S.pos;
        Name name = this.ident();
        type = this.bracketsOpt(type);
        return this.F.at(pos).VarDef(flags, name, type, null);
    }

    public Tree.TopLevel compilationUnit() {
        int pos = this.S.pos;
        Tree pid = null;
        if (this.S.token == 33) {
            this.S.nextToken();
            pid = this.qualident();
            this.accept(71);
        }
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        while (this.S.token == 26) {
            listBuffer.append(this.importDeclaration());
        }
        while (this.S.token != 0) {
            listBuffer.append(this.typeDeclaration());
        }
        return this.F.at(pos).TopLevel(pid, listBuffer.toList());
    }

    Tree importDeclaration() {
        int pos = this.S.pos;
        this.S.nextToken();
        Tree pid = this.F.at(this.S.pos).Ident(this.ident());
        boolean bl = false;
        while (this.S.token == 73 && !bl) {
            this.S.nextToken();
            if (this.S.token == 91) {
                pid = this.F.at(this.S.pos).Select(pid, Names.star);
                this.S.nextToken();
                bl = true;
                continue;
            }
            pid = this.F.at(this.S.pos).Select(pid, this.ident());
        }
        this.accept(71);
        return this.F.at(pos).Import(pid);
    }

    Tree typeDeclaration() {
        int flags = 0;
        if (this.S.pos == this.S.errPos) {
            flags = this.modifiersOpt();
            while (this.S.token != 10 && this.S.token != 29 && this.S.token != 0) {
                this.S.nextToken();
                flags = this.modifiersOpt();
            }
        }
        int n = this.S.pos;
        if (this.S.token == 71) {
            this.S.nextToken();
            return this.F.at(n).Block(0, Tree.emptyList);
        }
        return this.classOrInterfaceDeclaration(flags |= this.modifiersOpt());
    }

    Tree classOrInterfaceDeclaration(int n) {
        n |= this.modifiersOpt();
        if (this.S.token == 10) {
            return this.classDeclaration(n);
        }
        if (this.S.token == 29) {
            return this.interfaceDeclaration(n);
        }
        return this.syntaxError("'class' or 'interface' expected");
    }

    Tree classDeclaration(int flags) {
        int pos = this.S.pos;
        this.accept(10);
        Name name = this.ident();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        Tree extending = null;
        if (this.S.token == 17) {
            this.S.nextToken();
            extending = this.type();
        }
        List<Tree> implementing = Tree.emptyList;
        if (this.S.token == 25) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<Tree> list = this.classOrInterfaceBody(name, false);
        return this.F.at(pos).ClassDef(flags, name, typarams, extending, implementing, list);
    }

    Tree interfaceDeclaration(int flags) {
        int pos = this.S.pos;
        this.accept(29);
        Name name = this.ident();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        List<Tree> extending = Tree.emptyList;
        if (this.S.token == 17) {
            this.S.nextToken();
            extending = this.typeList();
        }
        List<Tree> list = this.classOrInterfaceBody(name, true);
        return this.F.at(pos).ClassDef(flags | 0x200, name, typarams, null, extending, list);
    }

    List<Tree> typeList() {
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        listBuffer.append(this.type());
        while (this.S.token == 72) {
            this.S.nextToken();
            listBuffer.append(this.type());
        }
        return listBuffer.toList();
    }

    public List<Tree> classOrInterfaceBody(Name className, boolean isInterface) {
        int pos = this.S.pos;
        this.accept(67);
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        while (this.S.token != 68 && this.S.token != 0) {
            listBuffer.append(this.classOrInterfaceBodyDeclaration(className, isInterface));
        }
        this.accept(68);
        return listBuffer.toList();
    }

    List<Tree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
        Tree type;
        boolean isVoid;
        int pos = this.S.pos;
        if (this.S.token == 71) {
            this.S.nextToken();
            return Tree.emptyList.prepend(this.F.at(pos).Block(0, Tree.emptyList));
        }
        int flags = this.modifiersOpt();
        if (this.S.token == 10 || this.S.token == 29) {
            return Tree.emptyList.prepend(this.classOrInterfaceDeclaration(flags));
        }
        if (this.S.token == 67 && !isInterface && (flags & 0x2FFF & 0xFFFFFFF7) == 0) {
            return Tree.emptyList.prepend(this.block(flags));
        }
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        int token = this.S.token;
        Name name = this.S.name;
        pos = this.S.pos;
        boolean bl = isVoid = this.S.token == 53;
        if (isVoid) {
            type = this.F.at(pos).TypeIdent(9);
            this.S.nextToken();
        } else {
            type = this.type();
        }
        if (this.S.token == 65 && !isInterface && type.tag == 31) {
            if (isInterface || name != className) {
                this.log.error(pos, "invalid method declaration; return type required");
            }
            return Tree.emptyList.prepend(this.methodDeclaratorRest(pos, flags, null, Names.init, typarams, isInterface, true));
        }
        pos = this.S.pos;
        name = this.ident();
        if (this.S.token == 65) {
            return Tree.emptyList.prepend(this.methodDeclaratorRest(pos, flags, type, name, typarams, isInterface, isVoid));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<Tree> list = this.variableDeclaratorsRest(pos, flags, type, name, isInterface);
            this.accept(71);
            return list;
        }
        this.log.error(this.S.pos, "'(' expected");
        return Tree.emptyList;
    }

    Tree methodDeclaratorRest(int pos, int flags, Tree type, Name name, List<Tree.TypeParameter> typarams, boolean isInterface, boolean isVoid) {
        Tree.Block block;
        List<Tree.VarDef> params = this.formalParameters();
        if (!isVoid) {
            type = this.bracketsOpt(type);
        }
        List<Tree> thrown = Tree.emptyList;
        if (this.S.token == 50) {
            this.S.nextToken();
            thrown = this.typeList();
        }
        if (this.S.token == 67) {
            if (isInterface) {
                this.log.error(this.S.pos, "interface methods cannot have body");
            }
            block = this.block();
        } else {
            this.S.nextToken();
            block = null;
        }
        return this.F.at(pos).MethodDef(flags, name, type, typarams, params, thrown, block);
    }

    List<Tree.TypeParameter> typeParametersOpt() {
        if (this.S.token == 76) {
            ListBuffer<Tree.TypeParameter> listBuffer = new ListBuffer<Tree.TypeParameter>();
            this.S.nextToken();
            listBuffer.append(this.typeParameter());
            while (this.S.token == 72) {
                this.S.nextToken();
                listBuffer.append(this.typeParameter());
            }
            this.accept(75);
            return listBuffer.toList();
        }
        return Tree.TypeParameter.emptyList;
    }

    Tree.TypeParameter typeParameter() {
        int pos = this.S.pos;
        Name name = this.ident();
        Tree extBound = null;
        Tree tree = null;
        if (this.S.token == 17) {
            this.S.nextToken();
            extBound = this.type();
        } else if (this.S.token == 25) {
            this.S.nextToken();
            tree = this.type();
        }
        return this.F.at(pos).TypeParameter(name, extBound, tree);
    }

    List<Tree.VarDef> formalParameters() {
        ListBuffer<Tree.VarDef> listBuffer = new ListBuffer<Tree.VarDef>();
        this.accept(65);
        if (this.S.token != 66) {
            listBuffer.append(this.formalParameter());
            while (this.S.token == 72) {
                this.S.nextToken();
                listBuffer.append(this.formalParameter());
            }
        }
        this.accept(66);
        return listBuffer.toList();
    }

    Tree.VarDef formalParameter() {
        return this.variableDeclaratorId(this.localVariableFlags(), this.type());
    }

    int localVariableFlags() {
        int flags = 0;
        while (true) {
            int n = 0;
            switch (this.S.token) {
                case 18: {
                    n = 16;
                    break;
                }
                case 11: {
                    n = 4096;
                    break;
                }
                default: {
                    return flags;
                }
            }
            if ((flags & n) != 0) {
                this.log.error(this.S.pos, "repeated modifier");
            }
            flags |= n;
            this.S.nextToken();
        }
    }

    Tree checkExprStat(Tree tree) {
        switch (tree.tag) {
            case 23: 
            case 24: 
            case 26: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return tree;
            }
        }
        this.log.error(tree.pos, "not a statement");
        return errorTree;
    }

    static int prec(int token) {
        int oc = Parser.opcode(token);
        return oc >= 0 ? TreeInfo.opPrec(oc) : -1;
    }

    static int opcode(int token) {
        switch (token) {
            case 86: {
                return 46;
            }
            case 85: {
                return 47;
            }
            case 94: {
                return 48;
            }
            case 105: {
                return 65;
            }
            case 95: {
                return 49;
            }
            case 106: {
                return 66;
            }
            case 93: {
                return 50;
            }
            case 104: {
                return 67;
            }
            case 81: {
                return 51;
            }
            case 84: {
                return 52;
            }
            case 76: {
                return 53;
            }
            case 75: {
                return 54;
            }
            case 82: {
                return 55;
            }
            case 83: {
                return 56;
            }
            case 97: {
                return 57;
            }
            case 108: {
                return 74;
            }
            case 98: {
                return 58;
            }
            case 109: {
                return 75;
            }
            case 99: {
                return 59;
            }
            case 110: {
                return 76;
            }
            case 89: {
                return 60;
            }
            case 100: {
                return 77;
            }
            case 90: {
                return 61;
            }
            case 101: {
                return 78;
            }
            case 91: {
                return 62;
            }
            case 102: {
                return 79;
            }
            case 92: {
                return 63;
            }
            case 103: {
                return 80;
            }
            case 96: {
                return 64;
            }
            case 107: {
                return 81;
            }
            case 27: {
                return 28;
            }
        }
        return -1;
    }

    static int unopcode(int token) {
        switch (token) {
            case 89: {
                return 38;
            }
            case 90: {
                return 39;
            }
            case 77: {
                return 40;
            }
            case 78: {
                return 41;
            }
            case 87: {
                return 42;
            }
            case 88: {
                return 43;
            }
        }
        return -1;
    }

    static int typetag(int token) {
        switch (token) {
            case 6: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 43: {
                return 3;
            }
            case 28: {
                return 4;
            }
            case 30: {
                return 5;
            }
            case 20: {
                return 6;
            }
            case 15: {
                return 7;
            }
            case 4: {
                return 8;
            }
        }
        return -1;
    }
}

