/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.jp.Context;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.MethodAccess;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.Tools;
import gjc.v6.jp.TransRecurse;
import gjc.v6.tree.Pretty;
import gjc.v6.tree.Tree;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Position;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransBody
extends TransRecurse<Context>
implements Flags,
Kinds,
TypeTags {
    final RemoteNames rnames;
    final Tools tools;
    final JPSymtab syms;
    final Log log;
    protected int lockVarId = 0;

    public TransBody(Log log, Tools tools) {
        this.log = log;
        this.tools = tools;
        this.rnames = tools.rnames;
        this.syms = tools.syms;
    }

    Tree handleSpecialCall(Tree ref, Name name, List<Tree> args, Context context) {
        if (name == this.rnames.waitMethod) {
            args = args.prepend(ref);
            ref = this.tools.getRef(this.rnames.remoteTools);
            name = this.rnames.doWaitMethod;
        } else if (name == this.rnames.notifyMethod) {
            args = args.prepend(ref);
            ref = this.tools.getRef(this.rnames.remoteTools);
            name = this.rnames.doNotifyMethod;
        } else if (name == this.rnames.notifyAllMethod) {
            args = args.prepend(ref);
            ref = this.tools.getRef(this.rnames.remoteTools);
            name = this.rnames.doNotifyMethod;
        } else if (name == this.rnames.getClassMethod) {
            if (this.tools.isSelf(ref)) {
                ref = context.f.at(0).Ident(this.rnames._thisVariable);
            }
        } else {
            this.log.error(ref.pos, String.valueOf(String.valueOf("internal: unknown special call (").concat(String.valueOf(name))).concat(String.valueOf(")")));
            return ref;
        }
        context.f.at(0);
        return context.f.Apply(context.f.Select(ref, name), args);
    }

    @Override
    public Tree _case(Tree.Apply t, Context c) {
        Tree meth = t.meth;
        MethodAccess methodAccess = new MethodAccess(this.tools, c, meth, this.log);
        if (methodAccess.fun.owner == this.syms.objectType.tsym && this.tools.isFinal(methodAccess.fun) && (methodAccess.refType == this.syms.objectType || this.tools.isRemote(methodAccess.refType))) {
            t.args = ((TransRecurse)this).doVisit(t.args, c);
            return this.handleSpecialCall(methodAccess.ref, methodAccess.name, t.args, c);
        }
        if (this.tools.isStatic(methodAccess.fun) && this.tools.isRemote(methodAccess.fun.owner) && (c.clazz != methodAccess.fun.owner || !c.isStatic()) && c.clazz.subclass(methodAccess.fun.owner) && (t.meth instanceof Tree.Ident || t.meth.tag == 30 && this.tools.isSelf(((Tree.Select)t.meth).selected))) {
            c.f.at(0);
            t.meth = c.f.Select((Tree)c.f.Ident(methodAccess.refType.tsym.name), methodAccess.fun.name);
        } else if (!methodAccess.isStaticRef && !methodAccess.isSelfRef) {
            c.f.at(0);
            t.meth = c.f.Select(((TransRecurse)this).visit(methodAccess.ref, c), methodAccess.name);
        } else if (methodAccess.isStaticRef && c.isStatic() && c.clazz == methodAccess.fun.owner) {
            t.meth = c.f.Ident(methodAccess.fun.name);
        }
        t.args = ((TransRecurse)this).doVisit(t.args, c);
        return t;
    }

    static Type arrayElemType(Type type) {
        while (type.tag == 11) {
            type = ((Type.ArrayType)type).elemtype;
        }
        return type;
    }

    @Override
    public Tree _case(Tree.Assign t, Context c) {
        VarAccess varAccess = new VarAccess();
        varAccess.decomposeAccess(t.lhs, c);
        varAccess.makeAccessibleFrom(this, c);
        return varAccess.makeSetAccess(t.rhs.visit(this, c), c.f);
    }

    @Override
    public Tree _case(Tree.Assignop t, Context c) {
        VarAccess varAccess = new VarAccess();
        varAccess.decomposeAccess(t.lhs, c);
        varAccess.makeAccessibleFrom(this, c);
        return varAccess.makeOpAccess(t.tag, t.rhs.visit(this, c), c.f);
    }

    @Override
    public Tree _case(Tree.Ident t, Context c) {
        if (this.tools.isSelf(t)) {
            if (this.tools.isRemote(c.clazz)) {
                if (t.name == Names._this) {
                    c.f.at(0);
                    return c.f.TypeCast(this.tools.getRef(c.clazz), c.f.Ident(this.rnames._thisVariable));
                }
                c.f.at(0);
                return c.f.TypeCast(this.tools.getRef(this.tools.getSuperClass(c.clazz)), c.f.Ident(this.rnames._thisVariable));
            }
            return t;
        }
        VarAccess varAccess = new VarAccess();
        varAccess.decomposeAccess(t, c);
        varAccess.makeAccessibleFrom(this, c);
        return varAccess.makeGetAccess(c.f);
    }

    @Override
    public Tree _case(Tree.Select t, Context c) {
        if (t.name == Names._class) {
            return t;
        }
        VarAccess varAccess = new VarAccess();
        varAccess.decomposeAccess(t, c);
        varAccess.makeAccessibleFrom(this, c);
        return varAccess.makeGetAccess(c.f);
    }

    @Override
    public Tree _case(Tree.Indexed t, Context c) {
        VarAccess varAccess = new VarAccess();
        varAccess.decomposeAccess(t, c);
        varAccess.makeAccessibleFrom(this, c);
        return varAccess.makeGetAccess(c.f);
    }

    @Override
    public Tree _case(Tree.Operation t, Context c) {
        List<Tree> args = t.args;
        if (args.isEmpty()) {
            this.log.error(t.pos, "internal: no arguments");
            return t;
        }
        List<Tree> lhs = args;
        args = args.tail;
        if (args.isEmpty()) {
            if (t.tag == 42 || t.tag == 43 || t.tag == 44 || t.tag == 45) {
                VarAccess access = new VarAccess();
                access.decomposeAccess((Tree)lhs.head, c);
                access.makeAccessibleFrom(this, c);
                return access.makeIncAccess(t.tag, c.f);
            }
            lhs.head = ((Tree)lhs.head).visit(this, c);
            return t;
        }
        List<Tree> rhs = args;
        args = args.tail;
        if (args.isEmpty()) {
            if ((t.tag == 51 || t.tag == 52) && this.tools.maybeRemote((Tree)lhs.head) && this.tools.maybeRemote((Tree)rhs.head)) {
                c.f.at(0);
                Tree tree = c.f.Apply(this.tools.getRef(this.rnames.doEqualsMethod), List.make(((Tree)lhs.head).visit(this, c), ((Tree)rhs.head).visit(this, c)));
                if (t.tag == 52) {
                    tree = c.f.Operation(40, new List<Tree>(tree));
                }
                return tree;
            }
            lhs.head = ((Tree)lhs.head).visit(this, c);
            rhs.head = ((Tree)rhs.head).visit(this, c);
            return t;
        }
        this.log.error(t.pos, String.valueOf(String.valueOf("internal: more than 2 arguments (").concat(String.valueOf(args.length() + 2))).concat(String.valueOf(")")));
        return t;
    }

    @Override
    public Tree _case(Tree.Synchronized t, Context c) {
        Tree.Block result;
        t.body = t.body.visit(this, c);
        if (this.tools.isSelf(t.lock)) {
            if (this.tools.isRemote(c.clazz) && !this.rnames.with_karmi) {
                c.f.at(0);
                t.body = c.f.Block(0, List.make(c.f.Exec(c.f.Apply(c.f.Ident(this.rnames._testlockMethod), new List<Tree>())), t.body));
                return t;
            }
            return t;
        }
        Tree origLockExpr = t.lock;
        VarAccess access = new VarAccess();
        access.decomposeAccess(origLockExpr, c);
        access.makeAccessibleFrom(this, c);
        t.lock = access.makeGetAccess(c.f);
        Name lockVar = this.rnames._syncedObjectVariablePrefix.append(Name.fromString(String.valueOf(this.lockVarId++)));
        Name rma = this.rnames._syncedObjectVariablePrefix.append(Name.fromString(String.valueOf(this.lockVarId++)));
        boolean possiblyRemote = this.tools.maybeRemote(origLockExpr);
        boolean surelyRemote = this.tools.isRemote(origLockExpr.type);
        if (!possiblyRemote) {
            return t;
        }
        c.f.at(0);
        Tree.Block rmaBlock = c.f.Block(0, List.make(c.f.VarDef(0, rma, this.tools.getTypeRef(this.syms.objectType), c.f.Apply(this.tools.getRef(this.rnames.rmaAcquire), new List<Tree>(c.f.TypeCast(this.tools.getTypeRef(this.syms.remoteType), c.f.Ident(lockVar))))), c.f.Try(t.body, new List<Tree.Catch>(), c.f.Block(0, new List<Tree>(c.f.Exec(c.f.Apply(this.tools.getRef(this.rnames.rmaRelease), new List<Tree>(c.f.Ident(rma)))))))));
        if (this.rnames.with_karmi) {
            Name name = this.rnames._syncedObjectVariablePrefix.append(Name.fromString(String.valueOf(this.lockVarId++)));
            result = c.f.Block(0, List.make(c.f.VarDef(0, lockVar, this.tools.getTypeRef(origLockExpr.type), access.makeGetAccess(c.f)), c.f.VarDef(0, name, this.tools.getTypeRef(this.syms.objectType), c.f.Conditional(16, c.f.TypeTest(c.f.Ident(lockVar), this.tools.getTypeRef(this.syms.remoteType)), c.f.Apply(c.f.Select((Tree)c.f.TypeCast(this.tools.getTypeRef(this.syms.remoteType), c.f.Ident(lockVar)), Name.fromString("_getImpl")), new List<Tree>()), c.f.Ident(lockVar))), c.f.Conditional(17, c.f.Operation(51, List.make(c.f.Ident(name), c.f.Ident(Name.fromString("null")))), rmaBlock, c.f.Synchronized(c.f.Ident(name), t.body.visit(c.transCopy, c.f)))));
        } else {
            result = c.f.Block(0, List.make(c.f.VarDef(0, lockVar, this.tools.getTypeRef(origLockExpr.type), access.makeGetAccess(c.f)), surelyRemote ? rmaBlock : c.f.Conditional(17, c.f.TypeTest(c.f.Ident(lockVar), this.tools.getTypeRef(this.syms.remoteType)), rmaBlock, c.f.Synchronized(c.f.Ident(lockVar), t.body.visit(c.transCopy, c.f)))));
        }
        return result;
    }

    @Override
    public Tree _case(Tree.TopLevel t, Context c) {
        long msec = System.currentTimeMillis();
        System.out.print(String.valueOf(String.valueOf("[generating remote classes of '").concat(String.valueOf(t.sourcefile))).concat(String.valueOf("' ")));
        List<Tree> list = t.defs;
        while (list.nonEmpty()) {
            list.head = ((Tree)list.head).visit(this, c);
            list = list.tail;
        }
        System.out.println(String.valueOf(System.currentTimeMillis() - msec).concat(String.valueOf("ms]")));
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tree _case(Tree.ClassDef t, Context c) {
        Name prevSrc = this.log.useSource(c.toplevel.sourcefile);
        try {
            Tree.ClassDef classDef;
            int parentState = c.getState();
            Symbol.ClassSymbol classSymbol = c.setClass(t.sym);
            try {
                if (this.tools.transportableGenerator == null && !this.tools.isSerializable(t.sym)) {
                    t.implementing = new List<Tree>(this.tools.getRef(this.syms.serializableType.tsym.fullName().toList()), t.implementing);
                }
                if (!this.tools.isRemote(t.sym)) {
                    t.defs = ((TransRecurse)this).doVisit(t.defs, c);
                }
                classDef = t;
                Object var8_7 = null;
                c.setClass(classSymbol);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                c.setClass(classSymbol);
                c.setState(parentState);
                throw throwable;
            }
            c.setState(parentState);
            Object var10_9 = null;
            this.log.useSource(prevSrc);
            return classDef;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.log.useSource(prevSrc);
            throw throwable;
        }
    }

    @Override
    public Tree _case(Tree.MethodDef t, Context c) {
        Tree.MethodDef methodDef;
        int n = c.setStatic(this.tools.isStatic(t));
        try {
            if (!this.tools.isAbstract(t.sym)) {
                t.body = (Tree.Block)t.body.visit(this, c);
            }
            methodDef = t;
            Object var6_5 = null;
            c.setState(n);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            c.setState(n);
            throw throwable;
        }
        return methodDef;
    }

    @Override
    public Tree _case(Tree.Block t, Context c) {
        if (c.isClassLevel()) {
            Object object;
            int n = c.setStatic(this.tools.isStatic(t));
            try {
                object = super._case(t, (Object)c);
                Object var6_5 = null;
                c.setState(n);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                c.setState(n);
                throw throwable;
            }
            return object;
        }
        return super._case(t, (Object)c);
    }

    @Override
    public Tree _case(Tree.Import that, Context context) {
        return that;
    }

    @Override
    public Tree _case(Tree.VarDef t, Context c) {
        if (c.isClassLevel()) {
            Tree.VarDef varDef;
            int n = c.setStatic(this.tools.isStatic(t));
            try {
                t.init = ((TransRecurse)this).visit(t.init, c);
                varDef = t;
                Object var6_5 = null;
                c.setState(n);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                c.setState(n);
                throw throwable;
            }
            return varDef;
        }
        t.init = ((TransRecurse)this).visit(t.init, c);
        return t;
    }

    @Override
    public Tree _case(Tree.TypeCast that, Context context) {
        that.expr = ((TransRecurse)this).visit(that.expr, context);
        return that;
    }

    @Override
    public Tree _case(Tree.TypeTest that, Context context) {
        that.expr = ((TransRecurse)this).visit(that.expr, context);
        return that;
    }

    @Override
    public Tree _case(Tree.NewClass that, Context context) {
        that.args = ((TransRecurse)this).doVisit(that.args, context);
        that.def = (Tree.ClassDef)((TransRecurse)this).visit(that.def, context);
        if (that.at != null) {
            context.f.at(0);
            that.args = that.args.prepend(context.f.Apply(context.f.Select((Tree)context.f.Select((Tree)context.f.Select((Tree)context.f.Ident(Name.fromString("jp")), Name.fromString("lang")), Name.fromString("Node")), Name.fromString("getNode")), List.make(((TransRecurse)this).visit(that.at, context))));
        }
        return that;
    }

    @Override
    public Tree _case(Tree.NewArray that, Context context) {
        that.dims = ((TransRecurse)this).doVisit(that.dims, context);
        that.elems = ((TransRecurse)this).doVisit(that.elems, context);
        return that;
    }

    private String debugPos(Tree expr) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(out);
        Pretty printer = new Pretty(print);
        printer.printStat(expr);
        if (expr.pos == 0) {
            return String.valueOf(out.toString()).concat(String.valueOf(": "));
        }
        int line = Position.line(expr.pos);
        int n = Position.column(expr.pos);
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("line ").concat(String.valueOf(line))).concat(String.valueOf(", col "))).concat(String.valueOf(n))).concat(String.valueOf(": "))).concat(String.valueOf(out.toString()))).concat(String.valueOf(": "));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Select x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Indexed x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeTest x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeCast x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewArray x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Throw x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Return x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Continue x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Break x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Exec x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Conditional x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Try x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Case x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Switch x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Labelled x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ForLoop x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.DoLoop x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Block x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Import x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TopLevel x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ List doVisit(List x0, Object object) {
        return super.doVisit(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Tree visit(Tree x0, Object object) {
        return super.visit(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return super._case(x0, (Object)((Context)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return this._case(x0, (Context)object);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VarAccess {
        public Tree expr;
        public Symbol.VarSymbol var;
        public boolean isStaticRef;
        public boolean isSelfRef;
        public Tree ref;
        public Name name;
        public List<Tree> indices;
        public List<Tree> casts;
        public boolean hasTypeCast;
        public boolean direct;
        List<Tree> directIndices;
        List<Tree> directCasts;

        VarAccess() {
        }

        public boolean decomposeAccess(Tree _expr, Context c) {
            this.expr = _expr;
            this.indices = new List();
            this.casts = new List();
            this.hasTypeCast = false;
            while (_expr.tag == 29 || _expr.tag == 27) {
                if (_expr.tag == 29) {
                    Tree.Indexed indexed = (Tree.Indexed)_expr;
                    this.indices = new List<Tree>(indexed.index, this.indices);
                    _expr = indexed.indexed;
                } else {
                    this.indices = new List<Tree>(null, this.indices);
                }
                if (_expr.tag == 27) {
                    Tree.TypeCast typecast = (Tree.TypeCast)_expr;
                    this.casts = new List<Tree>(typecast.clazz, this.casts);
                    this.hasTypeCast = true;
                    _expr = typecast.expr;
                    continue;
                }
                this.casts = new List<Tree>(null, this.casts);
            }
            switch (_expr.tag) {
                case 30: {
                    Tree.Select select = (Tree.Select)_expr;
                    if (select.sym == null) {
                        TransBody.this.log.error(select.pos, String.valueOf(String.valueOf("internal: no symbol found for select expression '").concat(String.valueOf(select.name))).concat(String.valueOf("'")));
                        return false;
                    }
                    if (select.sym.kind != 4) {
                        TransBody.this.log.error(select.pos, String.valueOf(String.valueOf("internal: not a variable (").concat(String.valueOf(select.sym.kind))).concat(String.valueOf(")")));
                        return false;
                    }
                    this.ref = select.selected;
                    this.isStaticRef = TransBody.this.tools.isStaticRef(this.ref);
                    this.isSelfRef = TransBody.this.tools.isSelf(this.ref);
                    if (!this.isStaticRef && !this.isSelfRef) {
                        this.ref = this.ref.visit(c.transBody, c);
                    }
                    this.name = select.name;
                    this.var = (Symbol.VarSymbol)select.sym;
                    return true;
                }
                case 31: {
                    Tree.Ident ident = (Tree.Ident)_expr;
                    if (ident.sym == null) {
                        TransBody.this.log.error(ident.pos, String.valueOf(String.valueOf("internal: no symbol found for identifier '").concat(String.valueOf(ident.name))).concat(String.valueOf("'")));
                        return false;
                    }
                    if (ident.sym.kind != 4) {
                        TransBody.this.log.error(ident.pos, String.valueOf(String.valueOf("internal: not a variable (").concat(String.valueOf(ident.sym.kind))).concat(String.valueOf(")")));
                        return false;
                    }
                    this.name = ident.name;
                    this.var = (Symbol.VarSymbol)ident.sym;
                    if (this.var == TransBody.this.syms.nullConst || this.var == TransBody.this.syms.trueConst || this.var == TransBody.this.syms.falseConst) {
                        this.ref = null;
                        this.isStaticRef = false;
                        this.isSelfRef = true;
                        return false;
                    }
                    switch (this.var.owner.kind) {
                        case 2: {
                            if (TransBody.this.tools.isStatic(this.var)) {
                                this.ref = TransBody.this.tools.getRef(this.var.owner);
                                this.isStaticRef = true;
                                this.isSelfRef = true;
                            } else {
                                boolean definedInOuterClass = false;
                                Type vowner = this.var.owner.type;
                                Type type = c.clazz.type;
                                while (!type.subType(vowner)) {
                                    type = type.outer();
                                    definedInOuterClass = true;
                                }
                                if (TransBody.this.tools.isRemote(type)) {
                                    c.f.at(0);
                                    this.ref = c.f.Ident(Names._this);
                                } else if (!TransBody.this.tools.hasRef(type.tsym)) {
                                    this.ref = null;
                                } else if (definedInOuterClass) {
                                    c.f.at(0);
                                    this.ref = c.f.Select(TransBody.this.tools.getRef(type.tsym), Names._this);
                                } else {
                                    c.f.at(0);
                                    this.ref = c.f.Ident(Names._this);
                                }
                                this.isStaticRef = false;
                                this.isSelfRef = true;
                            }
                            return true;
                        }
                        case 32: {
                            this.ref = null;
                            this.isStaticRef = false;
                            this.isSelfRef = true;
                            return false;
                        }
                    }
                    TransBody.this.log.error(ident.pos, String.valueOf(String.valueOf("internal: unexpected var owner (").concat(String.valueOf(this.var.owner.kind))).concat(String.valueOf(")")));
                    return false;
                }
            }
            this.ref = _expr;
            this.isStaticRef = false;
            this.isSelfRef = false;
            this.name = null;
            this.var = null;
            return false;
        }

        public void makeAccessibleFrom(Tree.Visitor<Tree, Context> v, Context c) {
            List<Tree> list = this.indices;
            while (list.nonEmpty()) {
                if (list.head != null) {
                    list.head = ((Tree)list.head).visit(v, c);
                }
                list = list.tail;
            }
            if (this.var == null) {
                this.direct = true;
                return;
            }
            if (this.ref == null) {
                this.direct = true;
                return;
            }
            if (TransBody.this.tools.isLocal(this.var)) {
                this.direct = true;
                this.ref = null;
                return;
            }
            if (TransBody.this.tools.isInterface(this.var.owner) || TransBody.this.tools.isRemote(this.var.owner) && (TransBody.this.tools.isConstant(this.var) || TransBody.this.tools.isReplicable(this.var) && (!c.isStatic() || c.clazz != this.var.owner))) {
                this.direct = true;
                if (this.isStaticRef) {
                    return;
                }
                if (this.isSelfRef) {
                    this.ref = TransBody.this.tools.getRef(this.var.owner);
                    return;
                }
                return;
            }
            if (!TransBody.this.tools.isRemote(this.var.owner)) {
                this.direct = true;
                return;
            }
            if (TransBody.this.tools.isStatic(this.var)) {
                if (this.isStaticRef) {
                    if (c.isStatic() && this.var.owner == c.clazz) {
                        this.direct = true;
                        c.f.at(0);
                        this.ref = c.f.Ident(Names._this);
                    } else {
                        this.direct = false;
                        this.ref = TransBody.this.tools.getRef(TransBody.this.tools.getHandle((Symbol.ClassSymbol)this.var.owner).toList());
                    }
                } else if (this.isSelfRef) {
                    this.direct = false;
                    this.ref = TransBody.this.tools.getRef(TransBody.this.tools.getHandle((Symbol.ClassSymbol)this.var.owner).toList());
                } else if (c.isStatic() && this.var.owner == c.clazz) {
                    this.direct = true;
                    c.f.at(0);
                    this.ref = c.f.Apply(c.f.Ident(TransBody.this.rnames._ClassType_Method), new List<Tree>(this.ref));
                } else {
                    this.direct = false;
                }
            } else {
                this.direct = this.isSelfRef;
            }
        }

        private Tree makeDirectIndexedAccess(Tree _expr, Tree.Factory f) {
            List<Tree> _indices = this.indices;
            List<Tree> list = this.casts;
            while (list.nonEmpty()) {
                if (list.head != null) {
                    _expr = f.TypeCast((Tree)list.head, _expr);
                }
                list = list.tail;
                if (_indices.head != null) {
                    _expr = f.Indexed(_expr, (Tree)_indices.head);
                }
                _indices = _indices.tail;
            }
            return _expr;
        }

        private Tree makeDirectVarAccess(Tree.Factory factory) {
            if (this.var != null) {
                return this.makeDirectIndexedAccess(this.ref != null ? factory.Select(this.ref, this.name) : factory.Ident(this.name), factory);
            }
            return this.makeDirectIndexedAccess(this.ref, factory);
        }

        private List<Tree> getIndexArguments(List<Tree> args) {
            List<Tree> first;
            List<Tree> next = first = new List<Tree>(null, args);
            List<Tree> list = this.indices;
            while (list.nonEmpty()) {
                if (list.head != null) {
                    next.tail = new List<Tree>((Tree)list.head, args);
                    next = next.tail;
                }
                list = list.tail;
            }
            return first.tail;
        }

        private List<Tree> getIndexArguments() {
            return this.getIndexArguments(new List<Tree>());
        }

        public Tree makeMethodGetAccess(Tree.Factory factory) {
            return factory.Apply(factory.Select(this.ref, TransBody.this.tools.getMethod(this.var)), this.getIndexArguments());
        }

        public Tree makeGetAccess(Tree.Factory f) {
            if (this.direct) {
                return this.makeDirectVarAccess(f);
            }
            if (this.splittIndices()) {
                Tree tree = this.makeMethodGetAccess(f);
                this.indices = this.directIndices;
                this.casts = this.directCasts;
                return this.makeDirectIndexedAccess(tree, f);
            }
            return this.makeMethodGetAccess(f);
        }

        public Tree makeSetAccess(Tree rhs, Tree.Factory f) {
            if (this.direct) {
                return this.makeDirectSetAccess(this.makeDirectVarAccess(f), rhs, f);
            }
            if (this.splittIndices()) {
                Tree tree = this.makeMethodGetAccess(f);
                this.indices = this.directIndices;
                this.casts = this.directCasts;
                return this.makeDirectSetAccess(this.makeDirectIndexedAccess(tree, f), rhs, f);
            }
            return this.makeMethodSetAccess(rhs, f);
        }

        private Tree makeDirectSetAccess(Tree lhs, Tree rhs, Tree.Factory factory) {
            return factory.Assign(lhs, rhs);
        }

        private Tree makeMethodSetAccess(Tree rhs, Tree.Factory factory) {
            return factory.Apply(factory.Select(this.ref, TransBody.this.tools.setMethod(this.var)), this.getIndexArguments(new List<Tree>(rhs)));
        }

        private Tree makeMethodIncAccess(Tree value, boolean isPost, Tree.Factory f) {
            Tree.Ident isPostLit = TransBody.this.tools.createBooleanLiteral(isPost);
            List<Tree> list = this.getIndexArguments(List.make(value, isPostLit));
            return f.Apply(f.Select(this.ref, TransBody.this.tools.incMethod(this.var)), list);
        }

        public Tree makeOpAccess(int opcode, Tree rhs, Tree.Factory f) {
            if (this.direct) {
                return f.Assignop(opcode, this.makeDirectVarAccess(f), rhs);
            }
            if (this.splittIndices()) {
                Tree tree = this.makeMethodGetAccess(f);
                this.indices = this.directIndices;
                this.casts = this.directCasts;
                return f.Assignop(opcode, this.makeDirectIndexedAccess(tree, f), rhs);
            }
            switch (opcode) {
                case 78: {
                    rhs = f.Operation(39, new List<Tree>(rhs));
                }
                case 77: {
                    return this.makeMethodIncAccess(rhs, false, f);
                }
            }
            TransBody.this.log.error(rhs.pos, String.valueOf(String.valueOf("internal: unsupported assign op (").concat(String.valueOf(opcode))).concat(String.valueOf(")")));
            return rhs;
        }

        private boolean splittIndices() {
            List<Tree> list;
            List<Tree> index;
            ListBuffer methodIndices;
            block3: {
                methodIndices = new ListBuffer();
                index = this.indices;
                list = this.casts;
                while (list.nonEmpty()) {
                    if (list.head == null) {
                        list = list.tail;
                        if (index.head != null) {
                            methodIndices.append(index.head);
                        }
                        index = index.tail;
                        continue;
                    }
                    break block3;
                }
                this.directIndices = new List();
                this.directCasts = new List();
                this.indices = methodIndices.toList();
                this.casts = List.make(this.indices.length(), (Tree)null);
                return false;
            }
            this.directIndices = index;
            this.directCasts = list;
            this.indices = methodIndices.toList();
            this.casts = null;
            return true;
        }

        public Tree makeIncAccess(int opcode, Tree.Factory f) {
            boolean bl;
            Tree.Literal numLit;
            if (this.direct) {
                return f.Operation(opcode, List.make(this.makeDirectVarAccess(f)));
            }
            if (this.splittIndices()) {
                Tree subexpr = this.makeMethodGetAccess(f);
                this.indices = this.directIndices;
                this.casts = this.directCasts;
                return f.Operation(opcode, List.make(this.makeDirectIndexedAccess(subexpr, f)));
            }
            Type type = TransBody.arrayElemType(this.expr.type);
            switch (opcode) {
                case 44: {
                    numLit = TransBody.this.tools.createNumberLiteral(type, 1);
                    bl = true;
                    break;
                }
                case 45: {
                    numLit = TransBody.this.tools.createNumberLiteral(type, -1);
                    bl = true;
                    break;
                }
                case 42: {
                    numLit = TransBody.this.tools.createNumberLiteral(type, 1);
                    bl = false;
                    break;
                }
                case 43: {
                    numLit = TransBody.this.tools.createNumberLiteral(type, -1);
                    bl = false;
                    break;
                }
                default: {
                    throw new InternalError(String.valueOf(String.valueOf("unexpected opcode (").concat(String.valueOf(opcode))).concat(String.valueOf(")")));
                }
            }
            return this.makeMethodIncAccess(numLit, bl, f);
        }
    }
}

