/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.MethodInfo;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.jp.Tools;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaRMIcGenerator {
    public final boolean traditional = false;
    private Type remoteInterface;
    private Type immutableType;
    public final Tools tools;
    public final Log log;
    public final RemoteNames rnames;
    public final JPSymtab syms;
    private final boolean stubdebug;
    private final boolean skelonly;
    private Type[] TYPES;
    private String[] UPPERCASENAMES = new String[]{"Byte", "Char", "Short", "Int", "Long", "Float", "Double", "Boolean", "Object", "Void"};
    static int[] IDX = new int[19];
    public static final int SIZEOF_boolean = 1;
    public static final int SIZEOF_byte = 1;
    public static final int SIZEOF_char = 2;
    public static final int SIZEOF_short = 2;
    public static final int SIZEOF_int = 4;
    public static final int SIZEOF_long = 8;
    public static final int SIZEOF_float = 4;
    public static final int SIZEOF_double = 8;
    static int[] SIZEOF = new int[]{1, 2, 2, 4, 8, 4, 8, 1};
    public static final String EMPTY = "";
    private List<SourceGenerator> code;

    public KaRMIcGenerator(Hashtable<String, String> options, Tools tools, Log log) {
        KaRMIcGenerator.IDX[1] = 0;
        KaRMIcGenerator.IDX[2] = 1;
        KaRMIcGenerator.IDX[3] = 2;
        KaRMIcGenerator.IDX[4] = 3;
        KaRMIcGenerator.IDX[5] = 4;
        KaRMIcGenerator.IDX[6] = 5;
        KaRMIcGenerator.IDX[7] = 6;
        KaRMIcGenerator.IDX[8] = 7;
        KaRMIcGenerator.IDX[10] = 8;
        KaRMIcGenerator.IDX[11] = 8;
        KaRMIcGenerator.IDX[9] = 9;
        this.tools = tools;
        this.log = log;
        this.syms = tools.syms;
        this.rnames = tools.rnames;
        this.skelonly = options.get("-skelonly") != null;
        this.stubdebug = options.get("-stubdebug") != null;
        this.remoteInterface = this.syms.reader.loadClass((Name)tools.rnames.nameRemote).type;
        this.immutableType = null;
        this.TYPES = new Type[]{Type.byteType, Type.charType, Type.shortType, Type.intType, Type.longType, Type.floatType, Type.doubleType, Type.booleanType, this.syms.objectType, Type.voidType};
    }

    private Type getImmutableType() {
        if (this.immutableType == null) {
            this.immutableType = this.syms.reader.loadClass((Name)Name.fromString((String)"uka.lang.Immutable")).type;
        }
        return this.immutableType;
    }

    private List<Type.ClassType> getRemoteInterfaces(Type.ClassType clazz) {
        Set interfaceSet = new Set();
        List<Type.ClassType> result = new List<Type.ClassType>();
        while (clazz != this.syms.objectType) {
            List<Type> interfaces = clazz.interfaces();
            while (interfaces.nonEmpty()) {
                if (((Type)interfaces.head).subType(this.remoteInterface) && !interfaceSet.contains(interfaces.head)) {
                    interfaceSet.put(interfaces.head);
                    result = result.prepend((Type.ClassType)interfaces.head);
                    List<Type> list = ((Type.ClassType)interfaces.head).interfaces();
                    while (list.nonEmpty()) {
                        if (!interfaceSet.contains(list.head)) {
                            interfaceSet.put(list.head);
                            result = result.prepend((Type.ClassType)list.head);
                        }
                        list = list.tail;
                    }
                }
                interfaces = interfaces.tail;
            }
            clazz = (Type.ClassType)clazz.supertype();
        }
        return result;
    }

    private List<Symbol.MethodSymbol> getRemoteMethods(Type.ClassType clazz, List<Type.ClassType> interfaces, boolean newlyDeclaredOnly) {
        Type.ClassType superClazz = (Type.ClassType)clazz.supertype();
        Set<Symbol.MethodSymbol> methodSet = new Set<Symbol.MethodSymbol>();
        List<Symbol.MethodSymbol> result = new List<Symbol.MethodSymbol>();
        while (interfaces.nonEmpty()) {
            Scope.Entry member = ((Type.ClassType)interfaces.head).tsym.members().elems;
            while (member != null && member.scope != null) {
                block11: {
                    Symbol.MethodSymbol method;
                    block13: {
                        block12: {
                            if (member.sym.kind != 32 || this.tools.isStatic(member.sym)) break block11;
                            method = ((Symbol.MethodSymbol)member.sym).implementation(clazz.tsym);
                            if (method != null) break block12;
                            if (!this.tools.isAbstract(clazz.tsym)) {
                                throw new InternalError(String.valueOf(String.valueOf(member.sym).concat(String.valueOf(" not found in "))).concat(String.valueOf(clazz.tsym)));
                            }
                            break block11;
                        }
                        if (!newlyDeclaredOnly) break block13;
                        Symbol.MethodSymbol superMethod = ((Symbol.MethodSymbol)member.sym).implementation(superClazz.tsym);
                        if (method.owner.type != clazz || superMethod != null) break block11;
                    }
                    if (!methodSet.contains(method)) {
                        methodSet.put(method);
                        boolean remoteExceptionDeclared = false;
                        Type.MethodType mtype = (Type.MethodType)member.sym.type;
                        List<Symbol.ClassSymbol> list = mtype.thrown;
                        while (list.nonEmpty()) {
                            if (this.syms.remoteExceptionType.assignable(((Symbol.ClassSymbol)list.head).type)) {
                                remoteExceptionDeclared = true;
                                break;
                            }
                            list = list.tail;
                        }
                        if (!remoteExceptionDeclared) {
                            this.log.error(0, String.valueOf(String.valueOf(String.valueOf(member.sym).concat(String.valueOf(" of "))).concat(String.valueOf(interfaces.head))).concat(String.valueOf(" does not declare RemoteException to be thrown")));
                        }
                        result = result.prepend(method);
                    }
                }
                member = member.sibling;
            }
            interfaces = interfaces.tail;
        }
        return result;
    }

    public static Name formFlatInnerName(Name name, Symbol owner) {
        if (owner == null || owner.kind != 2) {
            return name;
        }
        Name prefix = KaRMIcGenerator.formFlatInnerName(owner.name, owner.owner);
        if (prefix == null || prefix.len == 0) {
            return name;
        }
        return prefix.append(Names.dollar).append(name);
    }

    public void prepareScopeForClass(SourceGenerator.Scope s, String pkg, String clazz, String superClazz, String fullClazz, String flatInnerClazz, String interfaces, boolean bl) {
        s.set("stubPostfix", "_KStub");
        s.set("skelPostfix", "_KSkel");
        s.set("KaRMIPackage", this.rnames.nameKaRMIPackage);
        s.set("Remote", this.rnames.nameRemote);
        s.set("RemoteException", this.rnames.nameRemoteException);
        s.set("RootStub", this.rnames.nameRemoteStub);
        s.set("RootSkel", this.rnames.nameRemoteSkeleton);
        s.set("package", pkg);
        s.set("Class", clazz);
        if (this.rnames.karmi_with_smartstubs) {
            if (bl) {
                s.set("SuperStub", "@RootStub@");
            } else {
                s.set("Super", superClazz);
                s.set("SuperStub", "@Super@@stubPostfix@");
            }
        } else {
            s.set("SuperStub", "@RootStub@");
        }
        s.set("fullClass", fullClazz);
        s.set("flatClass", flatInnerClazz);
        s.set("StubClass", "@flatClass@@stubPostfix@");
        s.set("SkelClass", "@flatClass@@skelPostfix@");
        s.set("interfaces", interfaces);
        if (this.rnames.karmi_with_smartstubs) {
            s.set("remoteServer", "((@fullClass@) remoteServer)");
        } else {
            s.set("remoteServer", "remoteServer");
        }
    }

    public void prepareScopeForClass(SourceGenerator.Scope s, List<Type.ClassType> interfaces, Type.ClassType clazz) {
        Symbol pkg = clazz.tsym.owner;
        while (pkg.kind != 1) {
            pkg = pkg.owner;
        }
        StringBuffer interfacesS = new StringBuffer();
        List<Type.ClassType> list = interfaces;
        while (list.nonEmpty()) {
            if (list != interfaces) {
                interfacesS.append(", ");
            }
            interfacesS.append(((Type.ClassType)list.head).toString());
            list = list.tail;
        }
        this.prepareScopeForClass(s, pkg.fullName().toString(), clazz.tsym.name.toString(), clazz.supertype().tsym.fullName().toString(), clazz.tsym.fullName().toString(), KaRMIcGenerator.formFlatInnerName(clazz.tsym.name, clazz.tsym.owner).toString(), interfacesS.toString(), !clazz.supertype().subType(this.remoteInterface));
    }

    public static String createTypeID(Type type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type.tsym.name.toString();
            }
            case 10: 
            case 13: {
                if (type.tsym.owner != Symbol.emptyPackage) {
                    return String.valueOf(String.valueOf(KaRMIcGenerator.createTypeID(type.tsym.owner.type)).concat(String.valueOf('_'))).concat(String.valueOf(type.tsym.name.toString()));
                }
                return type.tsym.name.toString();
            }
            case 11: {
                return String.valueOf("_").concat(String.valueOf(KaRMIcGenerator.createTypeID(((Type.ArrayType)type).elemtype)));
            }
            case 12: {
                List<Type> fst;
                StringBuffer result = new StringBuffer();
                List<Type> args = fst = ((Type.MethodType)type).argtypes;
                while (args.nonEmpty()) {
                    if (args != fst) {
                        result.append('$');
                    }
                    result.append(KaRMIcGenerator.createTypeID((Type)args.head));
                    args = args.tail;
                }
                return result.toString();
            }
        }
        throw new InternalError(String.valueOf(String.valueOf("Unexpected type '").concat(String.valueOf(type))).concat(String.valueOf("'")));
    }

    public static String createID(Name name, List<Type> type) {
        StringBuffer result = new StringBuffer();
        result.append("ID_");
        result.append(name.toString());
        result.append('$');
        List<Type> l = type;
        while (l.nonEmpty()) {
            if (l != type) {
                result.append('$');
            }
            result.append(KaRMIcGenerator.createTypeID((Type)l.head));
            l = l.tail;
        }
        return result.toString();
    }

    public static String createID(Name name, Type type) {
        return KaRMIcGenerator.createID(name, List.make(type));
    }

    public List<SourceGenerator> generate(Type.ClassType clazz) {
        this.code = new List();
        SourceGenerator.Scope s = new SourceGenerator.Scope();
        List<Type.ClassType> interfaces = this.getRemoteInterfaces(clazz);
        List<Symbol.MethodSymbol> methods = this.getRemoteMethods(clazz, interfaces, false);
        List<Symbol.MethodSymbol> list = this.rnames.karmi_with_smartstubs ? this.getRemoteMethods(clazz, interfaces, true) : methods;
        this.prepareScopeForClass(s, interfaces, clazz);
        this.code = this.code.prepend(this.generateSkel(s.createInner(), this.createInfo(methods)));
        if (!this.skelonly) {
            this.code = this.code.prepend(this.generateStub(s.createInner(), this.createInfo(list), this.tools.isAbstract(clazz.tsym)));
        }
        return this.code;
    }

    public List<MethodInfo> createInfo(List<Symbol.MethodSymbol> methods) {
        ListBuffer<MethodInfo> infos = new ListBuffer<MethodInfo>();
        List<Symbol.MethodSymbol> method = methods;
        while (method.nonEmpty()) {
            MethodInfo methodInfo = new MethodInfo(this.syms, (Symbol.MethodSymbol)method.head);
            infos.append(methodInfo);
            method = method.tail;
        }
        return infos.toList();
    }

    public SourceGenerator generateStub(SourceGenerator.Scope s, List<MethodInfo> stubMethods, boolean isAbstract) {
        SourceGenerator stub = new SourceGenerator(s.get("StubClass"));
        s.set("smart?:final", this.rnames.karmi_with_smartstubs ? EMPTY : "final");
        s.set("abstract?", isAbstract ? "abstract" : EMPTY);
        stub.append(s, "// Generated code, do not modify");
        stub.newLine();
        stub.append(s, "@package (package);\n@");
        stub.newLine();
        stub.append(s, "/** Stub class for remote class '@fullClass@' */");
        stub.append(s, "public @abstract?@ @smart?:final@ class @StubClass@ extends @SuperStub@");
        stub.append(s, "@  implements (interfaces@");
        stub.append(s, "{");
        stub.indent(2);
        stub.append(s, "/** Explicitly defined default constructor is necessary");
        stub.append(s, "    if uka.transport is used. */");
        stub.append(s, "public @StubClass@() {");
        stub.append(s, "  super();");
        stub.append(s, "}");
        stub.newLine();
        if (!this.rnames.karmi_with_smartstubs) {
            stub.append(s, "/** Shortcut reference to local server object. Generated in the application");
            stub.append(s, "    stub class to avoid a type cast in each method invocation. */");
            stub.append(s, "private transient @fullClass@ remoteServer;");
            stub.newLine();
            stub.append(s, "/** Implementation of the abstract method in uka.rmi.server.RemoteStub. Called");
            stub.append(s, "    from the KaRMI system to set a reference to a local server object. */");
            stub.append(s, "protected void _KARMI_setRemoteServer(@Remote@ remoteServer) {");
            stub.append(s, "  this.remoteServer = (@fullClass@) remoteServer;");
            stub.append(s, "}");
            stub.newLine();
        }
        if (this.rnames.karmi_with_smartstubs) {
            stub.append(s, "/** Smart stubs reuse the stub of the servers super class. The first");
            stub.append(s, "    method identifier can not be computed at class loading time, ");
            stub.append(s, "    because a compile time constant is needed in switch statements. */");
            stub.append(s, "private static final int ID_FIRSTMETHOD = @SuperStub@.ID_LASTMETHOD + 1;");
            stub.newLine();
            stub.append(s, "static { ");
            stub.append(s, "  if (ID_FIRSTMETHOD != @SuperStub@._KARMI_getLastMethodID() + 1) {");
            stub.append(s, "    // The compile time constants differ from the constant at class");
            stub.append(s, "    // loading time. This is an error due to incomplete separate");
            stub.append(s, "    // compilation");
            stub.append(s, "    throw new InternalError(");
            stub.append(s, "      \"Separate compilation problem: Please recompile \" +");
            stub.append(s, "      \"class '@fullClass@' and all its subclasses.\"");
            stub.append(s, "    );");
            stub.append(s, "  }");
            stub.append(s, "}");
            stub.newLine();
        } else {
            stub.append(s, "/** Full stubs declare stub methods for all exported server methods");
            stub.append(s, "    and do not reuse the stub of the servers super class. The first ");
            stub.append(s, "    method identifier used is always zero. */");
            stub.append(s, "private static final int ID_FIRSTMETHOD = 0;");
            stub.newLine();
        }
        int methodNr = 0;
        List<MethodInfo> method = stubMethods;
        while (method.nonEmpty()) {
            SourceGenerator.Scope sOuter = s;
            s = sOuter.createInner();
            MethodInfo minfo = (MethodInfo)method.head;
            this.prepareScopeForMethod(s, minfo);
            s.set("nr", Integer.toString(methodNr++));
            stub.append(s, "/** Method identifier for method @funimpl@(@params@) */");
            stub.append(s, "public static final int @id@ = ID_FIRSTMETHOD + @nr@;");
            stub.newLine();
            stub.append(s, "public @type@ @funimpl@(@params@) @throws (thrownstub@ {");
            stub.indent(2);
            this.generateStubBodyForMethod(s, stub, minfo);
            stub.unindent(2);
            stub.append(s, "}");
            stub.newLine();
            if (method.tail.isEmpty()) {
                stub.append(s, "/** Export the last method id to subclasses of ");
                stub.append(s, "    this stub class to produce unique method ids");
                stub.append(s, "    within a branch of the class hierarchy. */");
                stub.append(s, "protected static final int ID_LASTMETHOD = @id@;");
                stub.newLine();
                stub.append(s, "/** Allow check for separate compilation problems ");
                stub.append(s, "    at class loading time. */");
                stub.append(s, "protected static int _KARMI_getLastMethodID() {");
                stub.append(s, "  return ID_LASTMETHOD;");
                stub.append(s, "}");
                stub.newLine();
            }
            s = sOuter;
            method = method.tail;
        }
        if (this.rnames.karmi_with_transport) {
            SourceGenerator.Scope scope = s.createInner();
            scope.set("Class", "@StubClass@");
            scope.set("Super", "@SuperStub@");
            scope.set("Serializable", "uka.transport.Transportable");
            scope.set("MarshalStream", "uka.transport.MarshalStream");
            scope.set("UnmarshalStream", "uka.transport.UnmarshalStream");
            scope.set("BasicIO", "uka.transport.BasicIO");
            this.tools.transportableGenerator.generateFull(stub, scope, false, isAbstract, false, false, true, false, new List<Symbol.VarSymbol>());
        }
        stub.unindent(2);
        stub.append(s, "}");
        return stub;
    }

    public SourceGenerator generateSkel(SourceGenerator.Scope s, List<MethodInfo> methods) {
        SourceGenerator skel = new SourceGenerator(s.get("SkelClass"));
        skel.append(s, "// Generated code, do not modify");
        skel.newLine();
        skel.append(s, "@package (package);\n@");
        skel.newLine();
        skel.append(s, "/** Skeleton class for remote class '@fullClass@' */");
        skel.append(s, "public final class @SkelClass@ extends @RootSkel@ {");
        skel.append(s, "  /** reference to the implementation object */");
        skel.append(s, "  @fullClass@ impl;");
        skel.newLine();
        skel.append(s, "  /** Set the implementation object of this skeleton */");
        skel.append(s, "  public final void setRemoteObject(@Remote@ object) {");
        skel.append(s, "    this.impl = (@fullClass@) object;");
        skel.append(s, "  }");
        skel.newLine();
        skel.append(s, "  protected final @Remote@ getRemoteObject() {");
        skel.append(s, "    return this.impl;");
        skel.append(s, "  }");
        skel.newLine();
        skel.indent(2);
        skel.append(s, "/** Direct marshaling protocol: Generic invocation */");
        skel.append(s, "public final void doApplicationCall(@KaRMIPackage@.ServerConnection c) ");
        skel.append(s, "  throws java.io.IOException, ClassNotFoundException");
        skel.append(s, "{");
        skel.indent(2);
        skel.append(s, "switch(c.mid) {");
        skel.indent(2);
        List<MethodInfo> method = methods;
        while (method.nonEmpty()) {
            List<Type> types;
            SourceGenerator.Scope sOuter = s;
            s = sOuter.createInner();
            MethodInfo minfo = (MethodInfo)method.head;
            this.prepareScopeForMethod(s, minfo);
            MethodInfo.SortedParams sorted = new MethodInfo.SortedParams(minfo);
            skel.append(s, "case @fullid@: {");
            skel.indent(2);
            if (this.stubdebug) {
                skel.append(s, "System.err.println(\"DEBUG-TRACE: @SkelClass@: case @id@\");");
            }
            skel.append(s, "// unmarshal parameters");
            if (sorted.basicSize > 0) {
                s.set("basicSize", Integer.toString(sorted.basicSize));
                skel.append(s, "c.openReceivePrimitive(@basicSize@);");
                types = sorted.basicTypes.toList();
                List<Name> names = sorted.basicNames.toList();
                while (types.nonEmpty()) {
                    s.set("type", (Type)types.head);
                    s.set("Type", this.UPPERCASENAMES[IDX[((Type)types.head).tag]]);
                    s.set("name", (Name)names.head);
                    skel.append(s, "@type@ @name@ = c.receive@Type@();");
                    types = types.tail;
                    names = names.tail;
                }
                skel.append(s, "c.closeReceivePrimitive(@basicSize@);");
            }
            types = sorted.objectTypes.toList();
            List<Name> list = sorted.objectNames.toList();
            while (types.nonEmpty()) {
                s.set("type", (Type)types.head);
                s.set("name", (Name)list.head);
                skel.append(s, "@type@ @name@ = (@type@) c.receiveObject();");
                types = types.tail;
                list = list.tail;
            }
            skel.append(s, "c.closeReceiveCall();");
            skel.newLine();
            s.set("returnType", minfo.type);
            s.set("returnTYPE", this.UPPERCASENAMES[IDX[minfo.type.tag]]);
            switch (minfo.type.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    s.set("result", "result");
                    s.set("send", "sendSingle@returnTYPE@");
                    skel.append(s, "@returnType@ @result@;");
                    break;
                }
                case 9: {
                    s.set("result", EMPTY);
                    s.reset("send");
                    break;
                }
                case 10: 
                case 11: {
                    s.set("result", "result");
                    s.set("send", "sendObject");
                    skel.append(s, "@returnType@ @result@;");
                    break;
                }
                default: {
                    throw new InternalError(String.valueOf(String.valueOf("unexpected result type: '").concat(String.valueOf(minfo.type))).concat(String.valueOf("'")));
                }
            }
            skel.append(s, "try {");
            skel.append(s, "  // call the implementation");
            skel.append(s, "  @result) = @impl.@funimpl@(@args@);");
            skel.append(s, "} catch (Throwable ex) {");
            if (this.stubdebug) {
                skel.append(s, "  System.err.println(\"DEBUG-TRACE: excption thrown in @Class@.@fun@(@params@):\" + ex);");
            }
            skel.append(s, "  // marshal the server-side exception");
            skel.append(s, "  c.openSendResult(false);");
            skel.append(s, "  c.sendObject(ex);");
            skel.append(s, "  return;");
            skel.append(s, "}");
            skel.newLine();
            skel.append(s, "// marshal the return value");
            skel.append(s, "c.openSendResult(true);");
            if (s.hasVar("send")) {
                skel.append(s, "c.@send@(@result@);");
            }
            skel.append(s, "return;");
            skel.unindent(2);
            skel.append(s, "}");
            skel.newLine();
            s = sOuter;
            method = method.tail;
        }
        skel.unindent(2);
        skel.append(s, "  default:");
        skel.append(s, "    throw new InternalError(\"illegal method number (\" + c.mid + \")\");");
        skel.append(s, "  }");
        skel.unindent(2);
        skel.append(s, "}");
        skel.unindent(2);
        skel.append(s, "}");
        return skel;
    }

    private boolean setLocalConversion(SourceGenerator.Scope s, Type t) {
        boolean bl = false;
        if (t.tag <= 8 || t == Type.voidType || t == this.syms.langBooleanType || t == this.syms.langByteType || t == this.syms.langCharacterType || t == this.syms.langShortType || t == this.syms.langIntegerType || t == this.syms.langLongType || t == this.syms.langFloatType || t == this.syms.langDoubleType || t == this.syms.stringType || t.subType(this.getImmutableType())) {
            s.set("local[", EMPTY);
            s.set("]local", EMPTY);
        } else if (t.subType(this.remoteInterface)) {
            s.set("ptype", t);
            s.set("local[", "(@ptype@) @KaRMIPackage@.ExportPoint.toStub(");
            s.set("]local", ")");
        } else {
            bl = true;
            s.set("ptype", t);
            s.set("local[", "(@ptype@) _cenv.doDeepClone(");
            s.set("]local", ")");
        }
        return bl;
    }

    public void prepareScopeForMethod(SourceGenerator.Scope s, MethodInfo minfo) {
        minfo.set(s);
        s.set("id", KaRMIcGenerator.createID(minfo.funimpl, minfo.getParameterTypes()));
        s.set("fullid", "@package).@@StubClass@.@id@");
        s.set("Type", this.UPPERCASENAMES[IDX[minfo.type.tag]]);
        boolean needDuplication = false;
        s.set("localArgs", EMPTY);
        int n = 0;
        List<MethodInfo.ParamInfo> list = minfo.params;
        while (list.nonEmpty()) {
            s.set("ptype", ((MethodInfo.ParamInfo)list.head).type.toString());
            s.set("pname", ((MethodInfo.ParamInfo)list.head).name.toString());
            needDuplication |= this.setLocalConversion(s, ((MethodInfo.ParamInfo)list.head).type);
            s.set("localArgs", "@localArgs), @@local[@@pname@@]local@");
            list = list.tail;
            ++n;
        }
        if (needDuplication |= this.setLocalConversion(s, minfo.type)) {
            s.set("needDuplication", EMPTY);
        } else {
            s.reset("needDuplication");
        }
        if (minfo.type.subType(this.syms.objectType)) {
            s.set("stubcast", "(@type@)");
        } else if (minfo.type == Type.voidType) {
            s.set("stubcast", EMPTY);
        } else {
            s.set("stubcast", EMPTY);
        }
    }

    public void generateStubBodyForMethod(SourceGenerator.Scope s, SourceGenerator stub, MethodInfo minfo) {
        List<Name> names;
        List<Type> types;
        if (this.stubdebug) {
            stub.append(s, "System.err.println(\"DEBUG-TRACE: @StubClass@.@funimpl@()\");");
        }
        stub.append(s, "if (remoteServer != null) {");
        stub.indent(2);
        stub.append(s, "// short cut: call server implementation directly");
        if (s.hasVar("needDuplication")) {
            stub.append(s, "@KaRMIPackage@.CopyEnvironment _cenv = @KaRMIPackage@.Transport.getCopyEnvironment();");
            stub.append(s, "try {");
            stub.indent(2);
        }
        stub.append(s, "@returnEarly) @@local[@@remoteServer@.@funimpl@(@localArgs@)@]local@;");
        stub.append(s, "@returnLate);@");
        if (s.hasVar("needDuplication")) {
            stub.unindent(2);
            stub.append(s, "} catch (CloneNotSupportedException ex) {");
            stub.append(s, "  throw new @RemoteException@(\"KaRMIc: arg or result not clonable\", ex);");
            stub.append(s, "} finally {");
            stub.append(s, "  @KaRMIPackage@.Transport.putCopyEnvironment(_cenv);");
            stub.append(s, "}");
        }
        stub.unindent(2);
        stub.append(s, "} else {");
        stub.indent(2);
        MethodInfo.SortedParams sorted = new MethodInfo.SortedParams(minfo);
        stub.append(s, "@KaRMIPackage@.ClientConnection _c = remoteClientRef.getContext(@fullid@);");
        stub.newLine();
        stub.append(s, "Throwable resultex;");
        stub.append(s, "try {");
        stub.append(s, "  _c.openSendCall();");
        if (sorted.basicSize > 0) {
            s.set("basicSize", Integer.toString(sorted.basicSize));
            stub.append(s, "  _c.openSendPrimitive(@basicSize@);");
            types = sorted.basicTypes.toList();
            names = sorted.basicNames.toList();
            while (types.nonEmpty()) {
                s.set("pType", this.UPPERCASENAMES[IDX[((Type)types.head).tag]]);
                s.set("pname", (Name)names.head);
                stub.append(s, "  _c.send@pType@(@pname@);");
                types = types.tail;
                names = names.tail;
            }
            stub.append(s, "  _c.closeSendPrimitive(@basicSize@);");
        }
        types = sorted.objectTypes.toList();
        names = sorted.objectNames.toList();
        while (types.nonEmpty()) {
            s.set("pname", (Name)names.head);
            stub.append(s, "  _c.sendObject(@pname@);");
            types = types.tail;
            names = names.tail;
        }
        stub.append(s, "  _c.closeSendCall();");
        stub.newLine();
        stub.append(s, "  boolean _normalReturn = _c.openReceiveResult();");
        stub.append(s, "  try {");
        stub.append(s, "    if (_normalReturn) {");
        switch (minfo.type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                stub.append(s, "      return _c.receiveSingle@Type@();");
                break;
            }
            case 9: {
                stub.append(s, "      return;");
                break;
            }
            case 10: 
            case 11: {
                stub.append(s, "      return (@type@) _c.receiveObject();");
                break;
            }
            default: {
                throw new InternalError(String.valueOf("unexpected result type: ").concat(String.valueOf(minfo.type)));
            }
        }
        stub.append(s, "    } else {");
        stub.append(s, "      resultex = (Throwable) _c.receiveObject();");
        stub.append(s, "    }");
        stub.append(s, "  } finally {");
        stub.append(s, "    _c.closeReceiveResult();");
        stub.append(s, "  }");
        stub.append(s, "} catch (ClassNotFoundException ex) {");
        stub.append(s, "  _c.closeExceptionally();");
        stub.append(s, "  throw new @RemoteException@(\"KaRMI: unmarshal problem\", ex);");
        stub.append(s, "} catch (@RemoteException@ ex) {");
        stub.append(s, "  _c.closeExceptionally();");
        stub.append(s, "  throw ex;");
        stub.append(s, "} catch (java.io.IOException ex) {");
        stub.append(s, "  _c.closeExceptionally();");
        stub.append(s, "  throw new @RemoteException@(\"KaRMI: transport problem\", ex);");
        stub.append(s, "} catch (RuntimeException ex) {");
        stub.append(s, "  _c.closeExceptionally();");
        stub.append(s, "  throw ex;");
        stub.append(s, "} catch (Error ex) {");
        stub.append(s, "  _c.closeExceptionally();");
        stub.append(s, "  throw ex;");
        stub.append(s, "}");
        stub.newLine();
        stub.append(s, "// rethrow runtime exceptions and declared exceptions");
        List<Type> list = minfo.thrownwrap;
        while (list.nonEmpty()) {
            s.set("thrownType", ((Type)list.head).tsym.fullName());
            stub.append(s, "if (resultex instanceof @thrownType@) {");
            stub.append(s, "  throw (@thrownType@) resultex;");
            stub.append(s, "}");
            list = list.tail;
        }
        stub.append(s, "// exception not possible here");
        stub.append(s, "throw new InternalError(\"KaRMI: exception not declared: \" + resultex);");
        stub.unindent(2);
        stub.append(s, "}");
    }
}

