/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.ClassReader;
import gjc.v6.code.ClassWriter;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.comp.Symtab;
import gjc.v6.jp.RemoteNames;
import gjc.v6.util.Name;

public class JPSymtab
extends Symtab {
    public RemoteNames rnames;
    public Type remoteIntf;
    public Type remoteStubType;
    public Type remoteExceptionType;
    public Type serializableType;
    public Type objectOutputStreamType;
    public Type objectInputStreamType;
    public Type remoteType;
    public Type externalizableType;
    public Type movedExceptionType;
    public Type replicatedType;
    public Type jpReplicatedType;
    public Type classType;
    public Type langBooleanType;
    public Type langByteType;
    public Type langCharacterType;
    public Type langShortType;
    public Type langIntegerType;
    public Type langLongType;
    public Type langFloatType;
    public Type langDoubleType;
    public Type netInetSocketAddressType;
    public Type netInet4AddressType;
    public Type netInet6AddressType;

    public JPSymtab(ClassReader reader, ClassWriter writer, RemoteNames remoteNames) throws Symbol.CompletionFailure {
        super(reader, writer);
        this.rnames = remoteNames;
        this.serializableType = this.enterClass("java.io.Serializable");
        this.externalizableType = this.enterClass("java.io.Externalizable");
        this.objectOutputStreamType = this.enterClass("java.io.ObjectOutputStream");
        this.objectInputStreamType = this.enterClass("java.io.ObjectInputStream");
        if (!remoteNames.local_only) {
            this.remoteIntf = this.enterClass(remoteNames.nameRemote);
            this.remoteStubType = this.enterClass(remoteNames.nameRemoteStub);
            this.remoteExceptionType = this.enterClass(remoteNames.nameRemoteException);
            this.remoteType = this.enterClass("jp.lang.RemoteObject");
            this.movedExceptionType = this.enterClass("jp.lang.MovedException");
            this.replicatedType = this.enterClass("uka.karmi.rmi.server.ReplicatedObject");
            this.jpReplicatedType = this.enterClass("jp.lang.ReplicatedObject");
        }
        this.classType = this.enterClass("java.lang.Class");
        this.langBooleanType = this.enterClass("java.lang.Boolean");
        this.langByteType = this.enterClass("java.lang.Byte");
        this.langCharacterType = this.enterClass("java.lang.Character");
        this.langShortType = this.enterClass("java.lang.Short");
        this.langIntegerType = this.enterClass("java.lang.Integer");
        this.langLongType = this.enterClass("java.lang.Long");
        this.langFloatType = this.enterClass("java.lang.Float");
        this.langDoubleType = this.enterClass("java.lang.Double");
        this.netInetSocketAddressType = this.enterClass("java.net.Inet4Address");
        this.netInet4AddressType = this.enterClass("java.lang.Inet6Address");
        this.netInet6AddressType = this.enterClass("java.lang.InetSocketAddress");
    }

    public Type enterClass(Name name) {
        if (name == null) {
            return null;
        }
        return this.enterClass(name.toString());
    }

    public Type enterClass(String string) {
        return this.reader.enterClass((Name)Name.fromString((String)string)).type;
    }
}

