/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.comp.Check;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.Tools;
import gjc.v6.util.Hashtable;
import gjc.v6.util.Log;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPCheck
extends Check {
    JPSymtab syms;
    Tools tools;

    public JPCheck(Log log, JPSymtab syms, Hashtable<String, String> options, Tools tools) {
        super(log, syms, options);
        this.syms = syms;
        this.tools = tools;
    }

    @Override
    protected int checkFlags(int pos, int flags, Symbol sym) {
        int n = super.checkFlags(pos, flags, sym);
        this.checkDisjoint(pos, flags, 512, 2048);
        this.checkConstArray(pos, flags, sym);
        return n;
    }

    protected boolean checkConstArray(int pos, int flags, Symbol sym) {
        if ((flags & 0x1000) != 0) {
            if ((flags & 0x10) == 0) {
                this.log.error(pos, "constants must be declared final");
                return false;
            }
            if (!this.tools.isLocal(sym) && (flags & 8) == 0) {
                this.log.error(pos, "only static constants are supported");
                return false;
            }
            if (!(sym.type instanceof Type.ArrayType)) {
                this.log.error(pos, "only array constants are supported");
                return false;
            }
            Type type = sym.type;
            while (type instanceof Type.ArrayType) {
                type = ((Type.ArrayType)type).elemtype;
            }
            if (!this.tools.isImmutable(type)) {
                this.log.error(pos, "base type of constant array must be immutable");
                return false;
            }
        }
        return true;
    }
}

