/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.ByteCodes;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.Symtab;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.tree.TreeMaker;
import gjc.v6.tree.TreeTranslator;
import gjc.v6.util.Base;
import gjc.v6.util.Convert;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransInner
extends TreeTranslator<Tree>
implements Flags,
Kinds,
TypeTags,
ByteCodes {
    Log log;
    Symtab syms;
    TreeMaker make;
    Symbol.ClassSymbol currentClass;
    Tree toplevelMemberDef;
    ListBuffer<Tree> translated;
    Hashtable<Symbol.ClassSymbol, Tree.ClassDef> classdefs;
    Hashtable<Symbol.ClassSymbol, List<Symbol.VarSymbol>> freevarCache;
    private static final int DEREFcode = 0;
    private static final int ASSIGNcode = 1;
    private static final int PREINCcode = 2;
    private static final int PREDECcode = 3;
    private static final int POSTINCcode = 4;
    private static final int POSTDECcode = 5;
    private static final int FIRSTASGOPcode = 6;
    private static final int FIRSTLONGcode = TransInner.accessCode(270);
    private static final int NCODES = TransInner.accessCode(274) + 1;
    private Hashtable<Symbol, Integer> accessNums;
    private Hashtable<Symbol, Symbol.MethodSymbol[]> accessSyms;
    private ListBuffer<Symbol> accessed;
    Scope proxies;

    public TransInner(Log log, Symtab syms, TreeMaker treeMaker) {
        this.log = log;
        this.syms = syms;
        this.make = treeMaker;
    }

    Tree.ClassDef classDef(Symbol.ClassSymbol c) {
        Tree.ClassDef classDef = this.classdefs.get(c);
        if (classDef == null && this.toplevelMemberDef != null) {
            this.toplevelMemberDef.visit(new ClassMap(), null);
            classDef = this.classdefs.get(c);
        }
        return classDef;
    }

    List<Symbol.VarSymbol> freevars(Symbol.ClassSymbol c) {
        if ((c.owner.kind & 0x24) != 0) {
            List<Symbol.VarSymbol> list = this.freevarCache.get(c);
            if (list == null) {
                list = new FreeVarCollector().freevars(this.classDef(c));
                this.freevarCache.put(c, list);
            }
            return list;
        }
        return Symbol.VarSymbol.emptyList;
    }

    private static int accessCode(int bytecode) {
        if (96 <= bytecode && bytecode <= 131) {
            return bytecode - 96 + 6;
        }
        if (270 <= bytecode && bytecode <= 274) {
            return bytecode - 270 + 131 + 1 - 96 + 6;
        }
        return -1;
    }

    private static int accessCode(Tree tree, Tree encl) {
        if (encl == null) {
            return 0;
        }
        if (encl.tag == 26 && tree == ((Tree.Assign)encl).lhs) {
            return 1;
        }
        if (42 <= encl.tag && encl.tag <= 45 && tree == ((Tree.Operation)encl).args.head) {
            return encl.tag - 42 + 2;
        }
        if (65 <= encl.tag && encl.tag <= 81 && tree == ((Tree.Assignop)encl).lhs) {
            return TransInner.accessCode(((Symbol.OperatorSymbol)((Tree.Assignop)encl).operator).opcode);
        }
        return 0;
    }

    private Symbol.OperatorSymbol binaryAccessOperator(int acode) {
        Scope.Entry e = this.syms.predefClass.members().elems;
        while (e != null) {
            if (e.sym instanceof Symbol.OperatorSymbol) {
                Symbol.OperatorSymbol operatorSymbol = (Symbol.OperatorSymbol)e.sym;
                if (TransInner.accessCode(operatorSymbol.opcode) == acode) {
                    return operatorSymbol;
                }
            }
            e = e.sibling;
        }
        return null;
    }

    private Symbol.OperatorSymbol unaryAccessOperator(int opcode, Type argtype) {
        Name name = TreeInfo.operatorName(opcode);
        Scope.Entry entry = this.syms.predefClass.members().lookup(name);
        while (!(entry.sym == null || entry.sym.type.argtypes().head == argtype && entry.sym.type.argtypes().tail.isEmpty())) {
            entry = entry.next();
        }
        return (Symbol.OperatorSymbol)entry.sym;
    }

    private static int treeTag(Symbol.OperatorSymbol operator) {
        switch (operator.opcode) {
            case 128: 
            case 129: {
                return 65;
            }
            case 130: 
            case 131: {
                return 66;
            }
            case 126: 
            case 127: {
                return 67;
            }
            case 120: 
            case 121: 
            case 270: 
            case 271: {
                return 74;
            }
            case 122: 
            case 123: 
            case 272: 
            case 273: {
                return 75;
            }
            case 124: 
            case 125: 
            case 274: 
            case 275: {
                return 76;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return 77;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return 78;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return 79;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 80;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return 81;
            }
        }
        throw new InternalError();
    }

    static Name accessName(int anum, int acode) {
        return Name.fromString(String.valueOf(String.valueOf(String.valueOf("access$").concat(String.valueOf(anum))).concat(String.valueOf(acode / 10))).concat(String.valueOf(acode % 10)));
    }

    Symbol.MethodSymbol accessSymbol(Symbol sym, Tree tree, Tree encl) {
        Symbol.MethodSymbol[] accessors;
        Symbol.MethodSymbol methodSymbol;
        List<Symbol.ClassSymbol> thrown;
        Type restype;
        List<Type> argtypes;
        int acode;
        Integer anum = this.accessNums.get(sym);
        if (anum == null) {
            anum = new Integer(this.accessed.length());
            this.accessNums.put(sym, anum);
            this.accessSyms.put(sym, new Symbol.MethodSymbol[NCODES]);
            this.accessed.append(sym);
        }
        if (sym.kind == 4) {
            acode = TransInner.accessCode(tree, encl);
            argtypes = acode >= 6 ? this.binaryAccessOperator((int)acode).type.argtypes().tail : (acode == 1 ? Type.emptyList.prepend(sym.erasure()) : Type.emptyList);
            restype = sym.erasure();
            thrown = Symbol.ClassSymbol.emptyList;
        } else if (sym.kind == 32) {
            acode = 0;
            argtypes = sym.erasure().argtypes();
            restype = sym.erasure().restype();
            thrown = sym.type.thrown();
        } else {
            throw new InternalError();
        }
        if ((sym.flags() & 8) == 0) {
            argtypes = argtypes.prepend(sym.owner.erasure());
        }
        if ((methodSymbol = (accessors = this.accessSyms.get(sym))[acode]) == null) {
            methodSymbol = new Symbol.MethodSymbol(65544, TransInner.accessName(anum, acode), new Type.MethodType(argtypes, restype, thrown), sym.owner);
            ((Symbol.ClassSymbol)sym.owner).members().enter(methodSymbol);
            accessors[acode] = methodSymbol;
        }
        return methodSymbol;
    }

    Tree makeLit(int typetag, Object object) {
        if (typetag == 8) {
            return this.make.Ident((Integer)object == 0 ? this.syms.trueConst : this.syms.falseConst);
        }
        return this.make.Literal(typetag, object);
    }

    Tree accessBase(int pos, Symbol symbol) {
        return (symbol.flags() & 8) != 0 ? this.access(this.make.at(pos).QualIdent(symbol.owner)) : this.makeThis(pos, symbol.owner.enclClass(), false);
    }

    Tree access(Symbol sym, Tree tree, Tree encl) {
        if (sym.kind == 4 && (sym.flags() & 0x40000) != 0 && sym.owner.enclClass() != this.currentClass) {
            this.make.at(tree.pos);
            Object cv = ((Symbol.VarSymbol)sym).constValue;
            if (cv != null) {
                return this.makeLit(sym.type.tag, cv).setType(sym.type.constType(cv));
            }
            sym = this.proxies.lookup((Name)TransInner.proxyName((Name)sym.name)).sym;
            tree = this.make.at(tree.pos).Ident(sym);
        }
        Tree base = tree.tag == 30 ? ((Tree.Select)tree).selected : null;
        switch (sym.kind) {
            case 2: {
                if (sym.owner.kind == 1) break;
                Name flatname = Convert.shortName(sym.flatName());
                while (base != null && TreeInfo.symbol((Tree)base).kind != 1) {
                    base = base.tag == 30 ? ((Tree.Select)base).selected : null;
                }
                if (tree.tag == 31) {
                    ((Tree.Ident)tree).name = flatname;
                    break;
                }
                if (base == null) {
                    tree = this.make.at(tree.pos).Ident(sym);
                    ((Tree.Ident)tree).name = flatname;
                    break;
                }
                ((Tree.Select)tree).selected = base;
                ((Tree.Select)tree).name = flatname;
                break;
            }
            case 4: 
            case 32: {
                Object cv;
                if (sym.owner.kind != 2 || ((sym.flags() & 2) == 0 || sym.owner == this.currentClass) && (base != null || sym.owner == this.syms.predefClass || this.currentClass.subclass(sym.owner))) break;
                this.make.at(tree.pos);
                if (sym.kind == 4 && sym.owner != this.syms.predefClass && (cv = ((Symbol.VarSymbol)sym).constValue) != null) {
                    return this.makeLit(sym.type.tag, cv).setType(sym.type.constType(cv));
                }
                if ((sym.flags() & 2) != 0) {
                    List<Tree> args = Tree.emptyList;
                    if ((sym.flags() & 8) == 0) {
                        if (base == null) {
                            args = args.prepend(this.makeThis(tree.pos, sym.owner.enclClass(), false));
                        } else {
                            args = args.prepend(base);
                            base = null;
                        }
                    }
                    Tree tree2 = this.make.Select(base != null ? base : this.make.QualIdent(sym.owner), this.accessSymbol(sym, tree, encl));
                    return this.make.App(tree2, args);
                }
                return this.make.at(tree.pos).Select(this.accessBase(tree.pos, sym), sym);
            }
        }
        return tree;
    }

    Tree access(Tree tree) {
        Symbol symbol = TreeInfo.symbol(tree);
        return symbol == null ? tree : this.access(symbol, tree, null);
    }

    void makeAccessible(Symbol sym) {
        Tree.ClassDef cdef = this.classDef(sym.owner.enclClass());
        Symbol.MethodSymbol[] accessors = this.accessSyms.get(sym);
        for (int i = 0; i < NCODES; ++i) {
            if (accessors[i] == null) continue;
            cdef.defs = cdef.defs.prepend(this.accessDef(cdef.pos, sym, accessors[i], i));
        }
    }

    Tree accessDef(int pos, Symbol sym, Symbol.MethodSymbol accessor, int acode) {
        Tree stat;
        List<Tree> args;
        Tree receiver;
        this.currentClass = sym.owner.enclClass();
        this.make.at(pos);
        Tree.MethodDef md = this.make.MethodDef(accessor, null);
        if ((sym.flags() & 8) != 0) {
            receiver = this.make.Ident(sym);
            args = this.make.Idents(md.params);
        } else {
            receiver = this.make.Select(this.make.Ident((Tree.VarDef)md.params.head), sym);
            args = this.make.Idents(md.params.tail);
        }
        if (sym.kind == 4) {
            Tree expr;
            switch (acode) {
                case 0: {
                    expr = receiver;
                    break;
                }
                case 1: {
                    expr = this.make.Assign(receiver, (Tree)args.head);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int opcode = acode - 2 + 42;
                    expr = this.make.Operation(opcode, List.make(receiver));
                    ((Tree.Operation)expr).operator = this.unaryAccessOperator(opcode, receiver.type);
                    break;
                }
                default: {
                    expr = this.make.Assignop(TransInner.treeTag(this.binaryAccessOperator(acode)), receiver, (Tree)args.head);
                    ((Tree.Assignop)expr).operator = this.binaryAccessOperator(acode);
                }
            }
            stat = this.make.Return(expr.setType(sym.type));
        } else {
            stat = this.make.Call(this.make.App(receiver, args));
        }
        md.body = this.make.Block(0, List.make(stat));
        List<Tree.VarDef> l = md.params;
        while (l.nonEmpty()) {
            ((Tree.VarDef)l.head).vartype = this.access(((Tree.VarDef)l.head).vartype);
            l = l.tail;
        }
        md.restype = this.access(md.restype);
        List<Tree> list = md.thrown;
        while (list.nonEmpty()) {
            list.head = this.access((Tree)list.head);
            list = list.tail;
        }
        return md;
    }

    static Name proxyName(Name name) {
        return Name.fromString(String.valueOf("val$").concat(String.valueOf(name)));
    }

    List<Tree.VarDef> freevarDefs(int pos, List<Symbol.VarSymbol> freevars, Symbol owner) {
        List<Tree.VarDef> defs = Tree.VarDef.emptyList;
        List<Symbol.VarSymbol> l = freevars;
        while (l.nonEmpty()) {
            Symbol.VarSymbol v = (Symbol.VarSymbol)l.head;
            Symbol.VarSymbol proxy = new Symbol.VarSymbol(65552, TransInner.proxyName(v.name), v.erasure(), owner);
            this.proxies.enter(proxy);
            Tree.VarDef varDef = this.make.at(pos).VarDef(proxy, null);
            varDef.vartype = this.access(varDef.vartype);
            defs = defs.prepend(varDef);
            l = l.tail;
        }
        return defs;
    }

    Tree.VarDef this0Def(int pos, Symbol owner) {
        Symbol.VarSymbol this0 = new Symbol.VarSymbol(65552, Names.this0, owner.enclClass().type.outer().erasure(), owner);
        this.proxies.enter(this0);
        Tree.VarDef varDef = this.make.at(pos).VarDef(this0, null);
        varDef.vartype = this.access(varDef.vartype);
        return varDef;
    }

    List<Tree> loadFreevars(int pos, List<Symbol.VarSymbol> freevars) {
        List<Tree> args = Tree.emptyList;
        List<Symbol.VarSymbol> list = freevars;
        while (list.nonEmpty()) {
            args = args.prepend(this.loadFreevar(pos, (Symbol.VarSymbol)list.head));
            list = list.tail;
        }
        return args;
    }

    Tree loadFreevar(int pos, Symbol.VarSymbol varSymbol) {
        return this.access(varSymbol, this.make.at(pos).Ident(varSymbol), null);
    }

    Tree makeThis(int pos, Symbol.TypeSymbol c, boolean preciseMatch) {
        Symbol.TypeSymbol c1 = this.currentClass;
        if (c.type.tag != 10) {
            return this.make.Ident(this.syms.nullConst);
        }
        if (this.currentClass == c || !preciseMatch && this.currentClass.subclass(c)) {
            return this.make.at(pos).This(c.erasure());
        }
        Scope.Entry e = this.proxies.lookup(Names.this0);
        if (e.sym == null) {
            this.log.error(pos, String.valueOf(String.valueOf("no enclosing instance of ").concat(String.valueOf(c))).concat(String.valueOf(" is in scope")));
            return this.make.Ident(this.syms.nullConst);
        }
        Tree tree = this.make.at(pos).Ident(e.sym);
        c1 = e.sym.type.tsym;
        while (c1 != c && (preciseMatch || !c1.subclass(c))) {
            do {
                e = e.next();
            } while (e.sym != null && e.sym.owner != c1);
            if (e.sym == null) {
                this.log.error(pos, String.valueOf(String.valueOf("no enclosing instance of ").concat(String.valueOf(c))).concat(String.valueOf(" is in scope")));
                break;
            }
            tree = this.make.at(pos).Select(tree, e.sym);
            c1 = e.sym.type.tsym;
        }
        return tree;
    }

    Tree initField(int pos, Name name) {
        Scope.Entry e = this.proxies.lookup(name);
        Symbol rhs = e.sym;
        Base._assert(rhs.owner.kind == 32);
        Symbol symbol = e.next().sym;
        Base._assert(rhs.owner.owner == symbol.owner);
        this.make.at(pos);
        return this.make.Exec(this.make.Assign(this.make.Select(this.make.This(symbol.owner.erasure()), symbol), this.make.Ident(rhs)).setType(symbol.erasure()));
    }

    @Override
    public Tree _case(Tree.ClassDef tree, Tree encl) {
        Symbol.ClassSymbol currentClassPrev = this.currentClass;
        this.currentClass = tree.sym;
        this.classdefs.put(this.currentClass, tree);
        this.proxies = this.proxies.dup();
        Tree.VarDef this0def = null;
        if (this.currentClass.hasOuterInstance()) {
            this0def = this.this0Def(tree.pos, this.currentClass);
        }
        List<Tree.VarDef> fvdefs = this.freevarDefs(tree.pos, this.freevars(this.currentClass), this.currentClass);
        tree.extending = ((TreeTranslator)this).translate(tree.extending, encl);
        tree.implementing = ((TreeTranslator)this).translate(tree.implementing, encl);
        List<Tree> l = tree.defs;
        while (l.nonEmpty()) {
            Tree toplevelMemberDefPrev = this.toplevelMemberDef;
            if (toplevelMemberDefPrev == null) {
                this.toplevelMemberDef = (Tree)l.head;
            }
            l.head = ((TreeTranslator)this).translate((Tree)l.head, encl);
            this.toplevelMemberDef = toplevelMemberDefPrev;
            l = l.tail;
        }
        if ((tree.flags & 4) != 0) {
            tree.flags |= 1;
        }
        tree.flags &= 0x2000E11;
        tree.name = Convert.shortName(this.currentClass.flatName());
        List<Tree.VarDef> list = fvdefs;
        while (list.nonEmpty()) {
            tree.defs = tree.defs.prepend((Tree)list.head);
            this.currentClass.members().enter(((Tree.VarDef)list.head).sym);
            list = list.tail;
        }
        if (this.currentClass.hasOuterInstance()) {
            tree.defs = tree.defs.prepend(this0def);
            this.currentClass.members().enter(this0def.sym);
        }
        this.proxies = this.proxies.leave();
        this.translated.append(tree);
        this.currentClass = currentClassPrev;
        return this.make.at(tree.pos).Block(0, Tree.emptyList);
    }

    @Override
    public Tree _case(Tree.MethodDef tree, Tree encl) {
        if (tree.name == Names.init && this.currentClass.isInner()) {
            Symbol.MethodSymbol m = tree.sym;
            this.proxies = this.proxies.dup();
            List<Symbol.VarSymbol> fvs = this.freevars(this.currentClass);
            Tree.VarDef this0def = null;
            if (this.currentClass.hasOuterInstance()) {
                this0def = this.this0Def(tree.pos, m);
            }
            List<Tree.VarDef> fvdefs = this.freevarDefs(tree.pos, fvs, m);
            super._case(tree, (Object)encl);
            tree.params = tree.params.prepend(fvdefs);
            if (this.currentClass.hasOuterInstance()) {
                tree.params = tree.params.prepend(this0def);
            }
            Tree selfCall = (Tree)tree.body.stats.head;
            List<Tree> rest = tree.body.stats.tail;
            if (fvs.nonEmpty()) {
                List<Type> argtypes = m.erasure().argtypes();
                List<Symbol.VarSymbol> list = fvs;
                while (list.nonEmpty()) {
                    if (TreeInfo.isInitialConstructor(tree)) {
                        rest = rest.prepend(this.initField(tree.body.pos, TransInner.proxyName(((Symbol.VarSymbol)list.head).name)));
                    }
                    argtypes = argtypes.prepend(((Symbol.VarSymbol)list.head).erasure());
                    list = list.tail;
                }
                m.erasure_field = new Type.MethodType(argtypes, m.erasure().restype(), m.erasure().thrown());
            }
            if (this.currentClass.hasOuterInstance() && TreeInfo.isInitialConstructor(tree)) {
                rest = rest.prepend(this.initField(tree.body.pos, Names.this0));
            }
            tree.body.stats = rest.prepend(selfCall);
            this.proxies = this.proxies.leave();
        } else {
            super._case(tree, (Object)encl);
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.NewClass tree, Tree encl) {
        Symbol.ClassSymbol c = tree.def == null ? (Symbol.ClassSymbol)tree.clazz.type.tsym : tree.def.sym;
        tree.clazz = this.access(c, tree.clazz, encl);
        tree.args = ((TreeTranslator)this).translate(tree.args, encl);
        if ((c.owner.kind & 0x24) != 0) {
            tree.args = tree.args.prepend(this.loadFreevars(tree.pos, this.freevars(c)));
        }
        if (c.hasOuterInstance()) {
            Tree tree2 = tree.encl != null ? ((TreeTranslator)this).translate(tree.encl, encl) : this.makeThis(tree.pos, c.type.outer().tsym, false);
            tree.args = tree.args.prepend(tree2);
        }
        tree.encl = null;
        if (tree.def != null) {
            ((TreeTranslator)this).translate(tree.def, encl);
            tree.clazz = this.access(this.make.at(tree.clazz.pos).Ident(tree.def.sym));
            tree.def = null;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Apply tree, Tree encl) {
        tree.args = ((TreeTranslator)this).translate(tree.args, encl);
        Name methName = TreeInfo.name(tree.meth);
        if (methName == Names._this || methName == Names._super) {
            Symbol self = TreeInfo.symbol(tree.meth);
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)self.owner;
            if ((c.owner.kind & 0x24) != 0) {
                tree.args = tree.args.prepend(this.loadFreevars(tree.pos, this.freevars(c)));
            }
            if (c.hasOuterInstance()) {
                Tree thisArg;
                if (tree.meth.tag == 30) {
                    thisArg = ((TreeTranslator)this).translate(((Tree.Select)tree.meth).selected, encl);
                    tree.meth = this.make.Ident(self);
                    ((Tree.Ident)tree.meth).name = methName;
                } else {
                    thisArg = this.makeThis(tree.pos, c.type.outer().tsym, false);
                }
                tree.args = tree.args.prepend(thisArg);
            }
        } else {
            tree.meth = ((TreeTranslator)this).translate(tree.meth, encl);
            if (tree.meth.tag == 23) {
                Tree.Apply apply = (Tree.Apply)tree.meth;
                apply.args = tree.args.prepend(apply.args);
                return apply;
            }
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Assign tree, Tree encl) {
        tree.lhs = ((TreeTranslator)this).translate(tree.lhs, tree);
        tree.rhs = ((TreeTranslator)this).translate(tree.rhs, encl);
        if (tree.lhs.tag == 23) {
            Tree.Apply apply = (Tree.Apply)tree.lhs;
            apply.args = List.make(tree.rhs).prepend(apply.args);
            return apply;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Assignop tree, Tree encl) {
        tree.lhs = ((TreeTranslator)this).translate(tree.lhs, tree);
        tree.rhs = ((TreeTranslator)this).translate(tree.rhs, encl);
        if (tree.lhs.tag == 23) {
            Tree.Apply apply = (Tree.Apply)tree.lhs;
            apply.args = List.make(tree.rhs).prepend(apply.args);
            return apply;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Operation tree, Tree tree2) {
        tree.args = ((TreeTranslator)this).translate(tree.args, tree);
        if (42 <= tree.tag && tree.tag <= 45 && ((Tree)tree.args.head).tag == 23) {
            return (Tree)tree.args.head;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Ident tree, Tree tree2) {
        return this.access(tree.sym, tree, tree2);
    }

    @Override
    public Tree _case(Tree.Select tree, Tree tree2) {
        tree.selected = ((TreeTranslator)this).translate(tree.selected, tree2);
        if (tree.name == Names._class) {
            return tree;
        }
        if (tree.name == Names._this) {
            return this.makeThis(tree.pos, tree.selected.type.tsym, true);
        }
        return this.access(tree.sym, tree, tree2);
    }

    public List<Tree> translateTopLevelClass(Tree cdef) {
        this.currentClass = null;
        this.toplevelMemberDef = null;
        this.translated = new ListBuffer();
        this.classdefs = Hashtable.make();
        this.freevarCache = Hashtable.make();
        this.proxies = new Scope(null);
        this.accessNums = Hashtable.make();
        this.accessSyms = Hashtable.make();
        this.accessed = new ListBuffer();
        cdef = ((TreeTranslator)this).translate(cdef, null);
        List<Symbol> list = this.accessed.toList();
        while (list.nonEmpty()) {
            this.makeAccessible((Symbol)list.head);
            list = list.tail;
        }
        return this.translated.toList();
    }

    @Override
    public /* synthetic */ Tree _case(Tree x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Select x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Indexed x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeTest x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeCast x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewArray x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Throw x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Return x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Continue x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Break x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Exec x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Conditional x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Try x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Synchronized x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Case x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Switch x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Labelled x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ForLoop x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.DoLoop x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Block x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.VarDef x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Import x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ List translateCatchers(List x0, Object object) {
        return super.translateCatchers(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ List translateCases(List x0, Object object) {
        return super.translateCases(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ List translateTypeParams(List x0, Object object) {
        return super.translateTypeParams(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ List translateVarDefs(List x0, Object object) {
        return super.translateVarDefs(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ List translate(List x0, Object object) {
        return super.translate(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Tree translate(Tree x0, Object object) {
        return super.translate(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Tree)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Object)((Tree)object));
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FreeVarCollector
    extends TreeTranslator<Void>
    implements Flags,
    Kinds {
        private Symbol owner;
        private List<Symbol.VarSymbol> fvs;

        FreeVarCollector() {
        }

        @Override
        public Tree _case(Tree.Ident tree, Void arg) {
            if (tree.sym.kind == 4 && tree.sym.owner == this.owner) {
                Symbol.VarSymbol v = (Symbol.VarSymbol)tree.sym;
                if (v.constValue == null && (v.flags_field & 0x40000) != 0) {
                    List<Symbol.VarSymbol> list = this.fvs;
                    while (list.nonEmpty()) {
                        if (list.head == v) {
                            return tree;
                        }
                        list = list.tail;
                    }
                    this.fvs = this.fvs.prepend(v);
                }
            }
            return tree;
        }

        List<Symbol.VarSymbol> freevars(Tree.ClassDef classDef) {
            this.owner = classDef.sym.owner;
            this.fvs = Symbol.VarSymbol.emptyList;
            classDef.visit(this, null);
            return this.fvs;
        }

        @Override
        public /* synthetic */ Tree _case(Tree x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Erroneous x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeApply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Literal x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Ident x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Select x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Indexed x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeTest x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeCast x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Operation x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assignop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assign x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewClass x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Apply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Throw x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Return x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Continue x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Break x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Exec x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assert x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Conditional x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Catch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Try x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Synchronized x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Case x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Switch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Labelled x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ForLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.DoLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Block x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.VarDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.MethodDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ClassDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Import x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TopLevel x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ List translateCatchers(List x0, Object object) {
            return super.translateCatchers(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translateCases(List x0, Object object) {
            return super.translateCases(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translateTypeParams(List x0, Object object) {
            return super.translateTypeParams(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translateVarDefs(List x0, Object object) {
            return super.translateVarDefs(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translate(List x0, Object object) {
            return super.translate(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Tree translate(Tree x0, Object object) {
            return super.translate(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassMap
    extends TreeTranslator<Void> {
        ClassMap() {
        }

        @Override
        public Tree _case(Tree.ClassDef tree, Void void_) {
            TransInner.this.classdefs.put(tree.sym, tree);
            return super._case(tree, (Object)void_);
        }

        @Override
        public /* synthetic */ Tree _case(Tree x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Erroneous x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeApply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Literal x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Ident x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Select x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Indexed x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeTest x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeCast x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Operation x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assignop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assign x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewClass x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Apply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Throw x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Return x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Continue x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Break x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Exec x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assert x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Conditional x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Catch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Try x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Synchronized x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Case x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Switch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Labelled x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ForLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.DoLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Block x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.VarDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.MethodDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ClassDef x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Import x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TopLevel x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ List translateCatchers(List x0, Object object) {
            return super.translateCatchers(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translateCases(List x0, Object object) {
            return super.translateCases(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translateTypeParams(List x0, Object object) {
            return super.translateTypeParams(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translateVarDefs(List x0, Object object) {
            return super.translateVarDefs(x0, (Void)object);
        }

        @Override
        public /* synthetic */ List translate(List x0, Object object) {
            return super.translate(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Tree translate(Tree x0, Object object) {
            return super.translate(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
            return super._case(x0, (Object)((Void)object));
        }
    }
}

