/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.ClassReader;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.AttrContext;
import gjc.v6.comp.Check;
import gjc.v6.comp.Env;
import gjc.v6.comp.Infer;
import gjc.v6.comp.Symtab;
import gjc.v6.tree.TreeInfo;
import gjc.v6.util.List;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolve
implements Flags,
Kinds,
TypeTags {
    static final int AMBIGUOUS = 256;
    static final int HIDDEN = 257;
    static final int ABSENT_VAR = 258;
    static final int WRONG_MTH = 259;
    static final int ABSENT_MTH = 260;
    static final int ABSENT_TYP = 261;
    Log log;
    Symtab syms;
    Check chk;
    Infer infer;

    public Resolve(Log log, Symtab syms, Check chk, Infer infer) {
        this.syms = syms;
        this.log = log;
        this.chk = chk;
        this.infer = infer;
    }

    boolean accessible(Env<AttrContext> env, Symbol.TypeSymbol typeSymbol) {
        switch (typeSymbol.flags() & 7) {
            case 2: {
                return env.enclClass.sym.outermostClass() == typeSymbol.owner.outermostClass();
            }
            case 0: {
                return env.toplevel.packge == typeSymbol.owner || env.toplevel.packge == typeSymbol.outermostClass().owner;
            }
            case 1: {
                return true;
            }
            case 4: {
                return env.toplevel.packge == typeSymbol.owner || env.toplevel.packge == typeSymbol.outermostClass().owner || env.enclClass.sym.subclass(typeSymbol.owner);
            }
        }
        throw new InternalError();
    }

    boolean accessible(Env<AttrContext> env, Type site, Symbol symbol) {
        if (symbol.name == Names.init && symbol.owner != site.tsym) {
            return false;
        }
        switch (symbol.flags() & 7) {
            case 2: {
                return env.enclClass.sym == symbol.owner || env.enclClass.sym.outermostClass() == symbol.owner.outermostClass();
            }
            case 0: {
                return env.toplevel.packge == symbol.owner.owner || env.toplevel.packge == symbol.outermostClass().owner;
            }
            case 4: {
                return env.toplevel.packge == symbol.owner.owner || env.toplevel.packge == symbol.outermostClass().owner || env.enclClass.sym.subclass(symbol.owner) && site.tsym.subclass(env.enclClass.sym) || ((AttrContext)env.info).selectSuper;
            }
        }
        return this.accessible(env, site.tsym);
    }

    Type instantiate(Type site, Symbol m, List<Type> typarams, List<Type> argtypes) {
        List<Type> undetTvars;
        Type mt0 = site.memberType(m);
        List<Type> tvars = Type.emptyList;
        if (mt0.tag == 15) {
            tvars = ((Type.ForAll)mt0).tvars;
            mt0 = ((Type.ForAll)mt0).qtype;
        }
        Type.MethodType mt = (Type.MethodType)mt0;
        List<Type> formals = mt.argtypes;
        Type restype = m.name == Names.init ? site : mt.restype;
        List<Type> list = undetTvars = typarams.tail == null ? tvars : Type.emptyList;
        if ((m.flags_field & 8) == 0 && site.occCount(Type.allType) >= 1) {
            formals = m.type.argtypes().prepend(m.owner.type);
            argtypes = argtypes.prepend(site);
            restype = m.type.restype();
            List<Type> ownerParams = m.owner.type.allParams();
            tvars = tvars.prepend(ownerParams);
            undetTvars = undetTvars.prepend(ownerParams);
        }
        if (tvars.tail != null) {
            if (undetTvars.nonEmpty()) {
                List<Type> list2 = this.infer.typeParams(undetTvars, formals, argtypes);
                if (list2 == null) {
                    return null;
                }
                typarams = typarams.prepend(list2);
            }
            formals = Type.subst(formals, tvars, typarams);
            restype = restype.subst(tvars, typarams);
        }
        if (Type.subTypes(argtypes, formals)) {
            return restype;
        }
        return null;
    }

    boolean asGood(Env<AttrContext> env, Type site, Symbol a, Symbol symbol) {
        return a.kind < symbol.kind || a.kind == symbol.kind && (!this.accessible(env, site, symbol) || this.accessible(env, site, a) && (((a.flags() | symbol.flags()) & 8) != 0 || (symbol.owner.flags() & 0x200) != 0 || a.owner.subclass(symbol.owner)) && this.instantiate(site, symbol, Type.emptyList, site.memberType(a).argtypes()) != null);
    }

    Symbol findField(Env<AttrContext> env, Type site, Symbol.TypeSymbol c, Name name) {
        Symbol sym = ResolveError.varNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null && sym.kind > 257) {
            if (e.sym.kind == 4 && (e.sym.flags_field & 0x10000) == 0) {
                sym = this.accessible(env, site, e.sym) ? e.sym : new AccessError(e.sym);
            }
            e = e.next();
        }
        if (sym.kind > 257) {
            Symbol sym1;
            Type st = c.type.supertype();
            if (st != null && st.tag == 10) {
                sym1 = this.findField(env, site, st.tsym, name);
                if (sym1.kind < sym.kind) {
                    sym = sym1;
                }
            }
            List<Type> list = c.type.interfaces();
            while (sym.kind != 256 && list.nonEmpty()) {
                sym1 = this.findField(env, site, ((Type)list.head).tsym, name);
                if (sym.kind < 256 && sym1.kind < 256 && sym.owner != sym1.owner) {
                    sym = new AmbiguityError(sym, sym1);
                } else if (sym1.kind < sym.kind) {
                    sym = sym1;
                }
                list = list.tail;
            }
        }
        return sym;
    }

    Symbol findVar(Env<AttrContext> env, Name name) {
        Symbol sym1;
        ResolveError sym = ResolveError.varNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry entry = ((AttrContext)env1.info).scope.lookup(name);
            while (entry.scope != null) {
                sym1 = entry.sym;
                if (sym1.kind == 4 && (sym1.flags_field & 0x10000) == 0) {
                    if (staticOnly && sym1.owner.kind == 2 && (sym1.flags() & 8) == 0) {
                        return new StaticError(sym1);
                    }
                    return sym1;
                }
                entry = entry.next();
            }
            sym1 = this.findField(env1, env1.enclClass.sym.type, env1.enclClass.sym, name);
            if (sym1.kind < 258) {
                if (staticOnly && sym1.kind < 256 && sym1.owner.kind == 2 && (sym1.flags() & 8) == 0) {
                    return new StaticError(sym1);
                }
                return sym1;
            }
            if ((env1.enclClass.sym.flags() & 8) != 0) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym1 = this.findField(env, this.syms.predefClass.type, this.syms.predefClass, name);
        if (sym1.kind <= 256) {
            return sym1;
        }
        return sym;
    }

    Symbol findInterfaceMethod(Env<AttrContext> env, Type site, Name name, List<Type> typarams, List<Type> argtypes, Symbol.ClassSymbol c, Symbol bestSoFar) {
        List<Type> l = c.type.interfaces();
        while (l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)((Type)l.head).tsym;
            Scope.Entry entry = i.members().lookup(name);
            while (entry.scope != null) {
                if (entry.sym.kind == 32) {
                    if (this.instantiate(site, entry.sym, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, entry.sym)) {
                        bestSoFar = entry.sym;
                    } else if (bestSoFar.kind > 259) {
                        bestSoFar = ResolveError.wrongMethod;
                    }
                }
                entry = entry.next();
            }
            bestSoFar = this.findInterfaceMethod(env, site, name, typarams, argtypes, i, bestSoFar);
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol checkBestInterfaceMethod(Env<AttrContext> env, Type site, Name name, List<Type> typarams, List<Type> argtypes, Symbol.ClassSymbol c, Symbol bestSoFar) {
        List<Type> l = c.type.interfaces();
        while (bestSoFar.kind == 32 && l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)((Type)l.head).tsym;
            Scope.Entry entry = i.members().lookup(name);
            while (bestSoFar.kind == 32 && entry.scope != null) {
                if (entry.sym.kind == 32 && this.instantiate(site, entry.sym, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, entry.sym)) {
                    bestSoFar = new AmbiguityError(bestSoFar, entry.sym);
                }
                entry = entry.next();
            }
            bestSoFar = this.checkBestInterfaceMethod(env, site, name, typarams, argtypes, i, bestSoFar);
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> typarams, List<Type> argtypes) {
        Symbol.ClassSymbol c;
        Symbol bestSoFar = ResolveError.methodNotFound;
        Type ct = site.tsym.type;
        boolean isAbstract = true;
        do {
            if (((c = (Symbol.ClassSymbol)ct.tsym).flags() & 0x600) == 0) {
                isAbstract = false;
            }
            Scope.Entry e = c.members().lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 32 && (e.sym.flags_field & 0x10000) == 0) {
                    if (this.instantiate(site, e.sym, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, e.sym)) {
                        bestSoFar = e.sym;
                    } else if (bestSoFar.kind > 259) {
                        bestSoFar = ResolveError.wrongMethod;
                    }
                }
                e = e.next();
            }
            if (!isAbstract) continue;
            bestSoFar = this.findInterfaceMethod(env, site, name, typarams, argtypes, c, bestSoFar);
        } while ((ct = ct.supertype()) != null && ct.tag == 10);
        if (bestSoFar.kind == 32 && !this.accessible(env, site, bestSoFar)) {
            bestSoFar = new AccessError(bestSoFar);
        }
        ct = site.tsym.type;
        isAbstract = true;
        while (bestSoFar.kind == 32 && ct.tag == 10) {
            c = (Symbol.ClassSymbol)ct.tsym;
            if ((c.flags() & 0x600) == 0) {
                isAbstract = false;
            }
            Scope.Entry entry = c.members().lookup(name);
            while (bestSoFar.kind == 32 && entry.scope != null) {
                if (bestSoFar != entry.sym && entry.sym.kind == 32 && (entry.sym.flags_field & 0x10000) == 0 && this.instantiate(site, entry.sym, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, entry.sym)) {
                    bestSoFar = new AmbiguityError(bestSoFar, entry.sym);
                }
                entry = entry.next();
            }
            if (bestSoFar.kind == 32 && isAbstract) {
                bestSoFar = this.checkBestInterfaceMethod(env, site, name, typarams, argtypes, c, bestSoFar);
            }
            ct = ct.supertype();
        }
        return bestSoFar;
    }

    Symbol findFun(Env<AttrContext> env, Name name, List<Type> typarams, List<Type> argtypes) {
        Symbol sym1;
        ResolveError sym = ResolveError.methodNotFound;
        Env<AttrContext> env1 = env;
        boolean bl = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                bl = true;
            }
            sym1 = this.findMethod(env1, env1.enclClass.sym.type, name, typarams, argtypes);
            if (sym1.kind < 260) {
                if (bl && sym1.kind < 256 && sym1.owner.kind == 2 && (sym1.flags() & 8) == 0) {
                    return new StaticError(sym1);
                }
                return sym1;
            }
            if ((env1.enclClass.sym.flags() & 8) != 0) {
                bl = true;
            }
            env1 = env1.outer;
        }
        sym1 = this.findMethod(env, this.syms.predefClass.type, name, typarams, argtypes);
        if (sym1.kind <= 256) {
            return sym1;
        }
        return sym;
    }

    Symbol loadClass(Env<AttrContext> env, Name name) {
        try {
            Symbol.ClassSymbol c = this.syms.reader.loadClass(name);
            if (this.accessible(env, c)) {
                return c;
            }
            return new AccessError(c);
        }
        catch (ClassReader.LoadError err) {
            throw err;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return ResolveError.typeNotFound;
        }
    }

    Symbol findMemberType(Env<AttrContext> env, Type site, Name name) {
        Symbol sym = ResolveError.typeNotFound;
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)site.tsym;
        Scope s = c.members();
        if (s != null) {
            Scope.Entry e = c.members().lookup(name);
            while (e.scope != null && sym.kind > 257) {
                if (e.sym.kind == 2) {
                    sym = this.accessible(env, site, e.sym) ? e.sym : new AccessError(e.sym);
                }
                e = e.next();
            }
            if (sym.kind > 257) {
                Type st = c.type.supertype();
                if (st.tag == 10) {
                    Symbol symbol = this.findMemberType(env, st, name);
                    if (symbol.kind < sym.kind) {
                        sym = symbol;
                    }
                }
            }
        }
        return sym;
    }

    Symbol findGlobalType(Env<AttrContext> env, Scope scope, Name name, boolean topOnly) {
        Symbol sym = ResolveError.typeNotFound;
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            if (!topOnly || e.sym.owner.kind == 1) {
                Symbol symbol = this.loadClass(env, e.sym.flatName());
                if (sym.kind == 2 && symbol.kind == 2 && sym != symbol) {
                    return new AmbiguityError(sym, symbol);
                }
                if (symbol.kind < sym.kind) {
                    sym = symbol;
                }
            }
            e = e.next();
        }
        return sym;
    }

    Symbol findType(Env<AttrContext> env, Name name) {
        Symbol sym1;
        Symbol sym = ResolveError.typeNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((AttrContext)env1.info).scope.lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 2) {
                    if (staticOnly && e.sym.type.tag == 14 && e.sym.owner.kind == 2) {
                        return new StaticError(e.sym);
                    }
                    return e.sym;
                }
                e = e.next();
            }
            sym1 = this.findMemberType(env1, env1.enclClass.sym.type, name);
            if (sym1.kind < 261) {
                return sym1;
            }
            int n = env1.enclClass.sym.flags();
            if ((n & 8) != 0 && (n & 0x200) == 0) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym1 = this.findGlobalType(env, env.toplevel.namedImportScope, name, false);
        if (sym1.kind <= 256) {
            return sym1;
        }
        if (sym1.kind < sym.kind) {
            sym = sym1;
        }
        sym1 = this.findGlobalType(env, env.toplevel.packge.members(), name, true);
        if (sym1.kind <= 256) {
            return sym1;
        }
        if (sym1.kind < sym.kind) {
            sym = sym1;
        }
        sym1 = this.findGlobalType(env, env.toplevel.starImportScope, name, false);
        if (sym1.kind <= 256) {
            return sym1;
        }
        if (sym1.kind < sym.kind) {
            sym = sym1;
        }
        return sym;
    }

    Symbol findIdent(Env<AttrContext> env, Name name, int kind) {
        Symbol sym = ResolveError.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findVar(env, name);
        }
        if (sym.kind > 257 && (kind & 2) != 0) {
            Symbol symbol = this.findType(env, name);
            if (symbol.kind < sym.kind) {
                sym = symbol;
            }
        }
        if (sym.kind > 257 && (kind & 1) != 0) {
            sym = this.syms.reader.enterPackage(name);
        }
        return sym;
    }

    Symbol findIdentInPackage(Env<AttrContext> env, Symbol.TypeSymbol pck, Name name, int kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol symbol = ResolveError.typeNotFound;
        if ((kind & 2) != 0) {
            symbol = this.loadClass(env, fullname);
        }
        if (symbol.kind > 257 && (kind & 1) != 0) {
            symbol = this.syms.reader.enterPackage(fullname);
        }
        return symbol;
    }

    Symbol findIdentInType(Env<AttrContext> env, Type site, Name name, int kind) {
        Symbol sym = ResolveError.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findField(env, site, site.tsym, name);
        }
        if (sym.kind > 256 && (kind & 2) != 0) {
            Symbol symbol = this.findMemberType(env, site, name);
            if (symbol.kind < sym.kind) {
                sym = symbol;
            }
        }
        return sym;
    }

    Symbol access(Symbol sym, int pos, Type site, Name name, List<Type> typarams, List<Type> list) {
        if (sym.kind >= 256) {
            if (!site.isErroneous() && !Type.isErroneous(list)) {
                ((ResolveError)sym).report(this.log, pos, site, name, typarams, list);
            }
            return ((ResolveError)sym).sym;
        }
        return sym;
    }

    Symbol access(Symbol sym, int pos, Type site, Name name) {
        if (sym.kind >= 256) {
            return this.access(sym, pos, site, name, Type.emptyList, Type.emptyList);
        }
        return sym;
    }

    public static boolean isStatic(Env<AttrContext> env) {
        return ((AttrContext)env.info).staticLevel > ((AttrContext)env.outer.info).staticLevel;
    }

    static int staticLevel(Symbol sym) {
        int level = 0;
        do {
            if ((sym.flags() & 8) != 0) {
                ++level;
            }
            sym = sym.owner;
        } while (sym.kind != 1);
        return level;
    }

    void checkNonAbstract(int pos, Symbol symbol) {
        if ((symbol.flags() & 0x400) != 0) {
            this.log.error(pos, String.valueOf(String.valueOf("abstract ").concat(String.valueOf(symbol))).concat(String.valueOf(" cannot be accessed directly")));
        }
    }

    public static void printscopes(Scope s) {
        while (s != null) {
            if (s.owner != null) {
                System.err.print(String.valueOf(s.owner).concat(String.valueOf(": ")));
            }
            Scope.Entry e = s.elems;
            while (e != null) {
                if ((e.sym.flags() & 0x400) != 0) {
                    System.err.print("abstract ");
                }
                System.err.print(String.valueOf(e.sym).concat(String.valueOf(" ")));
                e = e.sibling;
            }
            System.err.println();
            s = s.next;
        }
    }

    static void printscopes(Env<AttrContext> env) {
        while (env.outer != null) {
            System.err.println("------------------------------");
            Resolve.printscopes(((AttrContext)env.info).scope);
            env = env.outer;
        }
    }

    void warnUnchecked(int pos, Symbol sym, List<Type> list) {
        if (sym.kind < 256 && !this.chk.unchecked) {
            this.log.warning(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unchecked method call: ").concat(String.valueOf(sym))).concat(String.valueOf(sym.location()))).concat(String.valueOf(" is called with ("))).concat(String.valueOf(list))).concat(String.valueOf(")")));
        }
    }

    Symbol resolveIdent(int pos, Env<AttrContext> env, Name name, int n) {
        return this.access(this.findIdent(env, name, n), pos, env.enclClass.sym.type, name);
    }

    Symbol resolveMethod(int pos, Env<AttrContext> env, Name name, List<Type> typarams, List<Type> argtypes) {
        Symbol symbol = this.findFun(env, name, typarams, argtypes);
        if (symbol.kind >= 259 && Type.isRaw(argtypes)) {
            symbol = this.findFun(env, name, typarams, Type.minimizeRaw(argtypes));
            this.warnUnchecked(pos, symbol, argtypes);
        }
        if (symbol.kind >= 256) {
            symbol = this.access(symbol, pos, env.enclClass.sym.type, name, typarams, argtypes);
        }
        return symbol;
    }

    Symbol resolveQualifiedMethod(int pos, Env<AttrContext> env, Type site, Name name, List<Type> typarams, List<Type> argtypes) {
        Symbol symbol = this.findMethod(env, site, name, typarams, argtypes);
        if (symbol.kind >= 259 && Type.isRaw(argtypes)) {
            symbol = this.findMethod(env, site, name, typarams, Type.minimizeRaw(argtypes));
            this.warnUnchecked(pos, symbol, argtypes);
        }
        if (symbol.kind >= 256) {
            symbol = this.access(symbol, pos, site, name, typarams, argtypes);
        }
        return symbol;
    }

    Symbol resolveSelf(int pos, Env<AttrContext> env, Symbol.TypeSymbol c, Name name, boolean preciseMatch) {
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol symbol;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if ((env1.enclClass.sym == c || !preciseMatch && env1.enclClass.sym.subclass(c)) && (symbol = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly) {
                    symbol = new StaticError(symbol);
                }
                return this.access(symbol, pos, env.enclClass.sym.type, name);
            }
            if ((env1.enclClass.sym.flags() & 8) != 0) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        this.log.error(pos, String.valueOf("not an enclosing class: ").concat(String.valueOf(c.fullName())));
        return Symbol.errSymbol;
    }

    Symbol resolveConstructor(int pos, Env<AttrContext> env, Type site, List<Type> list) {
        return this.resolveQualifiedMethod(pos, env, site, Names.init, Type.emptyList, list);
    }

    Symbol resolveOperator(int pos, int opcode, Env<AttrContext> env, List<Type> argtypes) {
        Name name = TreeInfo.operatorName(opcode);
        return this.access(this.findMethod(env, this.syms.predefClass.type, name, Type.emptyList, argtypes), pos, env.enclClass.sym.type, name, Type.emptyList, argtypes);
    }

    static String kindName(int kind) {
        switch (kind) {
            case 1: {
                return "package";
            }
            case 2: {
                return "class";
            }
            case 4: {
                return "variable";
            }
            case 12: {
                return "value";
            }
            case 32: {
                return "method";
            }
        }
        return String.valueOf(String.valueOf("identifier(").concat(String.valueOf(kind))).concat(String.valueOf(")"));
    }

    static String kindNames(int kind) {
        String[] s = new String[4];
        int i = 0;
        if ((kind & 0xC) != 0) {
            String string = s[i++] = (kind & 0xC) == 4 ? "variable" : "value";
        }
        if ((kind & 0x20) != 0) {
            s[i++] = "method";
        }
        if ((kind & 2) != 0) {
            s[i++] = "class";
        }
        if ((kind & 1) != 0) {
            s[i++] = "package";
        }
        String names = "";
        for (int j = 0; j < i - 2; ++j) {
            names = String.valueOf(String.valueOf(names).concat(String.valueOf(s[j]))).concat(String.valueOf(", "));
        }
        if (i >= 2) {
            names = String.valueOf(String.valueOf(names).concat(String.valueOf(s[i - 2]))).concat(String.valueOf(" or "));
        }
        names = i >= 1 ? String.valueOf(names).concat(String.valueOf(s[i - 1])) : "identifier";
        return names;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AmbiguityError
    extends ResolveError {
        Symbol sym1;
        Symbol sym2;

        AmbiguityError(Symbol sym1, Symbol symbol) {
            super(256);
            this.sym1 = sym1;
            this.sym2 = symbol;
        }

        @Override
        void report(Log log, int pos, Type site, Name id, List<Type> typarams, List<Type> argtypes) {
            Name name = this.sym1.name;
            if (name == Names.init) {
                name = this.sym1.owner.name;
            }
            log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("reference to ").concat(String.valueOf(name))).concat(String.valueOf(" is ambiguous, both "))).concat(String.valueOf(this.sym1))).concat(String.valueOf(this.sym1.location()))).concat(String.valueOf(" and "))).concat(String.valueOf(this.sym2))).concat(String.valueOf(this.sym2.location()))).concat(String.valueOf(" match")));
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StaticError
    extends ResolveError {
        StaticError(Symbol symbol) {
            super(257);
            this.sym = symbol;
        }

        @Override
        void report(Log log, int pos, Type site, Name id, List<Type> typarams, List<Type> list) {
            log.error(pos, String.valueOf(String.valueOf("non-static ").concat(String.valueOf(this.sym))).concat(String.valueOf(" cannot be referenced from a static context")));
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AccessError
    extends ResolveError {
        AccessError(Symbol symbol) {
            super(257);
            this.sym = symbol;
        }

        @Override
        void report(Log log, int pos, Type site, Name id, List<Type> typarams, List<Type> list) {
            if (this.sym.name == Names.init && this.sym.owner != site.tsym) {
                ResolveError.methodNotFound.report(log, pos, site, id, typarams, list);
            } else if ((this.sym.flags() & 1) != 0) {
                log.error(pos, String.valueOf(String.valueOf(String.valueOf(this.sym).concat(String.valueOf(this.sym.location()))).concat(String.valueOf(" is not defined in a public class or interface"))).concat(String.valueOf("; cannot be accessed from outside package")));
            } else if ((this.sym.flags() & 6) != 0) {
                log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.sym).concat(String.valueOf(" has "))).concat(String.valueOf(TreeInfo.flagNames(this.sym.flags() & 6)))).concat(String.valueOf(" access"))).concat(String.valueOf(this.sym.location())));
            } else {
                log.error(pos, String.valueOf(String.valueOf(String.valueOf(this.sym).concat(String.valueOf(" is not public"))).concat(String.valueOf(this.sym.location()))).concat(String.valueOf("; cannot be accessed from outside package")));
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolveError
    extends Symbol
    implements TypeTags {
        static final ResolveError varNotFound = new ResolveError(258);
        static final ResolveError wrongMethod = new ResolveError(259);
        static final ResolveError methodNotFound = new ResolveError(260);
        static final ResolveError typeNotFound = new ResolveError(261);
        Symbol sym = Symbol.errSymbol;

        ResolveError(int n) {
            super(n, 0, null, null, null);
        }

        void report(Log log, int pos, Type site, Name id, List<Type> typarams, List<Type> argtypes) {
            if (id != Names.error) {
                String kindname = ResolveError.absentKindName(this.kind);
                String idname = id.toString();
                String targs = "";
                String string = "";
                if (this.kind == 260 || this.kind == 259) {
                    if (id == Names.init) {
                        kindname = "constructor";
                        idname = site.tsym.name.toString();
                    }
                    if (typarams.nonEmpty()) {
                        targs = String.valueOf(String.valueOf("<").concat(String.valueOf(typarams.toString()))).concat(String.valueOf(">"));
                    }
                    string = String.valueOf(String.valueOf("(").concat(String.valueOf(argtypes.toString()))).concat(String.valueOf(")"));
                }
                log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(kindname).concat(String.valueOf(" "))).concat(String.valueOf(idname))).concat(String.valueOf(targs))).concat(String.valueOf(string))).concat(String.valueOf(" not found"))).concat(String.valueOf(site.tsym.name.len != 0 ? String.valueOf(String.valueOf(String.valueOf(" in ").concat(String.valueOf(this.typeKindName(site)))).concat(String.valueOf(" "))).concat(String.valueOf(site)) : "")));
            }
        }

        private String typeKindName(Type type) {
            if (type.tag == 14) {
                return "bound of type variable";
            }
            if (type.tag == 13) {
                return "package";
            }
            if ((type.tsym.flags_field & 0x200) != 0) {
                return "interface";
            }
            return "class";
        }

        private static String absentKindName(int kind) {
            switch (kind) {
                case 258: {
                    return "variable";
                }
                case 259: 
                case 260: {
                    return "method";
                }
                case 261: {
                    return "class";
                }
            }
            return "identifier";
        }
    }
}

