/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.Check;
import gjc.v6.comp.Symtab;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Infer
implements Kinds,
Flags,
TypeTags {
    Log log;
    Symtab syms;
    Check chk;
    private Hashtable<Type, List<Type>> closureCache = Hashtable.make();

    public Infer(Log log, Symtab syms, Check check) {
        this.syms = syms;
        this.log = log;
        this.chk = check;
    }

    public static Constraint genTypeC(Type lo, Type hi, List<Type> tvars, Constraint c) {
        if (lo.tag == 18) {
            return c;
        }
        switch (hi.tag) {
            case 14: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 14 || lo.tag == 11 || lo.tag == 10) {
                    List<Type> l = tvars;
                    while (l.nonEmpty()) {
                        if (hi == l.head) {
                            return c.addEq(lo, hi);
                        }
                        l = l.tail;
                    }
                }
                return lo == hi ? c : Constraint.failure("% is different from %", lo, hi);
            }
            case 10: {
                if (lo.tag == 16) {
                    return c;
                }
                if (hi.tsym == lo.tsym) {
                    c = Infer.genTypeC(lo.outer(), hi.outer(), tvars, c);
                    c = Infer.genTypeC(lo.typarams(), hi.typarams(), tvars, c);
                    return c;
                }
                return Constraint.failure("% is different from %", lo, hi);
            }
            case 11: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 11) {
                    return Infer.genTypeC(lo.elemtype(), hi.elemtype(), tvars, c);
                }
                return Constraint.failure("% is different from %", lo, hi);
            }
        }
        if (lo.genType(hi)) {
            return c;
        }
        return Constraint.failure("% is different from %", lo, hi);
    }

    public static Constraint genTypeC(List<Type> lo, List<Type> hi, List<Type> tvars, Constraint c) {
        List<Type> lo1 = lo;
        List<Type> hi1 = hi;
        while (c != Constraint.fail && lo1.nonEmpty() && hi1.nonEmpty()) {
            c = Infer.genTypeC((Type)lo1.head, (Type)hi1.head, tvars, c);
            lo1 = lo1.tail;
            hi1 = hi1.tail;
        }
        if (lo1.isEmpty() == hi1.isEmpty()) {
            return c;
        }
        return Constraint.failure("different lengths: (%) and (%)", lo, hi);
    }

    public static Constraint subTypeC(Type lo, Type hi, List<Type> tvars, Constraint c) {
        if (lo.tag == 18) {
            return c;
        }
        switch (hi.tag) {
            case 14: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 14 || lo.tag == 11 || lo.tag == 10) {
                    List<Type> l = tvars;
                    while (l.nonEmpty()) {
                        if (hi == l.head) {
                            return c.addSub(lo, hi);
                        }
                        l = l.tail;
                    }
                }
                return lo == hi ? c : Constraint.failure("% is not a subtype of %", lo, hi);
            }
            case 10: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tsym == hi.tsym) {
                    return hi.typarams().length() == 0 ? c : Infer.genTypeC(lo, hi, tvars, c);
                }
                if (lo.tag == 11) {
                    if (lo.subType(hi)) {
                        return c;
                    }
                    return Constraint.failure("% is not a subtype of %", lo, hi);
                }
                if (lo.tag == 14) {
                    return Infer.subTypeC(lo.bound(), hi, tvars, c);
                }
                if (lo.tag == 10) {
                    Constraint c1;
                    Type st = lo.supertype();
                    if (st.tag == 10 && (c1 = Infer.subTypeC(st, hi, tvars, c)) != Constraint.fail) {
                        return c1;
                    }
                    if ((hi.tsym.flags() & 0x200) != 0) {
                        List<Type> l = lo.interfaces();
                        while (l.nonEmpty()) {
                            Constraint c12 = Infer.subTypeC((Type)l.head, hi, tvars, c);
                            if (c12 != Constraint.fail) {
                                return c12;
                            }
                            l = l.tail;
                        }
                    }
                }
                return Constraint.failure("% is not a subtype of %", lo, hi);
            }
            case 11: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 11) {
                    if (hi.elemtype().tag <= 8) {
                        return Infer.genTypeC(lo.elemtype(), hi.elemtype(), tvars, c);
                    }
                    return Infer.subTypeC(lo.elemtype(), hi.elemtype(), tvars, c);
                }
                return Constraint.failure("% is not a subtype of %", lo, hi);
            }
        }
        if (lo.subType(hi)) {
            return c;
        }
        return Constraint.failure("% is not a subtype of %", lo, hi);
    }

    public static Constraint subTypeC(List<Type> lo, List<Type> hi, List<Type> tvars, Constraint c) {
        List<Type> lo1 = lo;
        List<Type> hi1 = hi;
        while (c != Constraint.fail && lo1.nonEmpty() && hi1.nonEmpty()) {
            c = Infer.subTypeC((Type)lo1.head, (Type)hi1.head, tvars, c);
            lo1 = lo1.tail;
            hi1 = hi1.tail;
        }
        if (lo1.isEmpty() == hi1.isEmpty()) {
            return c;
        }
        return Constraint.failure("different lengths: (%) and (%)", lo, hi);
    }

    public static Type join(Type t1, Type t2) {
        if (t1 == t2 || t2.tag == 16) {
            return t1;
        }
        switch (t1.tag) {
            case 16: {
                return t2;
            }
            case 10: {
                if (t1.tsym == t2.tsym) {
                    Type outer1 = t1.outer();
                    Type outer2 = t2.outer();
                    List<Type> typarams1 = t1.typarams();
                    List<Type> typarams2 = t2.typarams();
                    Type outer = Infer.join(outer1, outer2);
                    List<Type> typarams = Infer.join(typarams1, typarams2);
                    if (outer == null || typarams == null) {
                        return null;
                    }
                    if (outer == outer1 && typarams == typarams1) {
                        return t1;
                    }
                    if (outer == outer2 && typarams == typarams2) {
                        return t2;
                    }
                    return new Type.ClassType(outer, typarams, t1.tsym);
                }
                return null;
            }
            case 11: {
                if (t2.tag == 11) {
                    Type elemtype2;
                    Type elemtype1 = t1.elemtype();
                    Type elemtype = Infer.join(elemtype1, elemtype2 = t2.elemtype());
                    if (elemtype == null) {
                        return null;
                    }
                    if (elemtype == elemtype1) {
                        return t1;
                    }
                    if (elemtype == elemtype2) {
                        return t2;
                    }
                    return new Type.ArrayType(elemtype);
                }
                return null;
            }
        }
        return t1.sameType(t2) ? t1 : null;
    }

    public static List<Type> join(List<Type> ts1, List<Type> ts2) {
        if (ts1.isEmpty() && ts2.isEmpty()) {
            return Type.emptyList;
        }
        if (ts1.nonEmpty() && ts2.nonEmpty()) {
            Type head = Infer.join((Type)ts1.head, (Type)ts2.head);
            List<Type> tail = Infer.join(ts1.tail, ts2.tail);
            if (head == null || tail == null) {
                return null;
            }
            if (head == ts1.head && tail == ts1.tail) {
                return ts1;
            }
            if (head == ts2.head && tail == ts2.tail) {
                return ts2;
            }
            return tail.prepend(head);
        }
        return null;
    }

    List<Type> closure(Type t) {
        List<Type> cl = this.closureCache.get(t);
        if (cl == null) {
            Type st = t.supertype();
            cl = st.tag == 10 ? this.insert(this.closure(st), t) : Type.emptyList.prepend(t);
            List<Type> list = t.interfaces();
            while (list.nonEmpty()) {
                cl = this.union(cl, this.closure((Type)list.head));
                list = list.tail;
            }
            this.closureCache.put(t, cl);
        }
        return cl;
    }

    private List<Type> insert(List<Type> cl, Type type) {
        if (cl.isEmpty() || type.tsym.precedes(((Type)cl.head).tsym)) {
            return cl.prepend(type);
        }
        if (((Type)cl.head).tsym.precedes(type.tsym)) {
            return this.insert(cl.tail, type).prepend((Type)cl.head);
        }
        return cl;
    }

    private List<Type> union(List<Type> cl1, List<Type> list) {
        if (cl1.isEmpty()) {
            return list;
        }
        if (list.isEmpty()) {
            return cl1;
        }
        if (((Type)cl1.head).tsym.precedes(((Type)list.head).tsym)) {
            return this.union(cl1.tail, list).prepend((Type)cl1.head);
        }
        if (((Type)list.head).tsym.precedes(((Type)cl1.head).tsym)) {
            return this.union(cl1, list.tail).prepend((Type)list.head);
        }
        return this.union(cl1.tail, list.tail).prepend((Type)cl1.head);
    }

    List<Type> intersect(List<Type> cl1, List<Type> cl2) {
        if (cl1 == cl2) {
            return cl1;
        }
        if (cl1.isEmpty() || cl2.isEmpty()) {
            return Type.emptyList;
        }
        if (((Type)cl1.head).tsym.precedes(((Type)cl2.head).tsym)) {
            return this.intersect(cl1.tail, cl2);
        }
        if (((Type)cl2.head).tsym.precedes(((Type)cl1.head).tsym)) {
            return this.intersect(cl1, cl2.tail);
        }
        Type t = Infer.join((Type)cl1.head, (Type)cl2.head);
        List<Type> list = this.intersect(cl1.tail, cl2.tail);
        return t == null ? list : list.prepend(t);
    }

    Type firstInDiff(List<Type> cl1, List<Type> list) {
        while (cl1.nonEmpty() && list.nonEmpty() && cl1.head == list.head) {
            cl1 = cl1.tail;
            list = list.tail;
        }
        return cl1.nonEmpty() ? (Type)cl1.head : null;
    }

    Type min(List<Type> cl) {
        if (cl.isEmpty()) {
            return Type.allType;
        }
        Type type = this.firstInDiff(cl, this.closure((Type)cl.head));
        return type == null ? (Type)cl.head : null;
    }

    List<Constraint> distribute(Constraint c, List<Type> tvars) {
        List<Constraint> cs = List.make(tvars.length(), Constraint.empty);
        while (c != Constraint.empty) {
            List<Type> tvs = tvars;
            List<Constraint> list = cs;
            while (tvs.nonEmpty() && tvs.head != c.hi) {
                tvs = tvs.tail;
                list = list.tail;
            }
            if (tvs.nonEmpty()) {
                list.head = new Constraint(c.kind, c.lo, c.hi, (Constraint)list.head);
            }
            c = c.rest;
        }
        return cs;
    }

    Type lub(Constraint c) {
        if (c == Constraint.empty) {
            return Type.allType;
        }
        if (c == Constraint.fail) {
            return null;
        }
        switch (c.lo.tag) {
            case 16: {
                return this.lub(c.rest);
            }
            case 11: {
                Constraint c2 = Constraint.empty;
                Constraint c1 = c;
                while (c1 != Constraint.empty) {
                    switch (c1.lo.tag) {
                        case 16: {
                            break;
                        }
                        case 11: {
                            c2 = new Constraint(c1.kind, c1.lo.elemtype(), c1.hi, c2);
                            break;
                        }
                        case 10: {
                            if (c1.kind == 2) {
                                return null;
                            }
                            return this.lub(new Constraint(1, this.syms.objectType, c1.hi, c1.rest));
                        }
                        default: {
                            return null;
                        }
                    }
                    c1 = c1.rest;
                }
                Type t = this.lub(c2);
                return t == null ? this.syms.objectType : new Type.ArrayType(t);
            }
            case 10: {
                List<Type> cl = this.closure(c.lo);
                boolean fixed = false;
                Constraint c1 = c.rest;
                while (c1 != Constraint.empty) {
                    switch (c1.lo.tag) {
                        case 16: {
                            break;
                        }
                        case 11: {
                            if (c1.kind == 2) {
                                return null;
                            }
                            cl = this.intersect(cl, this.closure(this.syms.objectType));
                            break;
                        }
                        case 10: {
                            if (fixed) {
                                Type t = Infer.join((Type)cl.head, c1.lo);
                                if (t == null) {
                                    return t;
                                }
                                cl.head = t;
                                break;
                            }
                            cl = this.intersect(cl, this.closure(c1.lo));
                            if (c1.kind != 2) break;
                            fixed = true;
                            if (c1.lo.genType((Type)cl.head)) break;
                            return null;
                        }
                        default: {
                            return null;
                        }
                    }
                    c1 = c1.rest;
                }
                return this.min(cl);
            }
        }
        Type type = this.lub(c.rest);
        return type == null ? type : Infer.join(c.lo, type);
    }

    List<Type> typeParams(List<Type> tvars, List<Type> formals, List<Type> argtypes) {
        Constraint c = Infer.subTypeC(Type.baseTypes(argtypes), formals, tvars, Constraint.empty);
        if (c == Constraint.fail) {
            return null;
        }
        ListBuffer<Type> buf = new ListBuffer<Type>();
        List<Constraint> l = this.distribute(c, tvars);
        while (l.nonEmpty()) {
            Type t = this.lub((Constraint)l.head);
            if (t == null) {
                return null;
            }
            buf.append(t);
            l = l.tail;
        }
        List<Type> list = buf.toList();
        return this.withinBounds(tvars, list) ? list : null;
    }

    String substitute(String s, Object[] args) {
        char[] cs = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        int j = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '%') {
                buf.append(args[j++]);
                continue;
            }
            buf.append(cs[i]);
        }
        return buf.toString();
    }

    boolean withinBounds(List<Type> tvars, List<Type> arguments) {
        List<Type> tvs = tvars;
        List<Type> list = arguments;
        while (tvs.nonEmpty()) {
            if (!this.chk.checkDeeplyExtends(0, false, (Type)list.head, ((Type)tvs.head).bound().subst(tvars, arguments))) {
                return false;
            }
            tvs = tvs.tail;
            list = list.tail;
        }
        return true;
    }

    void checkSafe(int pos, Type t, Symbol sym) {
        if (t.occCount(Type.allType) >= 2) {
            Type type = sym.type;
            if ((type.tag & 0xF) != 0) {
                type = type.restype();
            }
            this.checkSafe(pos, sym, t, type, Type.emptyList);
        }
    }

    private List<Type> checkSafe(int pos, Symbol sym, Type t, Type template, List<Type> tvars) {
        if (tvars == null) {
            return null;
        }
        switch (template.tag) {
            case 14: {
                if (t.occCount(Type.allType) > 0) {
                    List<Type> list = tvars;
                    while (list.nonEmpty()) {
                        if (list.head == template) {
                            this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("type variable ").concat(String.valueOf(template))).concat(String.valueOf(" occurs more than once in "))).concat(String.valueOf(sym.kind == 32 ? "result " : ""))).concat(String.valueOf("type of "))).concat(String.valueOf(sym))).concat(String.valueOf("; cannot be left uninstantiated")));
                            return null;
                        }
                        list = list.tail;
                    }
                    return tvars.prepend(template);
                }
                return tvars;
            }
            case 10: {
                return this.checkSafe(pos, sym, t.outer(), template.outer(), this.checkSafe(pos, sym, t.typarams(), template.typarams(), tvars));
            }
            case 11: {
                return this.checkSafe(pos, sym, t.elemtype(), template.elemtype(), tvars);
            }
        }
        return tvars;
    }

    private List<Type> checkSafe(int pos, Symbol sym, List<Type> ts, List<Type> templates, List<Type> tvars) {
        List<Type> l = ts;
        List<Type> list = templates;
        while (l.nonEmpty()) {
            tvars = this.checkSafe(pos, sym, (Type)l.head, (Type)list.head, tvars);
            l = l.tail;
            list = list.tail;
        }
        return tvars;
    }

    static class Constraint {
        static final int FAIL = -1;
        static final int EMPTY = 0;
        static final int SUB = 1;
        static final int GEN = 2;
        int kind;
        Type lo;
        Type hi;
        Constraint rest;
        static Constraint empty = new Constraint(0, null, null, null);
        static Constraint fail = new Constraint(-1, null, null, null);
        static String cause;
        static Object arg1;
        static Object arg2;

        public String toString() {
            switch (this.kind) {
                case -1: {
                    return "<fail>";
                }
                case 0: {
                    return "true";
                }
                case 1: {
                    return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.lo).concat(String.valueOf(" < "))).concat(String.valueOf(this.hi))).concat(String.valueOf(", "))).concat(String.valueOf(this.rest));
                }
                case 2: {
                    return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.lo).concat(String.valueOf(" = "))).concat(String.valueOf(this.hi))).concat(String.valueOf(", "))).concat(String.valueOf(this.rest));
                }
            }
            return "?";
        }

        Constraint(int kind, Type lo, Type hi, Constraint constraint) {
            this.lo = lo;
            this.hi = hi;
            this.kind = kind;
            this.rest = constraint;
        }

        Constraint addSub(Type otherLo, Type otherHi) {
            if (this.kind == 0) {
                return new Constraint(1, otherLo, otherHi, this);
            }
            if (this.kind == -1) {
                return this;
            }
            if (this.kind == 2 && this.hi == otherHi) {
                if (otherLo.subType(this.lo)) {
                    return this;
                }
                return Constraint.failure("% is not a subtype of %", otherLo, this.lo);
            }
            Constraint constraint = this.rest.addSub(otherLo, otherHi);
            if (this.rest == constraint) {
                return this;
            }
            if (constraint.kind == -1) {
                return constraint;
            }
            return new Constraint(this.kind, this.lo, this.hi, constraint);
        }

        Constraint addEq(Type otherLo, Type otherHi) {
            if (this.kind == 0) {
                return new Constraint(2, otherLo, otherHi, this);
            }
            if (this.kind == -1) {
                return this;
            }
            if (this.kind == 2 && this.hi == otherHi) {
                if (this.lo.sameType(otherLo)) {
                    return this;
                }
                return Constraint.failure("% is different from %", this.lo, otherLo);
            }
            if (this.kind == 1 && this.hi == otherHi) {
                if (this.lo.subType(otherLo)) {
                    return this.rest.addEq(otherLo, otherHi);
                }
                return Constraint.failure("% is not a subtype of %", this.lo, otherLo);
            }
            Constraint constraint = this.rest.addEq(otherLo, otherHi);
            if (this.rest == constraint) {
                return this;
            }
            if (constraint.kind == -1) {
                return constraint;
            }
            return new Constraint(this.kind, this.lo, this.hi, constraint);
        }

        static Constraint failure(String _cause, Object _arg1, Object _arg2) {
            cause = _cause;
            arg1 = _arg1;
            arg2 = _arg2;
            return fail;
        }
    }
}

