/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Symbol;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.Check;
import gjc.v6.comp.Symtab;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.util.Bits;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.Log;
import gjc.v6.util.Names;
import gjc.v6.util.Pair;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends Tree.Visitor<Void, Integer>
implements Flags,
Kinds,
TypeTags {
    static final Integer exprStatus = new Integer(0);
    static final Integer varStatus = new Integer(1);
    static final Integer condStatus = new Integer(2);
    Log log;
    Symtab syms;
    Check chk;
    Bits inits = new Bits();
    Bits uninits = new Bits();
    Bits initsWhenTrue;
    Bits initsWhenFalse;
    Bits uninitsWhenTrue;
    Bits uninitsWhenFalse;
    Symbol.VarSymbol[] vars = new Symbol.VarSymbol[32];
    int[] levels = new int[32];
    List<Symbol.ClassSymbol> thrown;
    List<Symbol.ClassSymbol> reported;
    boolean alive;
    int loopLevel = 0;
    int firstadr = 0;
    int nextadr = 0;
    Hashtable<Tree, Pair<Bits, Bits>> breaks = Hashtable.make();
    Hashtable<Tree, Pair<Bits, Bits>> continues = Hashtable.make();
    Symbol.ClassSymbol enclClass;

    public Flow(Log log, Symtab syms, Check check) {
        this.log = log;
        this.syms = syms;
        this.chk = check;
    }

    boolean trackable(Symbol symbol) {
        return symbol != null && symbol.kind == 4 && (symbol.owner.kind == 32 || symbol.owner == this.enclClass && (symbol.flags() & 0x10) != 0 && ((Symbol.VarSymbol)symbol).constValue == null && symbol.name != Names._this && symbol.name != Names._super);
    }

    void newVar(Symbol.VarSymbol sym) {
        if (this.nextadr == this.vars.length) {
            Symbol.VarSymbol[] newvars = new Symbol.VarSymbol[this.nextadr * 2];
            System.arraycopy(this.vars, 0, newvars, 0, this.nextadr);
            this.vars = newvars;
            int[] nArray = new int[this.nextadr * 2];
            System.arraycopy(this.levels, 0, nArray, 0, this.nextadr);
            this.levels = nArray;
        }
        sym.adr = this.nextadr;
        this.vars[this.nextadr] = sym;
        this.levels[this.nextadr] = this.loopLevel;
        ++this.nextadr;
    }

    void letInit(int pos, Symbol.VarSymbol sym) {
        if (this.inits == null) {
            Bits initsWhenTrue1 = this.initsWhenTrue.dup();
            Bits initsWhenFalse1 = this.initsWhenFalse.dup();
            Bits uninitsWhenTrue1 = this.uninitsWhenTrue.dup();
            Bits bits = this.uninitsWhenFalse.dup();
            this.merge();
            this.letInit(pos, sym);
            this.initsWhenTrue = initsWhenTrue1.orSet(this.inits);
            this.initsWhenFalse = initsWhenFalse1.orSet(this.inits);
            this.uninitsWhenTrue = uninitsWhenTrue1.orSet(this.uninits);
            this.uninitsWhenFalse = bits.orSet(this.uninits);
            this.inits = null;
            this.uninits = null;
        } else {
            this.inits.incl(sym.adr);
            if (!((sym.flags() & 0x10) == 0 || this.levels[sym.adr] >= this.loopLevel && this.uninits.member(sym.adr))) {
                this.log.error(pos, String.valueOf(sym).concat(String.valueOf(" might already have been assigned to")));
            }
            this.uninits.excl(sym.adr);
        }
    }

    void letInit(Tree tree) {
        Symbol symbol;
        if ((tree.tag == 31 || tree.tag == 30 && TreeInfo.name(((Tree.Select)tree).selected) == Names._this) && this.trackable(symbol = TreeInfo.symbol(tree))) {
            this.letInit(tree.pos, (Symbol.VarSymbol)symbol);
        }
    }

    void checkInit(int pos, Symbol.VarSymbol varSymbol) {
        if (!this.inits.member(varSymbol.adr)) {
            this.log.error(pos, String.valueOf(varSymbol).concat(String.valueOf(" might not have been initialized")));
            this.inits.incl(varSymbol.adr);
        }
    }

    boolean isFalse(Tree tree) {
        return tree.type.tag == 8 && tree.type.constValue != null && (Integer)tree.type.constValue == 0;
    }

    boolean isTrue(Tree tree) {
        return tree.type.tag == 8 && tree.type.constValue != null && (Integer)tree.type.constValue != 0;
    }

    void jump(Tree target, Hashtable<Tree, Pair<Bits, Bits>> initTable) {
        Pair<Bits, Bits> pair = initTable.get(target);
        if (pair == null) {
            initTable.put(target, new Pair<Bits, Bits>(this.inits.dup(), this.uninits.dup()));
        } else {
            ((Bits)pair.fst).andSet(this.inits);
            ((Bits)pair.snd).andSet(this.uninits);
        }
    }

    void resolve(Tree target, Hashtable<Tree, Pair<Bits, Bits>> initTable) {
        Pair<Bits, Bits> pair = initTable.get(target);
        if (pair != null) {
            this.inits.andSet((Bits)pair.fst);
            this.uninits.andSet((Bits)pair.snd);
            this.alive = true;
        }
    }

    void markThrown(int pos, Symbol.ClassSymbol classSymbol) {
        if (!this.chk.isUnchecked(classSymbol)) {
            this.chk.checkHandled(pos, classSymbol, this.reported);
            this.thrown = Check.incl(classSymbol, this.thrown);
        }
    }

    void markDead() {
        this.inits.inclRange(this.firstadr, this.nextadr);
        this.uninits.inclRange(this.firstadr, this.nextadr);
        this.alive = false;
    }

    void split() {
        this.initsWhenFalse = this.inits.dup();
        this.uninitsWhenFalse = this.uninits.dup();
        this.initsWhenTrue = this.inits;
        this.uninitsWhenTrue = this.uninits;
    }

    void merge() {
        this.inits = this.initsWhenFalse.andSet(this.initsWhenTrue);
        this.uninits = this.uninitsWhenFalse.andSet(this.uninitsWhenTrue);
    }

    public void analyze(Tree tree) {
        if (tree != null) {
            tree.visit(this, null);
        }
    }

    void analyzeVar(Tree tree) {
        tree.visit(this, varStatus);
    }

    void analyzeExpr(Tree tree) {
        if (tree != null) {
            tree.visit(this, exprStatus);
            if (this.inits == null) {
                this.merge();
            }
        }
    }

    void analyzeCond(Tree tree) {
        if (this.isFalse(tree)) {
            this.initsWhenTrue = this.inits.dup();
            this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
            this.uninitsWhenTrue = this.inits.dup();
            this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
            this.initsWhenFalse = this.inits;
            this.uninitsWhenFalse = this.uninits;
        } else if (this.isTrue(tree)) {
            this.initsWhenFalse = this.inits.dup();
            this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
            this.uninitsWhenFalse = this.inits.dup();
            this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
            this.initsWhenTrue = this.inits;
            this.uninitsWhenTrue = this.uninits;
        } else {
            tree.visit(this, condStatus);
            if (this.inits != null) {
                this.split();
            }
        }
        this.inits = null;
        this.uninits = null;
    }

    void analyzeStat(Tree tree) {
        if (!this.alive && tree != null && (tree.tag != 6 || ((Tree.Block)tree).stats.nonEmpty())) {
            this.log.error(tree.pos, "unreachable statement");
            this.alive = true;
        }
        tree.visit(this, null);
        this.resolve(tree, this.breaks);
    }

    void analyzeExprs(List<Tree> trees) {
        if (trees != null) {
            List<Tree> list = trees;
            while (list.nonEmpty()) {
                this.analyzeExpr((Tree)list.head);
                list = list.tail;
            }
        }
    }

    void analyzeStats(List<Tree> trees) {
        if (trees != null) {
            List<Tree> list = trees;
            while (list.nonEmpty()) {
                this.analyzeStat((Tree)list.head);
                list = list.tail;
            }
        }
    }

    @Override
    public Void _case(Tree.ClassDef tree, Integer status) {
        if (tree.sym == null) {
            return null;
        }
        List<Symbol.ClassSymbol> thrownPrev = this.thrown;
        List<Symbol.ClassSymbol> reportedPrev = this.reported;
        boolean alivePrev = this.alive;
        int firstadrPrev = this.firstadr;
        Symbol.ClassSymbol enclClassPrev = this.enclClass;
        this.thrown = Symbol.ClassSymbol.emptyList;
        this.reported = Symbol.ClassSymbol.emptyList;
        List<Tree> l = tree.defs;
        while (l.nonEmpty()) {
            if (TreeInfo.isInitialConstructor((Tree)l.head)) {
                List<Symbol.ClassSymbol> t = ((Tree.MethodDef)l.head).sym.type.thrown();
                this.reported = this.reported == null ? t : Check.intersect(t, this.reported);
            }
            l = l.tail;
        }
        this.firstadr = this.nextadr;
        this.enclClass = tree.sym;
        List<Tree> l2 = tree.defs;
        while (l2.nonEmpty()) {
            this.alive = true;
            if (((Tree)l2.head).tag != 4 && (TreeInfo.flags((Tree)l2.head) & 8) != 0) {
                this.analyze((Tree)l2.head);
            }
            l2 = l2.tail;
        }
        List<Tree> l3 = tree.defs;
        while (l3.nonEmpty()) {
            this.alive = true;
            if (((Tree)l3.head).tag != 4 && (TreeInfo.flags((Tree)l3.head) & 8) == 0) {
                this.analyze((Tree)l3.head);
            }
            l3 = l3.tail;
        }
        List<Tree> list = tree.defs;
        while (list.nonEmpty()) {
            this.alive = true;
            if (((Tree)list.head).tag == 4) {
                this.analyze((Tree)list.head);
            }
            list = list.tail;
        }
        this.thrown = thrownPrev;
        this.reported = reportedPrev;
        this.alive = alivePrev;
        this.nextadr = this.firstadr;
        this.firstadr = firstadrPrev;
        this.enclClass = enclClassPrev;
        return null;
    }

    @Override
    public Void _case(Tree.MethodDef tree, Integer status) {
        if (tree.body != null) {
            Bits initsPrev = this.inits.dup();
            Bits uninitsPrev = this.uninits.dup();
            List<Symbol.ClassSymbol> reportedPrev = this.reported;
            int nextadrPrev = this.nextadr;
            List<Symbol.ClassSymbol> t = tree.sym.type.thrown();
            boolean isInitialConstr = TreeInfo.isInitialConstructor(tree);
            this.reported = isInitialConstr ? this.reported.prepend(t) : t;
            this.breaks.reset();
            this.continues.reset();
            if (!isInitialConstr) {
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.inits.incl(i);
                    this.uninits.excl(i);
                }
            }
            List<Tree.VarDef> l = tree.params;
            while (l.nonEmpty()) {
                this.analyze((Tree)l.head);
                this.letInit(((Tree.VarDef)l.head).pos, ((Tree.VarDef)l.head).sym);
                l = l.tail;
            }
            this.analyzeStat(tree.body);
            int pos = tree.body.pos;
            if (this.alive && tree.sym.type.restype().tag != 9) {
                this.log.error(pos, "missing return statement");
            }
            if (isInitialConstr) {
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.checkInit(pos, this.vars[i]);
                }
            }
            this.inits = initsPrev;
            this.uninits = uninitsPrev;
            this.reported = reportedPrev;
            this.nextadr = nextadrPrev;
        }
        return null;
    }

    @Override
    public Void _case(Tree.VarDef tree, Integer status) {
        boolean bl = this.trackable(tree.sym);
        if (bl) {
            this.newVar(tree.sym);
        }
        if (tree.init != null) {
            this.analyzeExpr(tree.init);
            if (bl) {
                this.inits.incl(tree.sym.adr);
                this.uninits.excl(tree.sym.adr);
            }
        } else if (bl) {
            this.inits.excl(tree.sym.adr);
            this.uninits.incl(tree.sym.adr);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Block tree, Integer status) {
        int n = this.nextadr;
        this.analyzeStats(tree.stats);
        this.nextadr = n;
        return null;
    }

    @Override
    public Void _case(Tree.DoLoop tree, Integer n) {
        ++this.loopLevel;
        this.analyzeStat(tree.body);
        this.resolve(tree, this.continues);
        this.analyzeCond(tree.cond);
        this.alive = this.alive && !this.isTrue(tree.cond);
        this.inits = this.initsWhenFalse;
        this.uninits = this.uninitsWhenFalse;
        --this.loopLevel;
        return null;
    }

    @Override
    public Void _case(Tree.WhileLoop tree, Integer status) {
        ++this.loopLevel;
        this.analyzeCond(tree.cond);
        Bits initsCond = this.initsWhenFalse;
        Bits uninitsCond = this.uninitsWhenFalse;
        this.inits = this.initsWhenTrue;
        this.uninits = this.uninitsWhenTrue;
        boolean bl = this.alive;
        this.alive = this.alive && !this.isFalse(tree.cond);
        this.analyzeStat(tree.body);
        this.alive = bl && !this.isTrue(tree.cond);
        this.inits = initsCond;
        this.uninits = uninitsCond;
        --this.loopLevel;
        return null;
    }

    @Override
    public Void _case(Tree.ForLoop tree, Integer status) {
        Bits bits;
        Bits initsCond;
        int nextadrPrev = this.nextadr;
        this.analyzeStats(tree.init);
        ++this.loopLevel;
        if (tree.cond != null) {
            this.analyzeCond(tree.cond);
            initsCond = this.initsWhenFalse;
            bits = this.uninitsWhenFalse;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenFalse;
            this.alive &= !this.isFalse(tree.cond);
        } else {
            initsCond = this.inits.dup();
            initsCond.inclRange(this.firstadr, this.nextadr);
            bits = this.uninits.dup();
            bits.inclRange(this.firstadr, this.nextadr);
        }
        this.analyzeStat(tree.body);
        this.resolve(tree, this.continues);
        this.analyzeStats(tree.step);
        this.alive = this.alive && tree.cond != null && !this.isTrue(tree.cond);
        this.inits = initsCond;
        this.uninits = bits;
        --this.loopLevel;
        this.nextadr = nextadrPrev;
        return null;
    }

    @Override
    public Void _case(Tree.Labelled tree, Integer n) {
        this.analyzeStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Switch tree, Integer status) {
        int nextadrPrev = this.nextadr;
        this.analyzeExpr(tree.selector);
        Bits initsSwitch = this.inits;
        Bits uninitsSwitch = this.uninits;
        boolean aliveSwitch = this.alive;
        boolean hasDefault = false;
        List<Tree.Case> list = tree.cases;
        while (list.nonEmpty()) {
            this.inits = initsSwitch.dup();
            this.alive = aliveSwitch;
            this.analyzeStats(((Tree.Case)list.head).stats);
            if (((Tree.Case)list.head).pat == null) {
                hasDefault = true;
            }
            list = list.tail;
        }
        if (!hasDefault) {
            this.alive |= aliveSwitch;
            this.inits.andSet(initsSwitch);
        }
        this.nextadr = nextadrPrev;
        return null;
    }

    @Override
    public Void _case(Tree.Synchronized tree, Integer n) {
        this.analyzeExpr(tree.lock);
        this.analyzeStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Try tree, Integer status) {
        List<Symbol.ClassSymbol> reportedPrev = this.reported;
        List<Symbol.ClassSymbol> thrownPrev = this.thrown;
        this.thrown = Symbol.ClassSymbol.emptyList;
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            Symbol.ClassSymbol exc = (Symbol.ClassSymbol)((Tree.Catch)l.head).param.type.tsym;
            this.reported = Check.incl(exc, this.reported);
            l = l.tail;
        }
        Bits initsTry = this.inits.dup();
        boolean aliveTry = this.alive;
        this.analyzeStat(tree.body);
        Bits initsEnd = this.inits;
        Bits uninitsEnd = this.uninits;
        Bits uninitsTry = this.uninits.dup();
        boolean aliveEnd = this.alive;
        List<Symbol.ClassSymbol> thrownInTry = this.thrown;
        this.thrown = thrownPrev;
        List<Symbol.ClassSymbol> caught = Symbol.ClassSymbol.emptyList;
        int nextadrCatch = this.nextadr;
        this.reported = reportedPrev;
        List<Tree.Catch> l2 = tree.catchers;
        while (l2.nonEmpty()) {
            Tree.VarDef param = ((Tree.Catch)l2.head).param;
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)param.type.tsym;
            this.alive = !Check.elem(classSymbol, caught) && (this.chk.isUnchecked(classSymbol) || classSymbol == this.syms.throwableType.tsym || classSymbol == this.syms.exceptionType.tsym || Check.intersects(classSymbol, thrownInTry));
            caught = Check.incl(classSymbol, caught);
            this.inits = initsTry.dup();
            this.uninits = uninitsTry.dup();
            this.analyze(param);
            this.letInit(param.pos, param.sym);
            this.analyzeStat(((Tree.Catch)l2.head).body);
            initsEnd.andSet(this.inits);
            uninitsEnd.andSet(this.uninits);
            aliveEnd |= this.alive;
            this.nextadr = nextadrCatch;
            l2 = l2.tail;
        }
        if (tree.finalizer != null) {
            this.inits = initsTry.dup();
            this.uninits = uninitsTry.dup();
            this.alive = aliveTry;
            this.analyzeStat(tree.finalizer);
            this.inits = this.inits.orSet(initsEnd);
            this.uninits = this.uninits.andSet(uninitsEnd);
            this.alive &= aliveEnd;
        } else {
            this.alive = aliveEnd;
        }
        this.thrown = Check.union(this.thrown, Check.diff(thrownInTry, caught));
        return null;
    }

    @Override
    public Void _case(Tree.Conditional tree, Integer status) {
        this.analyzeCond(tree.cond);
        if (tree.tag == 17) {
            Bits initsBeforeElse = this.initsWhenFalse;
            Bits uninitsBeforeElse = this.uninitsWhenFalse;
            boolean aliveBeforeElse = this.alive;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenTrue;
            this.analyzeStat(tree.thenpart);
            if (tree.elsepart != null) {
                Bits initsAfterThen = this.inits.dup();
                Bits uninitsAfterThen = this.uninits.dup();
                boolean aliveAfterThen = this.alive;
                this.inits = initsBeforeElse;
                this.uninits = uninitsBeforeElse;
                this.alive = aliveBeforeElse;
                this.analyzeStat(tree.elsepart);
                this.inits.andSet(initsAfterThen);
                this.uninits.andSet(uninitsAfterThen);
                this.alive |= aliveAfterThen;
            } else {
                this.inits.andSet(initsBeforeElse);
                this.uninits.andSet(uninitsBeforeElse);
                this.alive = true;
            }
        } else if (tree.type.tag != 8) {
            Bits initsBeforeElse = this.initsWhenFalse;
            Bits uninitsBeforeElse = this.uninitsWhenFalse;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenTrue;
            this.analyzeExpr(tree.thenpart);
            Bits initsAfterThen = this.inits.dup();
            Bits uninitsAfterThen = this.uninits.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.analyzeExpr(tree.elsepart);
            this.inits.andSet(initsAfterThen);
            this.uninits.andSet(uninitsAfterThen);
        } else {
            Bits initsBeforeElse = this.initsWhenFalse;
            Bits uninitsBeforeElse = this.uninitsWhenFalse;
            Bits initsBeforeThen = this.initsWhenTrue;
            Bits uninitsBeforeThen = this.uninitsWhenTrue;
            this.inits = this.initsWhenTrue.dup();
            this.uninits = this.uninitsWhenTrue.dup();
            this.analyzeCond(tree.thenpart);
            Bits initsAfterThenWhenTrue = this.initsWhenTrue;
            Bits uninitsAfterThenWhenTrue = this.uninitsWhenTrue;
            Bits initsAfterThenWhenFalse = this.initsWhenFalse;
            Bits bits = this.uninitsWhenFalse;
            this.inits = initsBeforeElse.dup();
            this.uninits = uninitsBeforeElse.dup();
            this.analyzeCond(tree.elsepart);
            this.initsWhenTrue = initsBeforeThen.dup().orSet(initsAfterThenWhenTrue).andSet(initsBeforeElse.dup().orSet(this.initsWhenTrue));
            this.uninitsWhenTrue = uninitsBeforeThen.dup().andSet(uninitsAfterThenWhenTrue).andSet(uninitsBeforeElse.dup().andSet(this.uninitsWhenTrue));
            this.initsWhenFalse = initsBeforeThen.dup().orSet(initsAfterThenWhenFalse).andSet(initsBeforeElse.dup().orSet(this.initsWhenFalse));
            this.uninitsWhenFalse = uninitsBeforeThen.dup().andSet(bits).andSet(uninitsBeforeElse.dup().andSet(this.uninitsWhenFalse));
        }
        return null;
    }

    @Override
    public Void _case(Tree.Exec tree, Integer n) {
        this.analyzeExpr(tree.expr);
        return null;
    }

    @Override
    public Void _case(Tree.Break tree, Integer n) {
        this.jump(tree.target, this.breaks);
        this.markDead();
        return null;
    }

    @Override
    public Void _case(Tree.Continue tree, Integer n) {
        this.jump(tree.target, this.continues);
        this.markDead();
        return null;
    }

    @Override
    public Void _case(Tree.Return tree, Integer n) {
        this.analyzeExpr(tree.expr);
        this.markDead();
        return null;
    }

    @Override
    public Void _case(Tree.Throw tree, Integer n) {
        this.analyzeExpr(tree.expr);
        this.markThrown(tree.pos, (Symbol.ClassSymbol)tree.expr.type.tsym);
        this.markDead();
        return null;
    }

    @Override
    public Void _case(Tree.Apply tree, Integer status) {
        this.analyzeExpr(tree.meth);
        this.analyzeExprs(tree.args);
        List<Symbol.ClassSymbol> list = TreeInfo.symbol((Tree)tree.meth).type.thrown();
        while (list.nonEmpty()) {
            this.markThrown(tree.pos, (Symbol.ClassSymbol)list.head);
            list = list.tail;
        }
        return null;
    }

    @Override
    public Void _case(Tree.NewClass tree, Integer status) {
        this.analyzeExpr(tree.encl);
        this.analyzeExprs(tree.args);
        List<Symbol.ClassSymbol> list = tree.constructor.type.thrown();
        while (list.nonEmpty()) {
            this.markThrown(tree.pos, (Symbol.ClassSymbol)list.head);
            list = list.tail;
        }
        this.analyze(tree.def);
        return null;
    }

    @Override
    public Void _case(Tree.NewArray tree, Integer n) {
        this.analyzeExprs(tree.dims);
        this.analyzeExprs(tree.elems);
        return null;
    }

    @Override
    public Void _case(Tree.Assign tree, Integer n) {
        this.analyzeVar(tree.lhs);
        if (n == condStatus) {
            this.analyzeCond(tree.rhs);
        } else {
            this.analyzeExpr(tree.rhs);
        }
        this.letInit(tree.lhs);
        return null;
    }

    @Override
    public Void _case(Tree.Assignop tree, Integer n) {
        if (tree.type.tag == 8 && 65 <= tree.tag && tree.tag <= 67) {
            this.booleanBinop(tree.tag - 65 + 48, tree.lhs, tree.rhs);
        } else {
            this.analyzeExpr(tree.lhs);
            this.analyzeExpr(tree.rhs);
        }
        this.letInit(tree.lhs);
        return null;
    }

    @Override
    public Void _case(Tree.Operation tree, Integer status) {
        switch (tree.tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                if (((Tree)tree.args.head).type.tag == 8) {
                    this.booleanBinop(tree.tag, (Tree)tree.args.head, (Tree)tree.args.tail.head);
                    break;
                }
                this.analyzeExpr((Tree)tree.args.head);
                this.analyzeExpr((Tree)tree.args.tail.head);
                break;
            }
            case 47: {
                this.analyzeCond((Tree)tree.args.head);
                Bits initsWhenFalseLeft = this.initsWhenFalse;
                Bits uninitsWhenFalseLeft = this.uninitsWhenFalse;
                this.inits = this.initsWhenTrue;
                this.uninits = this.uninitsWhenTrue;
                this.analyzeCond((Tree)tree.args.tail.head);
                this.initsWhenFalse.andSet(initsWhenFalseLeft);
                this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                break;
            }
            case 46: {
                this.analyzeCond((Tree)tree.args.head);
                Bits initsWhenTrueLeft = this.initsWhenTrue;
                Bits uninitsWhenTrueLeft = this.uninitsWhenTrue;
                this.inits = this.initsWhenFalse;
                this.uninits = this.uninitsWhenFalse;
                this.analyzeCond((Tree)tree.args.tail.head);
                this.initsWhenTrue.andSet(initsWhenTrueLeft);
                this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                break;
            }
            case 40: {
                this.analyzeCond((Tree)tree.args.head);
                Bits t = this.initsWhenFalse;
                this.initsWhenFalse = this.initsWhenTrue;
                this.initsWhenTrue = t;
                t = this.uninitsWhenFalse;
                this.uninitsWhenFalse = this.uninitsWhenTrue;
                this.uninitsWhenTrue = t;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.analyzeExpr((Tree)tree.args.head);
                this.letInit((Tree)tree.args.head);
                break;
            }
            default: {
                List<Tree> list = tree.args;
                while (list.nonEmpty()) {
                    this.analyzeExpr((Tree)list.head);
                    list = list.tail;
                }
                break block0;
            }
        }
        return null;
    }

    void booleanBinop(int tag, Tree left, Tree right) {
        this.analyzeCond(left);
        Bits initsWhenFalseLeft = this.initsWhenFalse;
        Bits uninitsWhenFalseLeft = this.uninitsWhenFalse;
        Bits initsWhenTrueLeft = this.initsWhenTrue;
        Bits uninitsWhenTrueLeft = this.uninitsWhenTrue;
        this.inits = this.initsWhenTrue.dup().andSet(this.initsWhenFalse);
        this.uninits = this.uninitsWhenTrue.dup().andSet(this.uninitsWhenFalse);
        this.analyzeCond(right);
        Bits initsRight = this.initsWhenFalse.dup().andSet(this.initsWhenTrue.dup());
        Bits uninitsRight = this.uninitsWhenFalse.dup().andSet(this.uninitsWhenTrue.dup());
        switch (tag) {
            case 50: {
                this.initsWhenFalse = initsRight.orSet(initsWhenFalseLeft.andSet(this.initsWhenFalse));
                this.uninitsWhenFalse = uninitsRight.andSet(uninitsWhenFalseLeft.andSet(this.uninitsWhenFalse));
                this.initsWhenTrue.orSet(initsWhenTrueLeft);
                this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                break;
            }
            case 48: {
                this.initsWhenTrue = initsRight.orSet(initsWhenTrueLeft.andSet(this.initsWhenTrue));
                this.uninitsWhenTrue = uninitsRight.andSet(uninitsWhenTrueLeft.andSet(this.uninitsWhenTrue));
                this.initsWhenFalse.orSet(initsWhenFalseLeft);
                this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                break;
            }
            case 49: 
            case 52: {
                Bits initsWhenTrueRight = this.initsWhenTrue.dup();
                Bits initsWhenFalseRight = this.initsWhenFalse.dup();
                Bits uninitsWhenTrueRight = this.uninitsWhenTrue.dup();
                Bits uninitsWhenFalseRight = this.uninitsWhenFalse.dup();
                this.initsWhenTrue = initsRight.dup().orSet(initsWhenTrueLeft.dup().andSet(initsWhenTrueRight)).orSet(initsWhenFalseLeft.dup().andSet(initsWhenFalseRight));
                this.uninitsWhenTrue = uninitsRight.dup().andSet(uninitsWhenTrueLeft.dup().andSet(uninitsWhenTrueRight)).andSet(uninitsWhenFalseLeft.dup().andSet(uninitsWhenFalseRight));
                this.initsWhenFalse = initsRight.orSet(initsWhenTrueLeft.andSet(initsWhenFalseRight)).orSet(initsWhenFalseLeft.andSet(initsWhenTrueRight));
                this.uninitsWhenFalse = uninitsRight.andSet(uninitsWhenTrueLeft.andSet(uninitsWhenFalseRight)).andSet(uninitsWhenFalseLeft.andSet(uninitsWhenTrueRight));
                break;
            }
            case 51: {
                Bits initsWhenTrueRight = this.initsWhenTrue.dup();
                Bits initsWhenFalseRight = this.initsWhenFalse.dup();
                Bits uninitsWhenTrueRight = this.uninitsWhenTrue.dup();
                Bits bits = this.uninitsWhenFalse.dup();
                this.initsWhenTrue = initsRight.dup().orSet(initsWhenTrueLeft.dup().andSet(initsWhenFalseRight)).orSet(initsWhenFalseLeft.dup().andSet(initsWhenTrueRight));
                this.uninitsWhenTrue = uninitsRight.dup().andSet(uninitsWhenTrueLeft.dup().andSet(bits)).andSet(uninitsWhenFalseLeft.dup().andSet(uninitsWhenTrueRight));
                this.initsWhenFalse = initsRight.orSet(initsWhenFalseLeft.andSet(initsWhenFalseRight)).orSet(initsWhenTrueLeft.andSet(initsWhenTrueRight));
                this.uninitsWhenFalse = uninitsRight.andSet(uninitsWhenFalseLeft.andSet(bits)).andSet(uninitsWhenTrueLeft.andSet(uninitsWhenTrueRight));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    @Override
    public Void _case(Tree.TypeCast tree, Integer n) {
        this.analyzeExpr(tree.expr);
        return null;
    }

    @Override
    public Void _case(Tree.TypeTest tree, Integer n) {
        this.analyzeExpr(tree.expr);
        return null;
    }

    @Override
    public Void _case(Tree.Indexed tree, Integer n) {
        this.analyzeExpr(tree.indexed);
        this.analyzeExpr(tree.index);
        return null;
    }

    @Override
    public Void _case(Tree.Ident tree, Integer n) {
        if (this.trackable(tree.sym) && n != varStatus) {
            this.checkInit(tree.pos, (Symbol.VarSymbol)tree.sym);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Select tree, Integer n) {
        this.analyzeExpr(tree.selected);
        return null;
    }

    @Override
    public Void _case(Tree tree, Integer n) {
        return null;
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return super._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Integer)object);
    }
}

