/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.AttrContext;
import gjc.v6.comp.Check;
import gjc.v6.comp.ConstFold;
import gjc.v6.comp.Enter;
import gjc.v6.comp.Env;
import gjc.v6.comp.Infer;
import gjc.v6.comp.Resolve;
import gjc.v6.comp.Symtab;
import gjc.v6.tree.Pretty;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Base;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attr
extends Tree.Visitor<Type, Env<AttrContext>>
implements Flags,
Kinds,
TypeTags {
    protected Log log;
    protected Symtab syms;
    protected Resolve rs;
    protected Check chk;
    protected Infer infer;
    protected TreeMaker make;
    public Enter enter;
    public ConstFold cfolder;
    boolean retrofit;
    Type aMethodType = new Type.MethodType(null, null, null);
    ListBuffer<Type.MethodType> methTemplateSupply = new ListBuffer();

    public Attr(Hashtable<String, String> options, Log log, Symtab syms, Resolve rs, Check chk, Infer infer, TreeMaker treeMaker) {
        this.log = log;
        this.syms = syms;
        this.rs = rs;
        this.chk = chk;
        this.infer = infer;
        this.make = treeMaker;
        if (this.enter != null) {
            this.enter.attr = this;
        }
        this.cfolder = new ConstFold(log, syms);
        this.retrofit = options.get("-retrofit") != null;
    }

    public void init(Enter enter) {
        this.enter = enter;
    }

    Type check(Tree tree, Type owntype, int ownkind, int pkind, Type type) {
        if (owntype.tag != 18 && type.tag != 12) {
            if ((ownkind & ~pkind) == 0) {
                if (type.tag != 17) {
                    owntype = this.chk.checkType(tree.pos, owntype, type);
                }
            } else {
                this.log.error(tree.pos, String.valueOf(String.valueOf(String.valueOf(Resolve.kindNames(pkind)).concat(String.valueOf(" required, but "))).concat(String.valueOf(Resolve.kindName(ownkind)))).concat(String.valueOf(" found")));
                owntype = Type.errType;
            }
        }
        tree.type = owntype;
        return owntype;
    }

    static boolean finalAssignable(Symbol.VarSymbol v, Env<AttrContext> env) {
        Symbol owner = ((AttrContext)env.info).scope.owner;
        return v.constValue == null && (v.owner == owner || (owner.name == Names.init || (owner.flags() & 0x80000) != 0) && v.owner == owner.owner && (v.flags() & 8) != 0 == Resolve.isStatic(env));
    }

    void checkAssignable(int pos, Symbol.VarSymbol v, Tree base, Env<AttrContext> env) {
        if (!((v.flags() & 0x10) == 0 || (base == null || base.tag == 31 && TreeInfo.name(base) == Names._this) && Attr.finalAssignable(v, env))) {
            this.log.error(pos, String.valueOf("can't assign a value to final ").concat(String.valueOf(v)));
        }
    }

    void warnDeprecated(int pos, Symbol symbol) {
        if (!this.chk.compiled.contains(symbol.enclClass().fullname)) {
            this.log.warning(pos, String.valueOf(String.valueOf(symbol).concat(String.valueOf(symbol.location()))).concat(String.valueOf(" has been deprecated")));
        }
    }

    Symbol thisSym(Env<AttrContext> env) {
        return this.rs.resolveSelf(0, env, env.enclClass.sym, Names._this, true);
    }

    Type attribTerm(Tree tree, Env<AttrContext> env, int pkind, Type pt) {
        try {
            ((AttrContext)env.info).pkind = pkind;
            ((AttrContext)env.info).pt = pt;
            return tree.visit(this, env);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return this.chk.completionError(tree.pos, completionFailure);
        }
    }

    protected Type attribExpr(Tree tree, Env<AttrContext> env, Type type) {
        return this.attribTerm(tree, env, 12, type);
    }

    Type attribExpr(Tree tree, Env<AttrContext> env) {
        return this.attribExpr(tree, env, Type.noType);
    }

    protected final Type attribType(Tree tree, Env<AttrContext> env) {
        return this.attribTerm(tree, env, 2, Type.noType);
    }

    Type attribStat(Tree tree, Env<AttrContext> env) {
        return this.attribTerm(tree, env, 0, Type.noType);
    }

    List<Type> attribExprs(List<Tree> trees, Env<AttrContext> env, Type pt) {
        ListBuffer<Type> ts = new ListBuffer<Type>();
        List<Tree> list = trees;
        while (list.nonEmpty()) {
            ts.append(this.attribExpr((Tree)list.head, env, pt));
            list = list.tail;
        }
        return ts.toList();
    }

    <T extends Tree> void attribStats(List<T> trees, Env<AttrContext> env) {
        List<Object> list = trees;
        while (list.nonEmpty()) {
            this.attribStat((Tree)list.head, env);
            list = list.tail;
        }
    }

    protected List<Type> attribArgs(List<Tree> trees, Env<AttrContext> env) {
        ListBuffer<Type> argtypes = new ListBuffer<Type>();
        List<Tree> list = trees;
        while (list.nonEmpty()) {
            argtypes.append(this.chk.checkNonVoid(((Tree)list.head).pos, this.attribExpr((Tree)list.head, env)));
            list = list.tail;
        }
        return argtypes.toList();
    }

    Type attribBase(Tree tree, Env<AttrContext> env, int interfaceFlag) {
        Type type = this.chk.checkClassType(tree.pos, this.attribType(tree, env));
        if ((type.tsym.flags() & 0x200) != interfaceFlag) {
            this.log.error(tree.pos, String.valueOf(interfaceFlag == 0 ? "no " : "").concat(String.valueOf("interface expected here")));
        }
        if ((type.tsym.flags() & 0x10) != 0) {
            this.log.error(tree.pos, String.valueOf("can't inherit from final ").concat(String.valueOf(type.tsym)));
        }
        return type;
    }

    void addAbstractMethod(Tree.ClassDef cd, Symbol.MethodSymbol m, Env<AttrContext> env) {
        Tree.MethodDef methodDef = this.make.at(cd.pos).MethodDef(new Symbol.MethodSymbol(m.flags() | 0x100000, m.name, cd.sym.type.memberType(m), cd.sym), null);
        cd.defs = cd.defs.prepend(methodDef);
        this.enter.memberEnter(methodDef, env);
    }

    void implementInterfaceMethods(Symbol.ClassSymbol c, Env<AttrContext> env) {
        Tree.ClassDef cd = (Tree.ClassDef)env.tree;
        List<Type> l = c.type.interfaces();
        while (l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)((Type)l.head).tsym;
            Scope.Entry e = i.members().elems;
            while (e != null) {
                Symbol.MethodSymbol absMeth;
                Symbol.MethodSymbol methodSymbol;
                if (e.sym.kind == 32 && (e.sym.flags() & 8) == 0 && (methodSymbol = (absMeth = (Symbol.MethodSymbol)e.sym).implementation(cd.sym)) == null) {
                    this.addAbstractMethod(cd, absMeth, env);
                }
                e = e.sibling;
            }
            this.implementInterfaceMethods(i, env);
            l = l.tail;
        }
    }

    @Override
    public Type _case(Tree.ClassDef tree, Env<AttrContext> env) {
        if ((((AttrContext)env.info).scope.owner.kind & 0x24) != 0) {
            this.enter.classEnter(tree, env);
        } else if (tree.name.len == 0) {
            System.out.println(((AttrContext)env.info).scope.owner);
        }
        Symbol.ClassSymbol classSymbol = tree.sym;
        if (classSymbol == null) {
            return null;
        }
        classSymbol.complete();
        this.attribClass(classSymbol);
        tree.type = classSymbol.type;
        return tree.type;
    }

    @Override
    public Type _case(Tree.MethodDef tree, Env<AttrContext> env) {
        Symbol.MethodSymbol m = tree.sym;
        this.chk.checkOverride(tree.pos, m);
        Env<AttrContext> localEnv = this.enter.methodEnv(tree, env);
        List<Tree.TypeParameter> l = tree.typarams;
        while (l.nonEmpty()) {
            ((AttrContext)localEnv.info).scope.enterIfAbsent(((Tree.TypeParameter)l.head).type.tsym);
            l = l.tail;
        }
        List<Tree.VarDef> l2 = tree.params;
        while (l2.nonEmpty()) {
            this.attribStat((Tree)l2.head, localEnv);
            l2 = l2.tail;
        }
        this.chk.validateTypeParams(tree.typarams);
        this.chk.validate(tree.restype);
        List<Tree> l3 = tree.thrown;
        while (l3.nonEmpty()) {
            this.chk.checkType(((Tree)l3.head).pos, ((Tree)l3.head).type, this.syms.throwableType);
            l3 = l3.tail;
        }
        Symbol.ClassSymbol owner = env.enclClass.sym;
        if (tree.body == null) {
            if ((owner.flags() & 0x200) == 0 && (tree.flags & 0x500) == 0 && !this.retrofit) {
                this.log.error(tree.pos, "missing method body, or declare as abstract");
            }
        } else if ((owner.flags() & 0x200) != 0) {
            this.log.error(tree.pos, "interface methods cannot have body");
        } else if ((tree.flags & 0x400) != 0) {
            this.log.error(tree.pos, "abstract methods cannot have body");
        } else if ((tree.flags & 0x100) != 0) {
            this.log.error(tree.pos, "native methods cannot have body");
        } else {
            if (tree.name == Names.init && owner.type != this.syms.objectType) {
                Tree.Block block = tree.body;
                if (block.stats.isEmpty() || !this.isSelfCall((Tree)block.stats.head)) {
                    block.stats = block.stats.prepend(Enter.SuperCall(this.make.at(block.pos), Tree.VarDef.emptyList, false));
                }
            }
            this.attribStat(tree.body, localEnv);
        }
        ((AttrContext)localEnv.info).scope.leave();
        tree.type = m.type;
        return tree.type;
    }

    private boolean isSelfCall(Tree tree) {
        if (tree.tag == 18) {
            Name name;
            Tree.Exec exec = (Tree.Exec)tree;
            if (exec.expr.tag == 23 && ((name = TreeInfo.name(((Tree.Apply)exec.expr).meth)) == Names._this || name == Names._super)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Type _case(Tree.VarDef tree, Env<AttrContext> env) {
        if (((AttrContext)env.info).scope.owner.kind == 32) {
            this.enter.memberEnter(tree, env);
        }
        this.chk.validate(tree.vartype);
        Symbol.VarSymbol v = tree.sym;
        Base._assert(v != null, tree.name);
        if (tree.init != null) {
            v.pos = Integer.MAX_VALUE;
            Type type = this.attribExpr(tree.init, this.enter.initEnv(tree, env), v.type);
            if (v.constValue instanceof Enter.EnvAttrContextBox) {
                v.constValue = type.constValue != null ? this.cfolder.coerce((Type)type, (Type)v.type).constValue : null;
            }
            v.pos = tree.internalPos;
        }
        tree.type = v.type;
        return tree.type;
    }

    @Override
    public Type _case(Tree.Block tree, Env<AttrContext> env) {
        Env<AttrContext> env2 = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dup()));
        if (((AttrContext)env.info).scope.owner.kind == 2) {
            ((AttrContext)env2.info).scope.owner = new Symbol.MethodSymbol(tree.flags | 0x80000, Names.empty, null, ((AttrContext)env.info).scope.owner);
            if ((tree.flags & 8) != 0) {
                ++((AttrContext)env2.info).staticLevel;
            }
        }
        this.attribStats(tree.stats, env2);
        ((AttrContext)env2.info).scope.leave();
        return null;
    }

    @Override
    public Type _case(Tree.DoLoop tree, Env<AttrContext> env) {
        this.attribStat(tree.body, env.dup(tree));
        this.attribExpr(tree.cond, env, Type.booleanType);
        return null;
    }

    @Override
    public Type _case(Tree.WhileLoop tree, Env<AttrContext> env) {
        this.attribExpr(tree.cond, env, Type.booleanType);
        this.attribStat(tree.body, env.dup(tree));
        return null;
    }

    @Override
    public Type _case(Tree.ForLoop tree, Env<AttrContext> env) {
        Env<AttrContext> env2 = env.dup(env.tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dup()));
        this.attribStats(tree.init, env2);
        if (tree.cond != null) {
            this.attribExpr(tree.cond, env2, Type.booleanType);
        }
        env2.tree = tree;
        this.attribStats(tree.step, env2);
        this.attribStat(tree.body, env2);
        ((AttrContext)env2.info).scope.leave();
        return null;
    }

    @Override
    public Type _case(Tree.Labelled tree, Env<AttrContext> env) {
        this.attribStat(tree.body, env.dup(tree));
        return null;
    }

    @Override
    public Type _case(Tree.Switch tree, Env<AttrContext> env) {
        Type seltype = this.attribExpr(tree.selector, env, Type.intType);
        Env<AttrContext> switchEnv = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dup()));
        Set tags = Set.make();
        boolean hasDefault = false;
        List<Tree.Case> l = tree.cases;
        while (l.nonEmpty()) {
            Tree.Case c = (Tree.Case)l.head;
            if (c.pat != null) {
                Type type = this.attribExpr(c.pat, switchEnv, Type.intType);
                if (type.tag != 18) {
                    if (type.constValue == null) {
                        this.log.error(c.pat.pos, "constant expression required");
                    } else if (tags.contains(type.constValue)) {
                        this.log.error(c.pos, "duplicate case label");
                    } else {
                        tags.put(type.constValue);
                    }
                }
            } else if (hasDefault) {
                this.log.error(c.pos, "duplicate default label");
            } else {
                hasDefault = true;
            }
            this.attribStats(c.stats, switchEnv);
            l = l.tail;
        }
        ((AttrContext)switchEnv.info).scope.leave();
        return null;
    }

    @Override
    public Type _case(Tree.Synchronized tree, Env<AttrContext> env) {
        this.attribExpr(tree.lock, env, this.syms.objectType);
        this.attribStat(tree.body, env);
        return null;
    }

    @Override
    public Type _case(Tree.Try tree, Env<AttrContext> env) {
        Env<AttrContext> tryEnv = env.dup(tree, ((AttrContext)env.info).dup());
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            Tree.Catch c = (Tree.Catch)l.head;
            Env<AttrContext> catchEnv = env.dup(c, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dup()));
            Type ctype = this.attribStat(c.param, catchEnv);
            this.chk.checkType(c.param.vartype.pos, ctype, this.syms.throwableType);
            this.attribStat(c.body, catchEnv);
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)ctype.tsym;
            ((AttrContext)catchEnv.info).scope.leave();
            l = l.tail;
        }
        this.attribStat(tree.body, tryEnv);
        if (tree.finalizer != null) {
            this.attribStat(tree.finalizer, env);
        }
        return null;
    }

    @Override
    public Type _case(Tree.Conditional tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int n = ((AttrContext)env.info).pkind;
        this.attribExpr(tree.cond, env, Type.booleanType);
        this.attribExpr(tree.thenpart, env, pt);
        if (tree.elsepart != null) {
            this.attribExpr(tree.elsepart, env, pt);
        }
        if (tree.tag == 17) {
            return null;
        }
        return this.check(tree, this.condType(tree.pos, tree.cond.type, tree.thenpart.type, tree.elsepart.type), 12, n, pt);
    }

    private Type condType(int pos, Type condtype, Type thentype, Type elsetype) {
        if (condtype.constValue != null && thentype.constValue != null && elsetype.constValue != null) {
            return ((Number)condtype.constValue).intValue() != 0 ? thentype : elsetype;
        }
        if (thentype.tag < 4 && elsetype.tag == 4 && elsetype.assignable(thentype)) {
            return thentype.baseType();
        }
        if (elsetype.tag < 4 && thentype.tag == 4 && thentype.assignable(elsetype)) {
            return elsetype.baseType();
        }
        if (thentype.tag <= 7 && elsetype.tag <= 7) {
            for (int i = 1; i <= 7; ++i) {
                Type type = Type.typeOfTag[i];
                if (!thentype.subType(type) || !elsetype.subType(type)) continue;
                return type;
            }
        }
        if (thentype.tsym == this.syms.stringType.tsym && elsetype.tsym == this.syms.stringType.tsym) {
            return this.syms.stringType;
        }
        if (thentype.subType(elsetype)) {
            return elsetype.baseType();
        }
        this.chk.checkType(pos, elsetype, thentype);
        return thentype.baseType();
    }

    @Override
    public Type _case(Tree.Assert tree, Env<AttrContext> env) {
        this.attribExpr(tree.cond, env, Type.booleanType);
        if (tree.msg != null) {
            this.attribExpr(tree.msg, env, this.syms.stringType);
        }
        return null;
    }

    @Override
    public Type _case(Tree.Exec tree, Env<AttrContext> env) {
        this.attribExpr(tree.expr, env);
        return null;
    }

    @Override
    public Type _case(Tree.Break tree, Env<AttrContext> env) {
        tree.target = this.findJumpTarget(tree.pos, tree.tag, tree.label, env);
        return null;
    }

    @Override
    public Type _case(Tree.Continue tree, Env<AttrContext> env) {
        tree.target = this.findJumpTarget(tree.pos, tree.tag, tree.label, env);
        return null;
    }

    private Tree findJumpTarget(int pos, int tag, Name label, Env<AttrContext> env) {
        Env<AttrContext> env1 = env;
        while (env1 != null) {
            switch (env1.tree.tag) {
                case 10: {
                    Tree.Labelled labelled = (Tree.Labelled)env1.tree;
                    if (label != labelled.label) break;
                    Tree tree = labelled.body;
                    while (tree.tag == 10) {
                        tree = ((Tree.Labelled)tree).body;
                    }
                    if (tag == 20 && tree.tag != 7 && tree.tag != 8 && tree.tag != 9) {
                        this.log.error(pos, String.valueOf("not a loop label: ").concat(String.valueOf(label)));
                    }
                    return tree;
                }
                case 7: 
                case 8: 
                case 9: {
                    if (label != null) break;
                    return env1.tree;
                }
                case 11: {
                    if (label != null || tag != 19) break;
                    return env1.tree;
                }
            }
            env1 = env1.next;
        }
        if (label != null) {
            this.log.error(pos, String.valueOf("undefined label: ").concat(String.valueOf(label)));
        } else if (tag == 20) {
            this.log.error(pos, "continue outside of loop");
        } else {
            this.log.error(pos, "break outside switch or loop");
        }
        return null;
    }

    @Override
    public Type _case(Tree.Return tree, Env<AttrContext> env) {
        if (env.enclMethod == null || env.enclClass.sym.owner == env.enclMethod.sym) {
            this.log.error(tree.pos, "return outside method");
        } else {
            Symbol.MethodSymbol methodSymbol = env.enclMethod.sym;
            if (methodSymbol.type.restype().tag == 9) {
                if (tree.expr != null) {
                    this.log.error(tree.expr.pos, "can't return a value from method whose result type is void");
                }
            } else if (tree.expr == null) {
                this.log.error(tree.pos, "missing return value");
            } else {
                this.attribExpr(tree.expr, env, methodSymbol.type.restype());
            }
        }
        return null;
    }

    @Override
    public Type _case(Tree.Throw tree, Env<AttrContext> env) {
        Type type = this.attribExpr(tree.expr, env, this.syms.throwableType);
        return null;
    }

    @Override
    public Type _case(Tree.Apply tree, Env<AttrContext> env) {
        boolean isConstructorCall;
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type owntype = Type.errType;
        Env<AttrContext> localEnv = env;
        Name methName = TreeInfo.name(tree.meth);
        boolean bl = isConstructorCall = methName == Names._this || methName == Names._super;
        if (isConstructorCall) {
            if (this.checkFirstConstructorStat(tree, env)) {
                localEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
                ((AttrContext)localEnv.info).isSelfCall = true;
                List<Type> argtypes = this.attribArgs(tree.args, localEnv);
                Type site = env.enclClass.sym.type;
                if (methName == Names._super) {
                    site = site.supertype();
                }
                if (site.tag == 10) {
                    if (tree.meth.tag == 30) {
                        Tree qualifier = ((Tree.Select)tree.meth).selected;
                        if (site.outer().tag == 10) {
                            this.attribExpr(qualifier, localEnv, site.outer());
                        } else {
                            this.log.error(qualifier.pos, String.valueOf(String.valueOf("illegal qualifier; ").concat(String.valueOf(site.tsym))).concat(String.valueOf(" is not an inner class")));
                        }
                    }
                    boolean selectSuperPrev = ((AttrContext)localEnv.info).selectSuper;
                    ((AttrContext)localEnv.info).selectSuper = true;
                    Symbol sym = this.rs.resolveConstructor(tree.meth.pos, localEnv, site, argtypes);
                    if (sym == env.enclMethod.sym) {
                        this.log.error(tree.pos, "recursive constructor invocation");
                    }
                    TreeInfo.setSymbol(tree.meth, sym);
                    this.checkId(tree.meth, site, sym, 32, this.aMethodType);
                }
            }
            return Type.voidType;
        }
        List<Type> argtypes = this.attribArgs(tree.args, localEnv);
        List saved = this.methTemplateSupply.elems;
        Type type = this.newMethTemplate(argtypes);
        owntype = this.attribExpr(tree.meth, localEnv, type);
        this.methTemplateSupply.elems = saved;
        return this.check(tree, owntype, 12, pkind, pt);
    }

    boolean checkFirstConstructorStat(Tree.Apply tree, Env<AttrContext> env) {
        Tree.MethodDef enclMethod = env.enclMethod;
        if (enclMethod != null && enclMethod.name == Names.init) {
            Tree.Block block = enclMethod.body;
            if (((Tree)block.stats.head).tag == 18 && ((Tree.Exec)block.stats.head).expr == tree) {
                return true;
            }
        }
        this.log.error(tree.pos, String.valueOf(String.valueOf("call to ").concat(String.valueOf(TreeInfo.name(tree.meth)))).concat(String.valueOf(" must be first statement in constructor")));
        return false;
    }

    Type newMethTemplate(List<Type> argtypes) {
        if (this.methTemplateSupply.elems == this.methTemplateSupply.last) {
            this.methTemplateSupply.append(new Type.MethodType(null, null, null));
        }
        Type.MethodType methodType = (Type.MethodType)this.methTemplateSupply.elems.head;
        this.methTemplateSupply.elems = this.methTemplateSupply.elems.tail;
        methodType.argtypes = argtypes;
        return methodType;
    }

    @Override
    public Type _case(Tree.NewClass tree, Env<AttrContext> env) {
        Tree clazzid;
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type owntype = Type.errType;
        Tree.ClassDef cdef = tree.def;
        Type encltype = null;
        Tree clazz = tree.clazz;
        Tree clazzid1 = clazzid = clazz.tag == 35 ? ((Tree.TypeApply)clazz).clazz : clazz;
        if (tree.encl != null) {
            encltype = this.attribExpr(tree.encl, env);
            if (encltype.tag == 10) {
                clazzid1 = this.make.at(clazz.pos).Select(this.make.Type(encltype), ((Tree.Ident)clazzid).name);
                clazz = clazz.tag == 35 ? this.make.at(tree.pos).TypeApply(clazzid1, ((Tree.TypeApply)clazz).arguments) : clazzid1;
            }
        }
        Type clazztype = this.chk.checkClassType(tree.clazz.pos, this.attribType(clazz, env));
        this.chk.validate(clazz);
        if (tree.encl != null) {
            tree.clazz.type = clazztype;
            TreeInfo.setSymbol(clazzid, TreeInfo.symbol(clazzid1));
            clazzid.type = ((Tree.Ident)clazzid).sym.type;
        } else if ((clazztype.tsym.flags() & 0x200) == 0 && clazztype.outer().tag == 10) {
            this.rs.resolveSelf(tree.pos, env, clazztype.outer().tsym, Names._this, false);
        }
        List<Type> argtypes = this.attribArgs(tree.args, env);
        if (clazztype.tag == 10) {
            if (cdef == null && (clazztype.tsym.flags() & 0x600) != 0) {
                this.log.error(tree.pos, String.valueOf(clazztype.tsym).concat(String.valueOf(" is abstract; cannot be instantiated")));
            } else if (cdef != null && (clazztype.tsym.flags() & 0x200) != 0) {
                if (argtypes.nonEmpty()) {
                    this.log.error(tree.pos, "anonymous class implements interface; cannot have arguments");
                    argtypes = Type.emptyList;
                } else if (tree.encl != null) {
                    this.log.error(tree.pos, "anonymous class implements interface; cannot have qualifier for new");
                }
            } else {
                boolean selectSuperPrev = ((AttrContext)env.info).selectSuper;
                if (cdef != null) {
                    ((AttrContext)env.info).selectSuper = true;
                }
                tree.constructor = this.rs.resolveConstructor(tree.pos, env, clazztype, argtypes);
                ((AttrContext)env.info).selectSuper = selectSuperPrev;
            }
            if (cdef != null) {
                if (Resolve.isStatic(env)) {
                    cdef.flags |= 8;
                }
                Tree tree2 = this.make.at(cdef.pos).Type(clazztype);
                if ((clazztype.tsym.flags() & 0x200) != 0) {
                    cdef.implementing = List.make(tree2);
                } else {
                    cdef.extending = tree2;
                }
                this.attribStat(cdef, env.dup(tree));
                if (tree.encl == null && ((AttrContext)env.info).isSelfCall) {
                    cdef.sym.flags_field |= 0x200000;
                }
                if (tree.encl != null) {
                    tree.args = tree.args.prepend(tree.encl);
                    argtypes = argtypes.prepend(encltype);
                    tree.encl = null;
                    encltype = null;
                }
                clazztype = cdef.sym.type;
                tree.constructor = this.rs.resolveConstructor(tree.pos, env, clazztype, argtypes);
            }
            if (tree.constructor != null && tree.constructor.kind == 32) {
                owntype = this.rs.instantiate(clazztype, tree.constructor, Type.emptyList, argtypes);
                if (owntype == null && Type.isRaw(argtypes)) {
                    owntype = this.rs.instantiate(clazztype, tree.constructor, Type.emptyList, Type.minimizeRaw(argtypes));
                }
                if (owntype == null) {
                    this.log.error(tree.pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf("internal error; cannot instantiate ").concat(String.valueOf(tree.constructor))).concat(String.valueOf(" to ("))).concat(String.valueOf(argtypes))).concat(String.valueOf(")")));
                }
            }
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.NewArray tree, Env<AttrContext> env) {
        Type elemtype;
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type owntype = Type.errType;
        if (tree.elemtype != null) {
            elemtype = this.attribType(tree.elemtype, env);
            if (elemtype.tag == 14) {
                this.log.warning(tree.pos, "unchecked generic array creation");
            }
            this.chk.validate(tree.elemtype);
            owntype = elemtype;
            List<Tree> list = tree.dims;
            while (list.nonEmpty()) {
                this.attribExpr((Tree)list.head, env, Type.intType);
                owntype = new Type.ArrayType(owntype);
                list = list.tail;
            }
        } else if (pt.tag == 11) {
            elemtype = pt.elemtype();
        } else {
            if (pt.tag != 18) {
                this.log.error(tree.pos, String.valueOf("illegal initializer for ").concat(String.valueOf(pt)));
            }
            elemtype = Type.errType;
        }
        if (tree.elems != null) {
            this.attribExprs(tree.elems, env, elemtype);
            owntype = new Type.ArrayType(elemtype);
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.Assign tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type type = this.attribTerm(tree.lhs, env.dup(tree), 4, pt);
        this.attribExpr(tree.rhs, env, type);
        return this.check(tree, type, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.Assignop tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        List<Type> argtypes = List.make(this.attribTerm(tree.lhs, env, 4, Type.noType), this.attribExpr(tree.rhs, env));
        Symbol operator = tree.operator = this.rs.resolveOperator(tree.pos, tree.tag - 17, env, argtypes);
        Type type = (Type)argtypes.head;
        if (operator.kind == 32) {
            if (type.tag <= 7) {
                this.chk.checkCastable(tree.rhs.pos, operator.type.restype(), type);
            } else {
                this.chk.checkType(tree.rhs.pos, operator.type.restype(), type);
            }
        }
        return this.check(tree, type, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.Operation tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        List<Type> argtypes = 42 <= tree.tag && tree.tag <= 45 ? Type.emptyList.prepend(this.attribTerm((Tree)tree.args.head, env, 4, Type.noType)) : this.attribArgs(tree.args, env);
        Symbol operator = tree.operator = this.rs.resolveOperator(tree.pos, tree.tag, env, argtypes);
        Type owntype = Type.errType;
        if (operator.kind == 32) {
            Type type;
            owntype = operator.type.restype();
            int opc = ((Symbol.OperatorSymbol)operator).opcode;
            List<Type> l = argtypes;
            while (l.nonEmpty() && ((Type)l.head).constValue != null) {
                l = l.tail;
            }
            if (l.isEmpty() && (type = this.cfolder.fold(tree.pos, opc, argtypes)) != null) {
                owntype = this.cfolder.coerce(type, owntype);
            }
            if (!(opc != 165 && opc != 166 || ((Type)argtypes.head).castableTo(((Type)argtypes.tail.head).erasure()) || ((Type)argtypes.tail.head).castableTo(((Type)argtypes.head).erasure()))) {
                this.log.error(tree.pos, String.valueOf(String.valueOf(String.valueOf("incomparable types: ").concat(String.valueOf(argtypes.head))).concat(String.valueOf(" and "))).concat(String.valueOf(argtypes.tail.head)));
            }
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.TypeCast tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type clazztype = this.attribType(tree.clazz, env);
        Type exprtype = this.attribExpr(tree.expr, env);
        Type type = this.chk.checkCastable(tree.expr.pos, exprtype, clazztype);
        if (exprtype.constValue != null) {
            type = this.cfolder.coerce(exprtype, type);
        }
        return this.check(tree, type, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.TypeTest tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type exprtype = this.attribExpr(tree.expr, env);
        Type type = this.chk.checkClassOrArrayType(tree.clazz.pos, this.attribType(tree.clazz, env));
        this.chk.checkCastable(tree.expr.pos, exprtype, type);
        return this.check(tree, Type.booleanType, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.Indexed tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type owntype = Type.errType;
        Type type = this.attribExpr(tree.indexed, env);
        this.attribExpr(tree.index, env, Type.intType);
        if (type.tag == 11) {
            owntype = type.elemtype();
        } else if (type.tag != 18) {
            this.log.error(tree.pos, String.valueOf(String.valueOf("array required, but ").concat(String.valueOf(type))).concat(String.valueOf(" found")));
        }
        return this.check(tree, owntype, 4, pkind, pt);
    }

    @Override
    public Type _case(Tree.Ident tree, Env<AttrContext> env) {
        int pkind = ((AttrContext)env.info).pkind;
        Type pt = ((AttrContext)env.info).pt;
        Symbol sym = pt.tag == 12 ? this.rs.resolveMethod(tree.pos, env, tree.name, Type.emptyList, pt.argtypes()) : this.rs.resolveIdent(tree.pos, env, tree.name, pkind);
        tree.sym = sym;
        if (env.enclClass.sym.owner.kind != 1 && (sym.kind & 0x24) != 0 && sym.owner.kind == 2 && tree.name != Names._super && tree.name != Names._this) {
            Env<AttrContext> env1 = env;
            while (env1.outer != null && !env1.enclClass.sym.subclass(sym.owner)) {
                env1 = env1.outer;
            }
            if (env1 != null && env1.enclClass.sym != sym.owner) {
                while ((env1 = env1.outer) != null && (((AttrContext)env1.info).scope == null || this.checkNotHiding(tree.pos, sym, ((AttrContext)env1.info).scope)) && (env1.enclClass == null || this.checkNotHiding(tree.pos, sym, env1.enclClass.sym.members()))) {
                }
            }
        }
        if (sym.kind == 4) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)sym;
            this.checkInit(tree, env, varSymbol);
            if (varSymbol.owner.kind == 32 && varSymbol.owner != ((AttrContext)env.info).scope.owner && (varSymbol.flags_field & 0x40000) == 0) {
                varSymbol.flags_field |= 0x40000;
                if ((varSymbol.flags_field & 0x10) == 0) {
                    this.log.error(tree.pos, String.valueOf(String.valueOf(String.valueOf("local ").concat(String.valueOf(varSymbol))).concat(String.valueOf(" is accessed from within inner class; "))).concat(String.valueOf(" needs to be declared final")));
                }
            }
            if (pkind == 4) {
                this.checkAssignable(tree.pos, varSymbol, null, env);
            }
        }
        if (((AttrContext)env.info).isSelfCall && sym.owner != null && sym.owner.kind == 2 && (sym.kind & 0x24) != 0 && (sym.flags() & 8) == 0 && env.enclClass.sym.subclass(sym.owner)) {
            this.chk.earlyRefError(tree.pos, sym.kind == 4 ? sym : this.thisSym(env));
        }
        if ((sym.flags() & 0x20000) != 0) {
            this.warnDeprecated(tree.pos, sym);
        }
        return this.checkId(tree, env.enclClass.sym.type, sym, pkind, pt);
    }

    @Override
    public Type _case(Tree.Select tree, Env<AttrContext> env) {
        Symbol sym;
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        int skind = 0;
        if (tree.name == Names._this || tree.name == Names._class) {
            skind = 2;
        } else {
            if ((pkind & 1) != 0) {
                skind |= 1;
            }
            if ((pkind & 2) != 0) {
                skind = skind | 2 | 1;
            }
            if ((pkind & 0x2C) != 0) {
                skind = skind | 0xC | 2;
            }
        }
        Type site = this.attribTerm(tree.selected, env, skind, Type.noType);
        Symbol sitesym = TreeInfo.symbol(tree.selected);
        boolean selectSuperPrev = ((AttrContext)env.info).selectSuper;
        ((AttrContext)env.info).selectSuper = sitesym != null && (sitesym.name == Names._super || sitesym.kind == 2);
        tree.sym = sym = this.selectSym(tree, site, env, pt, pkind);
        if (sym.kind == 4) {
            Symbol.VarSymbol v = (Symbol.VarSymbol)sym;
            this.evalInit(v, env);
            if (pkind == 4) {
                this.checkAssignable(tree.pos, v, tree.selected, env);
            }
        }
        if (((AttrContext)env.info).selectSuper) {
            if ((sym.flags() & 8) == 0 && sym.name != Names._this && sym.name != Names._super) {
                Type type;
                if (sitesym.name == Names._super) {
                    this.rs.checkNonAbstract(tree.pos, sym);
                } else if (sym.kind == 4 || sym.kind == 32) {
                    this.rs.access(new Resolve.StaticError(sym), tree.pos, site, sym.name);
                }
                if (((AttrContext)env.info).isSelfCall && tree.name == Names._this && site.tsym == env.enclClass.sym) {
                    this.chk.earlyRefError(tree.pos, sym);
                }
                if ((type = env.enclClass.sym.type.asSuper(site.tsym)) != null) {
                    site = type;
                }
            }
            ((AttrContext)env.info).selectSuper = selectSuperPrev;
        }
        if ((sym.flags() & 0x20000) != 0) {
            this.warnDeprecated(tree.pos, sym);
        }
        return this.checkId(tree, site, sym, pkind, pt);
    }

    Symbol selectSym(Tree.Select tree, Type site, Env<AttrContext> env, Type pt, int pkind) {
        int pos = tree.pos;
        Name name = tree.name;
        switch (site.tag) {
            case 13: {
                return this.rs.access(this.rs.findIdentInPackage(env, site.tsym, name, pkind), pos, site, name);
            }
            case 10: 
            case 11: {
                if (pt.tag == 12) {
                    return this.rs.resolveQualifiedMethod(pos, env, site, name, Type.emptyList, pt.argtypes());
                }
                if (name == Names._this) {
                    return this.rs.resolveSelf(pos, env, site.tsym, name, true);
                }
                if (name == Names._class) {
                    return new Symbol.VarSymbol(9, Names._class, this.syms.classType, site.tsym);
                }
                Symbol sym = this.rs.findIdentInType(env, site, name, pkind);
                if (sym.kind >= 256) {
                    Name pname;
                    if ((pkind & 3) != 0 && (pname = TreeInfo.fullName(tree.selected)) != null) {
                        Symbol.PackageSymbol p = this.syms.reader.enterPackage(pname);
                        Symbol symbol = this.rs.findIdentInPackage(env, p, name, pkind);
                        if (symbol.kind < sym.kind) {
                            sym = symbol;
                        }
                    }
                    sym = this.rs.access(sym, pos, site, name);
                }
                return sym;
            }
            case 14: {
                return this.selectSym(tree, site.bound(), env, pt, pkind);
            }
            case 18: {
                return Symbol.errSymbol;
            }
        }
        if (name == Names._class) {
            return new Symbol.VarSymbol(9, Names._class, this.syms.classType, site.tsym);
        }
        this.log.error(pos, String.valueOf(site).concat(String.valueOf(" cannot be dereferenced")));
        return Symbol.errSymbol;
    }

    Type checkId(Tree tree, Type site, Symbol sym, int pkind, Type pt) {
        Type owntype;
        switch (sym.kind) {
            case 2: {
                owntype = sym.type;
                if (owntype.tag != 10) break;
                if (owntype.outer().tag == 10 && tree.tag == 30 && site != owntype.outer()) {
                    Type normSite = site;
                    if (normSite.tag == 10) {
                        normSite = site.asOuterSuper(owntype.outer().tsym);
                    }
                    if (normSite != owntype.outer()) {
                        owntype = new Type.ClassType(normSite, Type.emptyList, owntype.tsym);
                    }
                }
                if (!owntype.typarams().nonEmpty()) break;
                owntype = new Type.ClassType(owntype.outer(), Type.emptyList, owntype.tsym);
                break;
            }
            case 4: {
                Type s;
                Symbol.VarSymbol v = (Symbol.VarSymbol)sym;
                if (!this.chk.unchecked && pkind == 4 && v.owner.kind == 2 && (v.flags() & 8) == 0 && site.tag == 10 && (s = site.asOuterSuper(v.owner)) != null && s.isRaw() && !v.type.sameType(v.erasure())) {
                    this.log.warning(tree.pos, String.valueOf(String.valueOf(String.valueOf("unchecked assignment to ").concat(String.valueOf(v))).concat(String.valueOf(" of raw type "))).concat(String.valueOf(site)));
                }
                Type type = owntype = sym.owner.kind == 2 && sym.name != Names._this ? site.memberType(sym) : sym.type;
                if (v.constValue == null) break;
                owntype = owntype.constType(v.constValue);
                break;
            }
            case 32: {
                Type type;
                if (!this.chk.unchecked && (sym.flags() & 8) == 0 && site.tag == 10 && (type = site.asOuterSuper(sym.owner)) != null && type.isRaw() && sym.name != Names.init && !Type.sameTypes(sym.type.argtypes(), sym.erasure().argtypes())) {
                    this.log.warning(tree.pos, String.valueOf(String.valueOf(String.valueOf("unchecked call to ").concat(String.valueOf(sym))).concat(String.valueOf(" as a member of the raw type "))).concat(String.valueOf(site)));
                }
                if (sym.name == Names.init) {
                    owntype = Type.voidType;
                    break;
                }
                owntype = this.rs.instantiate(site, sym, Type.emptyList, pt.argtypes());
                if (owntype == null && Type.isRaw(pt.argtypes())) {
                    owntype = this.rs.instantiate(site, sym, Type.emptyList, Type.minimizeRaw(pt.argtypes()));
                }
                if (owntype != null) break;
                this.log.error(tree.pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("internal error; cannot instantiate ").concat(String.valueOf(sym))).concat(String.valueOf(" at "))).concat(String.valueOf(site))).concat(String.valueOf(" to ("))).concat(String.valueOf(pt.argtypes()))).concat(String.valueOf(")")));
                break;
            }
            case 1: 
            case 63: {
                owntype = sym.type;
                break;
            }
            default: {
                new Pretty().printExpr(tree);
                throw new InternalError(String.valueOf("unexpected kind: ").concat(String.valueOf(sym.kind)));
            }
        }
        this.infer.checkSafe(tree.pos, owntype, sym);
        return this.check(tree, owntype, sym.kind, pkind, pt);
    }

    private void checkInit(Tree tree, Env<AttrContext> env, Symbol.VarSymbol varSymbol) {
        if (varSymbol.pos > tree.internalPos && (varSymbol.owner.kind == 32 || varSymbol.owner.kind == 2 && (((AttrContext)env.info).scope.owner.kind & 6) != 0 && varSymbol.owner == ((AttrContext)env.info).scope.owner.enclClass() && (varSymbol.flags() & 8) != 0 == Resolve.isStatic(env)) && (env.tree.tag != 26 || tree != ((Tree.Assign)env.tree).lhs)) {
            this.log.error(tree.pos, "illegal forward reference");
        }
        this.evalInit(varSymbol, env);
    }

    void evalInit(Symbol.VarSymbol v, Env<AttrContext> env) {
        if (v.constValue instanceof Enter.EnvAttrContextBox) {
            Env<AttrContext> evalEnv = ((Enter.EnvAttrContextBox)v.constValue).env;
            Name prev = this.log.useSource(evalEnv.toplevel.sourcefile);
            v.constValue = null;
            Type type = this.attribExpr(((Tree.VarDef)evalEnv.tree).init, evalEnv, v.type);
            if (type.constValue != null) {
                v.constValue = this.cfolder.coerce((Type)type, (Type)v.type).constValue;
            }
            this.log.useSource(prev);
        }
    }

    boolean checkNotHiding(int pos, Symbol sym, Scope scope) {
        Scope.Entry entry = scope.lookup(sym.name);
        while (entry.scope != null) {
            if (entry.sym.owner != sym.owner && entry.sym.kind == sym.kind && entry.sym.owner == scope.owner) {
                this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(sym).concat(String.valueOf(" is inherited from "))).concat(String.valueOf(sym.owner))).concat(String.valueOf(" and hides a "))).concat(String.valueOf(Resolve.kindName(sym.kind)))).concat(String.valueOf(" of the same name"))).concat(String.valueOf(entry.sym.location()))).concat(String.valueOf(". An explicit `this' qualifier must be used to select the desired instance  ")));
                return false;
            }
            entry = entry.next();
        }
        return true;
    }

    @Override
    public Type _case(Tree.Literal tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int n = ((AttrContext)env.info).pkind;
        return this.check(tree, this.litType(tree.typetag).constType(tree.value), 12, n, pt);
    }

    Type litType(int n) {
        return n == 10 ? this.syms.stringType : Type.typeOfTag[n];
    }

    @Override
    public Type _case(Tree.TypeIdent tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int n = ((AttrContext)env.info).pkind;
        return this.check(tree, Type.typeOfTag[tree.typetag], 2, n, pt);
    }

    @Override
    public Type _case(Tree.TypeArray tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type type = this.attribType(tree.elemtype, env);
        return this.check(tree, new Type.ArrayType(type), 2, pkind, pt);
    }

    @Override
    public Type _case(Tree.TypeApply tree, Env<AttrContext> env) {
        Type pt = ((AttrContext)env.info).pt;
        int pkind = ((AttrContext)env.info).pkind;
        Type owntype = Type.errType;
        Type clazztype = this.chk.checkClassType(tree.clazz.pos, this.attribType(tree.clazz, env));
        ListBuffer<Type> actbuf = new ListBuffer<Type>();
        List<Tree> l = tree.arguments;
        while (l.nonEmpty()) {
            actbuf.append(this.chk.checkRefType(((Tree)l.head).pos, this.attribType((Tree)l.head, env)));
            l = l.tail;
        }
        List<Type> actuals = actbuf.toList();
        if (clazztype.tag == 10) {
            List<Type> list = clazztype.tsym.type.typarams();
            if (actuals.length() == list.length()) {
                owntype = new Type.ClassType(clazztype.outer(), actuals, clazztype.tsym);
            } else {
                this.log.error(tree.pos, list.length() != 0 ? String.valueOf("wrong number of type arguments; required: ").concat(String.valueOf(list.length())) : String.valueOf(String.valueOf("type ").concat(String.valueOf(clazztype))).concat(String.valueOf(" does not take parameters")));
                owntype = Type.errType;
            }
        }
        return this.check(tree, owntype, 2, pkind, pt);
    }

    @Override
    public Type _case(Tree.TypeParameter tree, Env<AttrContext> env) {
        Type.TypeVar typeVar = (Type.TypeVar)tree.type;
        typeVar.bound = tree.extBound != null ? this.attribBase(tree.extBound, env, 0) : (tree.implBound != null ? this.attribBase(tree.implBound, env, 512) : this.syms.objectType);
        return typeVar;
    }

    @Override
    public Type _case(Tree.Erroneous tree, Env<AttrContext> env) {
        tree.type = Type.errType;
        return tree.type;
    }

    @Override
    public Type _case(Tree tree, Env<AttrContext> env) {
        throw new InternalError();
    }

    public void attribClass(Symbol.ClassSymbol c) {
        Type st = c.type.supertype();
        if (st.tag == 10) {
            this.attribClass((Symbol.ClassSymbol)st.tsym);
        }
        if (c.owner.kind == 2) {
            this.attribClass((Symbol.ClassSymbol)c.owner);
        }
        if ((c.flags_field & 0x800000) != 0) {
            Name prev = this.log.useSource(c.sourcefile);
            c.flags_field &= 0xFF7FFFFF;
            Env<AttrContext> env = this.enter.classEnvs.get(c);
            this.enter.classEnvs.remove(c);
            Tree.ClassDef tree = (Tree.ClassDef)env.tree;
            if ((c.flags() & 0x200) == 0) {
                this.implementInterfaceMethods(c, env);
            }
            this.chk.validateTypeParams(tree.typarams);
            this.chk.validate(tree.extending);
            this.chk.validate(tree.implementing);
            if ((c.flags() & 0x600) == 0 && !this.retrofit) {
                this.chk.checkAllDefined(tree.pos, c);
            }
            this.chk.checkClassBounds(tree.pos, c);
            if (tree.typarams.length() != 0 && c.subclass(this.syms.throwableType.tsym)) {
                this.log.error(tree.pos, "subtypes of java.lang.Throwable cannot have arguments");
            }
            tree.type = c.type;
            List<Tree.TypeParameter> l = tree.typarams;
            while (l.nonEmpty()) {
                ((AttrContext)env.info).scope.enterIfAbsent(((Tree.TypeParameter)l.head).type.tsym);
                l = l.tail;
            }
            if ((c.flags() & 0x200) == 0) {
                Symbol.VarSymbol thisSym = new Symbol.VarSymbol(16, Names._this, c.type, c);
                thisSym.pos = 1025;
                ((AttrContext)env.info).scope.enter(thisSym);
                if (st.tag == 10) {
                    Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(16, Names._super, st, c);
                    varSymbol.pos = 1025;
                    ((AttrContext)env.info).scope.enter(varSymbol);
                }
                this.chk.checkImplementations(tree.pos, c);
            } else {
                c.members_field = c.members_field.dup();
                this.implementInterfaceMethods(c, env);
                this.chk.checkImplementations(tree.pos, c);
                c.members_field = c.members_field.leave();
            }
            this.attribStats(tree.defs, env);
            tree.type = c.type;
            this.log.useSource(prev);
        }
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Env)object);
    }
}

