/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.TypeTags;
import gjc.v6.util.Base;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type
implements Flags,
Kinds,
TypeTags {
    public static boolean moreInfo = false;
    public int tag;
    public Symbol.TypeSymbol tsym;
    public boolean isReplicated = false;
    public Object constValue = null;
    public static final List<Type> emptyList = new List();
    public static Type[] typeOfTag = new Type[19];
    public static Name[] boxedName = new Name[19];
    public static final Type byteType = new Type(1, null);
    public static final Type charType = new Type(2, null);
    public static final Type shortType = new Type(3, null);
    public static final Type intType = new Type(4, null);
    public static final Type longType = new Type(5, null);
    public static final Type floatType = new Type(6, null);
    public static final Type doubleType = new Type(7, null);
    public static final Type booleanType = new Type(8, null);
    public static final Type voidType = new Type(9, null);
    public static final Type noType = new Type(17, null);
    public static final Type allType = new Type(16, null);
    public static final Type errType = new ErrorType(null);
    public static int count = 0;

    public Type(int tag, Symbol.TypeSymbol typeSymbol) {
        this.tag = tag;
        this.tsym = typeSymbol;
    }

    public Type constType(Object _constValue) {
        Base._assert(this.tag <= 8);
        Type type = new Type(this.tag, this.tsym);
        type.constValue = _constValue;
        return type;
    }

    public Type baseType() {
        if (this.constValue == null) {
            return this;
        }
        return this.tsym.type;
    }

    public static List<Type> baseTypes(List<Type> types) {
        if (types.nonEmpty()) {
            Type t = ((Type)types.head).baseType();
            List<Type> ts = Type.baseTypes(types.tail);
            if (t != types.head || ts != types.tail) {
                return new List<Type>(t, ts);
            }
        }
        return types;
    }

    public String toString() {
        String string;
        String string2 = string = this.tsym == null || this.tsym.name == null ? "null" : this.tsym.name.toString();
        if (moreInfo && this.tag == 14) {
            string = String.valueOf(string).concat(String.valueOf(this.hashCode()));
        }
        return string;
    }

    public List<Type> typarams() {
        return emptyList;
    }

    public Type outer() {
        return null;
    }

    public Type elemtype() {
        return null;
    }

    public List<Type> argtypes() {
        return emptyList;
    }

    public Type restype() {
        return null;
    }

    public List<Symbol.ClassSymbol> thrown() {
        return Symbol.ClassSymbol.emptyList;
    }

    public Type bound() {
        return null;
    }

    public Type supertype() {
        return null;
    }

    public List<Type> interfaces() {
        return emptyList;
    }

    public List<Type> allParams() {
        return emptyList;
    }

    public Type asSuper(Symbol symbol) {
        return null;
    }

    public Type asOuterSuper(Symbol symbol) {
        return null;
    }

    public Type asSub(Symbol symbol) {
        return null;
    }

    public Type memberType(Symbol symbol) {
        return symbol.type;
    }

    public Type subst(List<Type> from, List<Type> list) {
        return this;
    }

    public static List<Type> subst(List<Type> these, List<Type> from, List<Type> to) {
        if (these.tail != null) {
            Type head1 = ((Type)these.head).subst(from, to);
            List<Type> tail1 = Type.subst(these.tail, from, to);
            if (head1 != these.head || tail1 != these.tail) {
                return tail1.prepend(head1);
            }
        }
        return these;
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (((Type)l.head).isErroneous()) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public static boolean isRaw(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty() && !((Type)l.head).isRaw()) {
            l = l.tail;
        }
        return l.nonEmpty();
    }

    public boolean isParameterized() {
        return false;
    }

    public Type erasure() {
        return this;
    }

    public static List<Type> erasure(List<Type> these) {
        if (these.nonEmpty()) {
            List<Type> tail1 = Type.erasure(these.tail);
            Type head1 = ((Type)these.head).erasure();
            if (tail1 != these.tail || head1 != these.head) {
                return tail1.prepend(head1);
            }
        }
        return these;
    }

    public int occCount(Type type) {
        if (type == this) {
            return 1;
        }
        if (this.tag == 10 && this.isParameterized()) {
            return this.outer().occCount(type) + Type.occCount(this.typarams(), type);
        }
        if (this.tag == 11) {
            return this.elemtype().occCount(type);
        }
        return 0;
    }

    public static int occCount(List<Type> these, Type elem) {
        int cnt = 0;
        List<Type> l = these;
        while (l.tail != null) {
            cnt += ((Type)l.head).occCount(elem);
            l = l.tail;
        }
        return cnt;
    }

    public boolean sameType(Type type) {
        if (this == type || type.tag == 18) {
            return true;
        }
        switch (this.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                return this.tag == type.tag;
            }
            case 14: {
                return false;
            }
        }
        throw new InternalError();
    }

    public static boolean sameTypes(List<Type> these, List<Type> those) {
        while (these.tail != null && those.tail != null && ((Type)these.head).sameType((Type)those.head)) {
            these = these.tail;
            those = those.tail;
        }
        return these.isEmpty() && those.isEmpty();
    }

    public boolean genType(Type type) {
        return this.sameType(type) || this.tag == 16 && this.subType(type);
    }

    public static boolean genTypes(List<Type> these, List<Type> those) {
        while (these.nonEmpty() && those.nonEmpty() && ((Type)these.head).genType((Type)those.head)) {
            these = these.tail;
            those = those.tail;
        }
        return these.isEmpty() && those.isEmpty();
    }

    public boolean subType(Type type) {
        if (this == type || type.tag == 18) {
            return true;
        }
        switch (this.tag) {
            case 1: 
            case 2: {
                return this.tag == type.tag || this.tag + 2 <= type.tag && type.tag <= 7;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.tag <= type.tag && type.tag <= 7;
            }
            case 8: 
            case 9: {
                return this.tag == type.tag;
            }
            case 14: {
                return this.bound().subType(type);
            }
            case 16: {
                return type.tag == 16 || type.tag == 10 || type.tag == 11 || type.tag == 14;
            }
        }
        throw new InternalError(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("subType this.tag=").concat(String.valueOf(this.tag))).concat(String.valueOf(", this.tsym="))).concat(String.valueOf(this.tsym))).concat(String.valueOf(", this="))).concat(String.valueOf(this))).concat(String.valueOf(", that="))).concat(String.valueOf(type)));
    }

    public static boolean subTypes(List<Type> these, List<Type> those) {
        while (these.tail != null && those.tail != null && ((Type)these.head).subType((Type)those.head)) {
            these = these.tail;
            those = those.tail;
        }
        return these.tail == null && those.tail == null;
    }

    public boolean assignable(Type that) {
        if (this.tag <= 4 && this.constValue != null) {
            int n = ((Number)this.constValue).intValue();
            switch (that.tag) {
                case 1: {
                    if (-128 > n || n > 127) break;
                    return true;
                }
                case 2: {
                    if (0 > n || n > 65535) break;
                    return true;
                }
                case 3: {
                    if (Short.MIN_VALUE > n || n > Short.MAX_VALUE) break;
                    return true;
                }
                case 4: {
                    return true;
                }
            }
        }
        return this.subType(that);
    }

    public boolean castableTo(Type type) {
        if (type.tag == 18) {
            return true;
        }
        switch (this.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.tag <= 7;
            }
            case 8: {
                return type.tag == 8;
            }
            case 9: {
                return false;
            }
            case 14: {
                return this.bound().castableTo(type);
            }
            case 16: {
                return this.subType(type);
            }
        }
        throw new InternalError();
    }

    public Symbol.TypeSymbol memberClass(Name name) {
        return null;
    }

    public MethodType methodType() {
        throw new InternalError();
    }

    public boolean sameArgs(Type type) {
        throw new InternalError();
    }

    public static Type minimizeRaw(Type t) {
        if (t.isRaw()) {
            switch (t.tag) {
                case 10: {
                    List<Type> typarams = t.typarams();
                    if (typarams.isEmpty()) {
                        List<Type> l = t.tsym.type.typarams();
                        while (l.nonEmpty()) {
                            typarams = typarams.prepend(allType);
                            l = l.tail;
                        }
                    }
                    return new ClassType(Type.minimizeRaw(t.outer()), typarams, t.tsym);
                }
                case 11: {
                    return new ArrayType(Type.minimizeRaw(t.elemtype()));
                }
            }
            throw new InternalError();
        }
        return t;
    }

    public static List<Type> minimizeRaw(List<Type> ts) {
        if (ts.isEmpty()) {
            return ts;
        }
        return Type.minimizeRaw(ts.tail).prepend(Type.minimizeRaw((Type)ts.head));
    }

    public void complete() {
    }

    static void initType(Type type, Symbol.ClassSymbol c) {
        type.tsym = c;
        Type.typeOfTag[type.tag] = type;
    }

    static void initType(Type type, String name) {
        Type.initType(type, new Symbol.ClassSymbol(1, Name.fromString(name), type, Symbol.emptyPackage));
    }

    static void initType(Type type, String name, String bname) {
        Type.initType(type, name);
        Type.boxedName[type.tag] = Name.fromString(String.valueOf("java.lang.").concat(String.valueOf(bname)));
    }

    static void init() {
        Type.initType(byteType, "byte", "Byte");
        Type.initType(shortType, "short", "Short");
        Type.initType(charType, "char", "Character");
        Type.initType(intType, "int", "Integer");
        Type.initType(longType, "long", "Long");
        Type.initType(floatType, "float", "Float");
        Type.initType(doubleType, "double", "Double");
        Type.initType(booleanType, "boolean", "Boolean");
        Type.initType(voidType, "void", "Void");
        Type.initType(allType, "*");
        Type.initType(errType, Symbol.errSymbol);
    }

    public static class ErrorType
    extends Type {
        ErrorType(Symbol.TypeSymbol typeSymbol) {
            super(18, typeSymbol);
        }

        public Type constType(Object object) {
            return this;
        }

        public Type outer() {
            return this;
        }

        public Type elemtype() {
            return this;
        }

        public Type restype() {
            return this;
        }

        public Type bound() {
            return this;
        }

        public Type asSuper(Symbol symbol) {
            return this;
        }

        public Type asOuterSuper(Symbol symbol) {
            return this;
        }

        public Type asSub(Symbol symbol) {
            return this;
        }

        public Type memberType(Symbol symbol) {
            return this;
        }

        public boolean isErroneous() {
            return true;
        }

        public boolean sameType(Type type) {
            return true;
        }

        public boolean subType(Type type) {
            return true;
        }

        public boolean castableTo(Type type) {
            return true;
        }

        public boolean sameArgs(Type type) {
            return false;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForAll
    extends Type {
        public List<Type> tvars;
        public Type qtype;

        public ForAll(List<Type> tvars, Type type) {
            super(15, type.tsym);
            this.tvars = tvars;
            this.qtype = type;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> typarams() {
            return this.tvars;
        }

        @Override
        public Type outer() {
            return this.qtype.outer();
        }

        @Override
        public Type elemtype() {
            return this.qtype.elemtype();
        }

        @Override
        public List<Type> argtypes() {
            return this.qtype.argtypes();
        }

        @Override
        public Type restype() {
            return this.qtype.restype();
        }

        @Override
        public List<Symbol.ClassSymbol> thrown() {
            return this.qtype.thrown();
        }

        @Override
        public Type supertype() {
            return this.qtype.supertype();
        }

        @Override
        public List<Type> interfaces() {
            return this.qtype.interfaces();
        }

        @Override
        public List<Type> allParams() {
            return this.qtype.allParams();
        }

        @Override
        public Type bound() {
            return this.qtype.bound();
        }

        @Override
        public Type subst(List<Type> from, List<Type> to) {
            Type type = this.qtype.subst(from, to);
            if (type == this.qtype) {
                return this;
            }
            return new ForAll(this.tvars, type);
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public Type erasure() {
            return this.qtype.erasure();
        }

        @Override
        public MethodType methodType() {
            return this.qtype.methodType();
        }

        @Override
        public boolean sameArgs(Type type) {
            return type.tag == 15 && Type.sameTypes(this.bounds(), Type.subst(((ForAll)type).bounds(), ((ForAll)type).tvars, this.tvars)) && this.qtype.sameArgs(((ForAll)type).qtype.subst(((ForAll)type).tvars, this.tvars));
        }

        private List<Type> bounds() {
            ListBuffer<Type> b = new ListBuffer<Type>();
            List<Type> list = this.tvars;
            while (list.nonEmpty()) {
                b.append(((Type)list.head).bound());
                list = list.tail;
            }
            return b.toList();
        }

        @Override
        public void complete() {
            List<Type> list = this.tvars;
            while (list.nonEmpty()) {
                ((Type)list.head).bound().complete();
                list = list.tail;
            }
            this.qtype.complete();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeVar
    extends Type {
        public Type bound;

        public TypeVar(Type bound, Symbol.TypeSymbol typeSymbol) {
            super(14, typeSymbol);
            this.bound = bound;
        }

        public TypeVar(Type bound, Name name, Symbol symbol) {
            this(bound, null);
            this.tsym = new Symbol.TypeSymbol(0, name, this, symbol);
        }

        @Override
        public Type bound() {
            return this.bound;
        }

        @Override
        public Type supertype() {
            if ((this.bound.tsym.flags() & 0x200) == 0) {
                return this.bound;
            }
            return null;
        }

        @Override
        public List<Type> interfaces() {
            if ((this.bound.tsym.flags() & 0x200) != 0) {
                return emptyList.prepend(this.bound);
            }
            return null;
        }

        @Override
        public Type asSuper(Symbol symbol) {
            return this.bound.asSuper(symbol);
        }

        @Override
        public Type asOuterSuper(Symbol symbol) {
            return this.bound.asOuterSuper(symbol);
        }

        @Override
        public Type asSub(Symbol symbol) {
            return this.bound.asSub(symbol);
        }

        @Override
        public Type memberType(Symbol symbol) {
            return this.bound.memberType(symbol);
        }

        @Override
        public Type subst(List<Type> from, List<Type> list) {
            while (from.tail != null && list.tail != null) {
                if (this == from.head) {
                    return (Type)list.head;
                }
                from = from.tail;
                list = list.tail;
            }
            return this;
        }

        @Override
        public Type erasure() {
            return this.bound.erasure();
        }

        @Override
        public Symbol.TypeSymbol memberClass(Name name) {
            return this.bound().memberClass(name);
        }
    }

    public static class PackageType
    extends Type {
        PackageType(Symbol.TypeSymbol typeSymbol) {
            super(13, typeSymbol);
        }

        public String toString() {
            return this.tsym.fullName().toString();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type {
        public List<Type> argtypes;
        public Type restype;
        public List<Symbol.ClassSymbol> thrown;
        private static Symbol.ClassSymbol methodClass = new Symbol.ClassSymbol(1, Name.fromString("Method"), Symbol.noSymbol);

        public MethodType(List<Type> argtypes, Type restype, List<Symbol.ClassSymbol> list) {
            super(12, methodClass);
            this.argtypes = argtypes;
            this.restype = restype;
            this.thrown = list;
        }

        @Override
        public String toString() {
            return String.valueOf(String.valueOf(String.valueOf("(").concat(String.valueOf(this.argtypes.toString()))).concat(String.valueOf(")"))).concat(String.valueOf(this.restype));
        }

        @Override
        public List<Type> argtypes() {
            return this.argtypes;
        }

        @Override
        public Type restype() {
            return this.restype;
        }

        @Override
        public List<Symbol.ClassSymbol> thrown() {
            return this.thrown;
        }

        @Override
        public Type subst(List<Type> from, List<Type> to) {
            List<Type> argtypes1 = Type.subst(this.argtypes, from, to);
            Type type = this.restype.subst(from, to);
            if (argtypes1 == this.argtypes && type == this.restype) {
                return this;
            }
            return new MethodType(argtypes1, type, this.thrown);
        }

        @Override
        public boolean isErroneous() {
            return Type.isErroneous(this.argtypes) || this.restype.isErroneous();
        }

        @Override
        public Type erasure() {
            List<Type> argtypes1 = Type.erasure(this.argtypes);
            Type type = this.restype.erasure();
            if (argtypes1 == this.argtypes && type == this.restype) {
                return this;
            }
            return new MethodType(argtypes1, type, this.thrown);
        }

        @Override
        public MethodType methodType() {
            return this;
        }

        @Override
        public boolean sameArgs(Type type) {
            return type.tag == 12 && Type.sameTypes(this.argtypes, type.argtypes());
        }

        @Override
        public boolean sameType(Type type) {
            return this.sameArgs(type) && this.restype.sameType(type.restype());
        }

        @Override
        public void complete() {
            List<Type> l = this.argtypes;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
            this.restype.complete();
            List<Symbol.ClassSymbol> list = this.thrown;
            while (list.nonEmpty()) {
                ((Symbol.ClassSymbol)list.head).complete();
                list = list.tail;
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayType
    extends Type {
        public Type elemtype;
        public static Symbol.ClassSymbol arrayClass = new Symbol.ClassSymbol(1, Name.fromString("Array"), Symbol.noSymbol);

        public ArrayType(Type type) {
            super(11, arrayClass);
            this.elemtype = type;
        }

        @Override
        public String toString() {
            return String.valueOf(this.elemtype).concat(String.valueOf("[]"));
        }

        @Override
        public Type elemtype() {
            return this.elemtype;
        }

        @Override
        public List<Type> allParams() {
            return this.elemtype.allParams();
        }

        @Override
        public Type subst(List<Type> from, List<Type> to) {
            Type type = this.elemtype.subst(from, to);
            if (type == this.elemtype) {
                return this;
            }
            return new ArrayType(type);
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        @Override
        public Type erasure() {
            Type type = this.elemtype.erasure();
            if (type == this.elemtype) {
                return this;
            }
            return new ArrayType(type);
        }

        @Override
        public Type asSuper(Symbol symbol) {
            return this.subType(symbol.type) ? symbol.type : null;
        }

        @Override
        public Type asOuterSuper(Symbol symbol) {
            return this.subType(symbol.type) ? symbol.type : null;
        }

        @Override
        public boolean sameType(Type type) {
            if (this == type || type.tag == 18) {
                return true;
            }
            return type.tag == 11 && this.elemtype.sameType(type.elemtype());
        }

        @Override
        public boolean genType(Type type) {
            if (this == type || type.tag == 18) {
                return true;
            }
            return type.tag == 11 && this.elemtype.genType(type.elemtype());
        }

        @Override
        public boolean subType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            if (that.tag == 11) {
                if (this.elemtype.tag <= 8) {
                    return this.elemtype.sameType(that.elemtype());
                }
                return this.elemtype.subType(that.elemtype());
            }
            if (that.tag == 10) {
                Name name = that.tsym.fullName();
                return name == Names.java_lang_Object || name == Names.java_lang_Cloneable;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean castableTo(Type type) {
            if (type.tag == 18) return true;
            if (type.tag == 10) {
                if (this.subType(type)) return true;
            }
            if (type.tag != 11) return false;
            if (this.elemtype().tag <= 8) {
                if (this.elemtype().tag != type.elemtype().tag) return false;
                return true;
            }
            boolean bl = this.elemtype().castableTo(type.elemtype());
            if (!bl) return false;
            return true;
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol typeSymbol) {
            super(10, typeSymbol);
            this.outer_field = outer;
            this.typarams_field = typarams;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public Type constType(Object _constValue) {
            ClassType classType = new ClassType(this.outer_field, this.typarams_field, this.tsym);
            classType.constValue = _constValue;
            return classType;
        }

        @Override
        public Type baseType() {
            if (this.constValue == null) {
                return this;
            }
            return this.tsym.type;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.outer().tag != 17) {
                stringBuffer.append(this.outer().toString());
                stringBuffer.append(".");
                stringBuffer.append(this.className(this.tsym, false));
            } else {
                stringBuffer.append(this.className(this.tsym, true));
            }
            if (this.typarams().nonEmpty()) {
                stringBuffer.append('<');
                stringBuffer.append(this.typarams().toString());
                stringBuffer.append(">");
            }
            return stringBuffer.toString();
        }

        private String className(Symbol sym, boolean bl) {
            if (sym.name.len == 0) {
                return String.valueOf(String.valueOf(String.valueOf("<anonymous ").concat(String.valueOf(sym.type.interfaces().nonEmpty() ? sym.type.interfaces().head : sym.type.supertype()))).concat(String.valueOf(">"))).concat(String.valueOf(moreInfo ? String.valueOf(sym.hashCode()) : ""));
            }
            if (bl) {
                return sym.fullName().toString();
            }
            return sym.name.toString();
        }

        @Override
        public List<Type> typarams() {
            if (this.typarams_field == null) {
                this.tsym.complete();
                this.typarams_field = this.tsym.type.typarams();
            }
            return this.typarams_field;
        }

        @Override
        public Type outer() {
            if (this.outer_field == null) {
                this.tsym.complete();
                this.outer_field = this.tsym.type.outer();
            }
            return this.outer_field;
        }

        @Override
        public Type supertype() {
            if (this.supertype_field == null) {
                this.tsym.complete();
                Type st = ((ClassType)this.tsym.type).supertype_field;
                if (st == null) {
                    this.supertype_field = noType;
                } else if (this == this.tsym.type) {
                    this.supertype_field = st;
                } else {
                    List<Type> ownparams = this.allParams();
                    List<Type> list = this.tsym.type.allParams();
                    this.supertype_field = ownparams.isEmpty() ? st.erasure() : st.subst(list, ownparams);
                }
            }
            return this.supertype_field;
        }

        @Override
        public List<Type> interfaces() {
            if (this.interfaces_field == null) {
                this.tsym.complete();
                List<Type> is = ((ClassType)this.tsym.type).interfaces_field;
                if (is == null) {
                    this.interfaces_field = emptyList;
                } else if (this == this.tsym.type) {
                    this.interfaces_field = is;
                } else {
                    List<Type> ownparams = this.allParams();
                    List<Type> list = this.tsym.type.allParams();
                    this.interfaces_field = ownparams.isEmpty() ? Type.erasure(is) : Type.subst(is, list, ownparams);
                }
            }
            return this.interfaces_field;
        }

        @Override
        public List<Type> allParams() {
            if (this.allparams_field == null) {
                this.allparams_field = this.typarams().prepend(this.outer().allParams());
            }
            return this.allparams_field;
        }

        @Override
        public Type asSuper(Symbol sym) {
            Type t;
            if (this.tsym == sym) {
                return this;
            }
            Type st = this.supertype();
            if (st.tag == 10 && (t = st.asSuper(sym)) != null) {
                return t;
            }
            if ((sym.flags() & 0x200) != 0) {
                List<Type> l = this.interfaces();
                while (l.nonEmpty()) {
                    Type type = ((Type)l.head).asSuper(sym);
                    if (type != null) {
                        return type;
                    }
                    l = l.tail;
                }
            }
            return null;
        }

        @Override
        public Type asOuterSuper(Symbol sym) {
            Type t = this;
            do {
                Type type;
                if ((type = ((Type)t).asSuper(sym)) != null) {
                    return type;
                }
                t = ((Type)t).outer();
            } while (t.tag == 10);
            return null;
        }

        @Override
        public Type asSub(Symbol sym) {
            if (this.tsym == sym) {
                return this;
            }
            Type base = sym.type.asSuper(this.tsym);
            if (base == null) {
                return null;
            }
            Type res = sym.type.subst(base.allParams(), this.allParams());
            if (!res.subType(this)) {
                return null;
            }
            List<Type> list = sym.type.allParams();
            while (list.nonEmpty()) {
                if (res.occCount((Type)list.head) != 0) {
                    return res.erasure();
                }
                list = list.tail;
            }
            return res;
        }

        @Override
        public Type memberType(Symbol sym) {
            Type base;
            Symbol owner = sym.owner;
            int flags = sym.flags();
            if (((flags & 8) == 0 || (flags & 0x200) != 0) && owner.type.isParameterized() && (base = this.asOuterSuper(owner)) != null) {
                List<Type> ownerParams = owner.type.allParams();
                List<Type> list = base.allParams();
                if (ownerParams.nonEmpty()) {
                    if (list.isEmpty()) {
                        return sym.type.erasure();
                    }
                    while (ownerParams.length() > list.length()) {
                        ownerParams = ownerParams.tail;
                    }
                    return sym.type.subst(ownerParams, list);
                }
            }
            return sym.type;
        }

        @Override
        public Type subst(List<Type> from, List<Type> to) {
            Symbol.TypeSymbol typeSymbol;
            Type outer = this.outer();
            List<Type> typarams = this.typarams();
            List<Type> typarams1 = Type.subst(typarams, from, to);
            Type outer1 = outer.subst(from, to);
            if (typarams1 == typarams && outer1 == outer) {
                return this;
            }
            Symbol.TypeSymbol tsym1 = this.tsym;
            if (outer.tsym != outer1.tsym && this.tsym.isNested() && (typeSymbol = outer1.memberClass(this.tsym.name)) != null) {
                tsym1 = typeSymbol;
                if (outer1.tag == 10) {
                    outer1 = outer1.asSuper(tsym1.type.outer().tsym);
                }
            }
            return new ClassType(outer1, typarams1, tsym1);
        }

        @Override
        public boolean isErroneous() {
            return this.outer().isErroneous() || Type.isErroneous(this.typarams());
        }

        @Override
        public boolean isParameterized() {
            return this.allParams().tail != null;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allParams().nonEmpty() && this.allParams().isEmpty() && (this.tsym.type.typarams().nonEmpty() && this.typarams().isEmpty() || this.outer().isRaw());
        }

        @Override
        public Type erasure() {
            return this.tsym.erasure();
        }

        @Override
        public boolean sameType(Type type) {
            if (this == type || type.tag == 18) {
                return true;
            }
            return this.tsym == type.tsym && this.outer().sameType(type.outer()) && Type.sameTypes(this.typarams(), type.typarams());
        }

        @Override
        public boolean genType(Type type) {
            if (this == type || type.tag == 18) {
                return true;
            }
            return this.tsym == type.tsym && this.outer().genType(type.outer()) && Type.genTypes(this.typarams(), type.typarams());
        }

        @Override
        public boolean subType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            if (this.tsym == that.tsym) {
                return (!that.isParameterized() || Type.genTypes(this.typarams(), that.typarams())) && this.outer().subType(that.outer());
            }
            Type st = this.supertype();
            if (st.tag == 10 && st.subType(that)) {
                return true;
            }
            if ((that.tsym.flags() & 0x200) != 0) {
                List<Type> list = this.interfaces();
                while (list.nonEmpty()) {
                    if (((Type)list.head).subType(that)) {
                        return true;
                    }
                    list = list.tail;
                }
            }
            return false;
        }

        @Override
        public Symbol.TypeSymbol memberClass(Name name) {
            Type t = this;
            while (t.tag == 10) {
                Scope.Entry entry = t.tsym.members().lookup(name);
                while (entry.scope != null && entry.sym.kind != 2) {
                    entry = entry.next();
                }
                if (entry.scope != null) {
                    return (Symbol.TypeSymbol)entry.sym;
                }
                t = ((Type)t).supertype();
            }
            return null;
        }

        @Override
        public boolean castableTo(Type that) {
            List<Type> list = that.allParams();
            return that.tag == 18 || (that.tag == 10 || that.tag == 11) && (this.subType(that) || that.subType(this) && (that.tag == 11 || that.tsym.type == that || that.sameType(this.asSub(that.tsym))) || that.tag == 10 && list.isEmpty() && ((that.tsym.flags() & 0x200) != 0 && (this.tsym.flags() & 0x10) == 0 || (this.tsym.flags() & 0x200) != 0 && (that.tsym.flags() & 0x10) == 0));
        }

        @Override
        public void complete() {
            if (this.tsym.completer != null) {
                this.tsym.complete();
            }
        }
    }
}

